# This Source Code Form is subject to the terms of the Waterfox Public
# License, v. 2.0. If a copy of the MPL was not distributed with this
# file, You can obtain one at http://mozilla.org/MPL/2.0/.

# DO NOT ADD THINGS OTHER THAN ERROR MESSAGES HERE.
# This file gets parsed into a JS dictionary of all known error message ids in
# gen_aboutneterror_codes.py . If we end up needing fluent attributes or
# refactoring them in some way, the script will need updating.

# Variables:
# $hostname (String) - Hostname of the website with SSL error.
# $errorMessage (String) - Error message corresponding to the type of error we are experiencing.
ssl-connection-error = Hiba történt a következőhöz csatlakozáskor: { $hostname }. { $errorMessage }

# Variables:
# $error (string) - NSS error code string that specifies type of cert error. e.g. unknown issuer, invalid cert, etc.
cert-error-code-prefix = Hibakód: { $error }

psmerr-ssl-disabled = Nem lehet biztonságosan kapcsolódni, mert az SSL protokoll le van tiltva.
psmerr-ssl2-disabled = Nem lehet biztonságosan kapcsolódni, mert a hely az SSL protokoll egy régi, nem biztonságos verzióját használja.

# This is a multi-line message.
psmerr-hostreusedissuerandserial =
    Érvénytelen tanúsítványt kapott.  Lépjen kapcsolatba a kiszolgáló adminisztrátorával vagy e-mailes kapcsolattartójával, és adja meg a következő információkat: 
    
    A tanúsítvány a hitelesítésszolgáltató egy másik tanúsítványával megegyező sorozatszámot tartalmaz.  Szerezzen egy egyedi sorozatszámmal rendelkező új tanúsítványt.

ssl-error-export-only-server = Nem lehet biztonságosan kommunikálni. A partner nem támogatja a magas szintű titkosítást.
ssl-error-us-only-server = Nem lehet biztonságosan kommunikálni. A partner olyan magas szintű titkosítást kíván meg, amely nincs támogatva.
ssl-error-no-cypher-overlap = Nem lehet biztonságosan kommunikálni a partnerrel: nincs közös titkosító algoritmus.
ssl-error-no-certificate = Nem található a hitelesítéshez szükséges tanúsítvány vagy kulcs.
ssl-error-bad-certificate = Nem lehet biztonságosan kommunikálni a partnerrel: a partner tanúsítványa vissza lett utasítva.
ssl-error-bad-client = A kiszolgáló rossz adatokat kapott az ügyféltől.
ssl-error-bad-server = Az ügyfél rossz adatokat kapott a kiszolgálótól.
ssl-error-unsupported-certificate-type = Nem támogatott tanúsítványtípus.
ssl-error-unsupported-version = A partner a biztonsági protokoll nem támogatott verzióját használja.
ssl-error-wrong-certificate = Az ügyfél hitelesítése sikertelen: a kulcsadatbázisban levő privát kulcs nem illik a tanúsítvány-adatbázisban levő nyilvános kulcshoz.
ssl-error-bad-cert-domain = Nem lehet biztonságosan kommunikálni a partnerrel: a kért tartománynév nem egyezik a kiszolgáló tanúsítványában levővel.
ssl-error-post-warning = Ismeretlen SSL hibakód.
ssl-error-ssl2-disabled = A partnert csak az SSL 2-es verzióját támogatja, ami helyileg le van tiltva.
ssl-error-bad-mac-read = Az SSL egy helytelen üzenethitelesítő kóddal rendelkező rekordot kapott.
ssl-error-bad-mac-alert = Az SSL-partner helytelen üzenetazonosító kódot jelentett.
ssl-error-bad-cert-alert = Az SSL-partner nem tudja ellenőrizni a tanúsítványát.
ssl-error-revoked-cert-alert = Az SSL-partner visszautasította a tanúsítványát, mert szerinte az vissza lett vonva.
ssl-error-expired-cert-alert = Az SSL-partner visszautasította a tanúsítványát, mert szerinte az lejárt.
ssl-error-ssl-disabled = Nem lehet kapcsolódni: az SSL le van tiltva.
ssl-error-fortezza-pqg = Nem lehet kapcsolódni: az SSL egy másik FORTEZZA-tartományban van.
ssl-error-unknown-cipher-suite = Ismeretlen SSL-kódolókészlet lett kérve.
ssl-error-no-ciphers-supported = Ebben a programban egyetlen kódolókészlet sincs jelen és engedélyezve.
ssl-error-bad-block-padding = Az SSL egy rossz blokkfeltöltéssel rendelkező rekordot kapott.
ssl-error-rx-record-too-long = Az SSL a maximálisan megengedhető hosszúságot meghaladó rekordot kapott.
ssl-error-tx-record-too-long = Az SSL a maximálisan megengedhető hosszúságot meghaladó rekordot próbált küldeni.
ssl-error-rx-malformed-hello-request = Az SSL egy rosszul formázott Hello Request kézfogási üzenetet kapott.
ssl-error-rx-malformed-client-hello = Az SSL egy rosszul formázott Client Hello kézfogási üzenetet kapott.
ssl-error-rx-malformed-server-hello = Az SSL egy rosszul formázott Server Hello kézfogási üzenetet kapott.
ssl-error-rx-malformed-certificate = Az SSL egy rosszul formázott Certificate kézfogási üzenetet kapott.
ssl-error-rx-malformed-server-key-exch = Az SSL egy rosszul formázott Server Key Exchange kézfogási üzenetet kapott.
ssl-error-rx-malformed-cert-request = Az SSL egy rosszul formázott Certificate Request kézfogási üzenetet kapott.
ssl-error-rx-malformed-hello-done = Az SSL egy rosszul formázott Server Hello Done kézfogási üzenetet kapott.
ssl-error-rx-malformed-cert-verify = Az SSL egy rosszul formázott Certificate Verify kézfogási üzenetet kapott.
ssl-error-rx-malformed-client-key-exch = Az SSL egy rosszul formázott Client Key Exchange kézfogási üzenetet kapott.
ssl-error-rx-malformed-finished = Az SSL egy rosszul formázott Finished kézfogási üzenetet kapott.
ssl-error-rx-malformed-change-cipher = Az SSL egy rosszul formázott Change Cipher Spec rekordot kapott.
ssl-error-rx-malformed-alert = Az SSL egy rosszul formázott Alert rekordot kapott.
ssl-error-rx-malformed-handshake = Az SSL egy rosszul formázott Handshake rekordot kapott.
ssl-error-rx-malformed-application-data = Az SSL egy rosszul formázott Application Data rekordot kapott.
ssl-error-rx-unexpected-hello-request = Az SSL egy váratlan Hello Request kézfogási üzenetet kapott.
ssl-error-rx-unexpected-client-hello = Az SSL egy váratlan Client Hello kézfogási üzenetet kapott.
ssl-error-rx-unexpected-server-hello = Az SSL egy váratlan Server Hello kézfogási üzenetet kapott.
ssl-error-rx-unexpected-certificate = Az SSL egy váratlan Certificate kézfogási üzenetet kapott.
ssl-error-rx-unexpected-server-key-exch = Az SSL egy váratlan Server Key Exchange kézfogási üzenetet kapott.
ssl-error-rx-unexpected-cert-request = Az SSL egy váratlan Certificate Request kézfogási üzenetet kapott.
ssl-error-rx-unexpected-hello-done = Az SSL egy váratlan Server Hello Done kézfogási üzenetet kapott.
ssl-error-rx-unexpected-cert-verify = Az SSL egy váratlan Certificate Verify kézfogási üzenetet kapott.
ssl-error-rx-unexpected-client-key-exch = Az SSL egy váratlan Client Key Exchange kézfogási üzenetet kapott.
ssl-error-rx-unexpected-finished = Az SSL egy váratlan Finished kézfogási üzenetet kapott.
ssl-error-rx-unexpected-change-cipher = Az SSL egy váratlan Change Cipher Spec rekordot kapott.
ssl-error-rx-unexpected-alert = Az SSL egy váratlan Alert rekordot kapott.
ssl-error-rx-unexpected-handshake = Az SSL egy váratlan Handshake rekordot kapott.
ssl-error-rx-unexpected-application-data = Az SSL egy váratlan Application Data rekordot kapott.
ssl-error-rx-unknown-record-type = Az SSL ismeretlen tartalomtípussal rendelkező rekordot kapott.
ssl-error-rx-unknown-handshake = Az SSL ismeretlen üzenettípussal rendelkező kézfogási üzenetet kapott.
ssl-error-rx-unknown-alert = Az SSL ismeretlen riasztási leírással rendelkező riasztási rekordot kapott.
ssl-error-close-notify-alert = Az SSL-partner lezárta a kapcsolatot.
ssl-error-handshake-unexpected-alert = Az SSL-partner nem várta a kapott kézfogási üzenetet.
ssl-error-decompression-failure-alert = Az SSL-partner nem tudta kitömöríteni a kapott SSL-rekordot.
ssl-error-handshake-failure-alert = Az SSL-partnerrel nem lehetett megtárgyalni a biztonsági paraméterek elfogadható beállításait.
ssl-error-illegal-parameter-alert = Az SSL-partner visszautasította az elfogadhatatlan tartalom kézfogási üzenetét.
ssl-error-unsupported-cert-alert = Az SSL-partner nem támogatja a kapott tanúsítványtípust.
ssl-error-certificate-unknown-alert = Az SSL-partnernek meg nem határozott problémája volt a kapott tanúsítvánnyal.
ssl-error-generate-random-failure = Az SSL hibát észlelt a véletlenszám-generátorában.
ssl-error-sign-hashes-failure = Nem sikerült digitálisan aláírni az Ön tanúsítványának ellenőrzéséhez szükséges adatokat.
ssl-error-extract-public-key-failure = Az SSL nem tudta kicsomagolni a nyilvános kulcsot a partner tanúsítványából.
ssl-error-server-key-exchange-failure = Nem meghatározott hiba az SSL-kiszolgálókulcscsere kézfogás közben.
ssl-error-client-key-exchange-failure = Nem meghatározott hiba az SSL-ügyfélkulcscsere kézfogás közben.
ssl-error-encryption-failure = Az adatcsomag titkosítási algoritmusa sikertelen a kijelölt titkosítóeszközön.
ssl-error-decryption-failure = Az adatcsomag visszafejtési algoritmusa sikertelen a kijelölt titkosítóeszközön.
ssl-error-socket-write-failure = A kísérlet a titkosított adatok az alsóbb szinten levő szoftvercsatornára való kiírására sikertelen volt.
ssl-error-md5-digest-failure = Az MD5 digest függvény sikertelen.
ssl-error-sha-digest-failure = Az SHA-1 digest függvény sikertelen.
ssl-error-mac-computation-failure = A MAC kiszámítása sikertelen.
ssl-error-sym-key-context-failure = A szimmetrikus kulcs kontextus létrehozása sikertelen.
ssl-error-sym-key-unwrap-failure = Nem sikerült kicsomagolni a szimmetrikus kulcsot az ügyfélkulcscsere üzenetben.
ssl-error-pub-key-size-limit-exceeded = Az SSL-kiszolgáló belföldi szintű nyilvános kulcsot próbált meg használni exportra szánt titkosítókészlettel.
ssl-error-iv-param-failure = A PKCS11-kód nem tudott egy IV-t paraméterré fordítani.
ssl-error-init-cipher-suite-failure = Nem sikerült inicializálni a kijelölt titkosítókészletet.
ssl-error-session-key-gen-failure = Az ügyfél nem tudott munkamenetkulcsokat generálni az SSL-munkamenethez.
ssl-error-no-server-key-for-alg = A kiszolgálónak nincs kulcs a megkísérelt kulcscserélő algoritmushoz.
ssl-error-token-insertion-removal = PKCS#11 token lett beszúrva vagy eltávolítva művelet közben.
ssl-error-token-slot-not-found = Nem található PKCS#11 token a kívánt művelet elvégzésére.
ssl-error-no-compression-overlap = Nem lehet biztonságosan kommunikálni a partnerrel: nincs közös tömörítő algoritmus.
ssl-error-handshake-not-completed = Nem lehet egy másik SSL-kézfogást kezdeményezni, amíg az aktuális kézfogás nem fejeződik be.
ssl-error-bad-handshake-hash-value = Helytelen kézfogási hash-értékek érkeztek a partnertől.
ssl-error-cert-kea-mismatch = A rendelkezésre álló tanúsítvány nem használható a kiválasztott kulcskicserélő algoritmussal.
ssl-error-no-trusted-ssl-client-ca = Nincs az SSL-ügyfél hitelesítésére megbízható hitelesítésszolgáltató.
ssl-error-session-not-found = Az ügyfél SSL-munkamenet-azonosítója nem található a kiszolgáló munkamenet-gyorsítótárában.
ssl-error-decryption-failed-alert = A partner nem tudta visszafejteni a kapott SSL-rekordot.
ssl-error-record-overflow-alert = A partner az engedélyezettnél hosszabb SSL-rekordot kapott.
ssl-error-unknown-ca-alert = A partner nem bízik meg a hitelesítésszolgáltatóban, amely az Ön tanúsítványát kiadta.
ssl-error-access-denied-alert = A partner érvényes tanúsítványt kapott, de a hozzáférés meg lett tagadva.
ssl-error-decode-error-alert = A partner nem tudott dekódolni egy SSL-kézfogási üzenetet.
ssl-error-decrypt-error-alert = A partner aláírás-ellenőrzési vagy kulcskicserélési hibát jelez.
ssl-error-export-restriction-alert = A partner azt jelzi, hogy a tárgyalás nem felel meg az exportkorlátozási előírásoknak.
ssl-error-protocol-version-alert = A partner nem kompatibilis vagy nem támogatott verziót jelez.
ssl-error-insufficient-security-alert = A kiszolgáló által megkövetelt titkosítók biztonságosabbak, mint amiket az ügyfél támogat.
ssl-error-internal-error-alert = A partner saját belső hibát jelet.
ssl-error-user-canceled-alert = A partner megszakította a kézfogást.
ssl-error-no-renegotiation-alert = A partner nem engedi az SSL biztonsági paramétereinek újratárgyalását.
ssl-error-server-cache-not-configured = Az SSL kiszolgálói gyorsítótár nincs konfigurálva, és nincs letiltva a sockethez.
ssl-error-unsupported-extension-alert = Az SSL-partner nem támogatja a kért TLS hello kiterjesztést.
ssl-error-certificate-unobtainable-alert = Az SSL-partner nem tudja letölteni az Ön tanúsítványát a megadott URL-ről.
ssl-error-unrecognized-name-alert = Az SSL-partnernek nincs tanúsítványa a kért DNS-névhez.
ssl-error-bad-cert-status-response-alert = Az SSL-patner nem kapott OCSP-választ a tanúsítványára.
ssl-error-bad-cert-hash-value-alert = Az SSL-partner rossz hash-értéket jelzett a tanúsítványhoz.
ssl-error-rx-unexpected-new-session-ticket = Az SSL egy váratlan New Session Ticket kézfogási üzenetet kapott.
ssl-error-rx-malformed-new-session-ticket = Az SSL egy rosszul formázott New Session Ticket kézfogási üzenetet kapott.
ssl-error-decompression-failure = Az SSL egy tömörített rekordot kapott, amit nem sikerült kicsomagolni.
ssl-error-renegotiation-not-allowed = Az újratárgyalás nem engedélyezett ezen az SSL socketen.
ssl-error-unsafe-negotiation = A partner régi stílusú (potenciálisan sebezhető) kézfogással próbálkozott.
ssl-error-rx-unexpected-uncompressed-record = Az SSL egy váratlan tömörítetlen rekordot kapott.
ssl-error-weak-server-ephemeral-dh-key = Az SSL egy gyenge efemerális Diffie-Hellman-kulcsot kapott a Server Key Exchange kézfogási üzenetben.
ssl-error-next-protocol-data-invalid = Az SSL érvénytelen NPN kiterjesztésadatokat kapott.
ssl-error-feature-not-supported-for-ssl2 = Az SSL szolgáltatás nem támogatott SSL 2.0 kapcsolatokhoz.
ssl-error-feature-not-supported-for-servers = Az SSL szolgáltatás nem támogatott kiszolgálókhoz.
ssl-error-feature-not-supported-for-clients = Az SSL szolgáltatás nem támogatott kliensekhez.
ssl-error-invalid-version-range = Az SSL verziótartomány nem érvényes.
ssl-error-cipher-disallowed-for-version = Az SSL partner a kijelölt protokollverzióhoz nem engedélyezett titkosítócsomagot választott.
ssl-error-rx-malformed-hello-verify-request = Az SSL rosszul formázott Hello Verify Request kézfogásüzenetet kapott.
ssl-error-rx-unexpected-hello-verify-request = Az SSL váratlan Hello Verify Request kézfogásüzenetet kapott.
ssl-error-feature-not-supported-for-version = Az SSL funkció nem támogatott a protokollverzióhoz.
ssl-error-rx-unexpected-cert-status = Az SSL váratlan tanúsítványstátusz kézfogásüzenetet kapott.
ssl-error-unsupported-hash-algorithm = A TLS partner nem támogatott hash algoritmust használt.
ssl-error-digest-failure = A kivonatoló függvény sikertelen.
ssl-error-incorrect-signature-algorithm = A digitálisan aláírt elemben helytelen aláírási algoritmus van megadva.
ssl-error-next-protocol-no-callback = A következő protokollegyeztetési kiterjesztés be lett kapcsolva, de a visszahívás törölve lett a szükségessé válása előtt.
ssl-error-next-protocol-no-protocol = A kiszolgáló nem támogat olyan protokollokat, amelyeket a kliens az ALPN kiterjesztésben hirdet.
ssl-error-inappropriate-fallback-alert = A kiszolgáló visszautasította a kézfogást, mert a kliens a szerver által támogatottnál régebbi TLS verzióra állt vissza.
ssl-error-weak-server-cert-key = A kiszolgáló tanúsítványa túl gyenge nyilvános kulcsot tartalmazott.
ssl-error-rx-short-dtls-read = Nincs elég hely a pufferben a DTLS rekordnak.
ssl-error-no-supported-signature-algorithm = Nem lett beállítva támogatott TLS aláírási algoritmus.
ssl-error-unsupported-signature-algorithm = A partner az aláírási és hash algoritmusok nem támogatott kombinációját használta.
ssl-error-missing-extended-master-secret = A partner megfelelő extended_master_secret kiterjesztés nélkül próbálta folytatni.
ssl-error-unexpected-extended-master-secret = A partner egy váratlan extended_master_secret kiterjesztéssel próbálta folytatni.
sec-error-io = I/O hiba történt a biztonsági hitelesítés közben.
sec-error-library-failure = biztonsági könyvtár hibája.
sec-error-bad-data = biztonsági könyvtár: rossz adatok érkeztek.
sec-error-output-len = biztonsági könyvtár: kimeneti hossz hiba.
sec-error-input-len = biztonsági könyvtár bemeneti hossz hibát észlelt.
sec-error-invalid-args = biztonsági könyvtár: érvénytelen argumentumok.
sec-error-invalid-algorithm = biztonsági könyvtár: érvénytelen algoritmus.
sec-error-invalid-ava = biztonsági könyvtár: érvénytelen AVA.
sec-error-invalid-time = Helytelenül formázott időkarakterlánc.
sec-error-bad-der = biztonsági könyvtár: helytelenül formázott DER-kódolt üzenet.
sec-error-bad-signature = A partner tanúsítványának aláírása érvénytelen.
sec-error-expired-certificate = A partner tanúsítványa lejárt.
sec-error-revoked-certificate = A partner tanúsítványát visszavonták.
sec-error-unknown-issuer = A partner tanúsítványának kiadója nem elismert.
sec-error-bad-key = A partner nyilvános kulcsa érvénytelen.
sec-error-bad-password = A beírt biztonsági jelszó helytelen.
sec-error-retry-password = Az új jelszót helytelenül írta be. Próbálja újra.
sec-error-no-nodelock = biztonsági könyvtár: nincs nodelock.
sec-error-bad-database = biztonsági könyvtár: rossz adatbázis.
sec-error-no-memory = biztonsági könyvtár: memóriaallokációs hiba.
sec-error-untrusted-issuer = A partner tanúsítványának kiadója nem megbízhatónak van jelölve a felhasználónál.
sec-error-untrusted-cert = A partner tanúsítványa nem megbízhatónak van jelölve a felhasználónál.
sec-error-duplicate-cert = A tanúsítvány már szerepel az adatbázisban.
sec-error-duplicate-cert-name = A letöltött tanúsítvány neve egyezik egy adatbázisban levőével.
sec-error-adding-cert = Hiba a tanúsítvány adatbázishoz adása során.
sec-error-filing-key = Hiba a kulcs tanúsítványhoz való újratárolásakor.
sec-error-no-key = Az ehhez a tanúsítványhoz tartozó személyes kulcs nem található a kulcsadatbázisban.
sec-error-cert-valid = Ez a tanúsítvány érvényes.
sec-error-cert-not-valid = Ez a tanúsítvány nem érvényes.
sec-error-cert-no-response = Tanúsítványkönyvtár: Nincs válasz
sec-error-expired-issuer-certificate = A tanúsítvány kiadójának tanúsítványa lejárt. Ellenőrizze a rendszerdátumot és a rendszeridőt.
sec-error-crl-expired = A tanúsítvány kiadójának CRL-je lejárt. Frissítse, vagy ellenőrizze a rendszerdátumot és a rendszeridőt.
sec-error-crl-bad-signature = A tanúsítvány kiadója CRL-jének aláírása érvénytelen.
sec-error-crl-invalid = Az új visszavont tanúsítványok listájának (CRL) érvénytelen a formátuma.
sec-error-extension-value-invalid = A tanúsítványkiterjesztés értéke érvénytelen.
sec-error-extension-not-found = Nem található tanúsítványkiterjesztés.
sec-error-ca-cert-invalid = A kiadó tanúsítványa érvénytelen.
sec-error-path-len-constraint-invalid = A tanúsítvány útvonalhosszának korlátozása érvénytelen.
sec-error-cert-usages-invalid = A tanúsítvány használati mezője érvénytelen.
sec-internal-only = **CSAK belső modul**
sec-error-invalid-key = A kulcs nem támogatja a kért műveletet.
sec-error-unknown-critical-extension = A tanúsítvány ismeretlen kritikus kiterjesztést tartalmaz.
sec-error-old-crl = Az új CRL nem későbbi, mint a jelenlegi.
sec-error-no-email-cert = Nincs titkosítva vagy aláírva: Önnek nincs még e-mail tanúsítványa.
sec-error-no-recipient-certs-query = Nincs titkosítva: Önnek nincs tanúsítványa az összes címzetthez.
sec-error-not-a-recipient = Nem sikerült visszafejteni: Ön nem címzett, vagy nem található egyező tanúsítvány és személyes kulcs.
sec-error-pkcs7-keyalg-mismatch = Nem sikerült visszafejteni: a kulcstitkosító algoritmus nem egyezik a tanúsítványával.
sec-error-pkcs7-bad-signature = Nem sikerült az aláírás-ellenőrzés: nem található aláíró, túl sok aláíró van, illetve az adatok nem megfelelőek vagy sérültek.
sec-error-unsupported-keyalg = Nem támogatott vagy ismeretlen kulcsalgoritmus.
sec-error-decryption-disallowed = Nem sikerült visszafejteni: a titkosítás nem engedélyezett algoritmust vagy kulcsméretet használ.
xp-sec-fortezza-bad-card = A Fortezza kártya nem lett megfelelően inicializálva. Vegye ki, és juttassa vissza a kibocsátóhoz.
xp-sec-fortezza-no-card = Nem található Fortezza kártya
xp-sec-fortezza-none-selected = Nincs kiválasztva Fortezza kártya
xp-sec-fortezza-more-info = Válasszon egy személyiséget, amelyről információt szeretne
xp-sec-fortezza-person-not-found = A személyiség nem található
xp-sec-fortezza-no-more-info = Nincs több információ a személyiségről
xp-sec-fortezza-bad-pin = Érvénytelen PIN
xp-sec-fortezza-person-error = Nem sikerült inicializálni a Fortezza-személyiségeket.
sec-error-no-krl = A hely tanúsítványához nem található KRL.
sec-error-krl-expired = A hely tanúsítványának KRL-je lejárt.
sec-error-krl-bad-signature = A hely tanúsítványa KRL-jének aláírása érvénytelen.
sec-error-revoked-key = A hely tanúsítványának kulcsát visszavonták.
sec-error-krl-invalid = Az új KRL formátuma érvénytelen.
sec-error-need-random = biztonsági könyvtár: véletlen adatok kellenek.
sec-error-no-module = biztonsági könyvtár: a kért műveletet semelyik biztonsági modul sem tudja elvégezni.
sec-error-no-token = A biztonsági kártya vagy token nem létezik, inicializálni kell, vagy el van távolítva.
sec-error-read-only = biztonsági könyvtár: csak olvasható adatbázis.
sec-error-no-slot-selected = Nincs kiválasztva slot vagy token.
sec-error-cert-nickname-collision = Ezen a néven már létezik tanúsítvány.
sec-error-key-nickname-collision = Ezen a néven már létezik kulcs.
sec-error-safe-not-created = hiba a biztonságos objektum létrehozásakor
sec-error-baggage-not-created = hiba a baggage objektum létrehozásakor
xp-java-remove-principal-error = Nem sikerült eltávolítani az egyszerű nevet
xp-java-delete-privilege-error = Nem sikerült törölni a jogosultságot
xp-java-cert-not-exists-error = Ehhez az egyszerű névhez nem tartozik tanúsítvány
sec-error-bad-export-algorithm = A szükséges algoritmus nem engedélyezett.
sec-error-exporting-certificates = Hiba történt a tanúsítványok exportálásakor.
sec-error-importing-certificates = Hiba történt a tanúsítványok importálásakor.
sec-error-pkcs12-decoding-pfx = Nem lehet importálni. Dekódolási hiba. A fájl érvénytelen.
sec-error-pkcs12-invalid-mac = Nem lehet importálni. Érvénytelen MAC. Helytelen jelszó vagy sérült fájl.
sec-error-pkcs12-unsupported-mac-algorithm = Nem lehet importálni. A MAC-algoritmus nem támogatott.
sec-error-pkcs12-unsupported-transport-mode = Nem lehet importálni. Csak a jelszóintegritás és az adatvédelmi módok támogatottak.
sec-error-pkcs12-corrupt-pfx-structure = Nem lehet importálni. A fájlstruktúra sérült.
sec-error-pkcs12-unsupported-pbe-algorithm = Nem lehet importálni. A titkosító algoritmus nem támogatott.
sec-error-pkcs12-unsupported-version = Nem lehet importálni. A fájlverzió nem támogatott.
sec-error-pkcs12-privacy-password-incorrect = Nem lehet importálni. Helytelen adatvédelmi jelszó.
sec-error-pkcs12-cert-collision = Nem lehet importálni. Ugyanez a név már szerepel az adatbázisban.
sec-error-user-cancelled = A felhasználó megszakította a folyamatot.
sec-error-pkcs12-duplicate-data = Nem lett importálva, már az adatbázisban van.
sec-error-message-send-aborted = Az üzenet nem lett elküldve.
sec-error-inadequate-key-usage = A tanúsítvány kulcshasználata nem megfelelő a megkísérelt művelethez.
sec-error-inadequate-cert-type = A tanúsítványtípus nem jóváhagyott az alkalmazáshoz.
sec-error-cert-addr-mismatch = Az aláíró tanúsítványban szereplő cím nem egyezik meg az üzenet fejlécében levő címmel.
sec-error-pkcs12-unable-to-import-key = Nem lehet importálni. Hiba történt a személyes kulcs importálásakor.
sec-error-pkcs12-importing-cert-chain = Nem lehet importálni. Hiba történt a tanúsítványlánc importálásakor.
sec-error-pkcs12-unable-to-locate-object-by-name = Nem lehet exportálni. A tanúsítvány vagy kulcs nem található meg név alapján.
sec-error-pkcs12-unable-to-export-key = Nem lehet exportálni. A személyes kulcs nem található és exportálható.
sec-error-pkcs12-unable-to-write = Nem lehet exportálni. Nem lehetett írni az exportfájlba.
sec-error-pkcs12-unable-to-read = Nem lehet importálni. Nem lehetett olvasni az importfájlból.
sec-error-pkcs12-key-database-not-initialized = Nem lehet exportálni. A kulcsadatbázis sérült vagy törölve van.
sec-error-keygen-fail = Nem sikerül a személyes/nyilvános kulcspár létrehozása.
sec-error-invalid-password = A beírt jelszó érvénytelen. Válasszon másikat.
sec-error-retry-old-password = A beírt régi jelszó helytelen. Próbálja újra.
sec-error-bad-nickname = Ha tanúsítvány neve már használatban van.
sec-error-not-fortezza-issuer = A partner FORTEZZA láncában van egy nem FORTEZZA tanúsítvány.
sec-error-cannot-move-sensitive-key = Az érzékeny kulcsot nem lehet áthelyezni abba a slotba, ahol szükség van rá.
sec-error-js-invalid-module-name = Érvénytelen modulnév.
sec-error-js-invalid-dll = Érvénytelen modulútvonal/fájlnév
sec-error-js-add-mod-failure = A modul hozzáadása sikertelen.
sec-error-js-del-mod-failure = A modul törlése sikertelen.
sec-error-old-krl = Az KRL régebbi mint a jelenlegi.
sec-error-ckl-conflict = Az új CKL kibocsátója más, mint a jelenlegi CKL-é. Törölje a jelenlegi CKL-t.
sec-error-cert-not-in-name-space = A tanúsítványhoz tartozó hitelesítésszolgáltató számára nem engedélyezett, hogy ezzel a névvel tanúsítványt adjon ki.
sec-error-krl-not-yet-valid = A tanúsítványhoz tartozó kulcsvisszavonási lista (KRL) még nem érvényes.
sec-error-crl-not-yet-valid = A tanúsítványhoz tartozó tanúsítvány-visszavonási lista (CRL) még nem érvényes.
sec-error-unknown-cert = A kért tanúsítvány nem található.
sec-error-unknown-signer = Az aláíró tanúsítványa nem található.
sec-error-cert-bad-access-location = A tanúsítványstátusz-kiszolgáló helyének érvénytelen a formátuma.
sec-error-ocsp-unknown-response-type = Az OCSP-választ nem lehet teljesen dekódolni, mert ismeretlen típusú.
sec-error-ocsp-bad-http-response = Az OCSP-kiszolgáló váratlan/érvénytelen HTTP-adatokat küldött vissza.
sec-error-ocsp-malformed-request = Az OCSP-kiszolgáló szerint a kérés sérült vagy nem megfelelően formázott.
sec-error-ocsp-server-error = Az OCSP-kiszolgálónak belső hibája van.
sec-error-ocsp-try-server-later = Az OCSP-kiszolgáló azt javasolja, hogy próbálkozzon később.
sec-error-ocsp-request-needs-sig = Az OCSP-kiszolgáló aláírást követel ehhez a kéréshez.
sec-error-ocsp-unauthorized-request = Az OCSP-kiszolgáló visszautasította a kérést, mint jogosulatlant.
sec-error-ocsp-unknown-response-status = Az OCSP-kiszolgáló felismerhetetlen státuszt adott vissza.
sec-error-ocsp-unknown-cert = Az OCSP-kiszolgálónak nincs státusza a tanúsítványhoz.
sec-error-ocsp-not-enabled = A művelet végrehajtása előtt engedélyeznie kell az OCSP-t.
sec-error-ocsp-no-default-responder = A művelet végrehajtása előtt be kell állítani az alapértelmezett OCSP-válaszadót.
sec-error-ocsp-malformed-response = Az OCSP-kiszolgáló válasza sérült vagy nem megfelelően formázott.
sec-error-ocsp-unauthorized-response = Az OCSP-válasz aláírója nem jogosult kiadni a tanúsítvány státuszát.
sec-error-ocsp-future-response = Az OCSP-válasz még nem érvényes (jövőbeli dátumot tartalmaz).
sec-error-ocsp-old-response = Az OCSP-válasz elavult információkat tartalmaz.
sec-error-digest-not-found = A CMS vagy a PKCS #7 Digest nem volt benne az aláírt üzenetben.
sec-error-unsupported-message-type = A CMS vagy a PKCS #7 Message típus nem támogatott
sec-error-module-stuck = A PKCS #11 modult nem lehet eltávolítani, mert még használatban van.
sec-error-bad-template = Nem sikerült dekódolni az ASN.1 adatokat. A megadott sablon érvénytelen volt.
sec-error-crl-not-found = Nem találhatók illeszkedő CRL-ek.
sec-error-reused-issuer-and-serial = Egy olyan tanúsítványt próbál importálni, amelynek a kiadója/sorozatszáma megegyezik egy létező tanúsítvánnyal, de ez a tanúsítvány nem ugyanaz.
sec-error-busy = Az NSS nem tud leállni. Az objektumok még használatban vannak.
sec-error-extra-input = A DER-kódolt üzenet felesleges használatlan adatot tartalmazott.
sec-error-unsupported-elliptic-curve = Nem támogatott elliptikus görbe.
sec-error-unsupported-ec-point-form = Nem támogatott elliptikus görbepontképlet.
sec-error-unrecognized-oid = Nem felismert objektumazonosító.
sec-error-ocsp-invalid-signing-cert = Érvénytelen OCSP-aláírótanúsítvány az OCSP-válaszban.
sec-error-revoked-certificate-crl = A tanúsítvány vissza van vonva a kiadó tanúsítvány-visszavonási listáján.
sec-error-revoked-certificate-ocsp = A kiadó OCSP-válaszadója azt jelzi, hogy a tanúsítvány vissza van vonva.
sec-error-crl-invalid-version = A kiadó tanúsítvány-visszavonási listájának verziószáma ismeretlen.
sec-error-crl-v1-critical-extension = A kiadó V1 tanúsítvány-visszavonó listája kritikus kiterjesztést tartalmaz.
sec-error-crl-unknown-critical-extension = A kiadó V2 tanúsítvány-visszavonó listája ismeretlen kritikus kiterjesztést tartalmaz.
sec-error-unknown-object-type = Ismeretlen objektumtípus lett megadva.
sec-error-incompatible-pkcs11 = A PKCS #11 illesztőprogram inkompatibilis módon megsérti a specifikációt.
sec-error-no-event = Jelenleg nincs új elérhető slot esemény.
sec-error-crl-already-exists = Már van CRL.
sec-error-not-initialized = Az NSS nincs inicializálva.
sec-error-token-not-logged-in = A művelet sikertelen volt, mert a PKCS#11 token nincs bejelentkezve.
sec-error-ocsp-responder-cert-invalid = A konfigurált OCSP-válaszadó tanúsítványa érvénytelen.
sec-error-ocsp-bad-signature = Az OCSP-válasz aláírása érvénytelen.
sec-error-out-of-search-limits = A tanúsítvány-ellenőrzési keresés kívül esik a keresési korlátokon
sec-error-invalid-policy-mapping = A házirendleképezés tetszőleges házirend értéket tartalmaz
sec-error-policy-validation-failed = A tanúsítványlánc nem megy át a házirend-ellenőrzésen
sec-error-unknown-aia-location-type = Ismeretlen helytípus a tanúsítvány AIA kiterjesztésében
sec-error-bad-http-response = A kiszolgáló rossz HTTP-választ adott vissza
sec-error-bad-ldap-response = A kiszolgáló rossz LDAP-választ adott vissza
sec-error-failed-to-encode-data = Nem sikerült kódolni az adatokat az ASN1 kódolóval
sec-error-bad-info-access-location = Hibás információ-hozzáférés a tanúsítványkiterjesztésben
sec-error-libpkix-internal = Libpkix belső hiba történt a tanúsítvány érvényesítése közben.
sec-error-pkcs11-general-error = Egy PKCS #11 modul CKR_GENERAL_ERROR hibát adott vissza, amely azt jelzi, hogy helyrehozhatatlan hiba történt.
sec-error-pkcs11-function-failed = Egy PKCS #11 modul CKR_FUNCTION_FAILED hibát adott vissza, amely azt jelzi, hogy a kért művelet nem volt elvégezhető. Ugyanez a művelet legközelebb sikerülhet.
sec-error-pkcs11-device-error = Egy PKCS #11 modul CKR_DEVICE_ERROR hibát adott vissza, amely azt jelzi, hogy valami probléma van a tokennel vagy a slottal.
sec-error-bad-info-access-method = Ismeretlen információ-hozzáférési metódus a tanúsítványkiterjesztésben.
sec-error-crl-import-failed = Hiba történt egy CRL importálása közben.
sec-error-expired-password = A jelszó lejárt.
sec-error-locked-password = A jelszó zárolva van.
sec-error-unknown-pkcs11-error = Ismeretlen PKCS #11 hiba.
sec-error-bad-crl-dp-url = Érvénytelen vagy nem támogatott URL a CRL terjesztési pont nevében.
sec-error-cert-signature-algorithm-disabled = A tanúsítvány egy nem biztonságos, és emiatt letiltott aláírási algoritmussal lett aláírva.
mozilla-pkix-error-key-pinning-failure = A kiszolgáló a kulcsrögzítést (HPKP) használja, de nem hozható létre a rögzítési készletnek megfelelő megbízható tanúsítványlánc. A kulcsrögzítés irányelvsértései nem bírálhatók felül.
mozilla-pkix-error-ca-cert-used-as-end-entity = A kiszolgáló által használt tanúsítvány alapvető megszorítások kiterjesztése hitelesítésszolgáltatóként azonosítja. A megfelelően kibocsátott tanúsítványok esetén ennek nem így kell lennie.
mozilla-pkix-error-inadequate-key-size = A kiszolgáló által bemutatott tanúsítvány kulcsmérete túl kicsi biztonságos kapcsolat létrehozásához.
mozilla-pkix-error-v1-cert-used-as-ca = A kiszolgáló tanúsítványa egy 1-es verziójú, nem trust anchor X.509 tanúsítvány használatával lett kibocsátva. Az 1-es verziójú X.509 tanúsítványok elavultak, és ezeket nem szabad más tanúsítványok aláírására használni.
mozilla-pkix-error-not-yet-valid-certificate = A kiszolgáló által bemutatott tanúsítvány még nem érvényes.
mozilla-pkix-error-not-yet-valid-issuer-certificate = A kiszolgáló tanúsítványának kiadásához egy még nem érvényes tanúsítvány lett felhasználva.
mozilla-pkix-error-signature-algorithm-mismatch = A tanúsítvány aláírás mezőjében lévő aláírás-algoritmus nem egyezik a signatureAlgorithm mezőjében lévő algoritmussal.
mozilla-pkix-error-ocsp-response-for-cert-missing = Az OCSP válasz nem tartalmaz állapotot az ellenőrzött tanúsítványhoz.
mozilla-pkix-error-validity-too-long = A kiszolgáló által bemutatott tanúsítvány túl sokáig érvényes.
mozilla-pkix-error-required-tls-feature-missing = Egy szükséges TLS funkció hiányzik.
mozilla-pkix-error-invalid-integer-encoding = A kiszolgáló egy egész szám érvénytelen kódolását tartalmazó tanúsítványt mutatott be. Ezt gyakran negatív sorozatszámok, negatív RSA modulusok, és a szükségesnél hosszabb kódolások okozzák.
mozilla-pkix-error-empty-issuer-name = A kiszolgáló által bemutatott tanúsítványban a kibocsátó megkülönböztető neve üres.
mozilla-pkix-error-additional-policy-constraint-failed = Egy további házirendmegszorítás lett megsértve a tanúsítvány érvényesítésekor.
mozilla-pkix-error-self-signed-cert = A tanúsítvány nem megbízható, mert a saját kibocsátója által van aláírva.
