#!/bin/bash
if [ ! -d $HOME/.pyNeighborhood ];then
   mkdir $HOME/.pyNeighborhood
   chown $USER:$USER $HOME/.pyNeighborhood
fi
if [ ! -d $HOME/Network ];then
   mkdir -p $HOME/Network
   chown -R $USER:$USER $HOME/Network
fi
if [ ! -d $HOME/.smb ];then
   mkdir -p $HOME/.smb
   chown -R $USER:$USER $HOME/.smb
   chown -R $USER:$USER $HOME/.smb/*.conf
   chmod 600 $HOME/.smb/*.*
fi
if [ ! -r $HOME/.linuxmint/mintDesktop ];then
	mkdir -p $HOME/.linuxmint
	touch $HOME/.linuxmint/mintDesktop
	touch $HOME/.linuxmint/mintDesktop_smb_browsing	
	mkdir -p $HOME/Network	
	chown -R $USER:$USER $HOME/.linuxmint
	chown -R $USER:$USER $HOME/Network
fi

if [ ! -f $HOME/.pyNeighborhood/options.conf ];then
	touch $HOME/.pyNeighborhood/options.conf
	echo mount_directory = $HOME/Network >> $HOME/.pyNeighborhood/options.conf
	echo delete_dirs = True >> $HOME/.pyNeighborhood/options.conf
	echo file_managers = /usr/bin/Thunar >> $HOME/.pyNeighborhood/options.conf
	chown $USER:$USER $HOME/.pyNeighborhood
	chown $USER:$USER $HOME/.pyNeighborhood/*
	chmod 600 $HOME/.pyNeighborhood/*
fi

if [ ! -f $HOME/.pyNeighborhood/config ];then
	touch $HOME/.pyNeighborhood/config
	echo [Main] >> $HOME/.pyNeighborhood/config
	echo mount_directory = $HOME/Network >> $HOME/.pyNeighborhood/config
	echo username = >> $HOME/.pyNeighborhood/config
	echo smbtree = /usr/bin/smbtree >> $HOME/.pyNeighborhood/config
	echo smbclient = /usr/bin/smbclient >> $HOME/.pyNeighborhood/config
	echo sudo = /usr/bin/gksu >> $HOME/.pyNeighborhood/config
	echo filemanager = /usr/bin/Thunar >> $HOME/.pyNeighborhood/config
	echo enable_file_manager = True >> $HOME/.pyNeighborhood/config
	echo nmblookup = /usr/bin/nmblookup >> $HOME/.pyNeighborhood/config
	echo legacy_browsing = False >> $HOME/.pyNeighborhood/config
	echo enable_sudo = True >> $HOME/.pyNeighborhood/config
	echo cleanup_dirs = True >> $HOME/.pyNeighborhood/config
	echo password =  >> $HOME/.pyNeighborhood/config
	echo workgroup =  >> $HOME/.pyNeighborhood/config
	echo  >> $HOME/.pyNeighborhood/config
	echo [SMB] >> $HOME/.pyNeighborhood/config
	echo mount = /usr/bin/smbmount >> $HOME/.pyNeighborhood/config
	echo enable = True >> $HOME/.pyNeighborhood/config
	echo unmount = /usr/bin/smbumount >> $HOME/.pyNeighborhood/config
	echo options =  >> $HOME/.pyNeighborhood/config
	echo  >> $HOME/.pyNeighborhood/config
	echo [CIFS] >> $HOME/.pyNeighborhood/config
	echo mount = /sbin/mount.cifs >> $HOME/.pyNeighborhood/config
	echo enable = True >> $HOME/.pyNeighborhood/config
	echo unmount = /sbin/umount.cifs >> $HOME/.pyNeighborhood/config
	echo options =  >> $HOME/.pyNeighborhood/config
	echo  >> $HOME/.pyNeighborhood/config
	chown $USER:$USER $HOME/.pyNeighborhood
	chown $USER:$USER $HOME/.pyNeighborhood/*
	chmod 600 $HOME/.pyNeighborhood/*
fi

if [ ! -d $HOME/Network/* ];then
	chown -R $USER:$USER $HOME/Network
fi
sleep 30
restartx=$(gconftool-2 --get /apps/mintdesktop-xfce/cab_toggle)
if [ "$restartx" = "" ]; then
	gconftool-2 --type bool --set /apps/mintdesktop-xfce/cab_toggle true
	setxkbmap -option terminate:ctrl_alt_bksp
elif [ "$restartx" = "true" ]; then
	setxkbmap -option terminate:ctrl_alt_bksp
elif [ "$restartx" = "false" ]; then
	exit 0
else
	exit 0
fi