/* Main module for the GyachE-Webcam viewer program */

/* This program borrows alot of code from both Ayttm and 
    Gyach-E itself, however, this program is a completely 
    restructured webcam viewer that handles sockets and threads
    in the Gyach-E way, not the Ayttm way of many threads, many 
    structs, etc.  It is designed for simplicity, speed, 
    memory-friendliness, and stability: It runs as an EXTERNAL 
    program to Gyach Enhanced, so that if it DOES crash, it 
    crashes ALONE, rather than taking down an entire chat program
    with it. It is a clean, efficient SINGLE-THREADED application */

/*****************************************************************************
 * main.c
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston,
 * MA 02111-1307, USA.
 *
 * Copyright (C) 2003-2004 Erica Andrews (Phrozensmoke ['a'] yahoo.com)
 * Released under the terms of the GPL.
 * *NO WARRANTY*
 *****************************************************************************/
/* 
	Ayttm is  Copyright (C) 2003, the Ayttm team
	and Copyright (C) 1999-2002, Torrey Searle <tsearle@uci.edu>
*/

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <sys/types.h>
#include <signal.h>
#include <time.h>
#include <unistd.h>
#include <stdlib.h>
#include <string.h>
#include <libintl.h>  /* added PhrozenSmoke: locale support */
#include <locale.h>   /* added PhrozenSmoke: locale support */

#include <gtk/gtk.h>
#include <gdk-pixbuf/gdk-pixbuf.h>

#include "gyachewebcam.h"
#include "camcapt.h"
#include "gyacheupload-v4l.h"
#include "gyacheupload-ui.h"

#include "gy_config.h"


extern GtkWidget *vstatuslabel;
GtkWidget *main_window;

int cam_app_quit=0;
unsigned long sock_sleep=200;

/* FOR TESTING */ /* 
int jpfswitch=0; 
 */

char *_(char *some)   /* added PhrozenSmoke: locale support */
{
	return gettext(some);
}

int display_disconnect_message(void *arg) {
	char gbuf[255];
	int len;
	int max = sizeof(gbuf);

	gbuf[max-1] = 0;
	strncpy(gbuf, _("You have been disconnected from Yahoo!: Broken pipe."), max-1);
	len = strlen(gbuf);

	if (len < (max-3)) {
		strncat(gbuf, "\n", max-len-1);
	}
	len = strlen(gbuf);
	strncat(gbuf, _("You have been disconnected from the Yahoo webcam server."), max-len-1);
	show_ok_dialog(gbuf, main_window, _("Webcam Viewer"), 0, NULL);
	mem_cleanup();
	return(FALSE);
}

void SIGPIPE_Handler (int signo) {
	if (signo == SIGPIPE) {
		g_idle_add(display_disconnect_message, NULL);
	}
}


int main( int argc, char **argv ) {
	struct timeval tv;
	fd_set set;
	int ret;
	char titlebuf[102]="";

	/* Takes 3-7 command-line arguments right now:
		[who_we_are_viewing], string...'nobody' if uploading/broadcasting
		[your_screename], string
		[web_cam_key_from_gyachE], string
		[webcam_server] - string
		[webcam_port] - ignored for now, int
		[connection_speed] - ignored for now, int
	*/
		
	if (argc<5) {
		printf("\n   Gyach Enhanced / GYachI External Webcam Viewer\n   Version:  %s\n   License:  GNU General Public License\n   Copyright (c) 2004 Erica Andrews\n   PhrozenSmoke ['at'] yahoo.com\n\n   Copyright (c) 2006 Stefan Sikora\n   hoshy ['at'] schrauberstube.de\n\n   Copyright (c) 2008 Gregory D Hosler\n   ghosler ['at'] users.sourceforge.net\n\nUsage: gyache-webcam [who_we_are_viewing] [your_screename] [web_cam_key_from_gyachE] [webcam_server]\n\n   You should be running this\n   program in GyachE Improved,\n   NOT on the command-line!\n\n", CAM_VERSION);
		fflush(stdout);
		exit(0);
	}

	webcam_to_view=strdup(argv[1]);
	whoami=strdup(argv[2]);
	webcam_key=strdup(argv[3]);
	webcam_server=strdup(argv[4]);
printf("webcam-server is: %s\n", webcam_server);
	setlocale(LC_ALL, "");
#ifdef ENABLE_NLS
	bindtextdomain (GETTEXT_PACKAGE, LOCALEDIR);  
	bind_textdomain_codeset(GETTEXT_PACKAGE, "UTF-8");
	textdomain (GETTEXT_PACKAGE);
#endif
	gtk_set_locale();

	gtk_init( &argc, &argv );
    
	gyach_init();

	/* init GUI */
	snprintf(titlebuf, 100, "%s: %s", webcam_to_view, _("Webcam"));
	main_window = gyache_image_window_new(320, 240, titlebuf);
	gtk_label_set_text(GTK_LABEL(vstatuslabel), _("Connecting..."));

	/* Trap possible broken pipe crap with msg dialog instead of 
	    abrupt exiting of the app */

	if (signal(SIGPIPE, SIGPIPE_Handler) == SIG_ERR) {  }

	while( gtk_events_pending()) {
		gtk_main_iteration();
	}

	start_connection(main_window) ;   /*  disable in testing mode! */	

	while( ! cam_app_quit ) {
		while( gtk_events_pending()) {
			gtk_main_iteration();
		}

		if (image_need_update)  {
			if (! video_paused) {
				update_webcam_image(main_window);
				gtk_widget_show_all( current_image );
				image_need_update=0;
			}
		}

		while( gtk_events_pending()) {
			gtk_main_iteration();
		}

		/* now check for input on our socket */
		FD_ZERO( &set );
		if (webcam_connected) {
			if ( camsocket != -1 ) {
				FD_SET( camsocket, &set );
				tv.tv_sec = 0;
				tv.tv_usec = 50000;
				ret = select( camsocket + 1, &set, NULL, NULL, &tv );

				if ( ret ) {
					show_webcam_packet(main_window);
					usleep(sock_sleep);   /* a little flow control */
				}
			} /* end if */
		} /* end if */ else {usleep(sock_sleep); } 
	}  /* end while */

	mem_cleanup();
	return( 0 );
}

