# Copyright (C) 2003, 2004 Konstantin Korikov

#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

import gtk
import gtk.glade
import gobject
import re
import os.path
import time
import commands
import chestnut_dialer
from chestnut_dialer import _

try: import pango
except ImportError: pass

main_glade_file = os.path.dirname(__file__) + "/main.glade"

class BaseBox:
  widget = None
  def destroy(self):
    pass
  def setup_accels(self, accel_group):
    pass

class SelectAccountBox(BaseBox):
  sw = None
  sw_vadj_value = 0
  accounts = None
  btn_box = None
  connect_handler = None
  def __init__(self, accounts, connect_handler):
    self.accounts = accounts
    self.connect_handler = connect_handler
    xml = gtk.glade.XML(main_glade_file, "SelectAccountBox",
        chestnut_dialer.domain)
    self.widget = xml.get_widget("SelectAccountBox")
    self.btn_box = xml.get_widget("AccountBox")
    self.sw = xml.get_widget("ScrolledWindow")
    self.widget.connect("size-allocate", self.size_allocate_event)
    self.refresh()
  def destroy(self):
    self.accounts = None
    self.connect_handler = None
    SelectAccountBox.sw_vadj_value = self.sw.get_vadjustment().get_value()
  def refresh(self):
    acc_list = self.accounts.ls_accounts()
    acc_list.sort(lambda a,b: cmp(a[0].lower(), b[0].lower()))
    for b in self.btn_box.get_children(): b.destroy()
    for a in acc_list:
      b = gtk.Button()
      b.set_label(a[0])
      b.connect("clicked", self.connect_handler, a[1])
      self.btn_box.pack_start(b, expand=0)
    self.btn_box.show_all()
  def size_allocate_event(self, *args):
    if self.sw_vadj_value != None:
      self.sw.get_vadjustment().set_value(SelectAccountBox.sw_vadj_value)
      self.sw_vadj_value = None
      
class ConnectingBox(BaseBox):
  text_widget = None
  text_view = None
  stop_btn = None
  def __init__(self, acc_name, terminate_handler):
    xml = gtk.glade.XML(main_glade_file, "ConnectingBox",
        chestnut_dialer.domain)
    self.widget = xml.get_widget("ConnectingBox")    
    self.init_text_widget()
    xml.get_widget("Text").add(self.text_widget)
    label = xml.get_widget("Label")
    label.set_text(_("Connecting to %s") % acc_name);
    xml.signal_connect("stop", terminate_handler)  
    self.stop_btn = xml.get_widget("StopButton")
  def init_text_widget(self):
    self.text_widget = gtk.ScrolledWindow()
    self.text_widget.set_policy(gtk.POLICY_AUTOMATIC, gtk.POLICY_AUTOMATIC)
    self.text_view = gtk.TextView()
    self.text_view.set_editable(False)
    try: self.text_view.modify_font(pango.FontDescription("Monospace 9"))
    except NameError: pass
    self.text_widget.add(self.text_view)
  def add_text(self, text):
    buf = self.text_view.get_buffer()
    buf.insert(buf.get_end_iter(), text)
    buf.place_cursor(buf.get_end_iter())
    self.text_view.set_property('has-focus', True)
    a = self.text_widget.get_vadjustment()
    a.set_value(a.upper)
  def setup_accels(self, accel_group):
    self.stop_btn.set_accel_path("<ChestnutDialer-Main>/Connecting/Stop",
        accel_group)

class StatusBox(BaseBox):
  connection = None
  params = [
    'account_name',
    'speed', 
    'time', 
    'interface',
    'local_ip',
    'remote_ip',
    'netmask',
    'rx',
    'tx',
    'rx_bytes',
    'tx_bytes']
  disconnect_btn = None
  def __init__(self, connection, disconnect_handler):
    self.connection = connection
    param_titles = [
      _("Connected to:"),
      _("Speed:"), 
      _("Time:"), 
      _("Interface:"),
      _("Local IP:"),
      _("Remote IP:"),
      _("Netmask:"),
      _("Receive:"),
      _("Send:"),
      _("Receive bytes:"),
      _("Send bytes:")]
    xml = gtk.glade.XML(main_glade_file, "StatusBox",
        chestnut_dialer.domain)
    self.widget = xml.get_widget("StatusBox")    
    tbl = gtk.Table(len(self.params), 2)
    tbl.set_border_width(5)
    tbl.set_col_spacings(5)
    tbl.set_row_spacings(0)    
    self.param_widgets = []
    for i in range(0, len(self.params)):
      l = gtk.Label(param_titles[i])
      l.set_alignment(1.0, 0.5)
      tbl.attach(l, 0, 1, i, i + 1, gtk.FILL, gtk.SHRINK)
      w = gtk.Label("")
      w.set_alignment(0.0, 0.5)
      w.set_selectable(1)
      w.set_padding(2, 2)
      f = gtk.Frame()
      f.add(w)
      tbl.attach(f, 1, 2, i, i + 1, gtk.EXPAND|gtk.FILL, gtk.SHRINK)
      self.param_widgets.append(w)
    box = xml.get_widget("Box")
    box.pack_start(tbl, expand=0)
    self.refresh()
    xml.signal_connect("disconnect", disconnect_handler)
    xml.signal_connect("refresh", self.refresh)
    self.disconnect_btn = xml.get_widget("DisconnectButton")
  def destroy(self):
    self.connection = None
    self.param_widgets = None
  def refresh(self, *args):
    info = self.connection.get_info()
    for i in range(0, len(self.params)):
      try: self.param_widgets[i].set_text(unicode(info[self.params[i]]))
      except KeyError: pass
  def setup_accels(self, accel_group):
    self.disconnect_btn.set_accel_path(
        "<ChestnutDialer-Main>/Status/Disconnect", accel_group)

