/* testing.c 
 *   by Nathan Laredo (laredo@gnu.org)
 *
 * Stradis 4:2:2 MPEG-2 Decoder Feature Tester
 * Copyright (C) 1999 Nathan Laredo <laredo@gnu.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>
#include <unistd.h>
#include <string.h>
#include <ctype.h>
#include <fcntl.h>
#include <errno.h>
#include <sys/stat.h>
#include <sys/mman.h>
#include <sys/ioctl.h>
#include <sys/types.h>
#include <sys/time.h>
#include <linux/types.h>
#include <linux/videodev.h>

int videofd;

int main(int argc, char **argv)
{
	int f, d = 0;
	struct video_play_mode p;
	char outf[25];

	if (argc < 4) {
		fprintf(stderr, "usage: %s mode p1 p2 dev\n", argv[0]);
		exit(1);
	}
	p.mode = atoi(argv[1]);
	p.p1 = atoi(argv[2]);
	p.p2 = atoi(argv[3]);
	d = atoi(argv[4]);
	sprintf(outf, "/dev/video%d", d);
	if ((videofd = open(outf, O_WRONLY)) < 0) {
		perror(outf);
		exit(1);
	}
	printf("ioctl(/dev/video%d, VIDIOCSPLAYMODE, p{%d,%d,%d}\n", d, p.mode,
		p.p1, p.p2);
	if (ioctl(videofd, VIDIOCSPLAYMODE, &p) < 0)
		perror("ioctl");
	close(f);
	exit(0);
}				/* main */
