/*
 * Copyright (c) 1997 by Procom Technology,Inc.
 *
 * This program can be redistributed or modified under the terms of the 
 * GNU General Public License as published by the Free Software Foundation.
 * This program is distributed without any warranty or implied warranty
 * of merchantability or fitness for a particular purpose.
 *
 * See the GNU General Public License for more details.
 *
 */
 
/* 
 * Defines interface to linux-specific system-level functions 
 */


#ifndef OS_IF_H
#define OS_IF_H


/* Interrupt enable/disable */
#define disable_interrupts(f)  save_flags (f); \
                               cli ()

#define enable_interrupts(f)   restore_flags (f)


/* Callbacks supported for LLC and NetBEUI layers only */

#define OS_CB_LLC          1
#define OS_CB_NB           2


typedef void           (*timer_callback_t)(us32);


#ifdef OS_IF_C
#define EXTRN
#else
#define EXTRN extern
#endif /* OS_IF_C */


EXTRN us16         os_tmr_create (mph_t mph, void ** timer);
EXTRN us16         os_tmr_set (void * timer, us32 ticks);
EXTRN us16         os_tmr_start (void * timer,
                                   timer_callback_t callback_func,
                                                           void * tmr_data);
EXTRN us16         os_tmr_stop (void * timer);


#undef EXTRN
#endif  /* OS_IF_H */


