/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.isg.archiver;

import gov.nist.isg.archiver.FilesArchiver;
import java.io.File;
import java.io.IOException;

public class FilesArchiverTools {
    private FilesArchiverTools() {
    }

    public static void addFolderToArchive(FilesArchiver archiver, File folder) throws IOException {
        FilesArchiverTools.addFolderToArchive(archiver, folder, "");
    }

    public static void addFolderToArchive(FilesArchiver archiver, File folder, String basePath) throws IOException {
        File[] files;
        if (!folder.isDirectory()) {
            throw new IllegalArgumentException("Path " + folder + " is not a directory.");
        }
        for (File file : files = folder.listFiles()) {
            String filename = file.getName();
            String concat = new File(basePath, filename).getPath();
            if (file.isFile()) {
                archiver.appendFile(concat, file);
                continue;
            }
            if (!file.isDirectory()) continue;
            FilesArchiverTools.addFolderToArchive(archiver, file, concat);
        }
    }
}

