/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.util.ui.treelist;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.prefs.Preferences;
import org.openide.util.NbPreferences;

public class TreeListSettings {
    public static final String PROP_DESCRIPTIONS = "descriptions";
    private static final String PREF_DESCRIPTION_STATE = "treelist.descriptions.state";
    private static TreeListSettings _instance;
    private final PropertyChangeSupport _changeSupport = new PropertyChangeSupport(this);

    private TreeListSettings() {
    }

    public static synchronized TreeListSettings getInstance() {
        if (_instance == null) {
            _instance = new TreeListSettings();
        }
        return _instance;
    }

    public boolean isShowDescriptions() {
        return this.getDescriptionState() != DescriptionState.HIDE;
    }

    public boolean isShowSingleLineDescriptions() {
        return this.getDescriptionState() == DescriptionState.SINGLE_LINE;
    }

    public boolean isShowMultiLineDescriptions() {
        return this.getDescriptionState() == DescriptionState.MULTI_LINE;
    }

    public void hideDescriptions() {
        this.setDescriptionState(DescriptionState.HIDE);
    }

    public void showSingleLineDescriptions() {
        this.setDescriptionState(DescriptionState.SINGLE_LINE);
    }

    public void showMultiLineDescriptions() {
        this.setDescriptionState(DescriptionState.MULTI_LINE);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this._changeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this._changeSupport.removePropertyChangeListener(listener);
    }

    private DescriptionState getDescriptionState() {
        int defaultCode = DescriptionState.SINGLE_LINE.getCode();
        int code = TreeListSettings.getPrefs().getInt(PREF_DESCRIPTION_STATE, defaultCode);
        return DescriptionState.fromCode(code);
    }

    private void setDescriptionState(DescriptionState state) {
        if (state != this.getDescriptionState()) {
            TreeListSettings.getPrefs().putInt(PREF_DESCRIPTION_STATE, state.getCode());
            this._changeSupport.firePropertyChange(PROP_DESCRIPTIONS, null, null);
        }
    }

    private static Preferences getPrefs() {
        return NbPreferences.forModule(TreeListSettings.class);
    }

    private static enum DescriptionState {
        HIDE(0),
        SINGLE_LINE(1),
        MULTI_LINE(2);

        private final int _code;

        private DescriptionState(int code) {
            this._code = code;
        }

        public static DescriptionState fromCode(int code) {
            for (DescriptionState state : DescriptionState.values()) {
                if (state.getCode() != code) continue;
                return state;
            }
            return null;
        }

        public int getCode() {
            return this._code;
        }
    }
}

