/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.util.ui.laf.debug;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import javax.swing.AbstractButton;
import javax.swing.DefaultButtonModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;

public class SafeIcon
implements Icon {
    private final Icon wrappee;
    private Icon standIn;

    public SafeIcon(Icon wrappee) {
        this.wrappee = wrappee;
    }

    @Override
    public int getIconHeight() {
        return this.wrappee.getIconHeight();
    }

    @Override
    public int getIconWidth() {
        return this.wrappee.getIconWidth();
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        if (this.standIn == this) {
            this.paintFallback(c, g, x, y);
        } else if (this.standIn != null) {
            this.standIn.paintIcon(c, g, x, y);
        } else {
            try {
                this.wrappee.paintIcon(c, g, x, y);
            }
            catch (ClassCastException e) {
                this.createStandIn(e, x, y);
                this.standIn.paintIcon(c, g, x, y);
            }
        }
    }

    private void createStandIn(ClassCastException e, int x, int y) {
        try {
            Class<?> clazz = this.getClass(e);
            JComponent standInComponent = this.getSubstitute(clazz);
            this.standIn = this.createImageIcon(standInComponent, x, y);
        }
        catch (Exception e1) {
            this.standIn = this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Icon createImageIcon(JComponent standInComponent, int x, int y) {
        BufferedImage image = new BufferedImage(this.getIconWidth(), this.getIconHeight(), 2);
        Graphics2D g = image.createGraphics();
        try {
            this.wrappee.paintIcon(standInComponent, g, 0, 0);
            ImageIcon imageIcon = new ImageIcon(image);
            return imageIcon;
        }
        finally {
            g.dispose();
        }
    }

    private JComponent getSubstitute(Class<?> clazz) throws IllegalAccessException {
        JComponent standInComponent;
        try {
            standInComponent = (JComponent)clazz.newInstance();
        }
        catch (InstantiationException e) {
            standInComponent = new AbstractButton(){};
            ((AbstractButton)standInComponent).setModel(new DefaultButtonModel());
        }
        return standInComponent;
    }

    private Class<?> getClass(ClassCastException e) throws ClassNotFoundException {
        String className = e.getMessage();
        className = className.substring(className.lastIndexOf(" ") + 1);
        return Class.forName(className);
    }

    private void paintFallback(Component c, Graphics g, int x, int y) {
        g.drawRect(x, y, this.getIconWidth(), this.getIconHeight());
        g.drawLine(x, y, x + this.getIconWidth(), y + this.getIconHeight());
        g.drawLine(x + this.getIconWidth(), y, x, y + this.getIconHeight());
    }

    public Image getImage() {
        if (this.wrappee == null) {
            return null;
        }
        if (this.wrappee instanceof ImageIcon) {
            return ((ImageIcon)this.wrappee).getImage();
        }
        BufferedImage bImage = new BufferedImage(this.getIconWidth(), this.getIconHeight(), 2);
        this.paintIcon(new JLabel(), bImage.getGraphics(), 0, 0);
        return bImage;
    }

    public BufferedImage getBufferedImage() {
        Image image = this.getImage();
        if (image == null) {
            return null;
        }
        if (image instanceof BufferedImage) {
            return (BufferedImage)image;
        }
        BufferedImage bImage = new BufferedImage(image.getWidth(null), image.getHeight(null), 2);
        Graphics2D g2 = bImage.createGraphics();
        g2.drawImage(image, 0, 0, null);
        g2.dispose();
        return bImage;
    }
}

