/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.automation.view;

import com.paterva.maltego.automation.MachineDescriptor;
import com.paterva.maltego.automation.view.MachineActions;
import com.paterva.maltego.automation.view.MachineNodeAction;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.nodes.Node;

public final class DeleteMachineAction
extends MachineNodeAction {
    public DeleteMachineAction() {
        super("CTL_DeleteMachineAction");
    }

    protected void performAction(Node[] nodes) {
        if (nodes == null || nodes.length == 0) {
            return;
        }
        String toDelete = nodes.length == 1 ? this.getMachine(nodes[0]).getDisplayName() : String.format("these %s machines", nodes.length);
        String msg = String.format("Are you sure you want to delete %s?", toDelete);
        NotifyDescriptor.Confirmation nd = new NotifyDescriptor.Confirmation((Object)msg, "Delete");
        if (NotifyDescriptor.YES_OPTION.equals(DialogDisplayer.getDefault().notify((NotifyDescriptor)nd))) {
            for (Node node : nodes) {
                MachineDescriptor machine = (MachineDescriptor)node.getLookup().lookup(MachineDescriptor.class);
                if (!this.canDelete(machine)) continue;
                MachineActions.delete(machine);
            }
        }
    }

    @Override
    protected boolean enable(Node[] nodes) {
        if (nodes == null || nodes.length == 0) {
            return false;
        }
        for (Node node : nodes) {
            if (this.canDelete(this.getMachine(node))) continue;
            return false;
        }
        return true;
    }

    protected String iconResource() {
        return "com/paterva/maltego/automation/resources/Delete.png";
    }

    private boolean canDelete(MachineDescriptor machine) {
        return machine != null;
    }

    private MachineDescriptor getMachine(Node node) {
        return (MachineDescriptor)node.getLookup().lookup(MachineDescriptor.class);
    }
}

