/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.automation;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;

public abstract class InitializationContext {
    public static InitializationContext EMPTY = new InitializationContext(){

        @Override
        public String[] getErrors() {
            return null;
        }

        @Override
        public int getProgressSteps() {
            return 0;
        }
    };

    public static InitializationContext compound(Collection<InitializationContext> contexts) {
        return new Compound(contexts);
    }

    public abstract String[] getErrors();

    public abstract int getProgressSteps();

    public static InitializationContext getEmpty() {
        return EMPTY;
    }

    public static InitializationContext progress(int steps) {
        return new Progress(steps);
    }

    private static class Compound
    extends InitializationContext {
        private String[] _errors;
        private int _total = 0;

        public Compound(Collection<InitializationContext> contexts) {
            ArrayList<String> errors = new ArrayList<String>();
            for (InitializationContext ctx : contexts) {
                this._total += ctx.getProgressSteps();
                if (ctx.getErrors() == null) continue;
                errors.addAll(Arrays.asList(ctx.getErrors()));
            }
            this._errors = errors.toArray(new String[errors.size()]);
        }

        @Override
        public String[] getErrors() {
            return this._errors;
        }

        @Override
        public int getProgressSteps() {
            return this._total;
        }
    }

    private static class Progress
    extends InitializationContext {
        private int _steps;

        public Progress(int steps) {
            this._steps = steps;
        }

        @Override
        public String[] getErrors() {
            return null;
        }

        @Override
        public int getProgressSteps() {
            return this._steps;
        }
    }
}

