/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.typing.editing.form.adapters;

import com.paterva.maltego.typing.editing.form.adapters.AbstractControlAdapter;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

class UrlTextBoxAdapter
extends AbstractControlAdapter<JTextField, URL> {
    UrlTextBoxAdapter() {
    }

    @Override
    public JTextField create() {
        JTextField field = this.createTextComponent();
        field.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UrlTextBoxAdapter.this.fireEditingFinished(e);
            }
        });
        field.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                UrlTextBoxAdapter.this.fireChange();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                UrlTextBoxAdapter.this.fireChange();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                UrlTextBoxAdapter.this.fireChange();
            }
        });
        return field;
    }

    protected JTextField createTextComponent() {
        return new JTextField(25);
    }

    @Override
    protected void set(JTextField component, URL value) {
        if (value == null) {
            component.setText("");
        } else {
            component.setText(value.toString());
        }
    }

    @Override
    protected URL get(JTextField component) {
        String s = component.getText().trim();
        if (s.isEmpty()) {
            return null;
        }
        URL url = null;
        try {
            url = new URL(s);
        }
        catch (MalformedURLException ex) {
            this.handleError(ex);
        }
        return url;
    }

    @Override
    protected boolean empty(JTextField component) {
        return "".equals(component.getText());
    }
}

