/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.typing.editing.controls;

import com.paterva.maltego.typing.Converter;
import com.paterva.maltego.typing.FormattedConverter;
import com.paterva.maltego.typing.editing.UnsupportedEditorException;
import com.paterva.maltego.typing.editing.controls.ArrayEditorPanel;
import com.paterva.maltego.typing.editing.form.adapters.DefaultAdapterFactory;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.Format;
import java.text.ParseException;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentListener;
import javax.swing.event.EventListenerList;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.util.Exceptions;

public class ArrayEditorTextBox
extends JPanel {
    private Class _type;
    private JTextField _textField;
    private ArrayEditorPanel _browser;
    private EventListenerList _listeners;
    private Format _format;

    public ArrayEditorTextBox(Class type) {
        this(type, null);
    }

    public ArrayEditorTextBox(Class type, Format format) {
        super(new BorderLayout(0, 0));
        if (type == null) {
            throw new IllegalArgumentException("Type cannot be null");
        }
        if (!type.isArray()) {
            throw new IllegalArgumentException("ArrayEditorTextBox can only be used with array types");
        }
        this._type = type;
        this._format = format;
        this._textField = new JTextField();
        JButton browseButton = new JButton("...");
        browseButton.setMargin(new Insets(0, 1, 0, 1));
        browseButton.setFocusPainted(false);
        this.add((Component)this._textField, "Center");
        this.add((Component)browseButton, "East");
        browseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ArrayEditorTextBox.this.browse();
            }
        });
        this._textField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ArrayEditorTextBox.this.fireActionPerformed(e);
            }
        });
    }

    private EventListenerList listeners() {
        if (this._listeners == null) {
            this._listeners = new EventListenerList();
        }
        return this._listeners;
    }

    public void addDocumentListener(DocumentListener listener) {
        this._textField.getDocument().addDocumentListener(listener);
    }

    public void removeDocumentListener(DocumentListener listener) {
        this._textField.getDocument().removeDocumentListener(listener);
    }

    public void addActionListener(ActionListener listener) {
        this.listeners().add(ActionListener.class, listener);
    }

    public void removeActiontListener(ActionListener listener) {
        this.listeners().remove(ActionListener.class, listener);
    }

    protected void fireActionPerformed(ActionEvent e) {
        if (this._listeners != null) {
            for (ActionListener l : (ActionListener[])this._listeners.getListeners(ActionListener.class)) {
                l.actionPerformed(e);
            }
        }
    }

    private void browse() {
        if (this._browser == null) {
            try {
                this._browser = new ArrayEditorPanel(DefaultAdapterFactory.instance().create(this._type.getComponentType(), this._format), this._format);
            }
            catch (UnsupportedEditorException ex) {
                Exceptions.printStackTrace((Throwable)ex);
                return;
            }
        }
        this._browser.setValue(this.getValue());
        if (this.showBrowseDialog(this._browser)) {
            this.setValue((Object[])Converter.changeArrayType((Object)this._browser.getValue(), (Class)Converter.getReferenceType(this._type.getComponentType())));
            this.fireActionPerformed(new ActionEvent(this, 0, "valueSet"));
        }
    }

    public String getText() {
        return this._textField.getText();
    }

    public void setText(String text) {
        this._textField.setText(text);
        this.validate();
    }

    public Object[] getValue() {
        try {
            Object array = FormattedConverter.convertFrom((String)this._textField.getText(), (Class)this._type, (Format)this._format);
            return (Object[])Converter.changeArrayType((Object)array, (Class)Converter.getReferenceType(this._type.getComponentType()));
        }
        catch (ParseException ex) {
            return null;
        }
    }

    public void setValue(Object[] value) {
        this._textField.setText(FormattedConverter.convertTo((Object)value, (Class)this._type, (Format)this._format));
    }

    private boolean showBrowseDialog(Object payload) {
        DialogDescriptor dd = new DialogDescriptor(payload, "Array Editor", true, 2, DialogDescriptor.OK_OPTION, null);
        dd.setClosingOptions(new Object[]{DialogDescriptor.OK_OPTION, DialogDescriptor.CANCEL_OPTION});
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dd);
        dialog.setResizable(true);
        dialog.setLocationRelativeTo(null);
        dialog.setVisible(true);
        return dd.getValue() == DialogDescriptor.OK_OPTION;
    }
}

