/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.transform.manager.sets;

import com.paterva.maltego.transform.descriptor.TransformSet;
import com.paterva.maltego.transform.descriptor.TransformSetRepository;
import java.awt.Component;
import javax.swing.AbstractButton;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.actions.NodeAction;

public class DeleteTransformSetAction
extends NodeAction {
    protected void performAction(Node[] nodes) {
        TransformSet set;
        if (nodes.length == 1 && !(set = (TransformSet)nodes[0].getLookup().lookup(TransformSet.class)).isReadOnly()) {
            NotifyDescriptor.Confirmation descriptor = new NotifyDescriptor.Confirmation((Object)("Are you sure you want to delete the set '" + set.getName() + "'?"), "Delete " + set.getName(), 2);
            if (DialogDisplayer.getDefault().notify((NotifyDescriptor)descriptor) == NotifyDescriptor.OK_OPTION) {
                TransformSetRepository.getDefault().remove(set.getName());
            }
        }
    }

    protected boolean enable(Node[] nodes) {
        if (nodes.length == 1) {
            TransformSet set = (TransformSet)nodes[0].getLookup().lookup(TransformSet.class);
            return set != null && !set.isReadOnly();
        }
        return false;
    }

    public String getName() {
        return "Delete...";
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    protected String iconResource() {
        return "com/paterva/maltego/transform/manager/sets/DeleteTransformSet.png";
    }

    public Component getToolbarPresenter() {
        Component c = super.getToolbarPresenter();
        if (c instanceof AbstractButton) {
            ((AbstractButton)c).setText(this.getName());
        }
        return c;
    }

    protected boolean asynchronous() {
        return false;
    }
}

