/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.ui.graph.merge;

import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.core.MaltegoEntity;
import com.paterva.maltego.merging.PartMergeStrategy;
import com.paterva.maltego.ui.graph.merge.MergeOptionsPanel;
import java.util.prefs.Preferences;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.NbPreferences;

public class MergeOptionsController {
    private static final String MERGE_SETTING = "mergeOptionsMergeEnabled";
    private static final String SKIP_SETTING = "mergeOptionsSkipEnabled";
    private static final String STRATEGY_SETTING = "mergeOptionsStrategy";
    private static final int STRAT_PREFER_NEW = 0;
    private static final int STRAT_PREFER_OLD = 1;
    private static final int STRAT_REPLACE = 2;
    private static final int STRAT_KEEP_OLD = 3;
    private final GraphID _destGraphID;
    private final GraphID _srcGraphID;
    private final MaltegoEntity _srcEntity;
    private final MaltegoEntity _destEntity;
    private final int _remaining;
    private final Preferences _prefs;
    private boolean _doForAll;

    public MergeOptionsController(GraphID destGraphID, GraphID srcGraphID, MaltegoEntity destEntity, MaltegoEntity srcEntity, int remaining) {
        this._destGraphID = destGraphID;
        this._srcGraphID = srcGraphID;
        this._destEntity = destEntity;
        this._srcEntity = srcEntity;
        this._remaining = remaining;
        this._prefs = NbPreferences.forModule(MergeOptionsPanel.class);
    }

    public boolean showMergeOptions() {
        MergeOptionsPanel panel = new MergeOptionsPanel(this._destGraphID, this._srcGraphID, this._destEntity, this._srcEntity, this._remaining);
        this.readSettings(panel);
        DialogDescriptor nd = new DialogDescriptor((Object)panel, "Entities Match", true, 2, DialogDescriptor.OK_OPTION, null);
        if (DialogDescriptor.OK_OPTION.equals(DialogDisplayer.getDefault().notify((NotifyDescriptor)nd))) {
            this.storeSettings(panel);
            this._doForAll = panel.isDoForAll();
            return true;
        }
        return false;
    }

    public boolean isDoForAll() {
        return this._doForAll;
    }

    public boolean isSkipEntity() {
        return this._prefs.getBoolean(SKIP_SETTING, false);
    }

    public boolean isKeepBothEntity() {
        return !this.isMergeEntities() && !this.isSkipEntity();
    }

    public boolean isMergeEntities() {
        return this._prefs.getBoolean(MERGE_SETTING, true);
    }

    public PartMergeStrategy getMergeStrategy() {
        int stratNum = this._prefs.getInt(STRATEGY_SETTING, 0);
        switch (stratNum) {
            case 1: {
                return PartMergeStrategy.PreferOriginal;
            }
            case 2: {
                return PartMergeStrategy.Replace;
            }
            case 3: {
                return PartMergeStrategy.KeepOriginal;
            }
        }
        return PartMergeStrategy.PreferNew;
    }

    private void readSettings(MergeOptionsPanel panel) {
        if (this.isMergeEntities()) {
            panel.setMergeEntities();
        } else if (this.isSkipEntity()) {
            panel.setSkipEntities();
        } else {
            panel.setKeepBothEntities();
        }
        panel.setMergeStrategy(this.getMergeStrategy());
    }

    private void storeSettings(MergeOptionsPanel panel) {
        boolean isMerge = panel.isMergeEntities();
        boolean isSkip = panel.isSkipEntity();
        this._prefs.putBoolean(MERGE_SETTING, isMerge);
        this._prefs.putBoolean(SKIP_SETTING, isSkip);
        int stratNum = 0;
        PartMergeStrategy strat = panel.getMergeStrategy();
        if (PartMergeStrategy.PreferOriginal.equals(strat)) {
            stratNum = 1;
        } else if (PartMergeStrategy.Replace.equals(strat)) {
            stratNum = 2;
        } else if (PartMergeStrategy.KeepOriginal.equals(strat)) {
            stratNum = 3;
        }
        this._prefs.putInt(STRATEGY_SETTING, stratNum);
    }
}

