/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.typing;

import com.paterva.maltego.typing.Converter;
import java.lang.reflect.Array;
import java.text.Format;
import java.text.ParseException;

public class FormattedConverter {
    private FormattedConverter() {
    }

    public static String convertTo(Object value, Class type, Format format) {
        if (format == null) {
            return Converter.convertTo(value, type);
        }
        if (value == null) {
            return null;
        }
        if (type.isArray()) {
            int length = Array.getLength(value);
            String[] strings = new String[length];
            Class<?> componentType = type.getComponentType();
            for (int i = 0; i < length; ++i) {
                Object item = Array.get(value, i);
                strings[i] = FormattedConverter.convertTo(item, componentType, format);
            }
            return FormattedConverter.convertTo(strings, String[].class, null);
        }
        return format.format(value);
    }

    public static Object convertFrom(String value, Class type, Format format) throws ParseException {
        if (format == null) {
            return Converter.convertFrom(value, type);
        }
        if (value == null) {
            return null;
        }
        if (type.isArray()) {
            String[] strings = (String[])FormattedConverter.convertFrom(value, String[].class, null);
            Class<?> componentType = type.getComponentType();
            Object array = Array.newInstance(componentType, strings.length);
            for (int i = 0; i < strings.length; ++i) {
                Array.set(array, i, FormattedConverter.convertFrom(strings[i], componentType, format));
            }
            return array;
        }
        return format.parseObject(value);
    }
}

