/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.transforms.tabular;

import com.paterva.maltego.transform.descriptor.TransformDescriptor;
import com.paterva.maltego.transform.gen.TransformSource;
import com.paterva.maltego.transform.gen.TransformSourceRegistry;
import com.paterva.maltego.transforms.tabular.TabularTransformNames;
import com.paterva.maltego.transforms.tabular.data.TabularTransformSource;
import com.paterva.maltego.util.Args;
import java.util.Optional;
import java.util.function.BiPredicate;

public class TabularTransformType {
    public static boolean isGlobalSearch(TransformDescriptor transform) {
        Args.notNull((Object)transform, (String)"transform");
        return "generated.global.search".equals(transform.getName());
    }

    public static Optional<TabularTransformSource> getSearchTransformSource(TransformDescriptor transform) {
        return TabularTransformType.getTransformSource(transform, (txSource, tx) -> TabularTransformNames.getSearchTransformName(txSource).equals(tx.getName()));
    }

    public static Optional<TabularTransformSource> getTransformSource(TransformDescriptor transform) {
        return TabularTransformType.getTransformSource(transform, (txSource, tx) -> txSource.getTabularTransform((TransformDescriptor)tx).isPresent());
    }

    public static Optional<TabularTransformSource> getTransformSource(TransformDescriptor transform, BiPredicate<TabularTransformSource, TransformDescriptor> sourcePredicate) {
        Args.notNull((Object)transform, (String)"transform");
        for (TransformSource ds : TransformSourceRegistry.getInstance().getAll()) {
            TabularTransformSource tds;
            if (!(ds instanceof TabularTransformSource) || !sourcePredicate.test(tds = (TabularTransformSource)ds, transform)) continue;
            return Optional.ofNullable(tds);
        }
        return Optional.empty();
    }
}

