/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.transforms.tabular;

import com.paterva.maltego.graph.table.TabularGraph;
import com.paterva.maltego.graph.table.TabularGraphEntity;
import com.paterva.maltego.graph.table.TabularGraphLink;
import com.paterva.maltego.transforms.tabular.data.TabularTransform;
import com.paterva.maltego.transforms.tabular.data.TabularTransformEntityNames;
import com.paterva.maltego.util.Args;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class TabularTransformFactory {
    private final TabularGraph tabularGraph;
    private final TabularTransformEntityNames entityNames;

    public TabularTransformFactory(TabularGraph tabularGraph, TabularTransformEntityNames entityNames) {
        Args.notNull((Object)tabularGraph, (String)"tabularGraph");
        Args.notNull((Object)entityNames, (String)"entityNames");
        this.tabularGraph = tabularGraph;
        this.entityNames = entityNames;
    }

    public List<TabularTransform> generateTabularTransforms() {
        ArrayList<TabularTransform> tabularTransforms = new ArrayList<TabularTransform>();
        tabularTransforms.addAll(this.generateTabularTransforms(false));
        tabularTransforms.addAll(this.generateTabularTransforms(true));
        return tabularTransforms;
    }

    private List<TabularTransform> generateTabularTransforms(boolean reversed) {
        return this.groupLinks(this.tabularGraph.getLinks(), reversed).stream().map(linkGroup -> this.createTabularTransform((List<TabularGraphLink>)linkGroup, reversed, false)).collect(Collectors.toList());
    }

    private List<List<TabularGraphLink>> groupLinks(List<TabularGraphLink> links, boolean reversed) {
        Args.notNull(links, (String)"links");
        ArrayList<List<TabularGraphLink>> combinedLinks = new ArrayList<List<TabularGraphLink>>();
        for (TabularGraphLink link : links) {
            boolean added = false;
            for (List list : combinedLinks) {
                TabularGraphLink firstLink = (TabularGraphLink)list.get(0);
                if (!this.shouldGroup(link, firstLink, reversed)) continue;
                list.add(link);
                added = true;
                break;
            }
            if (added) continue;
            ArrayList<TabularGraphLink> group = new ArrayList<TabularGraphLink>();
            group.add(link);
            combinedLinks.add(group);
        }
        return combinedLinks;
    }

    private boolean shouldGroup(TabularGraphLink link1, TabularGraphLink link2, boolean reversed) {
        Args.notNull((Object)link1, (String)"link1");
        Args.notNull((Object)link2, (String)"link2");
        boolean combineEnabled = false;
        if (!combineEnabled) {
            return false;
        }
        TabularGraphEntity source1 = link1.getSource();
        TabularGraphEntity source2 = link2.getSource();
        TabularGraphEntity target1 = link1.getTarget();
        TabularGraphEntity target2 = link2.getTarget();
        return this.isSameSpecs(source1, source2) && this.isSameSpecs(target1, target2) && this.isSameDisplayNames(target1, target2) && (!reversed || this.isSameDisplayNames(source1, source2));
    }

    private boolean isSameSpecs(TabularGraphEntity entity1, TabularGraphEntity entity2) {
        return entity1.getEntitySpecName().equals(entity2.getEntitySpecName());
    }

    private boolean isSameDisplayNames(TabularGraphEntity entity1, TabularGraphEntity entity2) {
        return this.getEntityString(entity1).equals(this.getEntityString(entity2));
    }

    private TabularTransform createTabularTransform(List<TabularGraphLink> linkGroup, boolean reverse, boolean favorite) {
        return new TabularTransform(this.getLinkIndexes(linkGroup), reverse, favorite);
    }

    private String getEntityString(TabularGraphEntity entity) {
        return this.entityNames.getName(entity).orElse("Unknown Name");
    }

    private List<Integer> getLinkIndexes(List<TabularGraphLink> linkGroup) {
        return linkGroup.stream().map(TabularGraphLink::getIndex).collect(Collectors.toList());
    }
}

