/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.entity.api.inheritance;

import com.paterva.maltego.typing.PropertyDescriptor;
import com.paterva.maltego.typing.descriptor.RegistryEvent;
import com.paterva.maltego.typing.descriptor.RegistryListener;
import com.paterva.maltego.typing.descriptor.SpecRegistry;
import com.paterva.maltego.typing.descriptor.TypeSpec;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openide.util.WeakListeners;

public class InheritanceCache {
    private static final Logger LOG = Logger.getLogger(InheritanceCache.class.getName());
    private static final Map<SpecRegistry<? extends TypeSpec>, Map<String, List<String>>> caches = new WeakHashMap<SpecRegistry<? extends TypeSpec>, Map<String, List<String>>>();
    private static final RegistryListener<? extends TypeSpec> registryListener = new InheritanceRegistryListener<TypeSpec>();
    private static WeakReference<SpecRegistry<? extends TypeSpec>> lastValuePropertyRegistry;
    private static String lastValuePropertyType;
    private static PropertyDescriptor lastValueProperty;

    public static synchronized <T extends TypeSpec> List<String> getInheritanceList(SpecRegistry<T> registry, String typename) {
        List<String> inheritanceList = null;
        Map<String, List<String>> cache = caches.get(registry);
        if (cache != null) {
            inheritanceList = cache.get(typename);
        }
        LOG.log(Level.FINE, "Get {0}->{1}: {2}", new Object[]{System.identityHashCode(registry), typename, inheritanceList});
        return inheritanceList;
    }

    public static synchronized <T extends TypeSpec> void setInheritanceList(SpecRegistry<T> registry, String typename, List<String> list) {
        if (list != null && !list.isEmpty()) {
            LOG.log(Level.FINE, "Put {0}->{1}: {2}", new Object[]{System.identityHashCode(registry), typename, list});
            Map<String, List<String>> cache = caches.get(registry);
            if (cache == null) {
                cache = new HashMap<String, List<String>>();
                caches.put(registry, cache);
                registry.addRegistryListener((RegistryListener)WeakListeners.create(RegistryListener.class, registryListener, registry));
            }
            cache.put(typename, list);
        }
    }

    public static synchronized <T extends TypeSpec> PropertyDescriptor getValueProperty(SpecRegistry<T> registry, String typename) {
        PropertyDescriptor pd = null;
        if (lastValuePropertyRegistry != null && typename.equals(lastValuePropertyType) && registry.equals(lastValuePropertyRegistry.get())) {
            pd = lastValueProperty;
        }
        return pd;
    }

    public static synchronized <T extends TypeSpec> void setValueProperty(SpecRegistry<T> registry, String typename, PropertyDescriptor pd) {
        lastValuePropertyRegistry = new WeakReference<SpecRegistry<T>>(registry);
        lastValuePropertyType = typename;
        lastValueProperty = pd;
    }

    private static class InheritanceRegistryListener<T extends TypeSpec>
    implements RegistryListener<T> {
        private InheritanceRegistryListener() {
        }

        public void typeAdded(RegistryEvent<T> event) {
            this.clearRegistryCache(event);
        }

        public void typeRemoved(RegistryEvent<T> event) {
            this.clearRegistryCache(event);
        }

        public void typeUpdated(RegistryEvent<T> event) {
            this.clearRegistryCache(event);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private <T extends TypeSpec> void clearRegistryCache(RegistryEvent<T> event) {
            Class<InheritanceCache> clazz = InheritanceCache.class;
            synchronized (InheritanceCache.class) {
                LOG.fine("Clear");
                caches.remove(event.getRegistry());
                lastValuePropertyRegistry = null;
                lastValuePropertyType = null;
                lastValueProperty = null;
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
        }
    }
}

