/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.transform.finder.wizard;

import com.paterva.maltego.discovery.DiscoveryMergingRules;
import com.paterva.maltego.seeds.api.HubSeedDescriptor;
import com.paterva.maltego.seeds.api.registry.HubSeedRegistry;
import com.paterva.maltego.seeds.api.registry.HubSeedSettings;
import com.paterva.maltego.transform.descriptor.TransformDefinition;
import com.paterva.maltego.transform.descriptor.TransformDescriptor;
import com.paterva.maltego.transform.descriptor.TransformRepository;
import com.paterva.maltego.transform.descriptor.TransformRepositoryRegistry;
import com.paterva.maltego.transform.descriptor.TransformSeed;
import com.paterva.maltego.transform.discovery.DiscoveryException;
import com.paterva.maltego.transform.discovery.DiscoveryResult;
import com.paterva.maltego.transform.discovery.TransformServerListing;
import com.paterva.maltego.transform.discovery.TransformServerReference;
import com.paterva.maltego.transform.discovery.TransformUpdater;
import com.paterva.maltego.transform.finder.DiscoverySettings;
import com.paterva.maltego.transform.finder.wizard.FailurePanel;
import com.paterva.maltego.transform.finder.wizard.UpdateFetchText;
import com.paterva.maltego.transform.finder.wizard.UpdateInstallPanel;
import com.paterva.maltego.transform.finder.wizard.UpdateTransformsFetchController;
import com.paterva.maltego.util.ui.dialog.PassFailProgressController;
import com.paterva.maltego.util.ui.dialog.WizardNavigationSupport;
import java.io.IOException;
import java.util.Set;
import org.netbeans.api.progress.ProgressHandle;
import org.openide.WizardDescriptor;
import org.openide.util.ImageUtilities;

public class InstallInitialTransformsController
extends PassFailProgressController<DiscoveryResult<TransformServerListing>, UpdateInstallPanel, FailurePanel>
implements WizardNavigationSupport {
    public InstallInitialTransformsController() {
        this.setName("Install Data Sources");
        this.setDescription("A summary of the progress to install items from the chosen Data Sources is shown below.");
        this.setImage(ImageUtilities.loadImage((String)"com/paterva/maltego/transform/finder/wizard/TransformSeed.png".replace(".png", "48.png")));
    }

    protected UpdateInstallPanel createPassComponent() {
        return new UpdateInstallPanel();
    }

    protected FailurePanel createFailComponent() {
        return new FailurePanel();
    }

    protected void pass(WizardDescriptor descriptor, UpdateInstallPanel component, DiscoveryResult<TransformServerListing> result) {
        if (result == null) {
            component.setNoSeeds();
        } else {
            UpdateFetchText urt = new UpdateFetchText();
            component.setText(urt.get((TransformServerListing[])result.getData()));
            component.setDuplicateTransforms(UpdateTransformsFetchController.getDuplicateTransforms((TransformServerListing[])result.getData()));
        }
        DiscoverySettings.setDiscoveryComplete(true);
    }

    protected void fail(FailurePanel component, Exception e) {
        if (e == null) {
            component.setError(null);
        } else {
            component.setError(e.getMessage());
        }
    }

    protected DiscoveryResult<TransformServerListing> doProcessing(WizardDescriptor descriptor, ProgressHandle handle) throws Exception {
        handle.progress("Updating transforms and entities...");
        HubSeedSettings seedSettings = HubSeedSettings.getDefault();
        HubSeedRegistry seedRegistry = HubSeedRegistry.getDefault();
        DiscoveryResult listings = (DiscoveryResult)descriptor.getProperty("transformListings");
        DiscoveryResult references = (DiscoveryResult)descriptor.getProperty("transformReferences");
        if (listings == null || references == null) {
            return null;
        }
        HubSeedDescriptor hubSeed = (HubSeedDescriptor)descriptor.getProperty("hubItem");
        TransformSeed[] selectedSeeds = (TransformSeed[])descriptor.getProperty("transformSeeds");
        Boolean autoAcceptDisclaimers = (Boolean)descriptor.getProperty("autoAcceptDisclaimers");
        try {
            TransformUpdater updater = TransformUpdater.getDefault();
            updater.updateServers((TransformServerListing[])listings.getData());
            Exception[] errors = references.getErrors();
            if (errors == null || errors.length == 0) {
                updater.removeMissingServers((TransformServerReference[])references.getData());
            }
            for (TransformSeed selectedSeed : selectedSeeds) {
                String url = selectedSeed.getUrl().toString();
                HubSeedDescriptor seed = seedRegistry.getSeeds(false).getSeed(null, url);
                seedSettings.setInstalled(seed, true);
            }
            updater.update(hubSeed, (TransformServerListing[])listings.getData(), DiscoveryMergingRules.getDefault());
            if (autoAcceptDisclaimers.booleanValue()) {
                TransformRepository repository = TransformRepositoryRegistry.getDefault().getOrCreateRepository("Remote");
                for (TransformServerListing listing : (TransformServerListing[])listings.getData()) {
                    Set transforms = listing.getTransforms();
                    for (TransformDescriptor transform : transforms) {
                        TransformDefinition def = repository.get(transform.getName());
                        def.setDisclaimerAccepted(true);
                        repository.updateSettings(def);
                    }
                }
            }
        }
        catch (IOException ex) {
            throw new DiscoveryException((Throwable)ex);
        }
        return listings;
    }
}

