/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.parsing.spi;

import java.beans.PropertyChangeListener;
import java.util.logging.Logger;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.modules.parsing.api.Source;
import org.netbeans.modules.parsing.impl.SchedulerAccessor;
import org.netbeans.modules.parsing.impl.SourceAccessor;
import org.netbeans.modules.parsing.impl.SourceCache;
import org.netbeans.modules.parsing.impl.Utilities;
import org.netbeans.modules.parsing.implspi.SchedulerControl;
import org.netbeans.modules.parsing.spi.SchedulerEvent;
import org.netbeans.modules.parsing.spi.SourceModificationEvent;
import org.openide.util.RequestProcessor;

public abstract class Scheduler {
    public static final int DEFAULT_REPARSE_DELAY = 500;
    private static final Logger LOG = Logger.getLogger(Scheduler.class.getName());
    int reparseDelay = 500;
    private Source source;
    private PropertyChangeListener wlistener;
    public static final Class<? extends Scheduler> CURSOR_SENSITIVE_TASK_SCHEDULER = Utilities.findDefaultScheduler("CURSOR_SENSITIVE_TASK_SCHEDULER");
    public static final Class<? extends Scheduler> EDITOR_SENSITIVE_TASK_SCHEDULER = Utilities.findDefaultScheduler("EDITOR_SENSITIVE_TASK_SCHEDULER");
    public static final Class<? extends Scheduler> SELECTED_NODES_SENSITIVE_TASK_SCHEDULER = Utilities.findDefaultScheduler("SELECTED_NODES_SENSITIVE_TASK_SCHEDULER");
    private RequestProcessor requestProcessor;
    private RequestProcessor.Task task;
    private final SchedulerControl ctrl = new Control(this);

    protected final synchronized void schedule(SchedulerEvent event) {
        if (this.source != null) {
            this.schedule(this.source, event);
        }
    }

    protected final synchronized void schedule(final Source source, final SchedulerEvent event) {
        boolean different;
        if (this.task != null) {
            this.task.cancel();
        }
        this.task = null;
        if (this.requestProcessor == null) {
            this.requestProcessor = new RequestProcessor(Scheduler.class.getName(), 1, false, false);
        }
        boolean bl = different = this.source != source;
        if (different) {
            if (this.source != null) {
                SourceCache cache = SourceAccessor.getINSTANCE().getCache(this.source);
                cache.unscheduleTasks(this.getClass());
                SourceAccessor.getINSTANCE().attachScheduler(this.source, this.ctrl, false);
            }
            this.source = source;
        }
        if (source == null) {
            return;
        }
        if (different) {
            SourceAccessor.getINSTANCE().attachScheduler(source, this.ctrl, true);
        }
        this.task = this.requestProcessor.create(new Runnable(){

            @Override
            public void run() {
                SourceCache cache = SourceAccessor.getINSTANCE().getCache(source);
                SourceAccessor.getINSTANCE().setSchedulerEvent(source, Scheduler.this, event);
                LOG.fine("Scheduling tasks for :" + source + " and scheduler " + this);
                cache.scheduleTasks(Scheduler.this.getClass());
            }
        });
        this.task.schedule(this.reparseDelay);
    }

    @CheckForNull
    protected final synchronized Source getSource() {
        return this.source;
    }

    protected abstract SchedulerEvent createSchedulerEvent(SourceModificationEvent var1);

    static {
        SchedulerAccessor.set(new Accessor());
    }

    private static final class Control
    implements SchedulerControl {
        private final Scheduler scheduler;

        public Control(Scheduler scheduler) {
            this.scheduler = scheduler;
        }

        @Override
        public Scheduler getScheduler() {
            return this.scheduler;
        }

        @Override
        public void sourceChanged(Source newSource) {
            this.scheduler.schedule(newSource, new SchedulerEvent(newSource));
        }
    }

    private static class Accessor
    extends SchedulerAccessor {
        private Accessor() {
        }

        @Override
        public SchedulerEvent createSchedulerEvent(Scheduler scheduler, SourceModificationEvent event) {
            return scheduler.createSchedulerEvent(event);
        }
    }
}

