/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.ui.graph.view2d.controls;

import com.paterva.maltego.ui.graph.data.GraphDataObject;
import com.paterva.maltego.ui.graph.view2d.controls.GraphAddOnControls;
import java.awt.Component;
import java.awt.Container;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BoxLayout;
import javax.swing.JPanel;

public class AddOnPanel
extends JPanel {
    private final GraphDataObject _gdo;
    private GraphAddOnListener _addOnListener;

    public AddOnPanel(GraphDataObject gdo) {
        this._gdo = gdo;
        this.setLayout(new BoxLayout(this, 1));
    }

    public void componentShowing() {
        this._addOnListener = new GraphAddOnListener();
        GraphAddOnControls.getDefault().addPropertyChangeListener(this._gdo, this._addOnListener);
        this.refreshAddOns();
    }

    public void componentHidden() {
        GraphAddOnControls.getDefault().removePropertyChangeListener(this._gdo, this._addOnListener);
        this._addOnListener = null;
        this.removeAll();
    }

    private void refreshAddOns() {
        this.removeAll();
        for (Component addOn : GraphAddOnControls.getDefault().get(this._gdo)) {
            this.add(addOn);
        }
        Container parent = this.getParent();
        if (parent != null) {
            parent.validate();
            parent.repaint();
        }
    }

    private class GraphAddOnListener
    implements PropertyChangeListener {
        private GraphAddOnListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            AddOnPanel.this.refreshAddOns();
        }
    }
}

