/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.transform.manager.sets;

import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import javax.swing.JMenuItem;
import org.openide.util.ImageUtilities;

public class TransformSetMenuItem
extends JMenuItem {
    private Image _helpIcon = ImageUtilities.loadImage((String)"com/paterva/maltego/transform/runner/Help.png");
    private boolean _buttonDown = false;
    private boolean _mouseInside = false;

    public TransformSetMenuItem(String title, String description) {
        super(TransformSetMenuItem.createHtml(title, description));
    }

    private static String createHtml(String name, String description) {
        String label = "<html><table cellpadding=\"0\" cellspacing=\"0\" border=\"0\"><tr><td><font color=\"#434A73\">" + name + "</font></td></tr><tr><td><font size=\"2\" color=\"#8F94AF\">" + description + "</font></td></tr></table></html>";
        return label;
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension d = super.getPreferredSize();
        return new Dimension(d.width + 15, d.height);
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        Rectangle rect = this.calcButtonRect();
        if (this._buttonDown) {
            rect.translate(1, 1);
        }
        g.drawImage(this._helpIcon, rect.x, rect.y, null);
    }

    private Rectangle calcButtonRect() {
        Rectangle bounds = this.getBounds();
        return new Rectangle(bounds.width - 20, 1, 16, 16);
    }

    private void fireMouseEntered() {
        this.setCursor(Cursor.getPredefinedCursor(12));
    }

    private void fireMouseExited() {
        this.setCursor(Cursor.getPredefinedCursor(0));
    }

    private void setMouseInside(boolean value) {
        if (value != this._mouseInside) {
            this._mouseInside = value;
            if (value) {
                this.fireMouseEntered();
            } else {
                this.fireMouseExited();
            }
        }
    }

    private void setButtonDown(boolean value) {
        if (value != this._buttonDown) {
            this._buttonDown = value;
            this.repaint();
        }
    }

    @Override
    protected void processMouseMotionEvent(MouseEvent e) {
        if (e.getID() == 503) {
            this.setMouseInside(this.calcButtonRect().contains(e.getPoint()));
        }
        super.processMouseMotionEvent(e);
    }

    @Override
    protected void processMouseEvent(MouseEvent e) {
        if (this._buttonDown && (e.getID() == 502 || e.getID() == 500) && e.getButton() == 1) {
            this.setButtonDown(false);
            this.fireHelpEvent();
        } else if (this.calcButtonRect().contains(e.getPoint()) && e.getID() == 501 && e.getButton() == 1) {
            this.setButtonDown(true);
        } else {
            super.processMouseEvent(e);
        }
    }

    private void fireHelpEvent() {
    }

    @Override
    protected final void paintComponent(Graphics g) {
        Graphics2D graphics = (Graphics2D)g;
        Object oldHint = graphics.getRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING);
        graphics.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        super.paintComponent(graphics);
        graphics.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, oldHint);
    }
}

