/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.view.customization.ui.imex;

import com.paterva.maltego.archive.mtz.Entry;
import com.paterva.maltego.view.customization.ui.imex.ViewletAttributesWrapper;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Properties;

public class ViewletAttributesEntry
extends Entry<ViewletAttributesWrapper> {
    private static final String ATTR_IN_TOOLBAR = "inToolbar";
    private static final String ATTR_IN_MENU = "inMenu";
    private static final String ATTR_ICON = "icon";
    public static final String DefaultFolder = "Viewlets";
    public static final String Type = "properties";

    public ViewletAttributesEntry(ViewletAttributesWrapper wrapper) {
        super((Object)wrapper, "Viewlets/" + wrapper.getViewID(), wrapper.getFileName() + "." + Type, wrapper.getFileName() + "'s attributes");
    }

    public ViewletAttributesEntry(String path) {
        super(path);
    }

    protected ViewletAttributesWrapper read(InputStream is) throws IOException {
        String subfolder = this.getFolder().substring(DefaultFolder.length() + 1);
        Properties properties = new Properties();
        properties.load(is);
        String icon = (String)properties.get(ATTR_ICON);
        boolean inMenu = Boolean.parseBoolean((String)properties.get(ATTR_IN_MENU));
        boolean inToolbar = Boolean.parseBoolean((String)properties.get(ATTR_IN_TOOLBAR));
        return new ViewletAttributesWrapper(subfolder, this.getTypeName(), icon, inMenu, inToolbar);
    }

    protected void write(ViewletAttributesWrapper wrapper, OutputStream os) throws IOException {
        Properties properties = new Properties();
        if (wrapper.getIcon() != null) {
            properties.put(ATTR_ICON, wrapper.getIcon());
        }
        properties.put(ATTR_IN_MENU, Boolean.toString(wrapper.isInMenu()));
        properties.put(ATTR_IN_TOOLBAR, Boolean.toString(wrapper.isInToolbar()));
        properties.store(os, null);
    }
}

