/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.util;

import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import org.lobobrowser.util.Strings;

public class Domains {
    private static final Collection gTLDs = new HashSet();

    private Domains() {
    }

    public static boolean isValidCookieDomain(String domain, String hostName) {
        String plainDomain;
        if (!domain.startsWith(".")) {
            plainDomain = domain;
            domain = "." + domain;
        } else {
            plainDomain = domain.substring(1);
        }
        String plainDomainTL = plainDomain.toLowerCase();
        String hostNameTL = hostName.toLowerCase();
        if (!hostNameTL.endsWith(plainDomainTL)) {
            return false;
        }
        int lastDotIdx = domain.lastIndexOf(46);
        if (lastDotIdx == -1) {
            return false;
        }
        String suffix = domain.substring(lastDotIdx).toLowerCase();
        if (gTLDs.contains(suffix)) {
            return Strings.countChars(domain, '.') >= 2;
        }
        return Strings.countChars(domain, '.') >= 3;
    }

    public static boolean endsWithGTLD(String host) {
        for (String ending : gTLDs) {
            if (!host.endsWith(ending)) continue;
            return true;
        }
        return false;
    }

    public static boolean isLikelyHostName(String name) {
        String nameTL = name.toLowerCase();
        if (nameTL.startsWith("www.")) {
            return true;
        }
        if (Domains.endsWithGTLD(name)) {
            return true;
        }
        int lastDotIdx = nameTL.lastIndexOf(46);
        if (lastDotIdx == -1) {
            return false;
        }
        return lastDotIdx == nameTL.length() - 3;
    }

    public static Collection getPossibleDomains(String hostName) {
        LinkedList<String> domains = new LinkedList<String>();
        domains.add(hostName);
        int dotIdx = hostName.indexOf(46, 1);
        if (dotIdx == -1) {
            return domains;
        }
        String testDomain = hostName.substring(dotIdx);
        if (!Domains.isValidCookieDomain(testDomain, hostName)) {
            return domains;
        }
        domains.addAll(Domains.getPossibleDomains(testDomain.substring(1)));
        return domains;
    }

    static {
        gTLDs.add(".com");
        gTLDs.add(".edu");
        gTLDs.add(".gov");
        gTLDs.add(".int");
        gTLDs.add(".mil");
        gTLDs.add(".net");
        gTLDs.add(".org");
        gTLDs.add(".biz");
        gTLDs.add(".info");
        gTLDs.add(".name");
        gTLDs.add(".pro");
        gTLDs.add(".aero");
        gTLDs.add(".coop");
        gTLDs.add(".museum");
    }
}

