/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.graph.store.views.impl.tools;

import com.paterva.maltego.core.EntityID;
import com.paterva.maltego.core.LinkEntityIDs;
import com.paterva.maltego.core.LinkID;
import com.paterva.maltego.graph.store.data.GraphDataMods;
import com.paterva.maltego.graph.store.data.GraphStoreException;
import com.paterva.maltego.graph.store.structure.GraphStructureMods;
import com.paterva.maltego.graph.store.structure.GraphStructureReader;
import com.paterva.maltego.graph.store.views.impl.InMemoryCollectionNodes;
import com.paterva.maltego.graph.store.views.impl.structures.ViewEntity;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class UncollectUtils {
    private final InMemoryCollectionNodes _collectionNodes;
    private GraphStructureMods _imsm;
    private GraphDataMods _imdm;

    public UncollectUtils(InMemoryCollectionNodes collectionNodes) {
        this._collectionNodes = collectionNodes;
    }

    public Set<EntityID> getExistingModelEntitiesInView(GraphStructureMods imsm, GraphDataMods imdm) throws GraphStoreException {
        LinkEntityIDs value;
        this._imsm = imsm;
        this._imdm = imdm;
        GraphStructureReader modelStructureReader = this._collectionNodes.getModelStructureReader();
        HashSet<EntityID> existingModelEntitiesInView = new HashSet<EntityID>();
        existingModelEntitiesInView.addAll(this._imdm.getEntitiesUpdated().keySet());
        existingModelEntitiesInView.addAll(this._imsm.getEntitiesPinned());
        existingModelEntitiesInView.addAll(this._imsm.getEntitiesUnpinned());
        for (Map.Entry entry : this._imsm.getLinksRemoved().entrySet()) {
            value = (LinkEntityIDs)entry.getValue();
            existingModelEntitiesInView.add(value.getSourceID());
            existingModelEntitiesInView.add(value.getTargetID());
        }
        for (Map.Entry entry : modelStructureReader.getEntities((Collection)this._imsm.getLinksAdded()).entrySet()) {
            value = (LinkEntityIDs)entry.getValue();
            existingModelEntitiesInView.add(value.getSourceID());
            existingModelEntitiesInView.add(value.getTargetID());
        }
        existingModelEntitiesInView.removeAll(this._imsm.getEntitiesAdded());
        existingModelEntitiesInView.removeAll(this._imsm.getEntitiesRemoved());
        return existingModelEntitiesInView;
    }

    public Set<EntityID> addNeighbouringCollections(Set<EntityID> viewEntities, Set<EntityID> visitedEntities) throws GraphStoreException {
        if (viewEntities.isEmpty()) {
            return visitedEntities;
        }
        HashSet<EntityID> newViewEntities = new HashSet<EntityID>();
        Map<EntityID, ViewEntity> currentViewEntities = this._collectionNodes.getViewEntities();
        Map<LinkID, LinkEntityIDs> entities = this._collectionNodes.getEntities(this._collectionNodes.getLinks(viewEntities));
        for (Map.Entry<LinkID, LinkEntityIDs> entry : entities.entrySet()) {
            EntityID targetID;
            LinkEntityIDs value = entry.getValue();
            EntityID sourceID = value.getSourceID();
            if (!visitedEntities.contains(sourceID)) {
                if (currentViewEntities.get(sourceID).isCollection()) {
                    newViewEntities.add(sourceID);
                }
                visitedEntities.add(sourceID);
            }
            if (visitedEntities.contains(targetID = value.getTargetID())) continue;
            if (currentViewEntities.get(targetID).isCollection()) {
                newViewEntities.add(targetID);
            }
            visitedEntities.add(targetID);
        }
        return this.addNeighbouringCollections(newViewEntities, visitedEntities);
    }

    public static Set<EntityID> lookupAddedEnts(InMemoryCollectionNodes collectionNodes, Set<LinkID> links, Set<EntityID> entitiesAdded) throws GraphStoreException {
        GraphStructureReader msr = collectionNodes.getModelStructureReader();
        HashSet<EntityID> ret = new HashSet<EntityID>();
        Map entities = msr.getEntities(links);
        for (Map.Entry entry : entities.entrySet()) {
            LinkID key = (LinkID)entry.getKey();
            LinkEntityIDs value = (LinkEntityIDs)entry.getValue();
            EntityID sourceID = value.getSourceID();
            EntityID targetID = value.getTargetID();
            if (!entitiesAdded.contains(sourceID)) {
                ret.add(sourceID);
            }
            if (entitiesAdded.contains(targetID)) continue;
            ret.add(targetID);
        }
        return ret;
    }

    public static Set<EntityID> lookupRemovedEnts(Map<LinkID, LinkEntityIDs> linksRemoved) {
        HashSet<EntityID> ret = new HashSet<EntityID>();
        for (Map.Entry<LinkID, LinkEntityIDs> entry : linksRemoved.entrySet()) {
            LinkID key = entry.getKey();
            LinkEntityIDs value = entry.getValue();
            EntityID sourceID = value.getSourceID();
            EntityID targetID = value.getTargetID();
            ret.add(sourceID);
            ret.add(targetID);
        }
        return ret;
    }

    static Set<EntityID> remove(Set<EntityID> entities, Set<EntityID> ... entitiesToRemove) {
        for (Set<EntityID> set : entitiesToRemove) {
            entities.removeAll(set);
        }
        return entities;
    }
}

