/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.seeds.ui.imex;

import com.paterva.maltego.importexport.BasicArrayConfig;
import com.paterva.maltego.seeds.api.HubSeedDescriptor;
import com.paterva.maltego.seeds.ui.imex.HubSeedConfigNode;
import com.paterva.maltego.seeds.ui.imex.HubSeedInstalledInfo;
import com.paterva.maltego.transform.descriptor.TransformDescriptor;
import com.paterva.maltego.transform.descriptor.TransformSeed;
import com.paterva.maltego.transform.descriptor.TransformServerInfo;
import java.util.List;
import java.util.Map;
import org.openide.nodes.Node;

final class HubSeedConfig
extends BasicArrayConfig<HubSeedDescriptor> {
    private Map<HubSeedDescriptor, TransformSeed> _seedMap;
    private TransformServerInfo[] _servers;
    private TransformDescriptor[] _transforms;

    HubSeedConfig(HubSeedDescriptor[] seedList) {
        this(seedList, seedList);
    }

    HubSeedConfig(HubSeedDescriptor[] seeds, HubSeedDescriptor[] selected) {
        this.setAll(seeds);
        this.setSelected(selected);
    }

    HubSeedConfig(List<HubSeedDescriptor> seedList) {
        Object[] seedArr = this.listToArray(seedList);
        this.setAll(seedArr);
        this.setSelected(seedArr);
    }

    HubSeedConfig(Map<HubSeedDescriptor, TransformSeed> seedMap, List<HubSeedDescriptor> selected, TransformServerInfo[] servers, TransformDescriptor[] transforms) {
        this._seedMap = seedMap;
        this._servers = servers;
        this._transforms = transforms;
        this.setAll(seedMap.keySet().toArray(new HubSeedDescriptor[seedMap.size()]));
        this.setSelected(this.listToArray(selected));
    }

    public TransformSeed getTransformSeed(HubSeedDescriptor hubSeed) {
        if (this._seedMap != null) {
            return this._seedMap.get(hubSeed);
        }
        return null;
    }

    public TransformServerInfo[] getServers() {
        return this._servers;
    }

    public TransformDescriptor[] getTransforms() {
        return this._transforms;
    }

    public Node getConfigNode(boolean showExistInfo) {
        HubSeedInstalledInfo existInfo = showExistInfo ? new HubSeedInstalledInfo() : null;
        return new HubSeedConfigNode(this, existInfo);
    }

    public int getPriority() {
        return 9;
    }

    protected HubSeedDescriptor nodeToType(Node node) {
        return (HubSeedDescriptor)node.getLookup().lookup(HubSeedDescriptor.class);
    }

    protected HubSeedDescriptor[] listToArray(List<HubSeedDescriptor> list) {
        return list.toArray(new HubSeedDescriptor[list.size()]);
    }
}

