/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.graph.table.io.links;

import com.paterva.maltego.graph.table.TabularGraph;
import com.paterva.maltego.graph.table.TabularGraphEntity;
import com.paterva.maltego.graph.table.TabularGraphLink;
import com.paterva.maltego.graph.table.io.impl.DefaultTabularGraphLink;
import com.paterva.maltego.graph.table.io.links.ConnectivityOptions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class LinkConnector {
    public void createLinks(TabularGraph tabularGraph, ConnectivityOptions connectivity) {
        block7: {
            List<TabularGraphEntity> entities;
            block9: {
                block8: {
                    block6: {
                        this.clearLinks(tabularGraph);
                        entities = this.getOrderedEntitiesList(tabularGraph);
                        if (connectivity != ConnectivityOptions.TREE) break block6;
                        TabularGraphEntity source = entities.get(0);
                        for (int i = 1; i < entities.size(); ++i) {
                            TabularGraphEntity target = entities.get(i);
                            DefaultTabularGraphLink link = new DefaultTabularGraphLink(source, target);
                            link.setIndex(i);
                            tabularGraph.putLink((TabularGraphLink)link);
                        }
                        break block7;
                    }
                    if (connectivity != ConnectivityOptions.FULLY_MESHED) break block8;
                    this.clearLinks(tabularGraph);
                    int linkCounter = 0;
                    for (int i = 0; i < entities.size(); ++i) {
                        TabularGraphEntity source = entities.get(i);
                        for (int k = 0; k < entities.size(); ++k) {
                            if (k == i) continue;
                            TabularGraphEntity target = entities.get(k);
                            DefaultTabularGraphLink link = new DefaultTabularGraphLink(source, target);
                            link.setIndex(++linkCounter);
                            tabularGraph.putLink((TabularGraphLink)link);
                        }
                    }
                    break block7;
                }
                if (connectivity != ConnectivityOptions.SEQUENTIAL) break block9;
                for (int i = 1; i < entities.size(); ++i) {
                    TabularGraphEntity source = entities.get(i - 1);
                    TabularGraphEntity target = entities.get(i);
                    DefaultTabularGraphLink link = new DefaultTabularGraphLink(source, target);
                    link.setIndex(i);
                    tabularGraph.putLink((TabularGraphLink)link);
                }
                break block7;
            }
            if (connectivity != ConnectivityOptions.SEQUENTIAL_TREE) break block7;
            int linkIndex = 0;
            for (int i = 0; i < entities.size(); ++i) {
                for (int j = i + 1; j < entities.size(); ++j) {
                    TabularGraphEntity source = entities.get(i);
                    TabularGraphEntity target = entities.get(j);
                    DefaultTabularGraphLink link = new DefaultTabularGraphLink(source, target);
                    link.setIndex(linkIndex++);
                    tabularGraph.putLink((TabularGraphLink)link);
                }
            }
        }
    }

    private void clearLinks(TabularGraph tg) {
        for (TabularGraphLink link : new ArrayList(tg.getLinks())) {
            tg.removeLink(link);
        }
    }

    private List<TabularGraphEntity> getOrderedEntitiesList(TabularGraph tg) {
        ArrayList<TabularGraphEntity> entities = new ArrayList<TabularGraphEntity>(tg.getEntities());
        Collections.sort(entities, new Comparator<TabularGraphEntity>(){

            @Override
            public int compare(TabularGraphEntity o1, TabularGraphEntity o2) {
                return new Integer(o1.getColumns()[0]).compareTo(o2.getColumns()[0]);
            }
        });
        return entities;
    }
}

