/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.graph.store.pandora.data;

import com.paterva.graph.store.pandora.data.DataCache;
import com.paterva.graph.store.pandora.data.EntityTypeCache;
import com.paterva.graph.store.pandora.data.PandoraGraphDataStore;
import com.paterva.graph.store.pandora.parts.PandoraPartsReader;
import com.paterva.maltego.core.EntityID;
import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.core.Guid;
import com.paterva.maltego.core.LinkID;
import com.paterva.maltego.core.MaltegoEntity;
import com.paterva.maltego.core.MaltegoLink;
import com.paterva.maltego.core.TypedPropertyBag;
import com.paterva.maltego.entity.api.EntityFactory;
import com.paterva.maltego.entity.api.EntityRegistry;
import com.paterva.maltego.entity.api.LinkFactory;
import com.paterva.maltego.entity.api.LinkRegistry;
import com.paterva.maltego.entity.api.inheritance.InheritanceHelper;
import com.paterva.maltego.graph.GraphUserData;
import com.paterva.maltego.graph.cache.FifoCache;
import com.paterva.maltego.graph.store.data.GraphDataStoreReader;
import com.paterva.maltego.graph.store.data.GraphStoreException;
import com.paterva.maltego.graph.store.data.SearchOptions;
import com.paterva.maltego.graph.store.data.sort.SortField;
import com.paterva.maltego.graph.store.query.part.EntitiesDataQuery;
import com.paterva.maltego.graph.store.query.part.EntityDataQuery;
import com.paterva.maltego.graph.store.query.part.EntitySectionsQuery;
import com.paterva.maltego.graph.store.query.part.LinkDataQuery;
import com.paterva.maltego.graph.store.query.part.LinksDataQuery;
import com.paterva.maltego.graph.store.query.part.PartDataQuery;
import com.paterva.maltego.graph.store.query.part.PartSectionsQuery;
import com.paterva.maltego.graph.store.query.part.PartsDataQuery;
import com.paterva.maltego.matching.AndMatchingRuleDescriptor;
import com.paterva.maltego.matching.LayeredMatchingRuleDescriptor;
import com.paterva.maltego.matching.PropertyMatchingRuleDescriptor;
import com.paterva.maltego.matching.StatelessMatchingRuleDescriptor;
import com.paterva.maltego.matching.TypeMapMatchingRuleDescriptor;
import com.paterva.maltego.matching.api.MatchingRuleDescriptor;
import com.paterva.maltego.serializers.GraphSerializationException;
import com.paterva.maltego.serializers.map.PartMapReader;
import com.paterva.maltego.serializers.map.PartMapWriter;
import com.paterva.maltego.typing.PropertyDescriptor;
import com.paterva.maltego.typing.TypeDescriptor;
import com.paterva.maltego.typing.TypeRegistry;
import com.paterva.maltego.typing.descriptor.SpecRegistry;
import com.paterva.maltego.util.BulkStatusDisplayer;
import com.paterva.maltego.util.StringUtilities;
import com.pinkmatter.pandora.Artifact;
import com.pinkmatter.pandora.PandoraException;
import com.pinkmatter.pandora.PandoraFilter;
import com.pinkmatter.pandora.PandoraQuery;
import com.pinkmatter.pandora.PandoraQueryResult;
import com.pinkmatter.pandora.PandoraSearch;
import com.pinkmatter.pandora.lucene.PandoraConstants;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openide.util.Exceptions;

public class PandoraGraphDataStoreReader
extends PandoraPartsReader
implements GraphDataStoreReader {
    private static final Logger LOG = Logger.getLogger(PandoraGraphDataStoreReader.class.getName());
    private static final boolean DEBUG_GETTER_STACKS = false;
    private static final int RETRIES = 100;
    private final PartMapReader _mapReader = new PartMapReader();
    private final EntityRegistry _entityRegistry;
    private final EntityFactory _entityFactory;
    private final LinkRegistry _linkRegistry;
    private final LinkFactory _linkFactory;
    private final PandoraGraphDataStore _store;

    public PandoraGraphDataStoreReader(GraphID id, PandoraGraphDataStore store) {
        super(id);
        this._store = store;
        this._entityRegistry = EntityRegistry.forGraphID((GraphID)id);
        if (this._entityRegistry == null) {
            throw new IllegalArgumentException("Entity registry not found for graph id: " + id);
        }
        this._linkRegistry = LinkRegistry.forGraphID((GraphID)id);
        if (this._linkRegistry == null) {
            throw new IllegalArgumentException("Link registry not found for graph id: " + id);
        }
        this._entityFactory = EntityFactory.forGraphID((GraphID)id);
        if (this._entityFactory == null) {
            throw new IllegalArgumentException("Entity factory not found for graph id: " + id);
        }
        this._linkFactory = LinkFactory.forGraphID((GraphID)id);
        if (this._linkFactory == null) {
            throw new IllegalArgumentException("Link factory not found for graph id: " + id);
        }
    }

    public int getEntityCount() throws GraphStoreException {
        try {
            return (int)this.getEntitySearch().query().count();
        }
        catch (Exception ex) {
            throw new GraphStoreException((Throwable)ex);
        }
    }

    public Set<EntityID> getEntityIDs() throws GraphStoreException {
        return this.getEntities(new EntitiesDataQuery()).keySet();
    }

    public Set<LinkID> getLinkIDs() throws GraphStoreException {
        return this.getLinks(new LinksDataQuery()).keySet();
    }

    public Map<EntityID, MaltegoEntity> getEntities(EntitiesDataQuery query) throws GraphStoreException {
        try {
            HashMap<Object, Object> entities = new HashMap<EntityID, MaltegoEntity>();
            if (query.isAllIDs() || !query.getIDs().isEmpty()) {
                PandoraQuery pandoraQuery = this.translateQuery(this.getEntitySearch(), (PartsDataQuery)query);
                List<Artifact> artifacts = this.queryWithRetries("Entities", query.getIDs(), pandoraQuery, 100);
                BulkStatusDisplayer statusDisplayer = new BulkStatusDisplayer("Querying entities (%d/" + artifacts.size() + ")");
                for (Artifact artifact : artifacts) {
                    MaltegoEntity entity = this.toEntity(artifact);
                    statusDisplayer.increment();
                    entities.put((EntityID)entity.getID(), entity);
                }
                if (artifacts.size() != entities.size()) {
                    HashSet entityIDs = new HashSet(entities.keySet());
                    for (Artifact artifact : artifacts) {
                        EntityID entityID = EntityID.create((long)artifact.getKey());
                        boolean removed = entityIDs.remove(entityID);
                        if (removed) continue;
                        this._store.getDataStoreWriter().removeEntity(entityID);
                    }
                    artifacts = this.queryWithRetries("Entities", query.getIDs(), pandoraQuery, 100);
                    entities = new HashMap();
                    for (Artifact artifact : artifacts) {
                        MaltegoEntity entity = this.toEntity(artifact);
                        entities.put((EntityID)entity.getID(), entity);
                    }
                }
                statusDisplayer.clear();
            }
            return entities;
        }
        catch (Exception ex) {
            throw new GraphStoreException((Throwable)ex);
        }
    }

    public MaltegoEntity getEntity(EntityID id, EntityDataQuery query) throws GraphStoreException {
        try {
            PandoraQuery pandoraQuery = this.translateQuery(this.getEntitySearch(), (Guid)id, (PartDataQuery)query);
            List<Artifact> artifacts = this.queryWithRetries("Entity", Collections.singleton(id), pandoraQuery, 100);
            Artifact artifact = artifacts.iterator().next();
            return this.toEntity(artifact);
        }
        catch (Exception ex) {
            throw new GraphStoreException((Throwable)ex);
        }
    }

    private List<Artifact> queryWithRetries(String partType, Collection<? extends Guid> ids, PandoraQuery pandoraQuery, int maxRetries) throws GraphStoreException, PandoraException {
        PandoraQueryResult result = null;
        long total = ids != null ? (long)ids.size() : pandoraQuery.count();
        int retries = 0;
        do {
            if (result == null) continue;
            ++retries;
            this.sleep(10);
        } while ((long)(result = pandoraQuery.list()).getCount() != total && retries < maxRetries);
        if ((long)result.getCount() != total) {
            throw new GraphStoreException(partType + " not found: " + (ids != null ? ids : "<all entities>") + " found " + result.getCount() + "/" + total);
        }
        if (retries > 0) {
            LOG.log(Level.WARNING, "{0} found after {1} of {2} retries: {3}", new Object[]{partType, retries, maxRetries, ids != null ? ids : "<all entities>"});
        }
        ArrayList<Artifact> artifacts = new ArrayList<Artifact>(result.getCount());
        for (Artifact artifact : result) {
            artifacts.add(artifact);
        }
        return artifacts;
    }

    private void sleep(int millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    public MaltegoEntity getEntity(EntityID id) throws GraphStoreException {
        FifoCache<EntityID, MaltegoEntity> entityCache = this.getEntityCache();
        MaltegoEntity entity = (MaltegoEntity)entityCache.get((Object)id);
        if (entity != null) {
            return entity;
        }
        try {
            PandoraQuery pandoraQuery = this.getEntitySearch().query().keys(new long[]{id.getValue()});
            List<Artifact> artifacts = this.queryWithRetries("Entity", Collections.singleton(id), pandoraQuery, 100);
            entity = this.toEntity(artifacts.get(0));
            entityCache.put((Object)id, (Object)entity);
            return entity;
        }
        catch (Exception ex) {
            throw new GraphStoreException((Throwable)ex);
        }
    }

    public Map<EntityID, String> getEntityTypes(Collection<EntityID> ids) throws GraphStoreException {
        HashMap<EntityID, String> types = new HashMap<EntityID, String>(ids.size());
        EntityTypeCache typeCache = this.getTypeCache();
        for (EntityID id : ids) {
            types.put(id, typeCache.getType(id));
        }
        return types;
    }

    public Set<String> getEntityTypesOnly(Collection<EntityID> ids) throws GraphStoreException {
        HashSet<String> types = new HashSet<String>();
        EntityTypeCache typeCache = this.getTypeCache();
        for (EntityID id : ids) {
            types.add(typeCache.getType(id));
        }
        return types;
    }

    public String getEntityType(EntityID id) throws GraphStoreException {
        return this.getTypeCache().getType(id);
    }

    public Set<String> getEntityTypes() throws GraphStoreException {
        return this.getTypeCache().getTypes();
    }

    private synchronized EntityTypeCache getTypeCache() throws GraphStoreException {
        String key;
        GraphUserData gud = GraphUserData.forGraph((GraphID)this.getGraphID());
        EntityTypeCache typeCache = (EntityTypeCache)gud.get((Object)(key = EntityTypeCache.class.getName()));
        if (typeCache == null) {
            typeCache = new EntityTypeCache();
            gud.put((Object)key, (Object)typeCache);
        }
        if (!typeCache.isInitialized()) {
            try {
                PandoraQueryResult result = this.getEntitySearch().query().include("type").list();
                HashMap<EntityID, String> types = new HashMap<EntityID, String>(result.getCount());
                for (Artifact artifact : result) {
                    EntityID entityID = EntityID.create((long)artifact.getKey());
                    String type = (String)artifact.get("type");
                    types.put(entityID, type);
                }
                typeCache.initialize(types);
            }
            catch (Exception ex) {
                throw new GraphStoreException((Throwable)ex);
            }
        }
        return typeCache;
    }

    public int getLinkCount() throws GraphStoreException {
        try {
            return (int)this.getLinkSearch().query().count();
        }
        catch (Exception ex) {
            throw new GraphStoreException((Throwable)ex);
        }
    }

    public Map<LinkID, MaltegoLink> getLinks(LinksDataQuery query) throws GraphStoreException {
        try {
            HashMap<LinkID, MaltegoLink> links = new HashMap<LinkID, MaltegoLink>();
            if (query.isAllIDs() || !query.getIDs().isEmpty()) {
                PandoraQuery pandoraQuery = this.translateQuery(this.getLinkSearch(), (PartsDataQuery)query);
                List<Artifact> artifacts = this.queryWithRetries("Links", query.getIDs(), pandoraQuery, 100);
                BulkStatusDisplayer statusDisplayer = new BulkStatusDisplayer("Querying links (%d/" + artifacts.size() + ")");
                for (Artifact artifact : artifacts) {
                    MaltegoLink link = this.toLink(artifact);
                    statusDisplayer.increment();
                    links.put((LinkID)link.getID(), link);
                }
                statusDisplayer.clear();
            }
            return links;
        }
        catch (Exception ex) {
            throw new GraphStoreException((Throwable)ex);
        }
    }

    public MaltegoLink getLink(LinkID id, LinkDataQuery query) throws GraphStoreException {
        try {
            PandoraQuery pandoraQuery = this.translateQuery(this.getLinkSearch(), (Guid)id, (PartDataQuery)query);
            List<Artifact> artifacts = this.queryWithRetries("Link", Collections.singleton(id), pandoraQuery, 100);
            Artifact artifact = artifacts.iterator().next();
            return this.toLink(artifact);
        }
        catch (Exception ex) {
            throw new GraphStoreException((Throwable)ex);
        }
    }

    public MaltegoLink getLink(LinkID id) throws GraphStoreException {
        try {
            return this.toLink(this.getLinkSearch().getArtifact(id.getValue()));
        }
        catch (Exception ex) {
            throw new GraphStoreException((Throwable)ex);
        }
    }

    public Map<MaltegoEntity, EntityID> getEntityMatches(Collection<MaltegoEntity> entities, MatchingRuleDescriptor ruleDescriptor) throws GraphStoreException {
        try {
            HashMap<MaltegoEntity, EntityID> matches = new HashMap<MaltegoEntity, EntityID>();
            for (MaltegoEntity entity : entities) {
                EntityID matchID = this.getEntityMatch(entity, ruleDescriptor);
                if (matchID == null) continue;
                matches.put(entity, matchID);
            }
            return matches;
        }
        catch (Exception ex) {
            throw new GraphStoreException((Throwable)ex);
        }
    }

    public Collection<EntityID> getFilteredEntities(String filterText, Collection<EntityID> ids) throws GraphStoreException {
        try {
            if (ids.isEmpty()) {
                return Collections.EMPTY_LIST;
            }
            if (StringUtilities.isNullOrEmpty((String)filterText)) {
                return ids;
            }
            long[] keys = this.toLongIDs(ids);
            PandoraQuery query = this.getEntitySearch().query().keys(keys);
            filterText = query.escape(filterText);
            query.filterLike("displayValueStr", "*" + filterText + "*");
            keys = query.includeKeyOnly().list().getKeys();
            ArrayList<EntityID> filteredIDs = new ArrayList<EntityID>(keys.length);
            for (long key : keys) {
                filteredIDs.add(EntityID.create((long)key));
            }
            if (LOG.isLoggable(Level.FINE)) {
                LOG.log(Level.FINE, "Filter: {0}", filterText);
                Map<EntityID, MaltegoEntity> entities = this.getEntities(new EntitiesDataQuery());
                LOG.fine("Entities to filter:");
                for (EntityID id : ids) {
                    MaltegoEntity entity = entities.get(id);
                    this.logEntity(entity);
                }
                LOG.fine("Entities filtered:");
                for (EntityID id : filteredIDs) {
                    MaltegoEntity entity = entities.get(id);
                    this.logEntity(entity);
                }
            }
            return filteredIDs;
        }
        catch (PandoraException ex) {
            throw new GraphStoreException((Throwable)ex);
        }
    }

    public List<EntityID> getSortedEntities(Collection<EntityID> ids, SortField ... sortFields) throws GraphStoreException {
        try {
            if (ids.isEmpty()) {
                return Collections.EMPTY_LIST;
            }
            long[] keys = this.toLongIDs(ids);
            if (LOG.isLoggable(Level.FINE)) {
                LOG.log(Level.FINE, "Keys before sort: {0}", Arrays.toString(keys));
            }
            PandoraQuery query = this.getEntitySearch().query().keys(keys);
            block9: for (SortField sortField : sortFields) {
                int field = sortField.getField();
                boolean ascending = sortField.isAscending();
                switch (field) {
                    case 0: {
                        query.sort("displayValueStr", ascending, ascending);
                        continue block9;
                    }
                    case 3: {
                        query.sort("bookmark", ascending, ascending);
                        continue block9;
                    }
                    case 9: {
                        query.sort("weight", ascending, ascending);
                        continue block9;
                    }
                    case 10: {
                        query.sort("type", ascending, ascending);
                        continue block9;
                    }
                    case 11: {
                        query.sort("id", ascending, ascending);
                        continue block9;
                    }
                    default: {
                        LOG.log(Level.SEVERE, "Unknown pandora sort field: {0}", field);
                    }
                }
            }
            keys = query.includeKeyOnly().list().getKeys();
            if (LOG.isLoggable(Level.FINE)) {
                LOG.log(Level.FINE, "Keys after sort: {0}", Arrays.toString(keys));
            }
            ArrayList<EntityID> sortedIDs = new ArrayList<EntityID>(keys.length);
            for (long key : keys) {
                sortedIDs.add(EntityID.create((long)key));
            }
            if (LOG.isLoggable(Level.FINE)) {
                LOG.log(Level.FINE, "Sort fields: {0}", sortFields);
                Map<EntityID, MaltegoEntity> entities = this.getEntities(new EntitiesDataQuery());
                LOG.fine("Entities to sort:");
                for (EntityID id : ids) {
                    MaltegoEntity entity = entities.get(id);
                    this.logEntity(entity);
                }
                LOG.fine("Entities sorted:");
                for (EntityID id : sortedIDs) {
                    MaltegoEntity entity = entities.get(id);
                    this.logEntity(entity);
                }
            }
            return sortedIDs;
        }
        catch (PandoraException ex) {
            throw new GraphStoreException((Throwable)ex);
        }
    }

    public Collection<LinkID> getFilteredLinks(String filterText, Collection<LinkID> ids) throws GraphStoreException {
        try {
            if (ids.isEmpty()) {
                return Collections.EMPTY_LIST;
            }
            if (StringUtilities.isNullOrEmpty((String)filterText)) {
                return ids;
            }
            long[] keys = this.toLongIDs(ids);
            PandoraQuery query = this.getLinkSearch().query().keys(keys);
            filterText = query.escape(filterText);
            query.filterLike("displayValueStr", "*" + filterText + "*");
            keys = query.includeKeyOnly().list().getKeys();
            ArrayList<LinkID> filteredIDs = new ArrayList<LinkID>(keys.length);
            for (long key : keys) {
                filteredIDs.add(LinkID.create((long)key));
            }
            return filteredIDs;
        }
        catch (PandoraException ex) {
            throw new GraphStoreException((Throwable)ex);
        }
    }

    public List<LinkID> getSortedLinks(SortField sortField, Collection<LinkID> ids) throws GraphStoreException {
        try {
            if (ids.isEmpty()) {
                return Collections.EMPTY_LIST;
            }
            long[] keys = this.toLongIDs(ids);
            if (LOG.isLoggable(Level.FINE)) {
                LOG.log(Level.FINE, "Keys before sort: {0}", Arrays.toString(keys));
            }
            PandoraQuery query = this.getLinkSearch().query().keys(keys);
            int field = sortField.getField();
            boolean ascending = sortField.isAscending();
            switch (field) {
                case 0: {
                    query.sort("displayValueStr", ascending, ascending);
                    break;
                }
                default: {
                    LOG.log(Level.SEVERE, "Unknown pandora sort field: {0}", field);
                }
            }
            keys = query.includeKeyOnly().list().getKeys();
            if (LOG.isLoggable(Level.FINE)) {
                LOG.log(Level.FINE, "Keys after sort: {0}", Arrays.toString(keys));
            }
            ArrayList<LinkID> sortedIDs = new ArrayList<LinkID>(keys.length);
            for (long key : keys) {
                sortedIDs.add(LinkID.create((long)key));
            }
            return sortedIDs;
        }
        catch (PandoraException ex) {
            throw new GraphStoreException((Throwable)ex);
        }
    }

    private void logEntity(MaltegoEntity entity) {
        LOG.log(Level.FINE, "{0} bookmark:{2} display:{1} ", new Object[]{entity.getID(), entity.getDisplayString(), entity.getBookmark()});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private EntityID getEntityMatch(MaltegoEntity entity, MatchingRuleDescriptor ruleDescriptor) throws Exception {
        if (StatelessMatchingRuleDescriptor.Default.equals(ruleDescriptor)) {
            PandoraQuery query = this.getDefaultMatchQuery(entity).includeKeyOnly();
            PandoraQueryResult result = query.list(1);
            if (!result.isEmpty()) {
                return EntityID.create((long)result.getFirstKey());
            }
        } else if (ruleDescriptor instanceof TypeMapMatchingRuleDescriptor) {
            TypeMapMatchingRuleDescriptor typeMapDescriptor = (TypeMapMatchingRuleDescriptor)ruleDescriptor;
            String type = entity.getTypeName();
            MatchingRuleDescriptor innerRuleDescriptor = null;
            TypeMapMatchingRuleDescriptor typeMapMatchingRuleDescriptor = typeMapDescriptor;
            synchronized (typeMapMatchingRuleDescriptor) {
                innerRuleDescriptor = (MatchingRuleDescriptor)typeMapDescriptor.getMap().get(type);
            }
            if (innerRuleDescriptor == null) {
                EntityID entityID = (EntityID)entity.getID();
                if (this.getEntitySearch().query().keys(new long[]{entityID.getValue()}).count() == 1L) {
                    return entityID;
                }
                return null;
            }
            if (!(innerRuleDescriptor instanceof LayeredMatchingRuleDescriptor)) {
                throw new IllegalArgumentException("Unsupported inner rule descriptor: " + innerRuleDescriptor);
            }
            LayeredMatchingRuleDescriptor layeredDescriptor = (LayeredMatchingRuleDescriptor)innerRuleDescriptor;
            MatchingRuleDescriptor[] rules = layeredDescriptor.getRules();
            if (rules == null || rules.length == 0) {
                return null;
            }
            if (rules.length != 1 || !(rules[0] instanceof AndMatchingRuleDescriptor)) {
                throw new IllegalArgumentException("LayeredMatchingRuleDescriptor does not contain AndMatchingRuleDescriptor");
            }
            AndMatchingRuleDescriptor andDescriptor = (AndMatchingRuleDescriptor)rules[0];
            Collection andRules = andDescriptor.getRules();
            if (andRules == null || andRules.isEmpty()) {
                return null;
            }
            boolean checkInherited = false;
            List<String> types = Collections.singletonList(type);
            PandoraQuery query = this.toPandoraQuery(andRules, entity, types).includeKeyOnly();
            PandoraQueryResult result = query.list(1);
            if (!result.isEmpty()) {
                return EntityID.create((long)result.getFirstKey());
            }
        } else {
            throw new IllegalArgumentException("Unsupported rule descriptor: " + ruleDescriptor);
        }
        return null;
    }

    private PandoraQuery getDefaultMatchQuery(MaltegoEntity entity) throws IllegalArgumentException {
        PandoraFilter.Contains idFilter = new PandoraFilter.Contains("__key", new Object[]{((EntityID)entity.getID()).getValue()});
        PandoraFilter.Contains typeFilter = new PandoraFilter.Contains("type", new Object[]{entity.getTypeName()});
        PandoraQuery query = this.getEntitySearch().query();
        this.getValueFilter(entity).map(arg_0 -> PandoraGraphDataStoreReader.lambda$getDefaultMatchQuery$0((PandoraFilter)typeFilter, arg_0)).ifPresent(arg_0 -> PandoraGraphDataStoreReader.lambda$getDefaultMatchQuery$1(query, (PandoraFilter)idFilter, arg_0));
        return query;
    }

    private PandoraQuery toPandoraQuery(Collection<MatchingRuleDescriptor> rules, MaltegoEntity entity, List<String> types) throws IllegalArgumentException {
        PandoraFilter.Contains idFilter = new PandoraFilter.Contains("__key", new Object[]{((EntityID)entity.getID()).getValue()});
        ArrayList<PandoraFilter.ContainsAny> filters = new ArrayList<PandoraFilter.ContainsAny>();
        filters.add(new PandoraFilter.ContainsAny("type", (Object[])types.toArray(new String[types.size()])));
        for (MatchingRuleDescriptor rule : rules) {
            PropertyDescriptor property;
            if (rule.equals(StatelessMatchingRuleDescriptor.Value)) {
                property = InheritanceHelper.getValueProperty((SpecRegistry)this._entityRegistry, (TypedPropertyBag)entity, (boolean)true);
            } else if (rule instanceof PropertyMatchingRuleDescriptor) {
                PropertyMatchingRuleDescriptor propertyDescriptor = (PropertyMatchingRuleDescriptor)rule;
                String propertyName = propertyDescriptor.getProperty();
                property = entity.getProperties().get(propertyName);
            } else {
                throw new IllegalArgumentException("Unsupported inner inner rule descriptor: " + rule);
            }
            if (property == null) continue;
            this.getPropertyFilter(entity, property).ifPresent(filters::add);
        }
        PandoraFilter.And andFilter = new PandoraFilter.And(filters.toArray(new PandoraFilter[filters.size()]));
        return this.getEntitySearch().query().andAny(new PandoraFilter[]{idFilter, andFilter});
    }

    private Optional<PandoraFilter> getValueFilter(MaltegoEntity entity) {
        PropertyDescriptor property = InheritanceHelper.getValueProperty((SpecRegistry)this._entityRegistry, (TypedPropertyBag)entity, (boolean)true);
        return this.getPropertyFilter(entity, property);
    }

    private Optional<PandoraFilter> getPropertyFilter(MaltegoEntity entity, PropertyDescriptor property) {
        String str;
        PartMapWriter mapWriter = new PartMapWriter();
        TypeDescriptor td = TypeRegistry.getDefault().getType(property.getType());
        Object value = mapWriter.translateValue(td.getType(), entity.getValue(property));
        if (value instanceof String && (str = (String)value).length() >= PandoraConstants.getExactMatchStringLimit()) {
            value = str.substring(0, PandoraConstants.getExactMatchStringLimit());
        }
        PandoraFilter.Or filter = null;
        if (value != null) {
            String propertyName = property.getName();
            propertyName = mapWriter.escapeDots(propertyName);
            String propValueKeyPrefix = "properties." + propertyName + ".";
            String pandoraPropNoType = propValueKeyPrefix + "value";
            String pandoraPropWithType = propValueKeyPrefix + PartMapWriter.getPropertyValueKey((TypeDescriptor)td);
            filter = new PandoraFilter.Or(new PandoraFilter[]{new PandoraFilter.Contains(pandoraPropNoType, new Object[]{value}), new PandoraFilter.Contains(pandoraPropWithType, new Object[]{value})});
        }
        return Optional.ofNullable(filter);
    }

    private MaltegoEntity toEntity(Artifact artifact) throws GraphStoreException {
        try {
            Map map = artifact == null ? null : this._mapReader.unescapeDots((Map)artifact);
            return map == null ? null : this._mapReader.entityFromMap(this._entityRegistry, this._entityFactory, map);
        }
        catch (GraphSerializationException ex) {
            throw new GraphStoreException((Throwable)ex);
        }
    }

    private MaltegoLink toLink(Artifact artifact) throws GraphStoreException {
        try {
            Map map = artifact == null ? null : this._mapReader.unescapeDots((Map)artifact);
            return map == null ? null : this._mapReader.linkFromMap(this._linkRegistry, this._linkFactory, map);
        }
        catch (GraphSerializationException ex) {
            throw new GraphStoreException((Throwable)ex);
        }
    }

    private PandoraQuery translateQuery(PandoraSearch pandoraSearch, Guid id, PartDataQuery partQuery) {
        PandoraQuery pandoraQuery = pandoraSearch.query();
        pandoraQuery = pandoraQuery.keys(new long[]{id.getValue()});
        return this.appendQuery(pandoraQuery, partQuery);
    }

    private PandoraQuery translateQuery(PandoraSearch pandoraSearch, PartsDataQuery query) {
        PandoraQuery pandoraQuery = pandoraSearch.query();
        if (!query.isAllIDs()) {
            long[] ids = this.toLongIDs(query.getIDs());
            pandoraQuery = pandoraQuery.keys(ids);
        }
        PartDataQuery partQuery = query.getPartDataQuery();
        return this.appendQuery(pandoraQuery, partQuery);
    }

    private PandoraQuery appendQuery(PandoraQuery pandoraQuery, PartDataQuery partQuery) {
        boolean getProps;
        if (partQuery == null) {
            return pandoraQuery;
        }
        boolean getAllSections = partQuery.isAllSections();
        if (partQuery.isAllProperties()) {
            getProps = true;
        } else {
            Set propNames = partQuery.getPropertyNames();
            boolean bl = getProps = propNames != null && !propNames.isEmpty();
        }
        if (getProps && getAllSections) {
            pandoraQuery = pandoraQuery.includeAll();
        } else {
            if (!getProps) {
                pandoraQuery.exclude("properties");
            }
            if (!getAllSections) {
                PartSectionsQuery sectionsQuery = partQuery.getSections();
                if (sectionsQuery instanceof EntitySectionsQuery) {
                    EntitySectionsQuery entitySectionsQuery = (EntitySectionsQuery)sectionsQuery;
                    if (!entitySectionsQuery.isQueryWeight()) {
                        pandoraQuery = pandoraQuery.exclude("weight");
                    }
                    if (!entitySectionsQuery.isQueryImagePropertyName()) {
                        pandoraQuery = pandoraQuery.exclude("imagePropName");
                    }
                }
                if (!sectionsQuery.isQueryType()) {
                    pandoraQuery = pandoraQuery.exclude("type");
                }
                if (!sectionsQuery.isQueryCachedValueStr()) {
                    pandoraQuery = pandoraQuery.exclude("valueStr");
                }
                if (!sectionsQuery.isQueryCachedDisplayStr()) {
                    pandoraQuery = pandoraQuery.exclude("displayValueStr");
                }
                if (!sectionsQuery.isQueryCachedImageValue()) {
                    pandoraQuery = pandoraQuery.exclude("imageValue");
                }
                if (!sectionsQuery.isQueryCachedHasAttachments()) {
                    pandoraQuery = pandoraQuery.exclude("hasAttachments");
                }
                if (!sectionsQuery.isQueryBookmark()) {
                    pandoraQuery = pandoraQuery.exclude("bookmark");
                }
                if (!sectionsQuery.isQueryNotes()) {
                    pandoraQuery = pandoraQuery.exclude("notes");
                }
                if (!sectionsQuery.isQueryValuePropertyName()) {
                    pandoraQuery = pandoraQuery.exclude("valuePropName");
                }
                if (!sectionsQuery.isQueryDisplayPropertyName()) {
                    pandoraQuery = pandoraQuery.exclude("displayPropName");
                }
                if (!sectionsQuery.isQueryDisplayInfo()) {
                    pandoraQuery = pandoraQuery.exclude("displayInfo");
                }
            }
        }
        Map matchProps = partQuery.getMatchProperties();
        if (matchProps != null) {
            for (Map.Entry entry : matchProps.entrySet()) {
                String key = (String)entry.getKey();
                Object value = entry.getValue();
                pandoraQuery.filterContains(key, new Object[]{value});
            }
        }
        return pandoraQuery;
    }

    private FifoCache<EntityID, MaltegoEntity> getEntityCache() {
        String key;
        GraphUserData gud = GraphUserData.forGraph((GraphID)this.getGraphID());
        DataCache cache = (DataCache)gud.get((Object)(key = DataCache.class.getName()));
        if (cache == null) {
            cache = new DataCache();
            gud.put((Object)key, (Object)cache);
        }
        return cache.getEntityCache();
    }

    public Set<EntityID> searchEntities(SearchOptions options) throws GraphStoreException {
        try {
            PandoraQuery query = this.toPandoraQuery(options, true);
            long[] keys = query.includeKeyOnly().list().getKeys();
            HashSet<EntityID> found = new HashSet<EntityID>(keys.length);
            for (long key : keys) {
                found.add(EntityID.create((long)key));
            }
            return found;
        }
        catch (PandoraException ex) {
            throw new GraphStoreException("Search exception for options: " + options, (Throwable)ex);
        }
    }

    public Set<LinkID> searchLinks(SearchOptions options) throws GraphStoreException {
        try {
            PandoraQuery query = this.toPandoraQuery(options, false);
            long[] keys = query.includeKeyOnly().list().getKeys();
            HashSet<LinkID> found = new HashSet<LinkID>(keys.length);
            for (long key : keys) {
                found.add(LinkID.create((long)key));
            }
            return found;
        }
        catch (PandoraException ex) {
            throw new GraphStoreException("Search exception for options: " + options, (Throwable)ex);
        }
    }

    private PandoraQuery toPandoraQuery(SearchOptions options, boolean isEntities) {
        PandoraQuery query;
        PandoraQuery pandoraQuery = query = isEntities ? this.getEntitySearch().query() : this.getLinkSearch().query();
        if (!StringUtilities.isNullOrEmpty((String)options.getType())) {
            query = query.filterContains("type", (Object[])new String[]{options.getType()});
        }
        String searchText = "*" + query.escape(options.getText()) + "*";
        searchText = searchText.replace("<", "\\<").replace(">", "\\>");
        ArrayList<PandoraFilter.Like> orFilters = new ArrayList<PandoraFilter.Like>();
        if (options.isSearchValue()) {
            orFilters.add(new PandoraFilter.Like("valueStr", searchText));
            orFilters.add(new PandoraFilter.Like("displayValueStr", searchText));
        }
        if (options.isSearchProperties()) {
            orFilters.add(new PandoraFilter.Like("propText", searchText));
        }
        if (options.isSearchNotes()) {
            orFilters.add(new PandoraFilter.Like("notes.value", searchText));
        }
        if (options.isSearchDisplayInfo()) {
            orFilters.add(new PandoraFilter.Like("displayInfo.name", searchText));
            orFilters.add(new PandoraFilter.Like("displayInfo.value", searchText));
        }
        if (!orFilters.isEmpty()) {
            query = query.andAny(orFilters.toArray(new PandoraFilter[orFilters.size()]));
        }
        return query;
    }

    private static /* synthetic */ void lambda$getDefaultMatchQuery$1(PandoraQuery query, PandoraFilter idFilter, PandoraFilter.And typeValueFilter) {
        query.andAny(new PandoraFilter[]{idFilter, typeValueFilter});
    }

    private static /* synthetic */ PandoraFilter.And lambda$getDefaultMatchQuery$0(PandoraFilter typeFilter, PandoraFilter valueFilter) {
        return new PandoraFilter.And(new PandoraFilter[]{typeFilter, valueFilter});
    }
}

