/*
 * Decompiled with CFR 0.152.
 */
package com.bulenkov.darcula.ui;

import com.bulenkov.darcula.ui.DarculaTextBorder;
import com.bulenkov.iconloader.IconLoader;
import com.bulenkov.iconloader.util.GraphicsConfig;
import com.bulenkov.iconloader.util.GraphicsUtil;
import com.paterva.maltego.util.IconSize;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.TextUI;
import javax.swing.plaf.basic.BasicTextFieldUI;
import javax.swing.text.JTextComponent;
import org.openide.awt.QuickSearch;

public class DarculaTextFieldUI
extends BasicTextFieldUI {
    private static final String SHOW_CLEAR_ICON = "JTextField.Search.showClearIcon";
    public static final String TEXTFIELD_SEARCH_TYPE = "JTextField.Search.SearchType";
    public static final String TEXTFIELD_SEARCH_CALLBACK = "JTextField.Search.ProgressiveTimer.Callback";
    public static final String TEXTFIELD_SMALL = "JTextField.small";
    protected static final int ICON_SIZE_SMALL = 6;
    protected static final int ICON_SIZE_NORMAL = IconSize.TINY.getSize();
    private final QuickSearch.TextFieldUICallback _searchCallback;
    private final JTextField _myTextField;
    private FilterTextListener _documentListener = null;
    private Timer _timer = null;
    private Action _enterAction = null;
    protected JLabel myClearIcon;
    protected JLabel myRecentIcon;

    public DarculaTextFieldUI(JTextField textField) {
        this._myTextField = textField;
        this._searchCallback = null;
    }

    public static ComponentUI createUI(final JComponent c) {
        final DarculaTextFieldUI ui = new DarculaTextFieldUI((JTextField)c);
        c.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                c.repaint();
            }

            @Override
            public void focusLost(FocusEvent e) {
                c.repaint();
            }
        });
        c.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                if (ui.getComponent() != null && DarculaTextFieldUI.isSearchField(c)) {
                    if (ui.getActionUnder(e) != null) {
                        c.setCursor(Cursor.getPredefinedCursor(12));
                    } else {
                        c.setCursor(Cursor.getPredefinedCursor(2));
                    }
                }
            }
        });
        c.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                SearchAction action;
                if (DarculaTextFieldUI.isSearchField(c) && (action = ui.getActionUnder(e)) != null) {
                    switch (action) {
                        case POPUP: {
                            ui.showSearchPopup();
                            ui.performActions(c);
                            break;
                        }
                        case CLEAR: {
                            ((JTextField)c).setText("");
                            ((JTextField)c).putClientProperty(DarculaTextFieldUI.SHOW_CLEAR_ICON, Boolean.FALSE);
                            c.repaint();
                        }
                    }
                    e.consume();
                }
            }
        });
        return ui;
    }

    @Override
    protected void installListeners() {
        super.installListeners();
    }

    @Override
    public void update(Graphics g, final JComponent c) {
        GraphicsUtil.setupTextAntialiasing(g, c);
        if (DarculaTextFieldUI.isProgressiveTimerSearch(c) || DarculaTextFieldUI.isStaticSearch(c)) {
            if (DarculaTextFieldUI.isProgressiveTimerSearch(c) && this._documentListener == null) {
                if (this.isNotEmpty(c)) {
                    this.onFilterTextChanged(0);
                }
                this._documentListener = new FilterTextListener();
                ((JTextField)c).getDocument().addDocumentListener(this._documentListener);
            }
            if (this._enterAction == null) {
                this._enterAction = new AbstractAction(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        DarculaTextFieldUI.this.performActions(c);
                    }
                };
                ((JTextField)c).addActionListener(this._enterAction);
            }
        }
        super.update(g, c);
    }

    @Override
    protected void uninstallListeners() {
        super.uninstallListeners();
        JTextComponent c = this.getComponent();
        if (this._documentListener != null && c != null && c instanceof JTextField) {
            ((JTextField)c).getDocument().removeDocumentListener(this._documentListener);
            this._documentListener = null;
        }
        if (this._enterAction != null && c != null && c instanceof JTextField) {
            ((JTextField)c).removeActionListener(this._enterAction);
            this._enterAction = null;
        }
    }

    protected void showSearchPopup() {
        Object value = this.getComponent().getClientProperty("JTextField.Search.FindPopup");
        if (value != null && value instanceof JPopupMenu) {
            JPopupMenu popup = (JPopupMenu)value;
            JTextField c = this._myTextField;
            Insets i = c.getInsets();
            popup.show(this.getComponent(), i.left, this.getComponent().getHeight());
        }
    }

    private SearchAction getActionUnder(MouseEvent e) {
        Point ePoint = e.getPoint();
        Point iconPoint = this.getClearIconCoord();
        int halfIconSize = this.getIconSize() / 2;
        iconPoint.x += halfIconSize;
        iconPoint.y += halfIconSize;
        boolean isShowClearIcon = Boolean.TRUE.equals(this.getComponent().getClientProperty(SHOW_CLEAR_ICON));
        return iconPoint.distance(ePoint) <= (double)halfIconSize ? (!isShowClearIcon ? SearchAction.POPUP : SearchAction.CLEAR) : null;
    }

    protected Rectangle getDrawingRect() {
        JTextField c = this._myTextField;
        Insets i = c.getInsets();
        int x = i.left;
        int y = i.top;
        int w = c.getWidth() - i.left - i.right;
        int h = c.getBounds().height - i.top - i.bottom;
        return new Rectangle(x, y, w, h);
    }

    protected Point getSearchIconCoord() {
        return this.getClearIconCoord();
    }

    protected Point getClearIconCoord() {
        JTextField c = this._myTextField;
        Rectangle r = this.getDrawingRect();
        int iconSize = this.getIconSize();
        int xOffset = 3;
        if (DarculaTextFieldUI.isSmall(c)) {
            xOffset = 1;
        }
        return new Point(r.x + r.width + xOffset, (int)((float)r.y + (float)(r.height - iconSize) / 2.0f));
    }

    @Override
    protected void paintBackground(Graphics graphics) {
        Graphics2D g = (Graphics2D)graphics;
        JTextComponent c = this.getComponent();
        Container parent = c.getParent();
        if (c.isOpaque() && parent != null) {
            g.setColor(parent.getBackground());
            g.fillRect(0, 0, c.getWidth(), c.getHeight());
        }
        GraphicsConfig config = new GraphicsConfig(g);
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        Border border = c.getBorder();
        if (DarculaTextFieldUI.isSearchField(c)) {
            int width = c.getWidth();
            int height = c.getHeight();
            g.setColor(c.getBackground());
            g.fillRect(0, 0, width, height);
            Point p = this.getSearchIconCoord();
            if (this.satisfiesSearchTypeCriteria(c)) {
                p = this.getClearIconCoord();
                Icon clearIcon = UIManager.getLookAndFeelDefaults().getIcon("TextField.darcula.clear2.icon");
                if (clearIcon == null) {
                    String res = "/com/bulenkov/darcula/icons/clear2.png";
                    clearIcon = IconLoader.findIcon(res, DarculaTextFieldUI.class, true);
                }
                this.paintIcon(g, clearIcon, p);
                if (!Boolean.TRUE.equals(((JTextField)c).getClientProperty(SHOW_CLEAR_ICON))) {
                    ((JTextField)c).putClientProperty(SHOW_CLEAR_ICON, Boolean.TRUE);
                }
            } else {
                Icon searchIcon;
                Icon icon = searchIcon = c.getClientProperty("JTextField.Search.FindPopup") instanceof JPopupMenu ? UIManager.getLookAndFeelDefaults().getIcon("TextField.darcula.searchWithHistory.icon") : UIManager.getLookAndFeelDefaults().getIcon("TextField.darcula.search.icon");
                if (searchIcon == null) {
                    String res = "/com/bulenkov/darcula/icons/search.png";
                    searchIcon = IconLoader.findIcon(res, DarculaTextFieldUI.class, true);
                }
                this.paintIcon(g, searchIcon, p);
                if (!Boolean.FALSE.equals(((JTextField)c).getClientProperty(SHOW_CLEAR_ICON))) {
                    ((JTextField)c).putClientProperty(SHOW_CLEAR_ICON, Boolean.FALSE);
                }
            }
        } else if (border instanceof DarculaTextBorder) {
            g.setColor(c.getBackground());
            int width = c.getWidth();
            int height = c.getHeight();
            g.fillRect(0, 0, width, height);
        } else {
            super.paintBackground(g);
        }
        config.restore();
    }

    public static boolean isSmall(Component c) {
        return c instanceof JTextField && Boolean.TRUE.equals(((JTextField)c).getClientProperty(TEXTFIELD_SMALL));
    }

    private int getIconSize() {
        return DarculaTextFieldUI.isSmall(this._myTextField) ? 6 : ICON_SIZE_NORMAL;
    }

    private void paintIcon(Graphics2D g, Icon icon, Point p) {
        boolean small = DarculaTextFieldUI.isSmall(this._myTextField);
        g = (Graphics2D)g.create();
        g.translate(p.x, p.y);
        if (small) {
            double scale = 6.0 / (double)ICON_SIZE_NORMAL;
            g.scale(scale, scale);
        }
        icon.paintIcon(null, g, 0, 0);
        g.dispose();
    }

    @Override
    protected void paintSafely(Graphics g) {
        this.paintBackground(g);
        super.paintSafely(g);
    }

    protected void performActions(JComponent c) {
        TextUI textUI = ((JTextField)c).getUI();
        if (textUI != null && textUI instanceof DarculaTextFieldUI) {
            Timer timer = ((DarculaTextFieldUI)textUI)._timer;
            if (timer != null) {
                ActionListener[] actionListeners;
                for (ActionListener actionListener : actionListeners = timer.getActionListeners()) {
                    actionListener.actionPerformed(new ActionEvent(this, 1001, "find"));
                }
            } else {
                QuickSearch.TextFieldUICallback cb = this.getSearchCallBack();
                if (cb != null) {
                    this.performSearchProgressiveTimerCallBack(cb);
                }
            }
        }
    }

    private void onFilterTextChanged() {
        this.onFilterTextChanged(-1);
    }

    private void onFilterTextChanged(int forcedDelay) {
        this.scheduleFilter(forcedDelay);
    }

    private void scheduleFilter(int forcedDelay) {
        if (this._timer != null) {
            this._timer.restart();
        } else {
            final QuickSearch.TextFieldUICallback cb = this.getSearchCallBack();
            if (cb != null) {
                this._timer = new Timer(forcedDelay == -1 ? cb.getFilterDelay() : forcedDelay, new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        DarculaTextFieldUI.this.performSearchProgressiveTimerCallBack(cb);
                        DarculaTextFieldUI.this._timer.stop();
                        DarculaTextFieldUI.this._timer = null;
                    }
                });
                this._timer.start();
            }
        }
    }

    private void performSearchProgressiveTimerCallBack(QuickSearch.TextFieldUICallback cb) {
        cb.perform();
        JTextComponent c = this.getComponent();
        if (c != null && c instanceof JTextField) {
            ((JTextField)c).putClientProperty(SHOW_CLEAR_ICON, Boolean.TRUE);
            c.repaint();
        }
    }

    private QuickSearch.TextFieldUICallback getSearchCallBack() {
        Object cbValue;
        JTextComponent c;
        if (this._searchCallback == null && (c = this.getComponent()) != null && c instanceof JTextField && (cbValue = c.getClientProperty(TEXTFIELD_SEARCH_CALLBACK)) != null && cbValue instanceof QuickSearch.TextFieldUICallback) {
            return (QuickSearch.TextFieldUICallback)cbValue;
        }
        return this._searchCallback;
    }

    public boolean satisfiesSearchTypeCriteria(Component c) {
        if (DarculaTextFieldUI.isStaticSearch(c)) {
            return Boolean.TRUE.equals(((JTextField)c).getClientProperty(SHOW_CLEAR_ICON)) && this.isNotEmpty(c);
        }
        if (DarculaTextFieldUI.isProgressiveTimerSearch(c)) {
            return Boolean.TRUE.equals(((JTextField)c).getClientProperty(SHOW_CLEAR_ICON)) && this.isNotEmpty(c);
        }
        if (DarculaTextFieldUI.isProgressiveSearch(c)) {
            return this.isNotEmpty(c);
        }
        return false;
    }

    private boolean isNotEmpty(Component c) {
        return ((JTextField)c).getText().length() > 0;
    }

    public static boolean isProgressiveSearch(Component c) {
        return DarculaTextFieldUI.isSearchField(c) && !DarculaTextFieldUI.isStaticSearch(c) && !DarculaTextFieldUI.isProgressiveTimerSearch(c);
    }

    public static boolean isStaticSearch(Component c) {
        return DarculaTextFieldUI.isSearchField(c) && "static".equals(((JTextField)c).getClientProperty(TEXTFIELD_SEARCH_TYPE));
    }

    public static boolean isProgressiveTimerSearch(Component c) {
        return DarculaTextFieldUI.isSearchField(c) && "progressiveTimer".equals(((JTextField)c).getClientProperty(TEXTFIELD_SEARCH_TYPE));
    }

    public static boolean isSearchField(Component c) {
        return c instanceof JTextField && "search".equals(((JTextField)c).getClientProperty("JTextField.variant"));
    }

    public static boolean isSearchFieldWithHistoryPopup(Component c) {
        return DarculaTextFieldUI.isSearchField(c) && ((JTextField)c).getClientProperty("JTextField.Search.FindPopup") instanceof JPopupMenu;
    }

    private class FilterTextListener
    implements DocumentListener {
        private FilterTextListener() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            DarculaTextFieldUI.this.onFilterTextChanged();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            DarculaTextFieldUI.this.onFilterTextChanged();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            DarculaTextFieldUI.this.onFilterTextChanged();
        }
    }

    private static enum SearchAction {
        POPUP,
        CLEAR;

    }
}

