/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.core;

import com.paterva.maltego.util.StringUtilities;
import java.util.UUID;

public class Guid
implements Comparable<Guid> {
    protected static final int RADIX = 36;
    private final long _value;
    private static long _lastValue = UUID.randomUUID().getLeastSignificantBits();
    private static final Object LOCK = new Object();

    protected Guid(long value) {
        this._value = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Guid() {
        Object object = LOCK;
        synchronized (object) {
            this._value = _lastValue++;
        }
    }

    public static synchronized Guid create() {
        return new Guid();
    }

    public static Guid parse(String guid) {
        long value = StringUtilities.parseUnsignedLong((String)guid.toLowerCase(), (int)36);
        return new Guid(value);
    }

    public long getValue() {
        return this._value;
    }

    @Override
    public int compareTo(Guid o) {
        return Long.compare(this._value, o._value);
    }

    public int hashCode() {
        return (int)this._value;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Guid other = (Guid)obj;
        return this._value == other._value;
    }

    public String toString() {
        return StringUtilities.toStringUnsignedLong((long)this._value, (int)36).toLowerCase();
    }
}

