/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.parsing.implspi;

import java.io.IOException;
import javax.swing.event.ChangeListener;
import javax.swing.text.Document;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.modules.parsing.api.Source;
import org.netbeans.modules.parsing.impl.ParserEventForward;
import org.netbeans.modules.parsing.impl.SourceAccessor;
import org.netbeans.modules.parsing.impl.event.FileChangeSupport;
import org.netbeans.modules.parsing.impl.event.ParserChangeSupport;
import org.netbeans.modules.parsing.implspi.SchedulerControl;
import org.netbeans.modules.parsing.implspi.SourceControl;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Parameters;

public abstract class SourceEnvironment {
    private static final int DEFAULT_REPARSE_DELAY = 500;
    private static final int IMMEDIATE_REPARSE_DELAY = 10;
    private static int reparseDelay = 500;
    private static int immediateReparseDelay = 10;
    private final SourceControl sourceControl;
    private FileChangeListener fileChangeListener;
    private ChangeListener parserListener;

    protected SourceEnvironment(@NonNull SourceControl sourceControl) {
        Parameters.notNull((CharSequence)"sourceControl", (Object)sourceControl);
        this.sourceControl = sourceControl;
    }

    @CheckForNull
    public abstract Document readDocument(@NonNull FileObject var1, boolean var2) throws IOException;

    public abstract void attachScheduler(@NonNull SchedulerControl var1, boolean var2);

    public abstract void activate();

    public abstract boolean isReparseBlocked();

    protected final SourceControl getSourceControl() {
        return this.sourceControl;
    }

    protected final void listenOnFileChanges() {
        FileObject fo = this.sourceControl.getSource().getFileObject();
        if (fo != null) {
            this.fileChangeListener = new FileChangeSupport(this.sourceControl);
            fo.addFileChangeListener(FileUtil.weakFileChangeListener((FileChangeListener)this.fileChangeListener, (Object)fo));
        }
    }

    protected final void listenOnParser() {
        ParserEventForward peFwd = SourceAccessor.getINSTANCE().getParserEventForward(this.sourceControl.getSource());
        this.parserListener = new ParserChangeSupport(this.sourceControl);
        peFwd.addChangeListener(this.parserListener);
    }

    @NonNull
    protected static SourceEnvironment forSource(@NonNull Source source) {
        return SourceAccessor.getINSTANCE().getEnv(source);
    }

    public static int getReparseDelay(boolean fast) {
        return fast ? immediateReparseDelay : reparseDelay;
    }

    static void setReparseDelays(int standardReparseDelay, int fastReparseDelay) throws IllegalArgumentException {
        if (standardReparseDelay < fastReparseDelay) {
            throw new IllegalArgumentException(String.format("Fast reparse delay %d > standatd reparse delay %d", fastReparseDelay, standardReparseDelay));
        }
        immediateReparseDelay = fastReparseDelay;
        reparseDelay = standardReparseDelay;
    }
}

