/*
 * Decompiled with CFR 0.152.
 */
package com.kenai.jbosh;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

final class GZIPCodec {
    private static final int BUFFER_SIZE = 512;

    private GZIPCodec() {
    }

    public static String getID() {
        return "gzip";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] encode(byte[] data) throws IOException {
        ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
        DeflaterOutputStream gzOut = null;
        try {
            gzOut = new GZIPOutputStream(byteOut);
            gzOut.write(data);
            gzOut.close();
            byteOut.close();
            byte[] byArray = byteOut.toByteArray();
            return byArray;
        }
        finally {
            gzOut.close();
            byteOut.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] decode(byte[] compressed) throws IOException {
        ByteArrayInputStream byteIn = new ByteArrayInputStream(compressed);
        ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
        GZIPInputStream gzIn = null;
        try {
            int read;
            gzIn = new GZIPInputStream(byteIn);
            byte[] buffer = new byte[512];
            do {
                if ((read = gzIn.read(buffer)) <= 0) continue;
                byteOut.write(buffer, 0, read);
            } while (read >= 0);
            byte[] byArray = byteOut.toByteArray();
            return byArray;
        }
        finally {
            gzIn.close();
            byteOut.close();
        }
    }
}

