/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.pws.oauth;

import com.github.scribejava.core.builder.api.DefaultApi10a;
import com.github.scribejava.core.builder.api.DefaultApi20;
import com.github.scribejava.core.exceptions.OAuthException;
import com.github.scribejava.core.extractors.TokenExtractor;
import com.github.scribejava.core.httpclient.HttpClient;
import com.github.scribejava.core.httpclient.jdk.JDKHttpClient;
import com.github.scribejava.core.httpclient.jdk.JDKHttpClientConfig;
import com.github.scribejava.core.model.OAuth1RequestToken;
import com.github.scribejava.core.model.OAuth2AccessToken;
import com.github.scribejava.core.model.OAuthConfig;
import com.github.scribejava.core.model.OAuthRequest;
import com.github.scribejava.core.model.Parameter;
import com.github.scribejava.core.model.ParameterList;
import com.github.scribejava.core.model.Response;
import com.github.scribejava.core.model.Verb;
import com.github.scribejava.core.oauth.OAuth10aService;
import com.github.scribejava.core.oauth.OAuth20Service;
import com.github.scribejava.core.oauth.OAuthService;
import com.github.scribejava.core.utils.OAuthEncoder;
import com.github.scribejava.core.utils.Preconditions;
import com.paterva.maltego.pws.api.OAuthAuthenticator;
import com.paterva.maltego.pws.api.OAuthVersion;
import com.paterva.maltego.util.StringUtilities;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.openide.util.Exceptions;
import org.openide.util.Utilities;

public class OAuthModel {
    private static final Logger LOG = Logger.getLogger(OAuthModel.class.getName());
    public static final String REQUEST_TYPE_GET = "GET";
    public static final String REQUEST_TYPE_POST = "POST";
    private static final String PROP_ACCESS_TOKEN = "maltego.oauth.accesstoken";
    private static final String USER_AGENT = "Mozilla/5.0";
    private final PropertyChangeSupport _changeSupport = new PropertyChangeSupport(this);
    private final OAuthAuthenticator _authenticator;
    private final int _port;
    private OAuthService _service;
    private String _accessToken;

    public OAuthModel(OAuthAuthenticator authenticator, int port, int connectTimeout, int readTimeout) {
        this._authenticator = authenticator;
        this._port = port;
        try {
            this.createService(connectTimeout, readTimeout);
        }
        catch (UnsupportedEncodingException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    public int getPort() {
        return this._port;
    }

    public boolean isOAuthV2() {
        return OAuthVersion.V2.equals((Object)this._authenticator.getOAuthVersion());
    }

    public Verb getRequestTypeForAccessToken() {
        return Verb.valueOf((String)this.requestType(this._authenticator.getRequestTypeForAccessToken(), REQUEST_TYPE_POST));
    }

    public Verb getRequestTypeForAuthorizationUrl() {
        return Verb.valueOf((String)this.requestType(this._authenticator.getRequestTypeForAuthorizationUrl(), REQUEST_TYPE_GET));
    }

    public Verb getRequestTypeForRequestToken() {
        return Verb.valueOf((String)this.requestType(this._authenticator.getRequestTypeForRequestToken(), REQUEST_TYPE_POST));
    }

    private String requestType(String requestType, String defaultValue) {
        if (requestType == null || requestType.isEmpty()) {
            return defaultValue;
        }
        return requestType;
    }

    public boolean useSSLHost() {
        return this._authenticator.useSSLHost();
    }

    public OAuthService getService() {
        return this._service;
    }

    public String getAccessToken() {
        return this._accessToken;
    }

    public boolean usesRefreshTokens() {
        return !StringUtilities.isNullOrEmpty((String)this._authenticator.getRefreshTokenEndpoint());
    }

    public void setAccessToken(String accessToken) {
        if (!Utilities.compareObjects((Object)this._accessToken, (Object)accessToken)) {
            String old = this._accessToken;
            this._accessToken = accessToken;
            this._changeSupport.firePropertyChange(PROP_ACCESS_TOKEN, old, this._accessToken);
        }
    }

    public String getSigninContextName() {
        return "signin";
    }

    public String getCallbackContextName() {
        return "callback";
    }

    public String getSuccessContextName() {
        return "success";
    }

    public String getServletUrl(String name) {
        return String.format(this.useSSLHost() ? "https://127.0.0.1:%d/%s" : "http://127.0.0.1:%d/%s", this._port, name);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this._changeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this._changeSupport.removePropertyChangeListener(listener);
    }

    private void createService(int connectTimeout, int readTimeout) throws UnsupportedEncodingException {
        JDKHttpClientConfig httpClientConfig = JDKHttpClientConfig.defaultConfig();
        if (connectTimeout > -1) {
            httpClientConfig.setConnectTimeout(Integer.valueOf(connectTimeout));
        }
        if (readTimeout > -1) {
            httpClientConfig.setReadTimeout(Integer.valueOf(readTimeout));
        }
        OAuthConfig config = new OAuthConfig(this._authenticator.getAppKey(), this._authenticator.getAppSecret(), this.getServletUrl(this.getCallbackContextName()), null, null, null, null, USER_AGENT, null, (HttpClient)new JDKHttpClient(httpClientConfig));
        this._service = this.isOAuthV2() ? this.createV2Service(config) : this.createV1Service(config);
    }

    private OAuth10aService createV1Service(OAuthConfig config) {
        return new OAuth10aService(new DefaultApi10a(){

            public String getRequestTokenEndpoint() {
                return OAuthModel.this._authenticator.getRequestTokenEndpoint();
            }

            public String getAccessTokenEndpoint() {
                return OAuthModel.this._authenticator.getAccessTokenEndpoint();
            }

            public String getAuthorizationUrl(OAuth1RequestToken requestToken) {
                return OAuthModel.this._authenticator.getAuthorizationUrl().replace("{token}", requestToken.getToken());
            }

            public Verb getAccessTokenVerb() {
                return OAuthModel.this.getRequestTypeForAccessToken();
            }

            public Verb getRequestTokenVerb() {
                return OAuthModel.this.getRequestTypeForRequestToken();
            }

            protected String getAuthorizationBaseUrl() {
                int indexOf;
                String authorizationUrl = OAuthModel.this._authenticator.getAuthorizationUrl();
                if (authorizationUrl != null && !authorizationUrl.isEmpty() && (indexOf = authorizationUrl.indexOf("?")) > 0) {
                    authorizationUrl = authorizationUrl.substring(0, indexOf);
                }
                return authorizationUrl;
            }
        }, config);
    }

    private OAuth20Service createV2Service(OAuthConfig config) {
        return new OAuth20Service(new MaltegoApi20(), config){

            protected OAuthRequest createAccessTokenRequest(String code) {
                OAuthRequest request = new OAuthRequest(this.getApi().getAccessTokenVerb(), this.getApi().getAccessTokenEndpoint());
                OAuthConfig config = this.getConfig();
                if (OAuthModel.this._authenticator.useClientAuthorizationHeader()) {
                    String auth = String.format("%s:%s", config.getApiKey(), config.getApiSecret());
                    request.addHeader("Authorization", "Basic " + Base64.getEncoder().encodeToString(auth.getBytes(StandardCharsets.UTF_8)));
                } else {
                    request.addParameter("client_id", config.getApiKey());
                    request.addParameter("client_secret", config.getApiSecret());
                }
                request.addParameter("code", code);
                request.addParameter("redirect_uri", config.getCallback());
                String scope = config.getScope();
                if (scope != null) {
                    request.addParameter("scope", scope);
                }
                request.addParameter("grant_type", "authorization_code");
                LOG.fine(() -> "Access Token request:\n" + this.toString(request));
                return request;
            }

            protected OAuthRequest createRefreshTokenRequest(String refreshToken) {
                return super.createRefreshTokenRequest(refreshToken);
            }

            public Response execute(OAuthRequest request) throws InterruptedException, ExecutionException, IOException {
                Response response = super.execute(request);
                if (LOG.isLoggable(Level.FINE)) {
                    StringBuilder sb = new StringBuilder();
                    sb.append("Access Token Response:\n");
                    sb.append("Code: ").append(response.getCode()).append("\n");
                    sb.append("Message: ").append(response.getMessage()).append("\n");
                    sb.append("Headers:\n");
                    this.appendMap(sb, response.getHeaders());
                    sb.append("Body:\n").append(response.getBody());
                    LOG.fine(sb.toString());
                }
                return response;
            }

            private String toString(OAuthRequest request) {
                StringBuilder sb = new StringBuilder();
                sb.append("URL: ").append(request.getCompleteUrl()).append("\n");
                sb.append("Query string parameters:\n");
                this.appendParameters(sb, request.getQueryStringParams());
                sb.append("Headers:\n");
                this.appendMap(sb, request.getHeaders());
                sb.append("OAuth parameters:\n");
                this.appendMap(sb, request.getOauthParameters());
                sb.append("Body parameters:\n");
                this.appendParameters(sb, request.getBodyParams());
                String body = request.getStringPayload();
                if (body != null) {
                    sb.append("Body:\n").append(body);
                }
                return sb.toString();
            }

            private void appendParameters(StringBuilder sb, ParameterList parameters) {
                Map<String, String> map = parameters.getParams().stream().collect(Collectors.toMap(Parameter::getKey, Parameter::getValue, (left, right) -> right));
                this.appendMap(sb, map);
            }

            private void appendMap(StringBuilder sb, Map<String, String> map) {
                map.forEach((key, value) -> this.appendKeyValue(sb, (String)key, (String)value));
            }

            private void appendKeyValue(StringBuilder sb, String key, String value) {
                sb.append("   ").append(key).append(": ").append(value).append("\n");
            }
        };
    }

    class MaltegoApi20
    extends DefaultApi20 {
        MaltegoApi20() {
        }

        public String getAccessTokenEndpoint() {
            return OAuthModel.this._authenticator.getAccessTokenEndpoint();
        }

        protected String getAuthorizationBaseUrl() {
            int indexOf;
            String authorizationUrl = OAuthModel.this._authenticator.getAuthorizationUrl();
            if (authorizationUrl != null && !authorizationUrl.isEmpty() && (indexOf = authorizationUrl.indexOf("?")) > 0) {
                authorizationUrl = authorizationUrl.substring(0, indexOf);
            }
            return authorizationUrl;
        }

        public String getAuthorizationUrl(OAuthConfig config, Map<String, String> additionalParams) {
            String url = OAuthModel.this._authenticator.getAuthorizationUrl();
            String apiKey = config.getApiKey();
            String callback = config.getCallback();
            if (OAuthModel.REQUEST_TYPE_GET.equals(OAuthModel.this._authenticator.getRequestTypeForAuthorizationUrl())) {
                apiKey = OAuthEncoder.encode((String)apiKey);
                callback = OAuthEncoder.encode((String)callback);
            }
            url = url.replace("{apiKey}", apiKey);
            url = url.replace("{callback}", callback);
            return url;
        }

        public TokenExtractor<OAuth2AccessToken> getAccessTokenExtractor() {
            return new PinkmatterAccessTokenExtractor();
        }

        public Verb getAccessTokenVerb() {
            return OAuthModel.this.getRequestTypeForAccessToken();
        }

        public String getRefreshTokenEndpoint() {
            String refreshTokenEndpoint = OAuthModel.this._authenticator.getRefreshTokenEndpoint();
            if (!StringUtilities.isNullOrEmpty((String)refreshTokenEndpoint)) {
                String apiKey = OAuthModel.this._authenticator.getAppKey();
                String apiSecret = OAuthModel.this._authenticator.getAppSecret();
                refreshTokenEndpoint = refreshTokenEndpoint.replace("{apiKey}", apiKey == null ? "" : apiKey);
                refreshTokenEndpoint = refreshTokenEndpoint.replace("{apiSecret}", apiSecret == null ? "" : apiSecret);
            }
            return refreshTokenEndpoint;
        }
    }

    private static class PinkmatterAccessTokenExtractor
    implements TokenExtractor<OAuth2AccessToken> {
        private static final String SPECIAL_CHARS = "'\",:=\\s&";
        private static final String ACCESS_TOKEN_REGEX = "access_token['\",:=\\s&]*([^'\",:=\\s&]+)";
        private static final String EXPIRES_TOKEN_REGEX = "expires_in['\",:=\\s&]*([^'\",:=\\s&]+)";
        private static final String REFRESH_TOKEN_REGEX = "refresh_token['\",:=\\s&]*([^'\",:=\\s&]+)";

        private PinkmatterAccessTokenExtractor() {
        }

        public OAuth2AccessToken extract(Response response) throws IOException, OAuthException {
            String body = response.getBody();
            Preconditions.checkEmptyString((String)body, (String)"Response body is incorrect. Can't extract a token from an empty string");
            String token = this.getValue(ACCESS_TOKEN_REGEX, body);
            if (token != null) {
                Integer expiry = null;
                String expiryString = this.getValue(EXPIRES_TOKEN_REGEX, body);
                if (expiryString != null) {
                    try {
                        expiry = Integer.parseInt(expiryString);
                    }
                    catch (NumberFormatException ex) {
                        LOG.log(Level.WARNING, "Failed to parse token expiry string");
                    }
                } else {
                    LOG.log(Level.WARNING, "Token expiry string is null");
                }
                return new OAuth2AccessToken(token, null, expiry, this.getValue(REFRESH_TOKEN_REGEX, body), null, body);
            }
            throw new OAuthException("Response body is incorrect. Can't extract a token from this: '" + response + "'", null);
        }

        private String getValue(String regex, String raw) {
            Matcher matcher = Pattern.compile(regex).matcher(raw);
            if (matcher.find()) {
                return OAuthEncoder.decode((String)matcher.group(1));
            }
            return null;
        }
    }
}

