/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.help;

import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.help.MergeHelpUtilities;
import javax.help.NavigatorView;
import javax.help.SortMerge;
import javax.help.TreeItem;
import javax.help.UniteAppendMerge;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import org.zaproxy.zap.extension.help.ZapTocItem;

public class ZapTocMerger
extends UniteAppendMerge {
    private static final String DEFAULT_MERGE_TYPE = ZapTocMerger.class.getCanonicalName();
    private static final String ADDONS_TOC_ID = "addons";
    public static final Map<String, ForceMergeRequirement> TOC_IDS_FORCE_MERGE_MAP;

    public ZapTocMerger(NavigatorView master, NavigatorView slave) {
        super(master, slave);
    }

    public TreeNode processMerge(TreeNode node) {
        DefaultMutableTreeNode masterNode = (DefaultMutableTreeNode)node;
        if (masterNode.equals(this.slaveTopNode)) {
            return masterNode;
        }
        if (this.slaveTopNode.getChildCount() == 0) {
            return masterNode;
        }
        ZapTocMerger.mergeNodes(masterNode, this.slaveTopNode);
        return masterNode;
    }

    public static void mergeNodes(TreeNode master, TreeNode slave) {
        DefaultMutableTreeNode masterNode = (DefaultMutableTreeNode)master;
        DefaultMutableTreeNode slaveNode = (DefaultMutableTreeNode)slave;
        int masterCnt = masterNode.getChildCount();
        while (slaveNode.getChildCount() > 0) {
            DefaultMutableTreeNode slaveNodeChild = (DefaultMutableTreeNode)slaveNode.getFirstChild();
            for (int m = 0; m < masterCnt; ++m) {
                DefaultMutableTreeNode masterAtM = (DefaultMutableTreeNode)masterNode.getChildAt(m);
                if (ZapTocMerger.doCustomMerge(slaveNodeChild, masterAtM)) {
                    slaveNodeChild = null;
                    break;
                }
                if (MergeHelpUtilities.compareNames((DefaultMutableTreeNode)masterAtM, (DefaultMutableTreeNode)slaveNodeChild) != 0) continue;
                if (MergeHelpUtilities.haveEqualID((DefaultMutableTreeNode)masterAtM, (DefaultMutableTreeNode)slaveNodeChild)) {
                    MergeHelpUtilities.mergeNodes((String)DEFAULT_MERGE_TYPE, (DefaultMutableTreeNode)masterAtM, (DefaultMutableTreeNode)slaveNodeChild);
                    slaveNodeChild.removeFromParent();
                    slaveNodeChild = null;
                    break;
                }
                MergeHelpUtilities.markNodes((DefaultMutableTreeNode)masterAtM, (DefaultMutableTreeNode)slaveNodeChild);
                masterNode.add(slaveNodeChild);
                MergeHelpUtilities.mergeNodeChildren((String)DEFAULT_MERGE_TYPE, (DefaultMutableTreeNode)slaveNodeChild);
                slaveNodeChild = null;
                break;
            }
            if (slaveNodeChild == null) continue;
            masterNode.add(slaveNodeChild);
            MergeHelpUtilities.mergeNodeChildren((String)DEFAULT_MERGE_TYPE, (DefaultMutableTreeNode)slaveNodeChild);
        }
        slaveNode.removeFromParent();
        slaveNode = null;
    }

    private static boolean doCustomMerge(DefaultMutableTreeNode slaveNodeChild, DefaultMutableTreeNode masterAtM) {
        if (ZapTocMerger.isSameTOCID(masterAtM, slaveNodeChild) || ZapTocMerger.isForceMerge(masterAtM, slaveNodeChild)) {
            MergeHelpUtilities.mergeNodes((String)DEFAULT_MERGE_TYPE, (DefaultMutableTreeNode)masterAtM, (DefaultMutableTreeNode)slaveNodeChild);
            slaveNodeChild.removeFromParent();
            if (ADDONS_TOC_ID.equals(ZapTocMerger.getTOCID(masterAtM))) {
                SortMerge.sortNode((DefaultMutableTreeNode)masterAtM, (Locale)MergeHelpUtilities.getLocale((DefaultMutableTreeNode)masterAtM));
            }
            return true;
        }
        return false;
    }

    private static boolean isSameTOCID(DefaultMutableTreeNode masterAtM, DefaultMutableTreeNode slaveNodeChild) {
        String slaveTocId = ZapTocMerger.getTOCID(slaveNodeChild);
        if (slaveTocId == null) {
            return false;
        }
        return slaveTocId.equals(ZapTocMerger.getTOCID(masterAtM));
    }

    private static String getTOCID(DefaultMutableTreeNode node) {
        TreeItem treeItem = (TreeItem)node.getUserObject();
        if (treeItem != null && treeItem instanceof ZapTocItem) {
            return ((ZapTocItem)treeItem).getTocId();
        }
        return null;
    }

    private static boolean isForceMerge(DefaultMutableTreeNode masterAtM, DefaultMutableTreeNode slaveNodeChild) {
        ForceMergeRequirement forceMergeRequirement;
        TreeItem slaveNodeChildTreeItem = (TreeItem)slaveNodeChild.getUserObject();
        String slaveName = slaveNodeChildTreeItem.getName();
        if (slaveName == null) {
            return false;
        }
        String tocId = ZapTocMerger.getTOCID(masterAtM);
        return tocId != null && (forceMergeRequirement = TOC_IDS_FORCE_MERGE_MAP.get(tocId)) != null && forceMergeRequirement.isSameMasterLevel(masterAtM.getLevel()) && forceMergeRequirement.isSameSlaveName(slaveName);
    }

    public static void mergeNodeChildren(TreeNode node) {
        DefaultMutableTreeNode masterNode = (DefaultMutableTreeNode)node;
        for (int i = 0; i < masterNode.getChildCount(); ++i) {
            DefaultMutableTreeNode child = (DefaultMutableTreeNode)masterNode.getChildAt(i);
            if (child.isLeaf()) continue;
            MergeHelpUtilities.mergeNodeChildren((String)DEFAULT_MERGE_TYPE, (DefaultMutableTreeNode)child);
        }
    }

    static {
        HashMap<String, ForceMergeRequirement> tempMap = new HashMap<String, ForceMergeRequirement>();
        tempMap.put("toplevelitem", new ForceMergeRequirement(1, "ZAP User Guide"));
        tempMap.put(ADDONS_TOC_ID, new ForceMergeRequirement(2, "Add Ons"));
        TOC_IDS_FORCE_MERGE_MAP = Collections.unmodifiableMap(tempMap);
    }

    public static final class ForceMergeRequirement {
        private final int masterNodeLevel;
        private final String slaveNodeName;

        public ForceMergeRequirement(int masterNodeLevel, String slaveNodeName) {
            if (masterNodeLevel < 0) {
                throw new IllegalArgumentException("Parameter masterNodeLevel must not be negative.");
            }
            if (slaveNodeName == null || slaveNodeName.isEmpty()) {
                throw new IllegalArgumentException("Parameter slaveNodeName must not be null.");
            }
            this.masterNodeLevel = masterNodeLevel;
            this.slaveNodeName = slaveNodeName;
        }

        public boolean isSameMasterLevel(int level) {
            return this.masterNodeLevel == level;
        }

        public boolean isSameSlaveName(String name) {
            return this.slaveNodeName.equals(name);
        }
    }
}

