// Copyright 2015, VIXL authors
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are met:
//
//   * Redistributions of source code must retain the above copyright notice,
//     this list of conditions and the following disclaimer.
//   * Redistributions in binary form must reproduce the above copyright notice,
//     this list of conditions and the following disclaimer in the documentation
//     and/or other materials provided with the distribution.
//   * Neither the name of ARM Limited nor the names of its contributors may be
//     used to endorse or promote products derived from this software without
//     specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS CONTRIBUTORS "AS IS" AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
// WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
// DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
// SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
// CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
// OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
// OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.


// ---------------------------------------------------------------------
// This file is auto generated using tools/generate_simulator_traces.py.
//
// PLEASE DO NOT EDIT.
// ---------------------------------------------------------------------

#ifndef VIXL_SIM_URSRA_8H_2OPIMM_TRACE_AARCH64_H_
#define VIXL_SIM_URSRA_8H_2OPIMM_TRACE_AARCH64_H_

const uint16_t kExpected_NEON_ursra_8H_2OPIMM[] = {
  0x7fc1, 0x7fc1, 0x7fc2, 0x7ff8, 0x7fff, 0x7fff, 0x8000, 0x0000,
  0xbfa1, 0xbfa2, 0xbfa3, 0xbff4, 0xbffe, 0xbfff, 0xc000, 0x0000,
  0xdf91, 0xdf92, 0xdf93, 0xdff2, 0xdffe, 0xdfff, 0xe000, 0x0000,
  0xef89, 0xef8a, 0xef8b, 0xeff1, 0xeffe, 0xefff, 0xf000, 0x0000,
  0xf785, 0xf786, 0xf787, 0xf7f1, 0xf7fe, 0xf7ff, 0xf800, 0x0000,
  0xfb83, 0xfb84, 0xfb85, 0xfbf1, 0xfbfe, 0xfbff, 0xfc00, 0x0000,
  0xfd82, 0xfd83, 0xfd84, 0xfdf1, 0xfdfe, 0xfdff, 0xfe00, 0x0000,
  0xfe82, 0xfe83, 0xfe84, 0xfef1, 0xfefe, 0xfeff, 0xff00, 0x0000,
  0xff02, 0xff03, 0xff04, 0xff71, 0xff7e, 0xff7f, 0xff80, 0x0000,
  0xff42, 0xff43, 0xff44, 0xffb1, 0xffbe, 0xffbf, 0xffc0, 0x0000,
  0xff62, 0xff63, 0xff64, 0xffd1, 0xffde, 0xffdf, 0xffe0, 0x0000,
  0xff72, 0xff73, 0xff74, 0xffe1, 0xffee, 0xffef, 0xfff0, 0x0000,
  0xff7a, 0xff7b, 0xff7c, 0xffe9, 0xfff6, 0xfff7, 0xfff8, 0x0000,
  0xff7e, 0xff7f, 0xff80, 0xffed, 0xfffa, 0xfffb, 0xfffc, 0x0000,
  0xff80, 0xff81, 0xff82, 0xffef, 0xfffc, 0xfffd, 0xfffe, 0x0000,
  0xff81, 0xff82, 0xff83, 0xfff0, 0xfffd, 0xfffe, 0xffff, 0x0000,
  0x7fc1, 0x7fc2, 0x7ff8, 0x7fff, 0x7fff, 0x8000, 0x0000, 0x0001,
  0xbfa2, 0xbfa3, 0xbff4, 0xbffe, 0xbfff, 0xc000, 0x0000, 0x0001,
  0xdf92, 0xdf93, 0xdff2, 0xdffe, 0xdfff, 0xe000, 0x0000, 0x0001,
  0xef8a, 0xef8b, 0xeff1, 0xeffe, 0xefff, 0xf000, 0x0000, 0x0001,
  0xf786, 0xf787, 0xf7f1, 0xf7fe, 0xf7ff, 0xf800, 0x0000, 0x0001,
  0xfb84, 0xfb85, 0xfbf1, 0xfbfe, 0xfbff, 0xfc00, 0x0000, 0x0001,
  0xfd83, 0xfd84, 0xfdf1, 0xfdfe, 0xfdff, 0xfe00, 0x0000, 0x0001,
  0xfe83, 0xfe84, 0xfef1, 0xfefe, 0xfeff, 0xff00, 0x0000, 0x0001,
  0xff03, 0xff04, 0xff71, 0xff7e, 0xff7f, 0xff80, 0x0000, 0x0001,
  0xff43, 0xff44, 0xffb1, 0xffbe, 0xffbf, 0xffc0, 0x0000, 0x0001,
  0xff63, 0xff64, 0xffd1, 0xffde, 0xffdf, 0xffe0, 0x0000, 0x0001,
  0xff73, 0xff74, 0xffe1, 0xffee, 0xffef, 0xfff0, 0x0000, 0x0001,
  0xff7b, 0xff7c, 0xffe9, 0xfff6, 0xfff7, 0xfff8, 0x0000, 0x0001,
  0xff7f, 0xff80, 0xffed, 0xfffa, 0xfffb, 0xfffc, 0x0000, 0x0001,
  0xff81, 0xff82, 0xffef, 0xfffc, 0xfffd, 0xfffe, 0x0000, 0x0001,
  0xff82, 0xff83, 0xfff0, 0xfffd, 0xfffe, 0xffff, 0x0000, 0x0001,
  0x7fc2, 0x7ff8, 0x7fff, 0x7fff, 0x8000, 0x0000, 0x0001, 0x0001,
  0xbfa3, 0xbff4, 0xbffe, 0xbfff, 0xc000, 0x0000, 0x0001, 0x0002,
  0xdf93, 0xdff2, 0xdffe, 0xdfff, 0xe000, 0x0000, 0x0001, 0x0002,
  0xef8b, 0xeff1, 0xeffe, 0xefff, 0xf000, 0x0000, 0x0001, 0x0002,
  0xf787, 0xf7f1, 0xf7fe, 0xf7ff, 0xf800, 0x0000, 0x0001, 0x0002,
  0xfb85, 0xfbf1, 0xfbfe, 0xfbff, 0xfc00, 0x0000, 0x0001, 0x0002,
  0xfd84, 0xfdf1, 0xfdfe, 0xfdff, 0xfe00, 0x0000, 0x0001, 0x0002,
  0xfe84, 0xfef1, 0xfefe, 0xfeff, 0xff00, 0x0000, 0x0001, 0x0002,
  0xff04, 0xff71, 0xff7e, 0xff7f, 0xff80, 0x0000, 0x0001, 0x0002,
  0xff44, 0xffb1, 0xffbe, 0xffbf, 0xffc0, 0x0000, 0x0001, 0x0002,
  0xff64, 0xffd1, 0xffde, 0xffdf, 0xffe0, 0x0000, 0x0001, 0x0002,
  0xff74, 0xffe1, 0xffee, 0xffef, 0xfff0, 0x0000, 0x0001, 0x0002,
  0xff7c, 0xffe9, 0xfff6, 0xfff7, 0xfff8, 0x0000, 0x0001, 0x0002,
  0xff80, 0xffed, 0xfffa, 0xfffb, 0xfffc, 0x0000, 0x0001, 0x0002,
  0xff82, 0xffef, 0xfffc, 0xfffd, 0xfffe, 0x0000, 0x0001, 0x0002,
  0xff83, 0xfff0, 0xfffd, 0xfffe, 0xffff, 0x0000, 0x0001, 0x0002,
  0x7ff8, 0x7fff, 0x7fff, 0x8000, 0x0000, 0x0001, 0x0001, 0x0008,
  0xbff4, 0xbffe, 0xbfff, 0xc000, 0x0000, 0x0001, 0x0002, 0x000c,
  0xdff2, 0xdffe, 0xdfff, 0xe000, 0x0000, 0x0001, 0x0002, 0x000e,
  0xeff1, 0xeffe, 0xefff, 0xf000, 0x0000, 0x0001, 0x0002, 0x000f,
  0xf7f1, 0xf7fe, 0xf7ff, 0xf800, 0x0000, 0x0001, 0x0002, 0x0010,
  0xfbf1, 0xfbfe, 0xfbff, 0xfc00, 0x0000, 0x0001, 0x0002, 0x0010,
  0xfdf1, 0xfdfe, 0xfdff, 0xfe00, 0x0000, 0x0001, 0x0002, 0x0010,
  0xfef1, 0xfefe, 0xfeff, 0xff00, 0x0000, 0x0001, 0x0002, 0x0010,
  0xff71, 0xff7e, 0xff7f, 0xff80, 0x0000, 0x0001, 0x0002, 0x0010,
  0xffb1, 0xffbe, 0xffbf, 0xffc0, 0x0000, 0x0001, 0x0002, 0x0010,
  0xffd1, 0xffde, 0xffdf, 0xffe0, 0x0000, 0x0001, 0x0002, 0x0010,
  0xffe1, 0xffee, 0xffef, 0xfff0, 0x0000, 0x0001, 0x0002, 0x0010,
  0xffe9, 0xfff6, 0xfff7, 0xfff8, 0x0000, 0x0001, 0x0002, 0x0010,
  0xffed, 0xfffa, 0xfffb, 0xfffc, 0x0000, 0x0001, 0x0002, 0x0010,
  0xffef, 0xfffc, 0xfffd, 0xfffe, 0x0000, 0x0001, 0x0002, 0x0010,
  0xfff0, 0xfffd, 0xfffe, 0xffff, 0x0000, 0x0001, 0x0002, 0x0010,
  0x7fff, 0x7fff, 0x8000, 0x0000, 0x0001, 0x0001, 0x0008, 0x003f,
  0xbffe, 0xbfff, 0xc000, 0x0000, 0x0001, 0x0002, 0x000c, 0x005e,
  0xdffe, 0xdfff, 0xe000, 0x0000, 0x0001, 0x0002, 0x000e, 0x006e,
  0xeffe, 0xefff, 0xf000, 0x0000, 0x0001, 0x0002, 0x000f, 0x0076,
  0xf7fe, 0xf7ff, 0xf800, 0x0000, 0x0001, 0x0002, 0x0010, 0x007a,
  0xfbfe, 0xfbff, 0xfc00, 0x0000, 0x0001, 0x0002, 0x0010, 0x007c,
  0xfdfe, 0xfdff, 0xfe00, 0x0000, 0x0001, 0x0002, 0x0010, 0x007d,
  0xfefe, 0xfeff, 0xff00, 0x0000, 0x0001, 0x0002, 0x0010, 0x007d,
  0xff7e, 0xff7f, 0xff80, 0x0000, 0x0001, 0x0002, 0x0010, 0x007d,
  0xffbe, 0xffbf, 0xffc0, 0x0000, 0x0001, 0x0002, 0x0010, 0x007d,
  0xffde, 0xffdf, 0xffe0, 0x0000, 0x0001, 0x0002, 0x0010, 0x007d,
  0xffee, 0xffef, 0xfff0, 0x0000, 0x0001, 0x0002, 0x0010, 0x007d,
  0xfff6, 0xfff7, 0xfff8, 0x0000, 0x0001, 0x0002, 0x0010, 0x007d,
  0xfffa, 0xfffb, 0xfffc, 0x0000, 0x0001, 0x0002, 0x0010, 0x007d,
  0xfffc, 0xfffd, 0xfffe, 0x0000, 0x0001, 0x0002, 0x0010, 0x007d,
  0xfffd, 0xfffe, 0xffff, 0x0000, 0x0001, 0x0002, 0x0010, 0x007d,
  0x7fff, 0x8000, 0x0000, 0x0001, 0x0001, 0x0008, 0x003f, 0x003f,
  0xbfff, 0xc000, 0x0000, 0x0001, 0x0002, 0x000c, 0x005e, 0x005f,
  0xdfff, 0xe000, 0x0000, 0x0001, 0x0002, 0x000e, 0x006e, 0x006f,
  0xefff, 0xf000, 0x0000, 0x0001, 0x0002, 0x000f, 0x0076, 0x0077,
  0xf7ff, 0xf800, 0x0000, 0x0001, 0x0002, 0x0010, 0x007a, 0x007b,
  0xfbff, 0xfc00, 0x0000, 0x0001, 0x0002, 0x0010, 0x007c, 0x007d,
  0xfdff, 0xfe00, 0x0000, 0x0001, 0x0002, 0x0010, 0x007d, 0x007e,
  0xfeff, 0xff00, 0x0000, 0x0001, 0x0002, 0x0010, 0x007d, 0x007e,
  0xff7f, 0xff80, 0x0000, 0x0001, 0x0002, 0x0010, 0x007d, 0x007e,
  0xffbf, 0xffc0, 0x0000, 0x0001, 0x0002, 0x0010, 0x007d, 0x007e,
  0xffdf, 0xffe0, 0x0000, 0x0001, 0x0002, 0x0010, 0x007d, 0x007e,
  0xffef, 0xfff0, 0x0000, 0x0001, 0x0002, 0x0010, 0x007d, 0x007e,
  0xfff7, 0xfff8, 0x0000, 0x0001, 0x0002, 0x0010, 0x007d, 0x007e,
  0xfffb, 0xfffc, 0x0000, 0x0001, 0x0002, 0x0010, 0x007d, 0x007e,
  0xfffd, 0xfffe, 0x0000, 0x0001, 0x0002, 0x0010, 0x007d, 0x007e,
  0xfffe, 0xffff, 0x0000, 0x0001, 0x0002, 0x0010, 0x007d, 0x007e,
  0x8000, 0x0000, 0x0001, 0x0001, 0x0008, 0x003f, 0x003f, 0x0040,
  0xc000, 0x0000, 0x0001, 0x0002, 0x000c, 0x005e, 0x005f, 0x0060,
  0xe000, 0x0000, 0x0001, 0x0002, 0x000e, 0x006e, 0x006f, 0x0070,
  0xf000, 0x0000, 0x0001, 0x0002, 0x000f, 0x0076, 0x0077, 0x0078,
  0xf800, 0x0000, 0x0001, 0x0002, 0x0010, 0x007a, 0x007b, 0x007c,
  0xfc00, 0x0000, 0x0001, 0x0002, 0x0010, 0x007c, 0x007d, 0x007e,
  0xfe00, 0x0000, 0x0001, 0x0002, 0x0010, 0x007d, 0x007e, 0x007f,
  0xff00, 0x0000, 0x0001, 0x0002, 0x0010, 0x007d, 0x007e, 0x007f,
  0xff80, 0x0000, 0x0001, 0x0002, 0x0010, 0x007d, 0x007e, 0x007f,
  0xffc0, 0x0000, 0x0001, 0x0002, 0x0010, 0x007d, 0x007e, 0x007f,
  0xffe0, 0x0000, 0x0001, 0x0002, 0x0010, 0x007d, 0x007e, 0x007f,
  0xfff0, 0x0000, 0x0001, 0x0002, 0x0010, 0x007d, 0x007e, 0x007f,
  0xfff8, 0x0000, 0x0001, 0x0002, 0x0010, 0x007d, 0x007e, 0x007f,
  0xfffc, 0x0000, 0x0001, 0x0002, 0x0010, 0x007d, 0x007e, 0x007f,
  0xfffe, 0x0000, 0x0001, 0x0002, 0x0010, 0x007d, 0x007e, 0x007f,
  0xffff, 0x0000, 0x0001, 0x0002, 0x0010, 0x007d, 0x007e, 0x007f,
  0x0000, 0x0001, 0x0001, 0x0008, 0x003f, 0x003f, 0x0040, 0x199a,
  0x0000, 0x0001, 0x0002, 0x000c, 0x005e, 0x005f, 0x0060, 0x2667,
  0x0000, 0x0001, 0x0002, 0x000e, 0x006e, 0x006f, 0x0070, 0x2ccd,
  0x0000, 0x0001, 0x0002, 0x000f, 0x0076, 0x0077, 0x0078, 0x3000,
  0x0000, 0x0001, 0x0002, 0x0010, 0x007a, 0x007b, 0x007c, 0x319a,
  0x0000, 0x0001, 0x0002, 0x0010, 0x007c, 0x007d, 0x007e, 0x3267,
  0x0000, 0x0001, 0x0002, 0x0010, 0x007d, 0x007e, 0x007f, 0x32cd,
  0x0000, 0x0001, 0x0002, 0x0010, 0x007d, 0x007e, 0x007f, 0x3300,
  0x0000, 0x0001, 0x0002, 0x0010, 0x007d, 0x007e, 0x007f, 0x331a,
  0x0000, 0x0001, 0x0002, 0x0010, 0x007d, 0x007e, 0x007f, 0x3327,
  0x0000, 0x0001, 0x0002, 0x0010, 0x007d, 0x007e, 0x007f, 0x332d,
  0x0000, 0x0001, 0x0002, 0x0010, 0x007d, 0x007e, 0x007f, 0x3330,
  0x0000, 0x0001, 0x0002, 0x0010, 0x007d, 0x007e, 0x007f, 0x3332,
  0x0000, 0x0001, 0x0002, 0x0010, 0x007d, 0x007e, 0x007f, 0x3333,
  0x0000, 0x0001, 0x0002, 0x0010, 0x007d, 0x007e, 0x007f, 0x3333,
  0x0000, 0x0001, 0x0002, 0x0010, 0x007d, 0x007e, 0x007f, 0x3333,
  0x0001, 0x0001, 0x0008, 0x003f, 0x003f, 0x0040, 0x199a, 0x2aab,
  0x0001, 0x0002, 0x000c, 0x005e, 0x005f, 0x0060, 0x2667, 0x4000,
  0x0001, 0x0002, 0x000e, 0x006e, 0x006f, 0x0070, 0x2ccd, 0x4aab,
  0x0001, 0x0002, 0x000f, 0x0076, 0x0077, 0x0078, 0x3000, 0x5000,
  0x0001, 0x0002, 0x0010, 0x007a, 0x007b, 0x007c, 0x319a, 0x52ab,
  0x0001, 0x0002, 0x0010, 0x007c, 0x007d, 0x007e, 0x3267, 0x5400,
  0x0001, 0x0002, 0x0010, 0x007d, 0x007e, 0x007f, 0x32cd, 0x54ab,
  0x0001, 0x0002, 0x0010, 0x007d, 0x007e, 0x007f, 0x3300, 0x5500,
  0x0001, 0x0002, 0x0010, 0x007d, 0x007e, 0x007f, 0x331a, 0x552b,
  0x0001, 0x0002, 0x0010, 0x007d, 0x007e, 0x007f, 0x3327, 0x5540,
  0x0001, 0x0002, 0x0010, 0x007d, 0x007e, 0x007f, 0x332d, 0x554b,
  0x0001, 0x0002, 0x0010, 0x007d, 0x007e, 0x007f, 0x3330, 0x5550,
  0x0001, 0x0002, 0x0010, 0x007d, 0x007e, 0x007f, 0x3332, 0x5553,
  0x0001, 0x0002, 0x0010, 0x007d, 0x007e, 0x007f, 0x3333, 0x5554,
  0x0001, 0x0002, 0x0010, 0x007d, 0x007e, 0x007f, 0x3333, 0x5555,
  0x0001, 0x0002, 0x0010, 0x007d, 0x007e, 0x007f, 0x3333, 0x5555,
  0x0001, 0x0008, 0x003f, 0x003f, 0x0040, 0x199a, 0x2aab, 0x3fff,
  0x0002, 0x000c, 0x005e, 0x005f, 0x0060, 0x2667, 0x4000, 0x5ffe,
  0x0002, 0x000e, 0x006e, 0x006f, 0x0070, 0x2ccd, 0x4aab, 0x6ffe,
  0x0002, 0x000f, 0x0076, 0x0077, 0x0078, 0x3000, 0x5000, 0x77fe,
  0x0002, 0x0010, 0x007a, 0x007b, 0x007c, 0x319a, 0x52ab, 0x7bfe,
  0x0002, 0x0010, 0x007c, 0x007d, 0x007e, 0x3267, 0x5400, 0x7dfe,
  0x0002, 0x0010, 0x007d, 0x007e, 0x007f, 0x32cd, 0x54ab, 0x7efe,
  0x0002, 0x0010, 0x007d, 0x007e, 0x007f, 0x3300, 0x5500, 0x7f7e,
  0x0002, 0x0010, 0x007d, 0x007e, 0x007f, 0x331a, 0x552b, 0x7fbe,
  0x0002, 0x0010, 0x007d, 0x007e, 0x007f, 0x3327, 0x5540, 0x7fde,
  0x0002, 0x0010, 0x007d, 0x007e, 0x007f, 0x332d, 0x554b, 0x7fee,
  0x0002, 0x0010, 0x007d, 0x007e, 0x007f, 0x3330, 0x5550, 0x7ff6,
  0x0002, 0x0010, 0x007d, 0x007e, 0x007f, 0x3332, 0x5553, 0x7ffa,
  0x0002, 0x0010, 0x007d, 0x007e, 0x007f, 0x3333, 0x5554, 0x7ffc,
  0x0002, 0x0010, 0x007d, 0x007e, 0x007f, 0x3333, 0x5555, 0x7ffd,
  0x0002, 0x0010, 0x007d, 0x007e, 0x007f, 0x3333, 0x5555, 0x7ffd,
  0x0008, 0x003f, 0x003f, 0x0040, 0x199a, 0x2aab, 0x3fff, 0x3fff,
  0x000c, 0x005e, 0x005f, 0x0060, 0x2667, 0x4000, 0x5ffe, 0x5fff,
  0x000e, 0x006e, 0x006f, 0x0070, 0x2ccd, 0x4aab, 0x6ffe, 0x6fff,
  0x000f, 0x0076, 0x0077, 0x0078, 0x3000, 0x5000, 0x77fe, 0x77ff,
  0x0010, 0x007a, 0x007b, 0x007c, 0x319a, 0x52ab, 0x7bfe, 0x7bff,
  0x0010, 0x007c, 0x007d, 0x007e, 0x3267, 0x5400, 0x7dfe, 0x7dff,
  0x0010, 0x007d, 0x007e, 0x007f, 0x32cd, 0x54ab, 0x7efe, 0x7eff,
  0x0010, 0x007d, 0x007e, 0x007f, 0x3300, 0x5500, 0x7f7e, 0x7f7f,
  0x0010, 0x007d, 0x007e, 0x007f, 0x331a, 0x552b, 0x7fbe, 0x7fbf,
  0x0010, 0x007d, 0x007e, 0x007f, 0x3327, 0x5540, 0x7fde, 0x7fdf,
  0x0010, 0x007d, 0x007e, 0x007f, 0x332d, 0x554b, 0x7fee, 0x7fef,
  0x0010, 0x007d, 0x007e, 0x007f, 0x3330, 0x5550, 0x7ff6, 0x7ff7,
  0x0010, 0x007d, 0x007e, 0x007f, 0x3332, 0x5553, 0x7ffa, 0x7ffb,
  0x0010, 0x007d, 0x007e, 0x007f, 0x3333, 0x5554, 0x7ffc, 0x7ffd,
  0x0010, 0x007d, 0x007e, 0x007f, 0x3333, 0x5555, 0x7ffd, 0x7ffe,
  0x0010, 0x007d, 0x007e, 0x007f, 0x3333, 0x5555, 0x7ffd, 0x7ffe,
  0x003f, 0x003f, 0x0040, 0x199a, 0x2aab, 0x3fff, 0x3fff, 0x4000,
  0x005e, 0x005f, 0x0060, 0x2667, 0x4000, 0x5ffe, 0x5fff, 0x6000,
  0x006e, 0x006f, 0x0070, 0x2ccd, 0x4aab, 0x6ffe, 0x6fff, 0x7000,
  0x0076, 0x0077, 0x0078, 0x3000, 0x5000, 0x77fe, 0x77ff, 0x7800,
  0x007a, 0x007b, 0x007c, 0x319a, 0x52ab, 0x7bfe, 0x7bff, 0x7c00,
  0x007c, 0x007d, 0x007e, 0x3267, 0x5400, 0x7dfe, 0x7dff, 0x7e00,
  0x007d, 0x007e, 0x007f, 0x32cd, 0x54ab, 0x7efe, 0x7eff, 0x7f00,
  0x007d, 0x007e, 0x007f, 0x3300, 0x5500, 0x7f7e, 0x7f7f, 0x7f80,
  0x007d, 0x007e, 0x007f, 0x331a, 0x552b, 0x7fbe, 0x7fbf, 0x7fc0,
  0x007d, 0x007e, 0x007f, 0x3327, 0x5540, 0x7fde, 0x7fdf, 0x7fe0,
  0x007d, 0x007e, 0x007f, 0x332d, 0x554b, 0x7fee, 0x7fef, 0x7ff0,
  0x007d, 0x007e, 0x007f, 0x3330, 0x5550, 0x7ff6, 0x7ff7, 0x7ff8,
  0x007d, 0x007e, 0x007f, 0x3332, 0x5553, 0x7ffa, 0x7ffb, 0x7ffc,
  0x007d, 0x007e, 0x007f, 0x3333, 0x5554, 0x7ffc, 0x7ffd, 0x7ffe,
  0x007d, 0x007e, 0x007f, 0x3333, 0x5555, 0x7ffd, 0x7ffe, 0x7fff,
  0x007d, 0x007e, 0x007f, 0x3333, 0x5555, 0x7ffd, 0x7ffe, 0x7fff,
  0x003f, 0x0040, 0x199a, 0x2aab, 0x3fff, 0x3fff, 0x4000, 0x4000,
  0x005f, 0x0060, 0x2667, 0x4000, 0x5ffe, 0x5fff, 0x6000, 0x6000,
  0x006f, 0x0070, 0x2ccd, 0x4aab, 0x6ffe, 0x6fff, 0x7000, 0x7000,
  0x0077, 0x0078, 0x3000, 0x5000, 0x77fe, 0x77ff, 0x7800, 0x7800,
  0x007b, 0x007c, 0x319a, 0x52ab, 0x7bfe, 0x7bff, 0x7c00, 0x7c00,
  0x007d, 0x007e, 0x3267, 0x5400, 0x7dfe, 0x7dff, 0x7e00, 0x7e00,
  0x007e, 0x007f, 0x32cd, 0x54ab, 0x7efe, 0x7eff, 0x7f00, 0x7f00,
  0x007e, 0x007f, 0x3300, 0x5500, 0x7f7e, 0x7f7f, 0x7f80, 0x7f80,
  0x007e, 0x007f, 0x331a, 0x552b, 0x7fbe, 0x7fbf, 0x7fc0, 0x7fc0,
  0x007e, 0x007f, 0x3327, 0x5540, 0x7fde, 0x7fdf, 0x7fe0, 0x7fe0,
  0x007e, 0x007f, 0x332d, 0x554b, 0x7fee, 0x7fef, 0x7ff0, 0x7ff0,
  0x007e, 0x007f, 0x3330, 0x5550, 0x7ff6, 0x7ff7, 0x7ff8, 0x7ff8,
  0x007e, 0x007f, 0x3332, 0x5553, 0x7ffa, 0x7ffb, 0x7ffc, 0x7ffc,
  0x007e, 0x007f, 0x3333, 0x5554, 0x7ffc, 0x7ffd, 0x7ffe, 0x7ffe,
  0x007e, 0x007f, 0x3333, 0x5555, 0x7ffd, 0x7ffe, 0x7fff, 0x7fff,
  0x007e, 0x007f, 0x3333, 0x5555, 0x7ffd, 0x7ffe, 0x7fff, 0x8000,
  0x0040, 0x199a, 0x2aab, 0x3fff, 0x3fff, 0x4000, 0x4000, 0x4001,
  0x0060, 0x2667, 0x4000, 0x5ffe, 0x5fff, 0x6000, 0x6000, 0x6001,
  0x0070, 0x2ccd, 0x4aab, 0x6ffe, 0x6fff, 0x7000, 0x7000, 0x7001,
  0x0078, 0x3000, 0x5000, 0x77fe, 0x77ff, 0x7800, 0x7800, 0x7801,
  0x007c, 0x319a, 0x52ab, 0x7bfe, 0x7bff, 0x7c00, 0x7c00, 0x7c01,
  0x007e, 0x3267, 0x5400, 0x7dfe, 0x7dff, 0x7e00, 0x7e00, 0x7e01,
  0x007f, 0x32cd, 0x54ab, 0x7efe, 0x7eff, 0x7f00, 0x7f00, 0x7f01,
  0x007f, 0x3300, 0x5500, 0x7f7e, 0x7f7f, 0x7f80, 0x7f80, 0x7f81,
  0x007f, 0x331a, 0x552b, 0x7fbe, 0x7fbf, 0x7fc0, 0x7fc0, 0x7fc1,
  0x007f, 0x3327, 0x5540, 0x7fde, 0x7fdf, 0x7fe0, 0x7fe0, 0x7fe1,
  0x007f, 0x332d, 0x554b, 0x7fee, 0x7fef, 0x7ff0, 0x7ff0, 0x7ff1,
  0x007f, 0x3330, 0x5550, 0x7ff6, 0x7ff7, 0x7ff8, 0x7ff8, 0x7ff9,
  0x007f, 0x3332, 0x5553, 0x7ffa, 0x7ffb, 0x7ffc, 0x7ffc, 0x7ffd,
  0x007f, 0x3333, 0x5554, 0x7ffc, 0x7ffd, 0x7ffe, 0x7ffe, 0x7fff,
  0x007f, 0x3333, 0x5555, 0x7ffd, 0x7ffe, 0x7fff, 0x7fff, 0x8000,
  0x007f, 0x3333, 0x5555, 0x7ffd, 0x7ffe, 0x7fff, 0x8000, 0x8001,
  0x199a, 0x2aab, 0x3fff, 0x3fff, 0x4000, 0x4000, 0x4001, 0x5555,
  0x2667, 0x4000, 0x5ffe, 0x5fff, 0x6000, 0x6000, 0x6001, 0x8000,
  0x2ccd, 0x4aab, 0x6ffe, 0x6fff, 0x7000, 0x7000, 0x7001, 0x9555,
  0x3000, 0x5000, 0x77fe, 0x77ff, 0x7800, 0x7800, 0x7801, 0xa000,
  0x319a, 0x52ab, 0x7bfe, 0x7bff, 0x7c00, 0x7c00, 0x7c01, 0xa555,
  0x3267, 0x5400, 0x7dfe, 0x7dff, 0x7e00, 0x7e00, 0x7e01, 0xa800,
  0x32cd, 0x54ab, 0x7efe, 0x7eff, 0x7f00, 0x7f00, 0x7f01, 0xa955,
  0x3300, 0x5500, 0x7f7e, 0x7f7f, 0x7f80, 0x7f80, 0x7f81, 0xaa00,
  0x331a, 0x552b, 0x7fbe, 0x7fbf, 0x7fc0, 0x7fc0, 0x7fc1, 0xaa55,
  0x3327, 0x5540, 0x7fde, 0x7fdf, 0x7fe0, 0x7fe0, 0x7fe1, 0xaa80,
  0x332d, 0x554b, 0x7fee, 0x7fef, 0x7ff0, 0x7ff0, 0x7ff1, 0xaa95,
  0x3330, 0x5550, 0x7ff6, 0x7ff7, 0x7ff8, 0x7ff8, 0x7ff9, 0xaaa0,
  0x3332, 0x5553, 0x7ffa, 0x7ffb, 0x7ffc, 0x7ffc, 0x7ffd, 0xaaa5,
  0x3333, 0x5554, 0x7ffc, 0x7ffd, 0x7ffe, 0x7ffe, 0x7fff, 0xaaa8,
  0x3333, 0x5555, 0x7ffd, 0x7ffe, 0x7fff, 0x7fff, 0x8000, 0xaaa9,
  0x3333, 0x5555, 0x7ffd, 0x7ffe, 0x7fff, 0x8000, 0x8001, 0xaaaa,
  0x2aab, 0x3fff, 0x3fff, 0x4000, 0x4000, 0x4001, 0x5555, 0x6666,
  0x4000, 0x5ffe, 0x5fff, 0x6000, 0x6000, 0x6001, 0x8000, 0x9999,
  0x4aab, 0x6ffe, 0x6fff, 0x7000, 0x7000, 0x7001, 0x9555, 0xb333,
  0x5000, 0x77fe, 0x77ff, 0x7800, 0x7800, 0x7801, 0xa000, 0xc000,
  0x52ab, 0x7bfe, 0x7bff, 0x7c00, 0x7c00, 0x7c01, 0xa555, 0xc666,
  0x5400, 0x7dfe, 0x7dff, 0x7e00, 0x7e00, 0x7e01, 0xa800, 0xc999,
  0x54ab, 0x7efe, 0x7eff, 0x7f00, 0x7f00, 0x7f01, 0xa955, 0xcb33,
  0x5500, 0x7f7e, 0x7f7f, 0x7f80, 0x7f80, 0x7f81, 0xaa00, 0xcc00,
  0x552b, 0x7fbe, 0x7fbf, 0x7fc0, 0x7fc0, 0x7fc1, 0xaa55, 0xcc66,
  0x5540, 0x7fde, 0x7fdf, 0x7fe0, 0x7fe0, 0x7fe1, 0xaa80, 0xcc99,
  0x554b, 0x7fee, 0x7fef, 0x7ff0, 0x7ff0, 0x7ff1, 0xaa95, 0xccb3,
  0x5550, 0x7ff6, 0x7ff7, 0x7ff8, 0x7ff8, 0x7ff9, 0xaaa0, 0xccc0,
  0x5553, 0x7ffa, 0x7ffb, 0x7ffc, 0x7ffc, 0x7ffd, 0xaaa5, 0xccc6,
  0x5554, 0x7ffc, 0x7ffd, 0x7ffe, 0x7ffe, 0x7fff, 0xaaa8, 0xccc9,
  0x5555, 0x7ffd, 0x7ffe, 0x7fff, 0x7fff, 0x8000, 0xaaa9, 0xcccb,
  0x5555, 0x7ffd, 0x7ffe, 0x7fff, 0x8000, 0x8001, 0xaaaa, 0xcccc,
  0x3fff, 0x3fff, 0x4000, 0x4000, 0x4001, 0x5555, 0x6666, 0x7fc0,
  0x5ffe, 0x5fff, 0x6000, 0x6000, 0x6001, 0x8000, 0x9999, 0xbfa0,
  0x6ffe, 0x6fff, 0x7000, 0x7000, 0x7001, 0x9555, 0xb333, 0xdf90,
  0x77fe, 0x77ff, 0x7800, 0x7800, 0x7801, 0xa000, 0xc000, 0xef88,
  0x7bfe, 0x7bff, 0x7c00, 0x7c00, 0x7c01, 0xa555, 0xc666, 0xf784,
  0x7dfe, 0x7dff, 0x7e00, 0x7e00, 0x7e01, 0xa800, 0xc999, 0xfb82,
  0x7efe, 0x7eff, 0x7f00, 0x7f00, 0x7f01, 0xa955, 0xcb33, 0xfd81,
  0x7f7e, 0x7f7f, 0x7f80, 0x7f80, 0x7f81, 0xaa00, 0xcc00, 0xfe81,
  0x7fbe, 0x7fbf, 0x7fc0, 0x7fc0, 0x7fc1, 0xaa55, 0xcc66, 0xff01,
  0x7fde, 0x7fdf, 0x7fe0, 0x7fe0, 0x7fe1, 0xaa80, 0xcc99, 0xff41,
  0x7fee, 0x7fef, 0x7ff0, 0x7ff0, 0x7ff1, 0xaa95, 0xccb3, 0xff61,
  0x7ff6, 0x7ff7, 0x7ff8, 0x7ff8, 0x7ff9, 0xaaa0, 0xccc0, 0xff71,
  0x7ffa, 0x7ffb, 0x7ffc, 0x7ffc, 0x7ffd, 0xaaa5, 0xccc6, 0xff79,
  0x7ffc, 0x7ffd, 0x7ffe, 0x7ffe, 0x7fff, 0xaaa8, 0xccc9, 0xff7d,
  0x7ffd, 0x7ffe, 0x7fff, 0x7fff, 0x8000, 0xaaa9, 0xcccb, 0xff7f,
  0x7ffd, 0x7ffe, 0x7fff, 0x8000, 0x8001, 0xaaaa, 0xcccc, 0xff80,
  0x3fff, 0x4000, 0x4000, 0x4001, 0x5555, 0x6666, 0x7fc0, 0x7fc1,
  0x5fff, 0x6000, 0x6000, 0x6001, 0x8000, 0x9999, 0xbfa0, 0xbfa1,
  0x6fff, 0x7000, 0x7000, 0x7001, 0x9555, 0xb333, 0xdf90, 0xdf91,
  0x77ff, 0x7800, 0x7800, 0x7801, 0xa000, 0xc000, 0xef88, 0xef89,
  0x7bff, 0x7c00, 0x7c00, 0x7c01, 0xa555, 0xc666, 0xf784, 0xf785,
  0x7dff, 0x7e00, 0x7e00, 0x7e01, 0xa800, 0xc999, 0xfb82, 0xfb83,
  0x7eff, 0x7f00, 0x7f00, 0x7f01, 0xa955, 0xcb33, 0xfd81, 0xfd82,
  0x7f7f, 0x7f80, 0x7f80, 0x7f81, 0xaa00, 0xcc00, 0xfe81, 0xfe82,
  0x7fbf, 0x7fc0, 0x7fc0, 0x7fc1, 0xaa55, 0xcc66, 0xff01, 0xff02,
  0x7fdf, 0x7fe0, 0x7fe0, 0x7fe1, 0xaa80, 0xcc99, 0xff41, 0xff42,
  0x7fef, 0x7ff0, 0x7ff0, 0x7ff1, 0xaa95, 0xccb3, 0xff61, 0xff62,
  0x7ff7, 0x7ff8, 0x7ff8, 0x7ff9, 0xaaa0, 0xccc0, 0xff71, 0xff72,
  0x7ffb, 0x7ffc, 0x7ffc, 0x7ffd, 0xaaa5, 0xccc6, 0xff79, 0xff7a,
  0x7ffd, 0x7ffe, 0x7ffe, 0x7fff, 0xaaa8, 0xccc9, 0xff7d, 0xff7e,
  0x7ffe, 0x7fff, 0x7fff, 0x8000, 0xaaa9, 0xcccb, 0xff7f, 0xff80,
  0x7ffe, 0x7fff, 0x8000, 0x8001, 0xaaaa, 0xcccc, 0xff80, 0xff81,
  0x4000, 0x4000, 0x4001, 0x5555, 0x6666, 0x7fc0, 0x7fc1, 0x7fc1,
  0x6000, 0x6000, 0x6001, 0x8000, 0x9999, 0xbfa0, 0xbfa1, 0xbfa2,
  0x7000, 0x7000, 0x7001, 0x9555, 0xb333, 0xdf90, 0xdf91, 0xdf92,
  0x7800, 0x7800, 0x7801, 0xa000, 0xc000, 0xef88, 0xef89, 0xef8a,
  0x7c00, 0x7c00, 0x7c01, 0xa555, 0xc666, 0xf784, 0xf785, 0xf786,
  0x7e00, 0x7e00, 0x7e01, 0xa800, 0xc999, 0xfb82, 0xfb83, 0xfb84,
  0x7f00, 0x7f00, 0x7f01, 0xa955, 0xcb33, 0xfd81, 0xfd82, 0xfd83,
  0x7f80, 0x7f80, 0x7f81, 0xaa00, 0xcc00, 0xfe81, 0xfe82, 0xfe83,
  0x7fc0, 0x7fc0, 0x7fc1, 0xaa55, 0xcc66, 0xff01, 0xff02, 0xff03,
  0x7fe0, 0x7fe0, 0x7fe1, 0xaa80, 0xcc99, 0xff41, 0xff42, 0xff43,
  0x7ff0, 0x7ff0, 0x7ff1, 0xaa95, 0xccb3, 0xff61, 0xff62, 0xff63,
  0x7ff8, 0x7ff8, 0x7ff9, 0xaaa0, 0xccc0, 0xff71, 0xff72, 0xff73,
  0x7ffc, 0x7ffc, 0x7ffd, 0xaaa5, 0xccc6, 0xff79, 0xff7a, 0xff7b,
  0x7ffe, 0x7ffe, 0x7fff, 0xaaa8, 0xccc9, 0xff7d, 0xff7e, 0xff7f,
  0x7fff, 0x7fff, 0x8000, 0xaaa9, 0xcccb, 0xff7f, 0xff80, 0xff81,
  0x7fff, 0x8000, 0x8001, 0xaaaa, 0xcccc, 0xff80, 0xff81, 0xff82,
  0x4000, 0x4001, 0x5555, 0x6666, 0x7fc0, 0x7fc1, 0x7fc1, 0x7fc2,
  0x6000, 0x6001, 0x8000, 0x9999, 0xbfa0, 0xbfa1, 0xbfa2, 0xbfa3,
  0x7000, 0x7001, 0x9555, 0xb333, 0xdf90, 0xdf91, 0xdf92, 0xdf93,
  0x7800, 0x7801, 0xa000, 0xc000, 0xef88, 0xef89, 0xef8a, 0xef8b,
  0x7c00, 0x7c01, 0xa555, 0xc666, 0xf784, 0xf785, 0xf786, 0xf787,
  0x7e00, 0x7e01, 0xa800, 0xc999, 0xfb82, 0xfb83, 0xfb84, 0xfb85,
  0x7f00, 0x7f01, 0xa955, 0xcb33, 0xfd81, 0xfd82, 0xfd83, 0xfd84,
  0x7f80, 0x7f81, 0xaa00, 0xcc00, 0xfe81, 0xfe82, 0xfe83, 0xfe84,
  0x7fc0, 0x7fc1, 0xaa55, 0xcc66, 0xff01, 0xff02, 0xff03, 0xff04,
  0x7fe0, 0x7fe1, 0xaa80, 0xcc99, 0xff41, 0xff42, 0xff43, 0xff44,
  0x7ff0, 0x7ff1, 0xaa95, 0xccb3, 0xff61, 0xff62, 0xff63, 0xff64,
  0x7ff8, 0x7ff9, 0xaaa0, 0xccc0, 0xff71, 0xff72, 0xff73, 0xff74,
  0x7ffc, 0x7ffd, 0xaaa5, 0xccc6, 0xff79, 0xff7a, 0xff7b, 0xff7c,
  0x7ffe, 0x7fff, 0xaaa8, 0xccc9, 0xff7d, 0xff7e, 0xff7f, 0xff80,
  0x7fff, 0x8000, 0xaaa9, 0xcccb, 0xff7f, 0xff80, 0xff81, 0xff82,
  0x8000, 0x8001, 0xaaaa, 0xcccc, 0xff80, 0xff81, 0xff82, 0xff83,
  0x4001, 0x5555, 0x6666, 0x7fc0, 0x7fc1, 0x7fc1, 0x7fc2, 0x7ff8,
  0x6001, 0x8000, 0x9999, 0xbfa0, 0xbfa1, 0xbfa2, 0xbfa3, 0xbff4,
  0x7001, 0x9555, 0xb333, 0xdf90, 0xdf91, 0xdf92, 0xdf93, 0xdff2,
  0x7801, 0xa000, 0xc000, 0xef88, 0xef89, 0xef8a, 0xef8b, 0xeff1,
  0x7c01, 0xa555, 0xc666, 0xf784, 0xf785, 0xf786, 0xf787, 0xf7f1,
  0x7e01, 0xa800, 0xc999, 0xfb82, 0xfb83, 0xfb84, 0xfb85, 0xfbf1,
  0x7f01, 0xa955, 0xcb33, 0xfd81, 0xfd82, 0xfd83, 0xfd84, 0xfdf1,
  0x7f81, 0xaa00, 0xcc00, 0xfe81, 0xfe82, 0xfe83, 0xfe84, 0xfef1,
  0x7fc1, 0xaa55, 0xcc66, 0xff01, 0xff02, 0xff03, 0xff04, 0xff71,
  0x7fe1, 0xaa80, 0xcc99, 0xff41, 0xff42, 0xff43, 0xff44, 0xffb1,
  0x7ff1, 0xaa95, 0xccb3, 0xff61, 0xff62, 0xff63, 0xff64, 0xffd1,
  0x7ff9, 0xaaa0, 0xccc0, 0xff71, 0xff72, 0xff73, 0xff74, 0xffe1,
  0x7ffd, 0xaaa5, 0xccc6, 0xff79, 0xff7a, 0xff7b, 0xff7c, 0xffe9,
  0x7fff, 0xaaa8, 0xccc9, 0xff7d, 0xff7e, 0xff7f, 0xff80, 0xffed,
  0x8000, 0xaaa9, 0xcccb, 0xff7f, 0xff80, 0xff81, 0xff82, 0xffef,
  0x8001, 0xaaaa, 0xcccc, 0xff80, 0xff81, 0xff82, 0xff83, 0xfff0,
  0x5555, 0x6666, 0x7fc0, 0x7fc1, 0x7fc1, 0x7fc2, 0x7ff8, 0x7fff,
  0x8000, 0x9999, 0xbfa0, 0xbfa1, 0xbfa2, 0xbfa3, 0xbff4, 0xbffe,
  0x9555, 0xb333, 0xdf90, 0xdf91, 0xdf92, 0xdf93, 0xdff2, 0xdffe,
  0xa000, 0xc000, 0xef88, 0xef89, 0xef8a, 0xef8b, 0xeff1, 0xeffe,
  0xa555, 0xc666, 0xf784, 0xf785, 0xf786, 0xf787, 0xf7f1, 0xf7fe,
  0xa800, 0xc999, 0xfb82, 0xfb83, 0xfb84, 0xfb85, 0xfbf1, 0xfbfe,
  0xa955, 0xcb33, 0xfd81, 0xfd82, 0xfd83, 0xfd84, 0xfdf1, 0xfdfe,
  0xaa00, 0xcc00, 0xfe81, 0xfe82, 0xfe83, 0xfe84, 0xfef1, 0xfefe,
  0xaa55, 0xcc66, 0xff01, 0xff02, 0xff03, 0xff04, 0xff71, 0xff7e,
  0xaa80, 0xcc99, 0xff41, 0xff42, 0xff43, 0xff44, 0xffb1, 0xffbe,
  0xaa95, 0xccb3, 0xff61, 0xff62, 0xff63, 0xff64, 0xffd1, 0xffde,
  0xaaa0, 0xccc0, 0xff71, 0xff72, 0xff73, 0xff74, 0xffe1, 0xffee,
  0xaaa5, 0xccc6, 0xff79, 0xff7a, 0xff7b, 0xff7c, 0xffe9, 0xfff6,
  0xaaa8, 0xccc9, 0xff7d, 0xff7e, 0xff7f, 0xff80, 0xffed, 0xfffa,
  0xaaa9, 0xcccb, 0xff7f, 0xff80, 0xff81, 0xff82, 0xffef, 0xfffc,
  0xaaaa, 0xcccc, 0xff80, 0xff81, 0xff82, 0xff83, 0xfff0, 0xfffd,
  0x6666, 0x7fc0, 0x7fc1, 0x7fc1, 0x7fc2, 0x7ff8, 0x7fff, 0x7fff,
  0x9999, 0xbfa0, 0xbfa1, 0xbfa2, 0xbfa3, 0xbff4, 0xbffe, 0xbfff,
  0xb333, 0xdf90, 0xdf91, 0xdf92, 0xdf93, 0xdff2, 0xdffe, 0xdfff,
  0xc000, 0xef88, 0xef89, 0xef8a, 0xef8b, 0xeff1, 0xeffe, 0xefff,
  0xc666, 0xf784, 0xf785, 0xf786, 0xf787, 0xf7f1, 0xf7fe, 0xf7ff,
  0xc999, 0xfb82, 0xfb83, 0xfb84, 0xfb85, 0xfbf1, 0xfbfe, 0xfbff,
  0xcb33, 0xfd81, 0xfd82, 0xfd83, 0xfd84, 0xfdf1, 0xfdfe, 0xfdff,
  0xcc00, 0xfe81, 0xfe82, 0xfe83, 0xfe84, 0xfef1, 0xfefe, 0xfeff,
  0xcc66, 0xff01, 0xff02, 0xff03, 0xff04, 0xff71, 0xff7e, 0xff7f,
  0xcc99, 0xff41, 0xff42, 0xff43, 0xff44, 0xffb1, 0xffbe, 0xffbf,
  0xccb3, 0xff61, 0xff62, 0xff63, 0xff64, 0xffd1, 0xffde, 0xffdf,
  0xccc0, 0xff71, 0xff72, 0xff73, 0xff74, 0xffe1, 0xffee, 0xffef,
  0xccc6, 0xff79, 0xff7a, 0xff7b, 0xff7c, 0xffe9, 0xfff6, 0xfff7,
  0xccc9, 0xff7d, 0xff7e, 0xff7f, 0xff80, 0xffed, 0xfffa, 0xfffb,
  0xcccb, 0xff7f, 0xff80, 0xff81, 0xff82, 0xffef, 0xfffc, 0xfffd,
  0xcccc, 0xff80, 0xff81, 0xff82, 0xff83, 0xfff0, 0xfffd, 0xfffe,
  0x7fc0, 0x7fc1, 0x7fc1, 0x7fc2, 0x7ff8, 0x7fff, 0x7fff, 0x8000,
  0xbfa0, 0xbfa1, 0xbfa2, 0xbfa3, 0xbff4, 0xbffe, 0xbfff, 0xc000,
  0xdf90, 0xdf91, 0xdf92, 0xdf93, 0xdff2, 0xdffe, 0xdfff, 0xe000,
  0xef88, 0xef89, 0xef8a, 0xef8b, 0xeff1, 0xeffe, 0xefff, 0xf000,
  0xf784, 0xf785, 0xf786, 0xf787, 0xf7f1, 0xf7fe, 0xf7ff, 0xf800,
  0xfb82, 0xfb83, 0xfb84, 0xfb85, 0xfbf1, 0xfbfe, 0xfbff, 0xfc00,
  0xfd81, 0xfd82, 0xfd83, 0xfd84, 0xfdf1, 0xfdfe, 0xfdff, 0xfe00,
  0xfe81, 0xfe82, 0xfe83, 0xfe84, 0xfef1, 0xfefe, 0xfeff, 0xff00,
  0xff01, 0xff02, 0xff03, 0xff04, 0xff71, 0xff7e, 0xff7f, 0xff80,
  0xff41, 0xff42, 0xff43, 0xff44, 0xffb1, 0xffbe, 0xffbf, 0xffc0,
  0xff61, 0xff62, 0xff63, 0xff64, 0xffd1, 0xffde, 0xffdf, 0xffe0,
  0xff71, 0xff72, 0xff73, 0xff74, 0xffe1, 0xffee, 0xffef, 0xfff0,
  0xff79, 0xff7a, 0xff7b, 0xff7c, 0xffe9, 0xfff6, 0xfff7, 0xfff8,
  0xff7d, 0xff7e, 0xff7f, 0xff80, 0xffed, 0xfffa, 0xfffb, 0xfffc,
  0xff7f, 0xff80, 0xff81, 0xff82, 0xffef, 0xfffc, 0xfffd, 0xfffe,
  0xff80, 0xff81, 0xff82, 0xff83, 0xfff0, 0xfffd, 0xfffe, 0xffff,
};
const unsigned kExpectedCount_NEON_ursra_8H_2OPIMM = 384;

#endif  // VIXL_SIM_URSRA_8H_2OPIMM_TRACE_AARCH64_H_
