use ui;
use layout;
use graphics;
use core:geometry;
use core:io;

frame ImageViewer {
	layout Grid grid {
		wrapCols: 3;
		expandCol: 0;
		expandCol: 1;
		expandCol: 2;
		expandRow: 0;
		Window image { colspan: 3; minHeight: 100; minWidth: 100; }
		nextLine;
	}

	Button[] select;
	ImagePainter paint;

	init() {
		Str[] names = [
			"ui_alpha.png", "ui_alpha.bmp", "ui_alpha-16.bmp", "ui_pattern.png",
			"tree.jpg",
			"tree-24.bmp", "tree-32.bmp", "tree-16-565.bmp", "tree-16-555.bmp", "tree-8.bmp", "tree-4.bmp", "tree-1.bmp",
			"flower-ascii.ppm", "flower-raw.ppm", "tree-1.pbm"
		];

		init("Image viewer", Size(400, 500)) {}

		image.painter(paint);

		for (id, f in names) {
			ImageViewer me = this;
			Button b(f);
			b.onClick = () => me.chooseImage(f);
			select << b;
			add(b);
			grid.add(component(b));
		}

		create();
	}

	void chooseImage(Str name) {
		Url url = resUrl / name;
		print("Loading " + url.toS);
		paint.show(url.loadImage);
		image.repaint();
	}
}

class ImagePainter extends Painter {
	Bitmap? picture;

	init() {
		init();
		bgColor = Color(0.5, 0.5, 0.5);
	}

	Bool render(Size me, Graphics g) {
		if (picture) {
			Size p = picture.size;
			Float scale = min(me.w / p.w, me.h / p.h);
			if (scale < 1) {
				p = p * scale;
			}

			Point corner = me.center - p/2;
			corner.x = corner.x.int.float; // Truncate to avoid weird effects in Skia with the pattern image.
			corner.y = corner.y.int.float; // Truncate to avoid weird effects in Skia with the pattern image.
			Rect pos(corner, p);
			g.draw(picture, pos);
		}

		false;
	}

	void show(Image p) {
		picture = Bitmap(p);
	}
}

void images() {
	ImageViewer w;
	w.waitForClose;
}
