package SmilesScripts::MolecularTransformations;

use strict;
use warnings;

use Chemistry::OpenSMILES qw(
    is_double_bond
    is_single_bond
    valence
);
use List::Util qw( first );

use parent Exporter::;
our @EXPORT_OK = qw(
    canonicalise_nitro_groups
);

sub canonicalise_nitro_groups
{
    my( $moiety ) = @_;

    my @N = grep { $_->{symbol} eq 'N' &&
                   $_->{charge} &&
                   $_->{charge} == 1 &&
                   $moiety->degree( $_  ) == 3 &&
                   valence( $moiety, $_ ) == 4 } $moiety->vertices;
    for my $N (@N) {
        my @O = sort { $a->{number} <=> $b->{number} }
                grep { $_->{symbol} eq 'O' && $moiety->degree( $_ ) == 1 }
                     $moiety->neighbours( $N );
        next unless @O >= 2;
        my $ketone = first { is_double_bond( $moiety, $N, $_ ) } @O;
        my $O      = first { is_single_bond( $moiety, $N, $_ ) &&
                             $_->{charge} &&
                             $_->{charge} == -1 } @O;
        next unless $ketone && $O;

        delete $N->{charge};
        delete $O->{charge};
        $moiety->set_edge_attribute( $N, $O, 'bond', '=' );
    }
}

1;
