/* ###
 * IP: GHIDRA
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package ghidra.app.util.viewer.util;

import java.awt.Rectangle;

import ghidra.program.model.address.Address;
import ghidra.program.model.mem.MemoryBlock;

public interface AddressPixelMap {

	public void createMapping(int width);

	public Address getAddress(int pixel);

	public int getPixel(Address address);

	public MemoryBlock[] getBlocks();

	public Rectangle getBlockPosition(MemoryBlock memoryBlock);

	public void clear();

}
