# 2024-02-20 Triage Log

Relatively few PRs affecting performance, but massive improvements thanks to the
update to LLVM 18 (PR #12005), as well as the merging of two related compiler
queries (PR #120919) and other small improvements from a rollup (PR #121055).

Triage done by **@pnkfelix**.
Revision range: [74c3f5a1..5af21304](https://perf.rust-lang.org/?start=74c3f5a146860c94ff4d179fc3bfa34f879adf41&end=5af2130440c198afefbe5b8099342057cf272ef4&absolute=false&stat=instructions%3Au)

**Summary**:

| (instructions:u)                   | mean  | range           | count |
|:----------------------------------:|:-----:|:---------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.5%  | [0.5%, 0.5%]    | 1     |
| Regressions ❌ <br /> (secondary)  | 7.1%  | [0.5%, 78.5%]   | 17    |
| Improvements ✅ <br /> (primary)   | -2.4% | [-13.9%, -0.4%] | 222   |
| Improvements ✅ <br /> (secondary) | -2.0% | [-9.8%, -0.3%]  | 155   |
| All ❌✅ (primary)                 | -2.4% | [-13.9%, 0.5%]  | 223   |


3 Regressions, 1 Improvements, 6 Mixed; 1 of them in rollups
65 artifact comparisons made in total

#### Regressions

Tracking import use types for more accurate redundant import checking [#117772](https://github.com/rust-lang/rust/pull/117772) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=6f726205a1b7992537ddec96c83f2b054b03e04f&end=8b21296b5db6d5724d6b8440dcf459fa82fd88b5&stat=instructions:u)

| (instructions:u)                   | mean | range        | count |
|:----------------------------------:|:----:|:------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.4% | [0.2%, 1.0%] | 44    |
| Regressions ❌ <br /> (secondary)  | 0.7% | [0.4%, 1.1%] | 13    |
| Improvements ✅ <br /> (primary)   | -    | -            | 0     |
| Improvements ✅ <br /> (secondary) | -    | -            | 0     |
| All ❌✅ (primary)                 | 0.4% | [0.2%, 1.0%] | 44    |

* regressions are [explained by petrochenkov](https://github.com/rust-lang/rust/pull/117772#issuecomment-1951430297): This lint is newly firing against benchmark code, which means that lint reporting machinery is being exercised that was previously not being exercised.
* marked as triaged and filed rust-lang/rustc-perf#1819 to follow up with potential counter-action in benchmark tooling.

macro_rules: Preserve all metavariable spans in a global side table [#119673](https://github.com/rust-lang/rust/pull/119673) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=8a497723e311a62fccb1f0bf40e79c6519744a12&end=2bf78d12d33ae02d10010309a0d85dd04e7cff72&stat=instructions:u)

| (instructions:u)                   | mean | range        | count |
|:----------------------------------:|:----:|:------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.4% | [0.1%, 1.3%] | 26    |
| Regressions ❌ <br /> (secondary)  | 0.5% | [0.1%, 3.3%] | 12    |
| Improvements ✅ <br /> (primary)   | -    | -            | 0     |
| Improvements ✅ <br /> (secondary) | -    | -            | 0     |
| All ❌✅ (primary)                 | 0.4% | [0.1%, 1.3%] | 26    |

* Instruction count regressions flagged against serde_derive, diesel, serde, html5ever, syn
* Most of these were anticipated in the final perf runs against the try builds.
* Marking as triaged under assumption that the reviewers deemed this change to be worth the predicted cost.


Always evaluate free constants and statics, even if previous errors occurred [#121087](https://github.com/rust-lang/rust/pull/121087) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=5af2130440c198afefbe5b8099342057cf272ef4&end=cce6a6e22e715bd74455f2560a956ab920c3a914&stat=instructions:u)

| (instructions:u)                   | mean | range        | count |
|:----------------------------------:|:----:|:------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.8% | [0.4%, 2.0%] | 4     |
| Regressions ❌ <br /> (secondary)  | 1.0% | [0.3%, 5.2%] | 11    |
| Improvements ✅ <br /> (primary)   | -    | -            | 0     |
| Improvements ✅ <br /> (secondary) | -    | -            | 0     |
| All ❌✅ (primary)                 | 0.8% | [0.4%, 2.0%] | 4     |


#### Improvements

pattern_analysis: Move constructor selection logic to `PlaceInfo` [#120692](https://github.com/rust-lang/rust/pull/120692) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=0b9f6ad99482c9fc35baa5f40cebf21be4fd98b3&end=bcea3cb748040aa507f44abbd66c50725f35ea4f&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -     | -              | 0     |
| Improvements ✅ <br /> (secondary) | -1.8% | [-1.9%, -1.7%] | 6     |
| All ❌✅ (primary)                 | -     | -              | 0     |


#### Mixed

Merge `impl_polarity` and `impl_trait_ref` queries [#120919](https://github.com/rust-lang/rust/pull/120919) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=0a5b998c57a8681acc13206b5917340b053b3a30&end=d26b41711282042c4ea0c5733e7332b07cfa4933&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.6%  | [0.5%, 0.7%]   | 3     |
| Regressions ❌ <br /> (secondary)  | 1.5%  | [1.5%, 1.5%]   | 1     |
| Improvements ✅ <br /> (primary)   | -0.3% | [-0.7%, -0.2%] | 43    |
| Improvements ✅ <br /> (secondary) | -0.4% | [-0.5%, -0.2%] | 5     |
| All ❌✅ (primary)                 | -0.3% | [-0.7%, 0.7%]  | 46    |

* already marked as triaged (more wins than losses)

Update to LLVM 18 [#120055](https://github.com/rust-lang/rust/pull/120055) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=bc1b9e0e9a813d27a09708b293dc2d41c472f0d0&end=eaff1af8fdd18ee3eb05167b2836042b7d4315f6&stat=instructions:u)

| (instructions:u)                   | mean  | range           | count |
|:----------------------------------:|:-----:|:---------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -               | 0     |
| Regressions ❌ <br /> (secondary)  | 1.1%  | [0.7%, 3.5%]    | 7     |
| Improvements ✅ <br /> (primary)   | -2.4% | [-14.1%, -0.5%] | 233   |
| Improvements ✅ <br /> (secondary) | -1.6% | [-8.0%, -0.3%]  | 160   |
| All ❌✅ (primary)                 | -2.4% | [-14.1%, -0.5%] | 233   |

* already marked as triaged (more wins than losses)

Rollup of 8 pull requests [#121055](https://github.com/rust-lang/rust/pull/121055) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=37b65339c8cf1d18e331f184dbf70bbddcb1e4f7&end=7508c3e4c1349e3dd405547bc7dd8d9549e105b6&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.2%  | [0.2%, 0.2%]   | 2     |
| Regressions ❌ <br /> (secondary)  | 0.9%  | [0.8%, 0.9%]   | 2     |
| Improvements ✅ <br /> (primary)   | -0.9% | [-1.8%, -0.2%] | 9     |
| Improvements ✅ <br /> (secondary) | -0.6% | [-1.1%, -0.3%] | 21    |
| All ❌✅ (primary)                 | -0.7% | [-1.8%, 0.2%]  | 11    |

* already marked as triaged (more wins than losses)


`cargo update` [#120454](https://github.com/rust-lang/rust/pull/120454) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=7508c3e4c1349e3dd405547bc7dd8d9549e105b6&end=cc1c0990ab6f7136d1d54fd008598095b2c53c66&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | 1.4%  | [0.8%, 1.9%]   | 10    |
| Improvements ✅ <br /> (primary)   | -     | -              | 0     |
| Improvements ✅ <br /> (secondary) | -0.9% | [-3.4%, -0.2%] | 15    |
| All ❌✅ (primary)                 | -     | -              | 0     |

* already marked as triaged (improvements and regressions balanced out, and the binary size regressions were deemed due to upstream dependencies)

Store static initializers in metadata instead of the MIR of statics. [#116564](https://github.com/rust-lang/rust/pull/116564) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=4ae1e79876fcee94a56c1edf7c029a677084d7fc&end=6a4222b5119bce8c24e74dd3ad44006ce0c803e6&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | 15.9% | [0.4%, 81.2%]  | 8     |
| Improvements ✅ <br /> (primary)   | -0.4% | [-0.5%, -0.2%] | 8     |
| Improvements ✅ <br /> (secondary) | -2.5% | [-8.9%, -0.4%] | 18    |
| All ❌✅ (primary)                 | -0.4% | [-0.5%, -0.2%] | 8     |

* already marked as triaged: the benchmark stress test is now writing an 8MB constant to metadata instead of a tiny bit of MIR

Clean up potential_query_instability with FxIndexMap and UnordMap [#120931](https://github.com/rust-lang/rust/pull/120931) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=6a4222b5119bce8c24e74dd3ad44006ce0c803e6&end=fa9f77ff35b4b63ed0cef9a9642c8f881b33f14f&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | 0.2%  | [0.2%, 0.2%]   | 4     |
| Improvements ✅ <br /> (primary)   | -0.2% | [-0.2%, -0.2%] | 2     |
| Improvements ✅ <br /> (secondary) | -6.6% | [-6.6%, -6.6%] | 1     |
| All ❌✅ (primary)                 | -0.2% | [-0.2%, -0.2%] | 2     |

* regressions are solely to the secondary many-assoc-items benchmark (check full, check/debug/opt incr-full), and was anticipated.
* marking as triaged
