from unittest import mock
from routersploit.modules.exploits.routers.linksys.eseries_themoon_rce import Exploit


@mock.patch("routersploit.modules.exploits.routers.linksys.eseries_themoon_rce.shell")
def test_check_success(mocked_shell, target):
    """ Test scenario - successful check """

    route_mock = target.get_route_mock("/HNAP1/", methods=["GET"])
    route_mock.return_value = "<ModelName>E2500</ModelName>"

    route_mock = target.get_route_mock("/tmUnblock.cgi", methods=["GET", "POST"])
    route_mock.return_value = ""

    exploit = Exploit()
    exploit.target = target.host
    exploit.port = target.port

    assert exploit.check()
    assert exploit.run() is None


@mock.patch("routersploit.modules.exploits.routers.linksys.eseries_themoon_rce.shell")
def test_check_unsuccess_no_hnapi(mocked_shell, target):
    """ Test scenario - unsuccessful check (no successful /HNAPI/ response)"""

    route_mock = target.get_route_mock("/tmUnblock.cgi", methods=["GET", "POST"])
    route_mock.return_value = ""

    exploit = Exploit()
    exploit.target = target.host
    exploit.port = target.port

    assert not (exploit.check())


@mock.patch("routersploit.modules.exploits.routers.linksys.eseries_themoon_rce.shell")
def test_check_success_no_cgi(mocked_shell, target):
    """ Test scenario - unsuccessful check (no successful /tmUnblock.cgi response)"""

    route_mock = target.get_route_mock("/HNAP1/", methods=["GET"])
    route_mock.return_value = "<ModelName>E2500</ModelName>"

    exploit = Exploit()
    exploit.target = target.host
    exploit.port = target.port

    assert not (exploit.check())
