/*	toolbar.c
	Copyright (C) 2006-2007 Mark Tyler and Dmitry Groshev

	This file is part of rgbPaint.

	rgbPaint is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version.

	rgbPaint is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with rgbPaint in the file COPYING.
*/

#include <gtk/gtk.h>
#include <gdk/gdkkeysyms.h>
#include <string.h>
#include <stdlib.h>


#include "global.h"

#include "memory.h"
#include "png.h"
#include "mainwindow.h"
#include "otherwindow.h"
#include "canvas.h"
#include "mygtk.h"
#include "toolbar.h"
#include "viewer.h"


#include "graphics/xpm_paint.xpm"
#include "graphics/xbm_paint.xbm"
#include "graphics/xbm_paint_mask.xbm"

#include "graphics/xpm_flood.xpm"
#include "graphics/xbm_flood.xbm"
#include "graphics/xbm_flood_mask.xbm"

#include "graphics/xpm_select.xpm"
#include "graphics/xbm_select.xbm"
#include "graphics/xbm_select_mask.xbm"

#include "graphics/xbm_move.xbm"
#include "graphics/xbm_move_mask.xbm"

#include "graphics/xpm_brcosa.xpm"

#include "graphics/xpm_brush01.xpm"
#include "graphics/xpm_brush02.xpm"
#include "graphics/xpm_brush03.xpm"
#include "graphics/xpm_brush04.xpm"
#include "graphics/xpm_brush05.xpm"
#include "graphics/xpm_brush06.xpm"
#include "graphics/xpm_brush07.xpm"
#include "graphics/xpm_brush08.xpm"
#include "graphics/xpm_brush09.xpm"
#include "graphics/xpm_brush10.xpm"

typedef struct
{
	int id;
	char *filename;
	GtkWidget *button;
} stamp_item;

GtkWidget *icon_buttons[TOTAL_ICONS_TOOLS];
GdkCursor *move_cursor;
GdkCursor *m_cursor[32];		// My mouse cursors

char *svg_dir;				// Location of SVG icons

static GtkWidget *toolbar_zoom_main = NULL;
static GList *stamp_list = NULL;


static GtkWidget *toolbar_add_zoom()		// Add zoom combo box
{
	int i;
	char *txt[] = { "10%", "20%", "25%", "33%", "50%", "100%", "200%", "300%",
		"400%", "800%", "1200%", "1600%", "2000%", NULL };
	GtkWidget *combo, *combo_entry;
	GList *combo_list = NULL;


	combo = gtk_combo_new ();
	gtk_combo_set_value_in_list (GTK_COMBO (combo), FALSE, FALSE);
	gtk_widget_show (combo);
//	gtk_box_pack_start (GTK_BOX (box), combo, FALSE, FALSE, 0);
	combo_entry = GTK_COMBO (combo)->entry;
	GTK_WIDGET_UNSET_FLAGS (combo_entry, GTK_CAN_FOCUS);
	gtk_widget_set_usize(GTK_COMBO(combo)->button, 18, -1);


	gtk_entry_set_width_chars( GTK_ENTRY(combo_entry), 6);

	gtk_entry_set_editable( GTK_ENTRY(combo_entry), FALSE );

	for ( i=0; txt[i]; i++ ) combo_list = g_list_append( combo_list, txt[i] );

	gtk_combo_set_popdown_strings( GTK_COMBO(combo), combo_list );
	g_list_free( combo_list );
	gtk_entry_set_text( GTK_ENTRY(combo_entry), "100%" );

	return combo;
}

static float toolbar_get_zoom( GtkWidget *combo )
{
	int i = 0;
	float res = 0;
	char *txt = (char *) gtk_entry_get_text( GTK_ENTRY(GTK_COMBO (combo)->entry) );

	if ( strlen(txt) > 2)		// Weed out bogus calls
	{
		sscanf(txt, "%i%%", &i);
		res = ((float) i ) / 100;
		if ( res<1 )
		{
			res = mt_round( 1/res );
			res = 1/res;
		}
	}

	return res;
}

void toolbar_zoom_update()			// Update the zoom combos to reflect current zoom
{
	char txt[32];

	if ( toolbar_zoom_main == NULL ) return;

	snprintf( txt, 30, "%i%%", (int)(can_zoom*100) );
	gtk_entry_set_text( GTK_ENTRY(GTK_COMBO(toolbar_zoom_main)->entry), txt );
}

static void toolbar_zoom_main_change()
{
	float new = toolbar_get_zoom( toolbar_zoom_main );

	if ( new > 0 ) align_size( new );
}

typedef struct
{
	int ID, radio, sep, rclick, actmap;
	char *tooltip, **xpm, *stock, *svg;
	guint key1;
	GdkModifierType key1_mod;
	guint key2;
	GdkModifierType key2_mod;
	GtkWidget *widget;
} toolbar_item;


static GtkWidget *toolbar_select_tool, *toolbar_paint_tool;


static void toolbar_click_tool(GtkWidget *w)
{
	if (w) gtk_toggle_button_set_active( GTK_TOGGLE_BUTTON(w), TRUE );
}

void toolbar_select_select_tool()
{
	toolbar_click_tool(toolbar_select_tool);
}

void toolbar_select_paint_tool()
{
	toolbar_click_tool(toolbar_paint_tool);
}


static void fill_toolbar(GtkToolbar *bar, toolbar_item *items,
	GtkSignalFunc lclick, int lbase, int rbase, GdkColor *c)
{
	char txt[256];
	int i, icon_size = gdk_screen_width() / 22;
	GtkWidget *iconw, *radio[32];
	GdkPixmap *icon, *mask;
	GtkAccelGroup *ag = gtk_accel_group_new();

	memset(radio, 0, sizeof(radio));
	i=0;
	for (; items->xpm; items++)
	{
		i++;
		if ( !svg_dir && items->stock )
		{
			items->widget = gtk_toolbar_insert_stock( bar, items->stock,
				_(items->tooltip), "Private", lclick,
				(gpointer)(items->ID + lbase), i);
		}
		else
		{
			GdkPixbuf *pbuf = NULL;
			GtkWidget *image;

			if ( svg_dir )
			{
				snprintf(txt, 250, "%s%c%s", svg_dir, DIR_SEP, items->svg);
//				pbuf = gdk_pixbuf_new_from_file( txt, NULL );
				pbuf = gdk_pixbuf_new_from_file_at_size( txt, icon_size, icon_size, NULL );
			}

			if ( pbuf )
			{
				iconw = NULL;
			}
			else
			{
				icon = gdk_pixmap_create_from_xpm_d(main_window->window, &mask,
					NULL, items->xpm);
				iconw = gtk_pixmap_new(icon, mask);
				gdk_pixmap_unref(icon);
				gdk_pixmap_unref(mask);
			}

			items->widget = gtk_toolbar_append_element(bar,
				items->radio < 0 ? GTK_TOOLBAR_CHILD_BUTTON :
				items->radio ? GTK_TOOLBAR_CHILD_RADIOBUTTON :
				GTK_TOOLBAR_CHILD_TOGGLEBUTTON,
				items->radio > 0 ? radio[items->radio] : NULL,
				"None", _(items->tooltip), "Private", iconw, lclick,
				(gpointer)(items->ID + lbase));

			if ( pbuf )
			{
				image = gtk_image_new_from_pixbuf(pbuf);
				gtk_button_set_image( GTK_BUTTON(items->widget), image );

				g_object_unref(pbuf);			// Release original pixbuf
			}
		}
		if ( items->key1 )
		{
			gtk_widget_add_accelerator( items->widget, "clicked", ag,
				items->key1, items->key1_mod, (GtkAccelFlags)0);
		}
		if ( items->key2 )
		{
			gtk_widget_add_accelerator( items->widget, "clicked", ag,
				items->key2, items->key2_mod, (GtkAccelFlags)0);
		}

		if (items->radio > 0) radio[items->radio] = items->widget;
		if (items->sep)
		{
			gtk_toolbar_append_space(bar);
			i++;
		}

		if (items->ID == TTB_SELECT ) toolbar_select_tool = items->widget;
		if (items->ID == TTB_PAINT ) toolbar_paint_tool = items->widget;
	}
	toolbar_zoom_main = toolbar_add_zoom();
	gtk_widget_modify_bg (GTK_COMBO(toolbar_zoom_main)->button, GTK_STATE_NORMAL, c);
	gtk_toolbar_append_widget( bar, toolbar_zoom_main, NULL, NULL );
	gtk_signal_connect_object (GTK_OBJECT (GTK_COMBO (toolbar_zoom_main)->entry), "changed",
		GTK_SIGNAL_FUNC (toolbar_zoom_main_change), NULL);

	gtk_window_add_accel_group(GTK_WINDOW(main_window), ag);
}

#define NEED_UNDO  0x0001
#define NEED_REDO  0x0002
#define NEED_CROP  0x0004
#define NEED_MARQ  0x0008
#define NEED_SEL   0x0010
#define NEED_CLIP  0x0020

static GtkWidget **need_lists[] = {
	menu_undo, menu_redo, menu_crop, menu_need_marquee,
	menu_need_selection, menu_need_clipboard };

static void tool_dis_add(toolbar_item *items)
{
	int i, j;

	for (; items->xpm; items++)
	{
		if (!items->actmap) continue;
		i = items->actmap;
		while (i)
		{
			j = i; i &= i - 1; j = (j ^ i) - 1;
			j = (j & 0x55555555) + ((j >> 1) & 0x55555555);
			j = (j & 0x33333333) + ((j >> 2) & 0x33333333);
			j = (j & 0x0F0F0F0F) + ((j >> 4) & 0x0F0F0F0F);
			j = (j & 0x00FF00FF) + ((j >> 8) & 0x00FF00FF);
			j = (j & 0xFFFF) + (j >> 16);
			men_dis_add(items->widget, need_lists[j]);
		}
	}
}

#undef _
#define _(X) X
static toolbar_item main_bar[] = {
	{ MTB_NEW, -1, 0, 0, 0, _("New Image"), xpm_paint_xpm, GTK_STOCK_NEW, "stock-new.svg", GDK_n, GDK_CONTROL_MASK, GDK_N, GDK_CONTROL_MASK },
	{ MTB_OPEN, -1, 0, 0, 0, _("Load Image File"), xpm_paint_xpm, GTK_STOCK_OPEN, "stock-open.svg", GDK_o, GDK_CONTROL_MASK, GDK_O, GDK_CONTROL_MASK },
	{ MTB_SAVE, -1, 0, 0, 0, _("Save Image File"), xpm_paint_xpm, GTK_STOCK_SAVE, "stock-save.svg", GDK_s, GDK_CONTROL_MASK, GDK_S, GDK_CONTROL_MASK },
	{ MTB_SAVE_AS, -1, 0, 0, 0, _("Save Image File As"), xpm_paint_xpm, GTK_STOCK_SAVE_AS, "stock-saveas.svg", GDK_s, GDK_CONTROL_MASK | GDK_SHIFT_MASK, GDK_S, GDK_CONTROL_MASK | GDK_SHIFT_MASK },
	{ MTB_CUT, -1, 0, 0, NEED_SEL, _("Cut"), xpm_paint_xpm, GTK_STOCK_CUT, "stock-cut.svg", GDK_x, GDK_CONTROL_MASK, GDK_X, GDK_CONTROL_MASK },
	{ MTB_COPY, -1, 0, 0, NEED_SEL, _("Copy"), xpm_paint_xpm, GTK_STOCK_COPY, "stock-copy.svg", GDK_c, GDK_CONTROL_MASK, GDK_C, GDK_CONTROL_MASK },
	{ MTB_PASTE, -1, 0, 0, NEED_CLIP, _("Paste"), xpm_paint_xpm, GTK_STOCK_PASTE, "stock-paste.svg", GDK_p, GDK_CONTROL_MASK, GDK_P, GDK_CONTROL_MASK },
	{ MTB_UNDO, -1, 0, 0, NEED_UNDO, _("Undo"), xpm_paint_xpm, GTK_STOCK_UNDO, "stock-undo.svg", GDK_z, GDK_CONTROL_MASK, GDK_Z, GDK_CONTROL_MASK },
	{ MTB_REDO, -1, 0, 0, NEED_REDO, _("Redo"), xpm_paint_xpm, GTK_STOCK_REDO, "stock-redo.svg", GDK_y, GDK_CONTROL_MASK, GDK_Y, GDK_CONTROL_MASK },
	{ TTB_TEXT, -1, 0, 0, 0, _("Paste Text"), xpm_paint_xpm, GTK_STOCK_SELECT_FONT, "stock-text.svg", GDK_t, 0, GDK_T, 0 },
	{ TTB_PAINT, 1, 0, 0, 0, _("Paint"), xpm_paint_xpm, NULL, "stock-paint.svg", GDK_p, 0, GDK_P, 0 },
	{ TTB_FLOOD, 1, 0, 0, 0, _("Flood Fill"), xpm_flood_xpm, NULL, "stock-fill.svg", GDK_f, 0, GDK_F, 0 },
	{ TTB_SELECT, 1, 0, 0, 0, _("Make Selection"), xpm_select_xpm, NULL, "stock-select.svg", GDK_s, 0, GDK_S, 0 },
	{ MTB_BRCOSA, -1, 0, 0, 0, _("Transform Colour"), xpm_brcosa_xpm, NULL, "stock-sun.svg" },
	{ MTB_PAN, -1, 0, 0, 0, _("Pan Window"), xpm_paint_xpm, GTK_STOCK_ZOOM_FIT, "stock-zoom.svg" },
	{ 0, 0, 0, 0, 0, NULL, NULL, NULL }};
#undef _
#define _(X) __(X)

void toolbar_init(GtkWidget *vbox_main)
{
	int i;
	GdkColor c;
	GtkStyle *style = gtk_widget_get_style(vbox_main);
	GdkPixmap *icon, *mask;
	GtkWidget *toolbar_main, /**toolbar_tools,*/ *hbox;
	GdkColor cfg = { -1, -1, -1, -1 }, cbg = { 0, 0, 0, 0 };

	static char *xbm_list[3] = { xbm_paint_bits, xbm_select_bits, xbm_flood_bits },
	*xbm_mask_list[3] = { xbm_paint_mask_bits, xbm_select_mask_bits, xbm_flood_mask_bits };
	static unsigned char cursor_tip[3][3] = { {1, 19}, {10, 10}, {2, 18} };

///	MAIN TOOLBAR

	hbox = gtk_hbox_new (FALSE, 0);
	gtk_widget_show (hbox);
	gtk_box_pack_start ( GTK_BOX (vbox_main), hbox, FALSE, FALSE, 0 );


	toolbar_main = gtk_toolbar_new();
	gtk_toolbar_set_style( GTK_TOOLBAR(toolbar_main), GTK_TOOLBAR_ICONS );
	gtk_box_pack_start ( GTK_BOX (hbox), toolbar_main, TRUE, TRUE, 0 );

//	c.red   = 64 * 255;
//	c.green = 64 * 255;
//	c.blue  = 64 * 255;
//	c.pixel = 0;
	c = style->bg[GTK_STATE_NORMAL];
//	gtk_widget_modify_bg (toolbar_main, GTK_STATE_NORMAL, &c);
			// Ensures icons are clear

//	toolbar_zoom_main = toolbar_add_zoom( hbox );
//	gtk_signal_connect_object (GTK_OBJECT (GTK_COMBO (toolbar_zoom_main)->entry), "changed",
//		GTK_SIGNAL_FUNC (toolbar_zoom_main_change), NULL);

	for (i=0; i<3; i++)
	{
		icon = gdk_bitmap_create_from_data (NULL, xbm_list[i], 20, 20);
		mask = gdk_bitmap_create_from_data (NULL, xbm_mask_list[i], 20, 20);

		m_cursor[i] = gdk_cursor_new_from_pixmap(icon, mask, &cfg, &cbg,
			cursor_tip[i][0], cursor_tip[i][1]);

		gdk_pixmap_unref( icon );
		gdk_pixmap_unref( mask );
	}
	icon = gdk_bitmap_create_from_data (NULL, xbm_move_bits, 20, 20);
	mask = gdk_bitmap_create_from_data (NULL, xbm_move_mask_bits, 20, 20);
	move_cursor = gdk_cursor_new_from_pixmap (icon, mask, &cfg, &cbg, 10, 10);
	gdk_pixmap_unref( icon );
	gdk_pixmap_unref( mask );

	fill_toolbar(GTK_TOOLBAR(toolbar_main), main_bar,
		GTK_SIGNAL_FUNC(toolbar_icon_event2), 0, 0, &c);
	tool_dis_add(main_bar);

	gtk_widget_show ( toolbar_main );
}


static GtkWidget *palette_buttons[TOTAL_PALETTE_BUTTONS], *palette_swatch,
		*brush_buttons[TOTAL_BRUSH_BUTTONS];


static gint toolbar_click_brush(GtkWidget *w,  GdkEvent *event, gpointer user)
{
	int i, item = (int) user, brush_list[TOTAL_BRUSH_BUTTONS][3] = {
		{TOOL_CIRCLE, 25, 0},
		{TOOL_CIRCLE, 15, 0},
		{TOOL_CIRCLE, 5, 0},
		{TOOL_SPRAY, 25, 25},
		{TOOL_SPRAY, 15, 15},
		{TOOL_SQUARE, 25, 25},
		{TOOL_SQUARE, 15, 15},
		{TOOL_SQUARE, 5, 5},
		{TOOL_SQUARE, 1, 1},
		{TOOL_SPRAY, 7, 7}
		};

	if (item>TOTAL_BRUSH_BUTTONS || item<0) return FALSE;	// Bogus

	tool_type = brush_list[item][0];
	brush_type = tool_type;
	tool_size = brush_list[item][1];
	tool_flow = brush_list[item][2];

	toolbar_select_paint_tool();		// Select paint tool on top toolbar

	for ( i=0; i<TOTAL_BRUSH_BUTTONS ; i++ )
	{
		if ( i!=item )			// Unselect all other brushes
			gtk_toggle_button_set_active(
				GTK_TOGGLE_BUTTON(brush_buttons[i]), FALSE);
	}
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(brush_buttons[item]), TRUE);

	return TRUE;
}

static gint toolbar_click_colours(GtkWidget *w,  GdkEvent *event, gpointer user)
{
	int item = (int) user;

	if ( item<0 || item>=TOTAL_PALETTE_BUTTONS ) item=0;

	mem_col_A = item;
	mem_col_A24 = mem_pal[mem_col_A];
	mem_col_B = item;
	mem_col_B24 = mem_pal[mem_col_B];
	init_pal();
	toolbar_palette_refresh();

	return FALSE;
}

void toolbar_palette_refresh()
{
	GdkColor c;
	int i;

	c.pixel = 0;
	for ( i=0; i<TOTAL_PALETTE_BUTTONS; i++ )
	{
		c.red   = mem_pal[i].red * 255;
		c.green = mem_pal[i].green * 255;
		c.blue  = mem_pal[i].blue * 255;

		gtk_widget_modify_bg (palette_buttons[i], GTK_STATE_NORMAL, &c);
		gtk_widget_modify_bg (palette_buttons[i], GTK_STATE_ACTIVE, &c);
		gtk_widget_modify_bg (palette_buttons[i], GTK_STATE_PRELIGHT, &c);
	}
	c.red   = mem_col_A24.red * 255;
	c.green = mem_col_A24.green * 255;
	c.blue  = mem_col_A24.blue * 255;
	gtk_widget_modify_bg (palette_swatch, GTK_STATE_NORMAL, &c);
	gtk_widget_modify_bg (palette_swatch, GTK_STATE_ACTIVE, &c);
	gtk_widget_modify_bg (palette_swatch, GTK_STATE_PRELIGHT, &c);
}

void toolbar_palette_init(GtkWidget *box)		// Set up the palette area
{
	char **brushes[] = {
			xpm_brush01_xpm, xpm_brush02_xpm, xpm_brush03_xpm, xpm_brush04_xpm,
			xpm_brush05_xpm, xpm_brush06_xpm, xpm_brush07_xpm, xpm_brush08_xpm,
			xpm_brush09_xpm, xpm_brush10_xpm
			};
	int i, j, k;
	GtkWidget *vbox, *table, *button, *pixmapw, *hbox;
	GdkPixmap *pixmap, *mask;
//	GdkColor c;


	vbox = gtk_vbox_new (FALSE, 0);
	gtk_widget_show (vbox);
	gtk_box_pack_start (GTK_BOX (box), vbox, FALSE, TRUE, 0);

	table = add_a_table(6, 2, 0, vbox);

	k=0;
	for ( i=0; i<TOTAL_BRUSH_COLUMNS; i++ )
	{
		for ( j=0; j<TOTAL_BRUSH_ROWS; j++ )
		{
			button = gtk_toggle_button_new();
//			button = gtk_button_new();
			brush_buttons[k] = button;
			gtk_toggle_button_set_active( GTK_TOGGLE_BUTTON(button), FALSE);
			GTK_WIDGET_UNSET_FLAGS (button, GTK_CAN_FOCUS);	// Stops distracting square
			gtk_widget_set_usize(button, 36, 36);

/*			c.red   = 211 * 255;
			c.green = 211 * 255;
			c.blue  = 221 * 255;
			c.pixel = 0;
			gtk_widget_modify_bg (button, GTK_STATE_NORMAL, &c);*/
					// Ensures icons are clear


			hbox = gtk_hbox_new (FALSE, 0);
			gtk_widget_show(hbox);
			gtk_container_add (GTK_CONTAINER (button), hbox);
			pixmap = gdk_pixmap_create_from_xpm_d (main_window->window, &mask,
					NULL, brushes[k]);
			pixmapw = gtk_pixmap_new (pixmap, mask);
			gtk_widget_show(pixmapw);
			gdk_pixmap_unref(pixmap);
			gdk_pixmap_unref(mask);
			gtk_box_pack_start (GTK_BOX (hbox), pixmapw, TRUE, TRUE, 0);

			gtk_signal_connect( GTK_OBJECT(button), "button_press_event",
				GTK_SIGNAL_FUNC (toolbar_click_brush), (gpointer)k );

			gtk_widget_show (button);
			gtk_table_attach (GTK_TABLE (table), button, i, i+1, j, j+1,
				(GtkAttachOptions) (GTK_FILL),
				(GtkAttachOptions) (0), 0, 0);

			k++;
		}
	}
	gtk_toggle_button_set_active( GTK_TOGGLE_BUTTON(brush_buttons[DEFAULT_BRUSH]), TRUE);

	button = gtk_button_new();
	GTK_WIDGET_UNSET_FLAGS (button, GTK_CAN_FOCUS);	// Stops distracting square
	gtk_container_set_border_width(GTK_CONTAINER(button), 2);
	gtk_widget_set_usize(button, -2, 40);
	gtk_widget_show(button);
	gtk_box_pack_start (GTK_BOX (vbox), button, FALSE, FALSE, 0);
	palette_swatch = button;
	gtk_signal_connect( GTK_OBJECT(button), "clicked",
			GTK_SIGNAL_FUNC (pressed_allcol), NULL );


	table = gtk_table_new(TOTAL_PALETTE_ROWS, TOTAL_PALETTE_COLUMNS, TRUE);
	gtk_widget_set_usize(table, -2, 200);
	gtk_widget_show(table);
	gtk_box_pack_start(GTK_BOX(vbox), table, TRUE, TRUE, 0);
	gtk_container_set_border_width (GTK_CONTAINER (table), 0);

	k=0;
	for ( i=0; i<TOTAL_PALETTE_COLUMNS; i++ )
	{
		for ( j=0; j<TOTAL_PALETTE_ROWS; j++ )
		{
			button = gtk_button_new();
			GTK_WIDGET_UNSET_FLAGS (button, GTK_CAN_FOCUS);	// Stops distracting square
			palette_buttons[k] = button;

			gtk_signal_connect( GTK_OBJECT(button), "button_press_event",
				GTK_SIGNAL_FUNC (toolbar_click_colours), (gpointer)k );

			gtk_widget_show (button);
			gtk_table_attach (GTK_TABLE (table), button, i, i+1, j, j+1,
				(GtkAttachOptions) (GTK_FILL | GTK_EXPAND | GTK_SHRINK),
				(GtkAttachOptions) (GTK_FILL | GTK_EXPAND | GTK_SHRINK), 0, 0);

			k++;
		}
	}
	toolbar_palette_refresh();
}



static stamp_item *find_stamp_data(int id)	// Find stamp in list using id
{
	int i;
	GList *lst;
	stamp_item *sitem = NULL;

	lst = g_list_first( stamp_list );
	for ( i=0; lst; i++ )		// Find this item in the list
	{
		sitem = (stamp_item *) (lst->data);
		if ( sitem->id == id )		// Item found!!
		{
//printf("filename = %s\n", sitem->filename);
			break;
		}
		lst = g_list_next(lst);
	}

	return sitem;
}


static gint expose_stamp( GtkWidget *widget, GdkEventExpose *event, gpointer user )
{		// Use this expose event to load and put an image onto the button - only done once
	GdkPixbuf *pbuf;
	GtkWidget *image;
	int id = (int) user, px, py, pw, ph;
	stamp_item *sitem = NULL;

	px = event->area.x;		// Only repaint if we need to
	py = event->area.y;
	pw = event->area.width;
	ph = event->area.height;

	g_signal_handlers_disconnect_by_func( widget, GTK_SIGNAL_FUNC(expose_stamp), (gpointer) id );
		// Now we have created the image, we don't need to call this again

	sitem = find_stamp_data(id);
	if (sitem)
	{
		pbuf = gdk_pixbuf_new_from_file_at_scale( sitem->filename, thumb_size,
				thumb_size, TRUE, NULL );
		if ( pbuf )
		{
			image = gtk_image_new_from_pixbuf(pbuf);
			gtk_button_set_image( GTK_BUTTON(sitem->button), image );
			g_object_unref(pbuf);			// Release original pixbuf
		}
	}

	return FALSE;
}

static gint pressed_stamp(GtkWidget *w, gpointer user)
{
	int id = (int) user;
	stamp_item *sitem = NULL;

//printf("Stamp pressed = %i\n", id);
	sitem = find_stamp_data(id);
	if (sitem)
	{
		pressed_select_none(NULL, NULL);		// If pasting, lose it
		if ( load_clipboard(sitem->filename) );		// Load image into clipboard
		{
			pressed_paste_centre( NULL, NULL );	// Paste to centre of image
		}
	}

	return FALSE;
}

int toolbar_stamp_init(GtkWidget *box)
{
	GtkWidget *button;
	int i, done = 0, w, h;
	stamp_item *nstamp;
	GdkPixbufFormat *file_info;

	for (i=stamp_start; i<global_argc; i++)		// Add a button for each valid image file passed
	{
		file_info = gdk_pixbuf_get_file_info( global_argv[i], &w, &h);
			// Check to see if this file is an image
		if ( !file_info ) continue;

		nstamp = malloc( sizeof(stamp_item) );
		if ( !nstamp ) continue;

		button = gtk_button_new();

		gtk_signal_connect( GTK_OBJECT(button), "clicked",
			GTK_SIGNAL_FUNC (pressed_stamp), (gpointer) i );
		gtk_signal_connect( GTK_OBJECT(button), "expose_event",
			GTK_SIGNAL_FUNC (expose_stamp), (gpointer) i );

		gtk_widget_set_usize( button, thumb_size+10, thumb_size+10 );
		gtk_box_pack_start (GTK_BOX (box), button, FALSE, FALSE, 0);

		nstamp->id = i;
		nstamp->filename = global_argv[i];
		nstamp->button = button;

		stamp_list = g_list_append( stamp_list, (gpointer) nstamp );
				// Add item to the list

//printf("arg[%i] = %s\n", i, global_argv[i]);
		done++;
	}
//printf("STAMPS = %i\n", done);

	return done;
}
