% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assay5.R
\name{merge.StdAssay}
\alias{merge.StdAssay}
\title{Merge Assays}
\usage{
\method{merge}{StdAssay}(x, y, labels = NULL, add.cell.ids = NULL, collapse = FALSE, ...)
}
\arguments{
\item{x}{An \code{\link{Assay5}} object}

\item{y}{One or more \code{\link{Assay5}} objects}

\item{labels}{A character vector equal to the number of objects; defaults to
\code{as.character(seq_along(c(x, y)))}}

\item{add.cell.ids}{A character vector equal to the number of objects
provided to append to all cell names; if \code{TRUE}, uses \code{labels} as
\code{add.cell.ids}}

\item{collapse}{If \code{TRUE}, merge layers of the same name together; if
\code{FALSE}, appends \code{labels} to the layer name}

\item{...}{Ignored}
}
\value{
A new v5 assay with data merged from \code{c(x, y)}
}
\description{
Merge one or more v5 assays together
}
\details{
\strong{Note}: collapsing layers is currently not supported
}
\note{
All assays must be of the same type; merging different v5 assays (eg.
\code{\link{Assay5}} and \code{\link{Assay5T}}) is currently unsupported
}
\keyword{internal}
