% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/328-extractDrugIPMolecularLearning.R
\name{extractDrugIPMolecularLearning}
\alias{extractDrugIPMolecularLearning}
\title{Calculate the Descriptor that Evaluates the Ionization Potential}
\usage{
extractDrugIPMolecularLearning(molecules, silent = TRUE)
}
\arguments{
\item{molecules}{Parsed molucule object.}

\item{silent}{Logical. Whether the calculating process
should be shown or not, default is \code{TRUE}.}
}
\value{
A data frame, each row represents one of the molecules,
each column represents one feature.
This function returns one column named \code{MolIP}.
}
\description{
Calculate the Descriptor that Evaluates the Ionization Potential
}
\details{
Calculate the ionization potential of a molecule.
The descriptor assumes that explicit hydrogens have been added to the molecules.
}
\examples{
smi = system.file('vignettedata/FDAMDD.smi', package = 'Rcpi')
\donttest{
mol = readMolFromSmi(smi, type = 'mol')
dat = extractDrugIPMolecularLearning(mol)
head(dat)}
}
