% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_mofa.R
\name{create_mofa_from_SingleCellExperiment}
\alias{create_mofa_from_SingleCellExperiment}
\title{create a MOFA object from a SingleCellExperiment object}
\usage{
create_mofa_from_SingleCellExperiment(
  sce,
  groups = NULL,
  assay = "logcounts",
  extract_metadata = FALSE
)
}
\arguments{
\item{sce}{SingleCellExperiment object}

\item{groups}{a string specifying column name of the colData to use it as a group variable. 
Alternatively, a character vector with group assignment for every sample.
Default is \code{NULL} (no group structure).}

\item{assay}{assay to use, default is \code{logcounts}.}

\item{extract_metadata}{logical indicating whether to incorporate the metadata from the SingleCellExperiment object into the MOFA object}
}
\value{
Returns an untrained \code{\link{MOFA}} object
}
\description{
Method to create a \code{\link{MOFA}} object from a SingleCellExperiment object
}
