/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.spi;

import java.io.Serializable;
import org.neo4j.cypher.internal.planner.spi.EventuallyConsistent$;
import org.neo4j.cypher.internal.planner.spi.IndexDescriptor;
import org.neo4j.cypher.internal.planner.spi.SkipAndLimit$;
import org.neo4j.cypher.internal.planner.spi.SlowContains$;
import org.neo4j.cypher.internal.runtime.interpreted.TransactionBoundReadTokenContext;
import org.neo4j.cypher.internal.util.LabelId;
import org.neo4j.cypher.internal.util.RelTypeId;
import org.neo4j.internal.kernel.api.exceptions.LabelNotFoundKernelException;
import org.neo4j.internal.schema.IndexBehaviour;
import org.neo4j.internal.schema.IndexType;
import org.neo4j.internal.schema.LabelSchemaDescriptor;
import org.neo4j.internal.schema.RelationTypeSchemaDescriptor;
import org.neo4j.internal.schema.SchemaDescriptor;
import org.neo4j.internal.schema.SchemaDescriptors;
import org.neo4j.kernel.api.exceptions.PropertyKeyNotFoundException;
import org.neo4j.kernel.api.exceptions.RelationshipTypeNotFoundException;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.util.control.Exception$;

@ScalaSignature(bytes="\u0006\u0001\u0005%aa\u0002\u0005\n!\u0003\r\t\u0001\u0006\u0005\u00067\u0001!\t\u0001\b\u0005\u0006A\u0001!\t!\t\u0005\u0006A\u0001!\t!\r\u0005\u0006\u0001\u0002!\t!\u0011\u0005\u0006\u0015\u0002!\ta\u0013\u0005\u0006%\u0002!\ta\u0015\u0005\u0006u\u0002!\ta\u001f\u0002\u001d\u0013:$W\r\u001f#fg\u000e\u0014\u0018\u000e\u001d;pe\u000e{W\u000e]1uS\nLG.\u001b;z\u0015\tQ1\"A\u0002ta&T!\u0001D\u0007\u0002\u0011%tG/\u001a:oC2T!AD\b\u0002\r\rL\b\u000f[3s\u0015\t\u0001\u0012#A\u0003oK>$$NC\u0001\u0013\u0003\ry'oZ\u0002\u0001'\t\u0001Q\u0003\u0005\u0002\u001735\tqCC\u0001\u0019\u0003\u0015\u00198-\u00197b\u0013\tQrC\u0001\u0004B]f\u0014VMZ\u0001\u0007I%t\u0017\u000e\u001e\u0013\u0015\u0003u\u0001\"A\u0006\u0010\n\u0005}9\"\u0001B+oSR\fab[3s]\u0016dGk\\\"za\",'\u000f\u0006\u0002#SA\u00111eJ\u0007\u0002I)\u0011!\"\n\u0006\u0003M-\tq\u0001\u001d7b]:,'/\u0003\u0002)I\tq\u0011J\u001c3fq\n+\u0007.\u0019<j_V\u0014\b\"\u0002\u0016\u0003\u0001\u0004Y\u0013!\u00032fQ\u00064\u0018n\\;s!\ta\u0003'D\u0001.\u0015\tqs&\u0001\u0004tG\",W.\u0019\u0006\u0003\u0019=I!\u0001K\u0017\u0015\u0005Ib\u0004c\u0001\f4k%\u0011Ag\u0006\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0005YJdBA\u00128\u0013\tAD%A\bJ]\u0012,\u0007\u0010R3tGJL\u0007\u000f^8s\u0013\tQ4HA\u0005J]\u0012,\u0007\u0010V=qK*\u0011\u0001\b\n\u0005\u0006{\r\u0001\rAP\u0001\nS:$W\r\u001f+za\u0016\u0004\"\u0001L \n\u0005ij\u0013\u0001F2za\",'\u000fV8LKJtW\r\\*dQ\u0016l\u0017\r\u0006\u0002C\u000bB\u0011AfQ\u0005\u0003\t6\u0012\u0001cU2iK6\fG)Z:de&\u0004Ho\u001c:\t\u000b\u0019#\u0001\u0019A$\u0002\u000b%tG-\u001a=\u0011\u0005\rB\u0015BA%%\u0005=Ie\u000eZ3y\t\u0016\u001c8M]5qi>\u0014\u0018AD2za\",'\u000fV8LKJtW\r\u001c\u000b\u0003}1CQ!P\u0003A\u00025\u0003\"AT\u001d\u000f\u0005=;dB\u0001)R\u001b\u0005)\u0013B\u0001\u0006&\u0003]!x\u000eT1cK2\u001c6\r[3nC\u0012+7o\u0019:jaR|'\u000f\u0006\u0003U1\n|\u0007c\u0001\f4+B\u0011AFV\u0005\u0003/6\u0012Q\u0003T1cK2\u001c6\r[3nC\u0012+7o\u0019:jaR|'\u000fC\u0003Z\r\u0001\u0007!,\u0001\u0002uGB\u00111\fY\u0007\u00029*\u0011QLX\u0001\fS:$XM\u001d9sKR,GM\u0003\u0002`\u0017\u00059!/\u001e8uS6,\u0017BA1]\u0005\u0001\"&/\u00198tC\u000e$\u0018n\u001c8C_VtGMU3bIR{7.\u001a8D_:$X\r\u001f;\t\u000b\r4\u0001\u0019\u00013\u0002\u00131\f'-\u001a7OC6,\u0007CA3m\u001d\t1'\u000e\u0005\u0002h/5\t\u0001N\u0003\u0002j'\u00051AH]8pizJ!a[\f\u0002\rA\u0013X\rZ3g\u0013\tigN\u0001\u0004TiJLgn\u001a\u0006\u0003W^AQ\u0001\u001d\u0004A\u0002E\fA\u0002\u001d:pa\u0016\u0014H/_&fsN\u00042A]<e\u001d\t\u0019XO\u0004\u0002hi&\t\u0001$\u0003\u0002w/\u00059\u0001/Y2lC\u001e,\u0017B\u0001=z\u0005\r\u0019V-\u001d\u0006\u0003m^\t\u0011\u0004^8SK2$\u0016\u0010]3TG\",W.\u0019#fg\u000e\u0014\u0018\u000e\u001d;peR9A0!\u0001\u0002\u0004\u0005\u001d\u0001c\u0001\f4{B\u0011AF`\u0005\u0003\u007f6\u0012ADU3mCRLwN\u001c+za\u0016\u001c6\r[3nC\u0012+7o\u0019:jaR|'\u000fC\u0003Z\u000f\u0001\u0007!\f\u0003\u0004\u0002\u0006\u001d\u0001\r\u0001Z\u0001\fe\u0016dG+\u001f9f\u001d\u0006lW\rC\u0003q\u000f\u0001\u0007\u0011\u000f")
public interface IndexDescriptorCompatibility {
    public static /* synthetic */ org.neo4j.cypher.internal.planner.spi.IndexBehaviour kernelToCypher$(IndexDescriptorCompatibility $this, IndexBehaviour behaviour) {
        return $this.kernelToCypher(behaviour);
    }

    default public org.neo4j.cypher.internal.planner.spi.IndexBehaviour kernelToCypher(IndexBehaviour behaviour) {
        SlowContains$ slowContains$;
        IndexBehaviour indexBehaviour = behaviour;
        if (IndexBehaviour.SLOW_CONTAINS.equals(indexBehaviour)) {
            slowContains$ = SlowContains$.MODULE$;
        } else if (IndexBehaviour.SKIP_AND_LIMIT.equals(indexBehaviour)) {
            slowContains$ = SkipAndLimit$.MODULE$;
        } else if (IndexBehaviour.EVENTUALLY_CONSISTENT.equals(indexBehaviour)) {
            slowContains$ = EventuallyConsistent$.MODULE$;
        } else {
            throw new IllegalStateException(new StringBuilder(54).append("Missing kernel to cypher mapping for index behaviour: ").append(behaviour).toString());
        }
        return slowContains$;
    }

    public static /* synthetic */ Option kernelToCypher$(IndexDescriptorCompatibility $this, IndexType indexType) {
        return $this.kernelToCypher(indexType);
    }

    default public Option<IndexDescriptor.IndexType> kernelToCypher(IndexType indexType) {
        IndexType indexType2 = indexType;
        Object object = IndexType.BTREE.equals(indexType2) ? new Some((Object)IndexDescriptor.IndexType$.Btree$.MODULE$) : (IndexType.TEXT.equals(indexType2) ? new Some((Object)IndexDescriptor.IndexType$.Text$.MODULE$) : None$.MODULE$);
        return object;
    }

    public static /* synthetic */ SchemaDescriptor cypherToKernelSchema$(IndexDescriptorCompatibility $this, IndexDescriptor index) {
        return $this.cypherToKernelSchema(index);
    }

    default public SchemaDescriptor cypherToKernelSchema(IndexDescriptor index) {
        LabelSchemaDescriptor labelSchemaDescriptor;
        IndexDescriptor.EntityType entityType = index.entityType();
        if (entityType instanceof IndexDescriptor.EntityType$.Node) {
            IndexDescriptor.EntityType$.Node node = (IndexDescriptor.EntityType$.Node)entityType;
            LabelId label = node.label();
            labelSchemaDescriptor = SchemaDescriptors.forLabel((int)label.id(), (int[])((int[])((TraversableOnce)index.properties().map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToInteger((int)x$1.id()), Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.Int())));
        } else if (entityType instanceof IndexDescriptor.EntityType$.Relationship) {
            IndexDescriptor.EntityType$.Relationship relationship = (IndexDescriptor.EntityType$.Relationship)entityType;
            RelTypeId relType = relationship.relType();
            labelSchemaDescriptor = SchemaDescriptors.forRelType((int)relType.id(), (int[])((int[])((TraversableOnce)index.properties().map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToInteger((int)x$2.id()), Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.Int())));
        } else {
            throw new MatchError((Object)entityType);
        }
        return labelSchemaDescriptor;
    }

    public static /* synthetic */ IndexType cypherToKernel$(IndexDescriptorCompatibility $this, IndexDescriptor.IndexType indexType) {
        return $this.cypherToKernel(indexType);
    }

    default public IndexType cypherToKernel(IndexDescriptor.IndexType indexType) {
        IndexType indexType2;
        IndexDescriptor.IndexType indexType3 = indexType;
        if (IndexDescriptor.IndexType$.Btree$.MODULE$.equals(indexType3)) {
            indexType2 = IndexType.BTREE;
        } else if (IndexDescriptor.IndexType$.Text$.MODULE$.equals(indexType3)) {
            indexType2 = IndexType.TEXT;
        } else {
            throw new MatchError((Object)indexType3);
        }
        return indexType2;
    }

    public static /* synthetic */ Option toLabelSchemaDescriptor$(IndexDescriptorCompatibility $this, TransactionBoundReadTokenContext tc, String labelName, Seq propertyKeys) {
        return $this.toLabelSchemaDescriptor(tc, labelName, (Seq<String>)propertyKeys);
    }

    default public Option<LabelSchemaDescriptor> toLabelSchemaDescriptor(TransactionBoundReadTokenContext tc, String labelName, Seq<String> propertyKeys) {
        return Exception$.MODULE$.catching((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Class[]{LabelNotFoundKernelException.class, PropertyKeyNotFoundException.class})).opt((Function0 & Serializable & scala.Serializable)() -> {
            int labelId = tc.getLabelId(labelName);
            Seq propertyKeyIds = (Seq)propertyKeys.map((Function1 & Serializable & scala.Serializable)propertyKeyName -> BoxesRunTime.boxToInteger((int)tc.getPropertyKeyId(propertyKeyName)), Seq$.MODULE$.canBuildFrom());
            return SchemaDescriptors.forLabel((int)labelId, (int[])((int[])propertyKeyIds.toArray(ClassTag$.MODULE$.Int())));
        });
    }

    public static /* synthetic */ Option toRelTypeSchemaDescriptor$(IndexDescriptorCompatibility $this, TransactionBoundReadTokenContext tc, String relTypeName, Seq propertyKeys) {
        return $this.toRelTypeSchemaDescriptor(tc, relTypeName, (Seq<String>)propertyKeys);
    }

    default public Option<RelationTypeSchemaDescriptor> toRelTypeSchemaDescriptor(TransactionBoundReadTokenContext tc, String relTypeName, Seq<String> propertyKeys) {
        return Exception$.MODULE$.catching((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Class[]{RelationshipTypeNotFoundException.class, PropertyKeyNotFoundException.class})).opt((Function0 & Serializable & scala.Serializable)() -> {
            int relTypeId = tc.getRelTypeId(relTypeName);
            Seq propertyKeyIds = (Seq)propertyKeys.map((Function1 & Serializable & scala.Serializable)propertyKeyName -> BoxesRunTime.boxToInteger((int)tc.getPropertyKeyId(propertyKeyName)), Seq$.MODULE$.canBuildFrom());
            return SchemaDescriptors.forRelType((int)relTypeId, (int[])((int[])propertyKeyIds.toArray(ClassTag$.MODULE$.Int())));
        });
    }

    public static void $init$(IndexDescriptorCompatibility $this) {
    }
}

