/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.batchimport;

import org.neo4j.internal.batchimport.RecordProcessor;
import org.neo4j.internal.batchimport.cache.NodeRelationshipCache;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.storageengine.api.cursor.StoreCursors;

public class SparseNodeFirstRelationshipProcessor
implements RecordProcessor<NodeRecord> {
    private final NodeRelationshipCache cache;

    public SparseNodeFirstRelationshipProcessor(NodeRelationshipCache cache) {
        this.cache = cache;
    }

    @Override
    public boolean process(NodeRecord node, StoreCursors storeCursors) {
        long nodeId = node.getId();
        long firstRel = this.cache.getFirstRel(nodeId, NodeRelationshipCache.NO_GROUP_VISITOR);
        if (firstRel != -1L) {
            node.setNextRel(firstRel);
        }
        return true;
    }

    @Override
    public void done() {
    }

    @Override
    public void mergeResultsFrom(RecordProcessor<NodeRecord> other) {
        throw new UnsupportedOperationException("Should not be called, since it's single-threaded");
    }

    @Override
    public void close() {
    }
}

