# The libpostal Code of Conduct

libpostal is all about addresses, and addresses are all about how people communicate. The philosophy of this project has always been one of multiculturalism, of acknowledging and embracing the specifics of our experiences, the nuances of our cultures, languages, identities, and intersections thereof. This code of conduct expresses the values we hope our contributors will emulate and adopt. We further acknowledge that machine learning models like the ones used in libpostal can reflect and sometimes reinforce the defaults, biases, and injustices that are encoded in the underlying training data and it is urgent and necessary that we stay vigilant in ensuring that open mapping data sets are representative of the under-represented.

> "Maps are an abstraction of reality, but whose reality are we talking about?"
> 
> -- Kate Chapman of the Humanitarian OpenStreetMap Team

## Our Pledge

In the interest of fostering an open and welcoming environment, we as contributors and maintainers pledge to making participation in our project and our community a harassment-free experience for everyone, regardless of age, body size, disability, ethnicity, gender identity and expression, level of experience, nationality, personal appearance, primary language(s), race, religion, or sexual identity and orientation.

It's a core tenet of this project to represent different cultures, languages, and realities. This can only be accomplished through creating an inclusive community that goes beyond simply tolerating differences, and instead intrinsically values and seeks out the diverse experiences of people around the world. We pledge to encourage and support people who are directly and/or indirectly marginalized in the open source community and in our societies.

## Our Standards

Examples of behavior that contributes to creating a positive environment include:

- Using welcoming and inclusive language
- Being respectful of differing viewpoints and experiences
- Gracefully accepting constructive criticism
- Acknowledging the privilege that one holds in a conversation
- Focusing on what is best for the community
- Showing empathy towards other community members

Examples of unacceptable behavior by participants include:

- Hate speech, overt or coded racism, use or promotion of hate symbols or imagery
- The use of sexualized language or imagery and unwelcome sexual attention or advances
- Trolling, insulting/derogatory comments, and personal or political attacks
- Public or private harassment
- Use of condescending language
- Making assumptions about technical knowledge based on personal characteristics
- "Othering" of languages, cultures, or groups of people and their lived experiences
- Publishing others' private information, such as a physical or electronic address, without explicit permission
- Other conduct which could reasonably be considered inappropriate in a professional setting

## Our Responsibilities

Project maintainers are responsible for clarifying the standards of acceptable behavior and are expected to take appropriate and fair corrective action in response to any instances of unacceptable behavior.

Project maintainers have the right and responsibility to remove, edit, or reject comments, commits, code, wiki edits, issues, and other contributions that are not aligned to this Code of Conduct, or to ban temporarily or permanently any contributor for other behaviors that they deem inappropriate, threatening, offensive, or harmful.

## Scope

This Code of Conduct applies both within project spaces and in public spaces when an individual is representing the project or its community. Examples of representing a project or community include using an official project e-mail address, posting via an official social media account, or acting as an appointed representative at an online or offline event. Representation of a project may be further defined and clarified by project maintainers.

## Enforcement

Instances of abusive, harassing, or otherwise unacceptable behavior may be reported by contacting the project team at Contact email address. The project team will review and investigate all complaints, and will respond in a way that it deems appropriate to the circumstances. The project team is obligated to maintain confidentiality with regard to the reporter of an incident. Further details of specific enforcement policies may be posted separately.

Project maintainers who do not follow or enforce the Code of Conduct in good faith may face temporary or permanent repercussions as determined by other members of the project's leadership.

## Attribution

This Code of Conduct is adapted from the Contributor Covenant, version 1.4, available at http://contributor-covenant.org/version/1/4
