/* ----- core/scale3sntrup1277, derived from supercop/crypto_core/try.c */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdint.h>
#include <ntruprime.h>
#include "ntruprime_test.h"

#define fail ((ok = 0),printf)
static const char *core_scale3sntrup1277_checksums[] = {
  "49d516671d2ccb0512a7301439c928e5c3b0c931be7394eb883c9ca3748d3f1d",
  "58b6d7e044d2860ed9aee951367fcf8040720e3c780ce65bea54ff2f7b9ffed6",
} ;

static void (*crypto_core)(unsigned char *,const unsigned char *,const unsigned char *,const unsigned char *);
#define crypto_core_OUTPUTBYTES ntruprime_core_scale3sntrup1277_OUTPUTBYTES
#define crypto_core_INPUTBYTES ntruprime_core_scale3sntrup1277_INPUTBYTES
#define crypto_core_KEYBYTES ntruprime_core_scale3sntrup1277_KEYBYTES
#define crypto_core_CONSTBYTES ntruprime_core_scale3sntrup1277_CONSTBYTES

static void *storage_core_scale3sntrup1277_h;
static unsigned char *test_core_scale3sntrup1277_h;
static void *storage_core_scale3sntrup1277_n;
static unsigned char *test_core_scale3sntrup1277_n;
static void *storage_core_scale3sntrup1277_k;
static unsigned char *test_core_scale3sntrup1277_k;
static void *storage_core_scale3sntrup1277_c;
static unsigned char *test_core_scale3sntrup1277_c;
static void *storage_core_scale3sntrup1277_h2;
static unsigned char *test_core_scale3sntrup1277_h2;
static void *storage_core_scale3sntrup1277_n2;
static unsigned char *test_core_scale3sntrup1277_n2;
static void *storage_core_scale3sntrup1277_k2;
static unsigned char *test_core_scale3sntrup1277_k2;
static void *storage_core_scale3sntrup1277_c2;
static unsigned char *test_core_scale3sntrup1277_c2;

#define precomputed_core_scale3sntrup1277_NUM 4

static const unsigned char precomputed_core_scale3sntrup1277_h[precomputed_core_scale3sntrup1277_NUM][crypto_core_OUTPUTBYTES] = {
  {22,3,65,94,243,215,190,104,65,189,118,80,9,250,161,178,155,41,89,4,92,75,209,8,218,252,37,10,6,206,117,247,117,250,40,83,188,248,100,184,159,255,208,0,204,221,165,231,124,187,157,252,145,49,219,14,148,7,147,94,221,214,138,226,230,92,53,30,219,175,92,98,90,180,155,219,158,248,36,225,73,39,211,52,19,11,81,238,187,108,223,39,15,202,172,52,31,8,231,98,162,3,190,3,85,218,163,50,143,14,126,109,224,206,199,21,215,48,217,207,223,69,1,177,49,253,78,219,35,18,23,237,177,92,194,18,177,240,86,220,123,196,83,250,216,6,66,86,26,25,126,241,15,91,12,246,22,224,18,8,234,176,170,1,166,57,101,247,129,10,106,249,84,45,192,52,0,249,13,241,144,2,116,247,46,0,161,55,77,6,117,202,228,80,92,186,26,246,143,39,182,254,26,191,113,215,80,183,212,55,34,98,185,253,125,3,64,6,31,223,24,2,122,241,231,2,207,107,248,209,241,6,248,16,3,214,69,1,202,197,73,248,162,220,170,5,145,112,7,32,82,7,125,63,222,195,60,241,125,206,111,248,8,67,164,105,219,240,101,41,174,227,102,91,236,10,125,10,173,174,202,11,74,199,230,240,98,40,202,182,107,253,81,243,210,216,62,250,97,253,189,47,179,8,190,14,217,56,76,50,210,255,211,174,65,237,252,18,176,248,236,39,123,107,137,207,140,180,46,254,255,208,114,40,135,9,161,1,154,243,24,21,211,215,96,74,90,238,47,19,157,206,21,246,132,77,110,248,47,50,135,7,211,65,187,229,109,13,144,227,156,5,54,51,225,244,12,15,79,40,171,56,101,255,32,78,185,55,177,71,79,45,79,88,31,45,214,176,46,238,173,12,148,180,131,242,108,60,139,8,6,24,201,87,225,83,88,200,48,227,174,255,38,200,244,17,31,35,101,45,4,214,127,7,24,3,197,42,189,242,216,3,154,19,100,73,117,60,94,174,60,241,35,232,246,190,120,214,134,87,238,241,55,11,64,82,172,255,114,202,203,229,94,18,242,245,9,246,95,190,216,58,177,193,168,21,178,87,88,51,117,91,68,1,250,18,248,249,126,195,203,245,100,93,254,207,27,244,22,233,173,92,133,96,167,9,79,212,249,251,119,55,8,183,83,232,63,15,11,60,178,80,101,49,200,200,39,216,225,195,205,14,82,15,130,185,4,9,22,199,7,47,19,18,27,187,164,185,234,251,251,80,132,57,165,232,231,20,26,31,230,76,83,28,24,250,13,10,243,203,114,0,73,18,147,86,168,79,183,17,229,198,181,254,143,14,232,247,198,74,56,229,199,92,84,244,171,236,126,12,45,77,84,42,195,197,39,255,128,244,234,20,169,69,232,200,4,67,132,95,55,175,12,243,51,98,147,76,227,225,124,4,96,248,22,14,160,189,29,233,172,248,104,180,65,255,245,40,41,248,216,253,126,215,108,214,205,217,209,34,179,97,75,35,19,176,18,53,184,254,149,53,248,87,77,178,23,176,123,213,172,47,221,213,177,100,176,200,6,176,120,180,8,8,44,247,135,2,202,80,218,211,166,10,154,187,0,246,215,38,36,55,43,7,118,33,84,111,46,22,199,12,142,213,187,190,220,12,28,10,134,41,100,89,204,108,51,27,141,40,189,253,181,67,181,199,136,233,60,6,154,15,31,97,135,188,141,230,81,197,59,212,51,239,225,61,19,190,45,183,18,255,167,15,238,56,42,209,175,205,218,245,149,234,18,222,248,51,159,244,117,25,244,104,64,108,68,78,223,97,176,83,30,2,100,26,3,93,22,180,90,46,186,66,66,198,184,207,114,20,109,30,170,244,146,59,47,10,38,187,49,204,103,250,31,104,23,31,132,252,234,72,230,98,233,252,251,39,136,29,87,253,119,207,180,104,59,107,241,59,0,109,108,53,115,11,250,89,16,102,32,254,216,253,235,227,102,108,55,10,47,239,165,248,229,88,28,255,152,20,38,209,103,243,181,1,21,11,164,192,231,244,15,15,122,252,238,56,8,47,242,26,53,63,58,4,33,245,202,247,182,244,7,19,63,233,65,202,175,6,25,248,51,6,134,6,128,2,155,241,92,188,42,2,83,242,156,219,216,250,241,243,195,3,52,106,11,212,112,14,191,232,31,245,121,48,61,235,98,65,72,241,130,9,108,53,252,32,174,28,186,241,89,219,127,32,88,243,181,252,159,4,130,203,83,241,39,233,218,99,32,244,174,236,32,64,233,103,152,14,81,0,100,185,94,102,206,32,241,66,216,255,84,110,158,74,157,68,140,14,137,2,58,70,94,217,59,254,10,206,128,183,17,205,207,244,235,91,176,217,38,177,168,246,247,107,184,97,183,13,161,7,182,239,186,216,238,5,238,195,36,35,3,245,220,184,14,244,170,91,144,104,31,63,225,232,166,105,145,236,207,71,80,243,8,5,55,241,14,252,45,249,113,72,181,251,236,29,239,95,222,203,240,193,236,4,181,185,66,249,96,14,60,247,190,203,224,4,94,12,58,202,66,182,23,222,26,250,25,187,183,17,169,0,228,66,172,61,59,222,67,77,151,254,158,43,0,216,243,221,168,227,47,212,204,19,16,53,232,241,165,13,88,52,152,112,225,5,179,53,105,244,178,67,17,244,209,3,249,6,157,246,212,63,237,255,11,2,95,42,225,70,17,61,246,187,250,252,73,0,188,253,87,175,69,204,12,254,166,57,30,219,81,248,4,200,174,109,148,203,28,3,121,9,60,36,112,12,84,255,157,43,160,9,199,91,71,10,253,206,163,80,105,175,211,43,59,48,170,79,78,101,72,215,73,188,96,204,59,222,238,3,209,60,74,90,195,14,246,12,193,175,87,90,252,175,229,2,11,207,211,245,2,101,151,231,110,44,149,92,146,56,117,41,181,11,228,0,87,35,14,59,217,12,168,245,139,34,187,255,133,55,163,211,45,14,0,207,69,13,138,6,126,55,140,247,109,186,130,189,177,183,251,231,107,241,57,226,212,255,70,12,127,8,89,64,175,4,235,245,69,5,177,208,106,253,42,236,33,17,83,192,104,79,67,1,136,177,31,68,40,101,86,98,248,177,206,20,245,251,122,62,50,3,184,28,93,227,135,215,214,17,253,30,91,3,58,182,222,42,244,61,172,177,111,20,59,32,188,243,30,228,60,105,244,69,148,53,194,77,87,103,109,112,140,12,78,109,110,49,170,253,166,4,107,252,242,68,138,65,56,5,168,3,1,213,142,72,52,4,226,27,175,9,76,195,79,221,203,5,254,19,62,2,3,196,111,220,170,27,217,239,81,188,74,66,249,208,2,239,158,209,61,231,2,254,115,191,155,98,113,75,57,219,254,42,91,109,206,63,203,216,30,3,200,222,77,92,60,219,188,196,77,42,128,248,171,251,155,98,169,3,70,221,129,92,218,204,232,183,143,224,163,92,207,255,255,203,45,178,68,240,37,193,28,15,0,181,114,254,153,180,250,72,100,86,115,249,73,105,7,250,176,12,15,94,36,10,240,246,125,18,135,34,244,1,100,213,205,244,4,248,119,8,185,46,174,85,99,14,63,251,178,190,114,241,64,68,215,9,112,12,143,78,220,8,205,7,36,0,219,57,253,247,53,246,8,3,57,2,208,215,9,20,183,73,222,2,16,72,43,0,236,64,186,211,35,101,33,5,97,89,178,218,95,7,232,29,180,232,197,90,186,9,34,65,132,248,35,28,57,27,149,246,16,4,144,241,85,10,64,250,131,242,72,180,191,189,59,248,71,34,175,22,136,180,221,191,115,10,216,201,51,36,24,217,42,97,197,107,80,12,238,0,129,240,104,249,243,32,28,3,8,184,172,77,255,58,106,29,139,91,91,217,237,177,20,217,92,78,222,56,105,72,145,43,225,246,50,235,29,68,165,223,245,3,197,255,33,14,98,56,250,249,121,14,78,17,252,10,22,49,225,244,68,64,204,16,126,11,82,203,55,197,220,32,103,254,191,82,10,81,96,57,104,250,70,244,52,53,235,6,210,46,85,246,58,24,103,209,46,110,171,63,214,31,142,226,228,255,220,88,134,96,179,36,12,12,22,13,190,40,33,198,25,88,11,193,68,4,131,1,158,244,54,87,16,102,107,51,120,201,26,75,196,246,89,63,62,106,80,250,55,76,97,251,241,255,127,195,74,177,104,109,35,10,90,11,223,255,175,100,36,10,213,5,188,203,181,198,177,106,229,36,7,229,131,11,210,70,213,54,82,179,255,12,222,79,255,22,117,40,169,238,208,89,244,214,99,7,171,224,41,80,211,230,53,221,14,9,223,31,250,98,30,255,5,11,141,11,204,249,17,199,192,3,47,226,96,247,176,3,184,106,166,242,117,251,201,218,13,245,132,242,32,64,230,185,27,178,171,224,172,92,140,238,191,23,142,252,235,41,139,80,168,78,206,19,80,251,206,49,0,58,184,254,219,220,48,177,136,178,127,104,6,54,135,3,16,105,148,87,141,35,195,248,220,16,2,51,54,241,54,3,212,192,98,22,121,253,57,217,63,49,235,222,43,21,59,64,151,38,71,61,65,247,72,46,198,224,24,64,196,189,200,15,75,103,73,238,70,190,13,177,150,100,8,184,184,224,168,92,122,94,174,255,125,16,200,90,79,72,104,182,99,63,52,252,35,249,32,88,5,208,36,48,185,27,148,198,178,199,5,108,73,218,48,197,228,244,239,89,80,197,47,57,205,248,63,10,128,19,237,185,46,191,64,86,121,187,13,35,9,25,155,220,143,14,152,7,252,9,64,12,163,4,100,28,10,188,147,0,251,250,123,79,16,2,223,12,248,74,116,225,71,0,225,44,225,95,26,108,241,8,42,253,162,71,153,225,39,80,150,64,75,211,167,4,65,16,96,243,121,243,145,40,193,0,117,196,34,56,171,8,96,40,63,92,240,252,113,34,119,32,100,60,77,3,185,17,159,78,205,244,29,12,113,67,231,92,158,194,136,181,211,93,176,90,128,239,204,7,165,12,147,2,243,201,102,23,157,20,42,184,5,80,168,220,38,253,37,227,231,46,153,18,57,105,127,24,136,200,59,242,122,63,189,255,218,244,66,251,34,3,74,244,254,60,231,207,17,18,63,0,243,0,51,245,229,216,89,5,234,66,2,89,73,198,128,78,90,63,173,12,31,12,109,248,147,239,195,46,117,41,201,0,112,218,100,11,190,3,10,185,18,85,194,11,76,62,176,7,33,103,114,95,49,1,127,2,151,213,20,219,24,246,128,20,65,105,155,186,236,227,133,245,191,50,241,23,119,203,255,12,186,108,193,78,120,212,182,9,225,63,253,5,211,90,251,7,24,246,207,0,216,252,52,188,222,8,106,63,103,230,106,11,77,206,188,14,162,0,104,1,139,241,209,28,16,242,177,68,17,245,64,200,238,196,22,15,29,11,83,246,138,205,159,64,247,254,189,63,136,7,27,200,74,225,55,97,207,45,8,12,101,3,240,4,231,4,230,2,37,107,149,55,16,112,45,208,142,71,33,247,208,35,234,209,149,243,92,182,177,208,148,250,182,185,230,63,101,222,173,110,110,10,220,216,147,68,100,250,236,107,247,229,216,213,30,45,203,177,108,243,249,83,47,246,142,76,43,230,231,194,92,64,129,227,246,69,174,8,196,254,120,64,196,82,88,174,171,6,147,204},
  {158,206,62,1,137,232,206,110,172,225,44,5,243,96,8,215,117,2,183,194,99,19,24,224,210,68,130,32,70,177,245,251,16,196,69,182,0,191,55,242,43,242,203,66,132,230,229,97,84,110,100,253,135,93,185,210,229,22,12,15,181,38,224,70,93,245,209,96,110,7,106,3,128,211,252,7,128,252,66,190,54,232,41,38,159,188,195,191,173,195,84,2,129,50,236,179,219,74,251,245,123,194,191,91,252,59,90,1,128,11,142,190,166,255,140,185,198,251,107,202,241,175,101,80,219,52,246,223,190,200,70,2,170,62,150,85,158,205,26,205,154,69,73,198,84,17,166,228,238,49,248,219,96,254,34,49,137,207,149,70,250,233,192,110,174,209,247,246,251,33,49,252,212,75,199,254,123,219,57,87,246,99,66,255,158,3,207,2,206,243,42,38,79,200,104,30,69,181,4,179,241,186,160,50,107,217,61,32,108,247,40,33,3,197,213,252,101,62,125,7,195,176,158,236,210,10,62,103,89,60,144,70,94,3,148,245,224,100,52,192,14,184,75,9,54,236,147,63,3,70,178,210,249,209,129,11,247,33,201,187,209,252,202,211,100,251,110,254,226,246,2,16,161,80,148,15,102,214,221,244,120,13,151,70,165,209,4,33,155,12,250,241,197,192,255,89,254,246,170,234,53,0,22,242,106,176,197,5,22,255,228,242,10,13,183,88,239,248,235,254,173,246,249,101,175,11,225,223,77,15,201,189,64,58,215,188,205,240,2,226,151,251,40,232,139,252,95,46,5,11,99,11,178,102,98,249,196,110,195,0,219,88,241,9,173,12,45,225,35,53,100,106,8,242,62,38,95,178,112,245,37,251,165,1,252,61,162,5,195,6,28,247,150,192,137,251,188,254,206,87,95,250,237,10,72,239,202,243,200,108,48,226,154,97,37,247,66,42,47,200,228,241,43,5,38,13,244,250,127,18,130,204,117,60,46,208,184,12,179,195,244,12,245,255,168,38,62,14,88,195,64,240,37,0,218,237,73,56,118,92,114,212,196,5,43,40,168,221,193,225,85,26,237,8,198,240,26,8,217,221,62,20,113,223,114,250,142,250,15,206,172,186,193,14,210,225,36,28,217,34,192,3,242,244,130,245,63,213,122,11,162,102,30,80,199,100,123,57,114,206,198,194,56,3,7,20,140,244,162,22,154,70,70,247,52,241,184,41,247,101,210,193,200,45,63,61,45,224,248,83,22,2,175,248,27,252,184,42,208,248,235,182,58,212,128,12,25,48,165,249,207,63,41,226,32,243,146,187,197,57,138,28,229,15,167,56,245,14,70,67,24,77,187,252,70,13,181,196,104,92,35,251,167,47,77,242,236,105,10,58,32,211,179,6,244,1,56,36,197,88,247,41,94,41,43,71,182,181,170,76,33,237,63,189,224,95,189,6,218,251,242,85,132,248,150,226,114,255,183,3,49,111,87,18,165,232,97,27,62,97,202,17,27,5,39,65,123,234,170,252,55,69,97,209,93,27,124,238,182,209,118,253,14,253,71,70,234,212,109,224,100,31,34,98,177,211,80,186,241,63,168,12,91,3,184,11,169,198,89,174,91,248,84,250,107,4,173,58,246,41,34,226,112,90,228,231,141,11,54,190,101,253,102,248,107,73,245,11,29,42,189,9,116,64,161,252,131,66,120,61,132,243,198,177,102,183,45,189,238,240,239,54,254,13,58,244,152,108,89,242,44,241,66,215,27,206,175,47,234,250,137,53,33,14,62,12,225,69,222,12,170,82,43,248,78,90,198,223,158,194,51,61,209,239,27,199,49,209,48,93,49,68,129,9,36,235,205,28,255,219,30,185,194,9,193,66,41,239,131,252,79,68,139,206,84,67,69,183,116,49,17,3,80,12,129,180,24,11,162,182,29,210,62,174,73,103,232,79,42,6,121,204,160,240,238,10,72,5,232,2,61,242,96,52,10,8,194,255,179,184,5,8,234,109,137,196,49,8,231,190,48,248,106,219,162,43,133,244,74,224,81,29,82,67,131,7,173,88,189,182,188,252,58,241,173,250,117,189,43,7,49,193,188,198,246,62,198,41,24,105,168,240,91,53,183,58,16,15,149,230,50,209,164,252,189,108,117,82,173,210,254,30,134,88,150,51,0,194,39,29,14,7,217,32,9,201,90,34,63,213,45,226,211,200,208,97,16,188,139,181,170,182,149,252,81,4,31,234,243,104,27,74,228,184,72,64,200,84,93,47,69,81,212,184,113,231,160,223,183,37,110,190,185,82,135,181,172,176,192,10,140,186,190,242,130,175,234,229,154,198,52,13,230,84,86,238,209,185,228,83,165,247,89,55,5,224,172,1,128,91,61,107,158,253,159,82,251,71,212,251,240,214,189,0,202,1,81,76,85,72,191,61,227,1,105,188,202,197,210,104,50,80,205,8,100,7,19,96,167,13,213,24,91,10,125,212,171,10,0,252,120,220,81,6,73,36,152,98,19,254,10,62,68,64,2,41,108,5,157,97,204,29,167,64,38,249,184,0,221,182,151,253,111,31,245,214,183,106,31,252,108,232,159,61,254,17,118,19,43,33,82,13,40,236,253,206,162,241,148,9,24,88,99,54,125,1,155,20,136,25,32,13,228,194,219,187,194,29,246,26,39,242,74,33,159,88,153,246,120,26,31,42,30,219,22,95,188,210,166,193,208,107,151,66,63,59,224,94,15,60,144,27,3,27,206,95,219,42,114,212,72,40,49,4,48,255,222,50,164,59,17,92,226,211,29,185,81,250,172,207,214,221,112,68,181,251,158,55,184,242,228,220,214,213,2,53,19,182,18,224,65,31,12,112,27,243,250,65,141,28,171,100,138,9,176,184,128,102,182,36,197,48,122,197,77,31,119,13,146,205,240,8,26,0,211,1,248,216,57,98,51,248,48,87,80,73,19,243,203,57,155,214,72,12,96,178,73,181,45,253,164,77,190,5,251,212,130,181,52,40,82,45,117,73,17,15,152,4,49,242,45,207,61,41,26,12,248,102,44,1,165,175,223,54,33,27,159,101,197,241,140,195,169,29,70,249,187,19,0,250,17,85,179,58,224,35,67,37,222,56,66,24,81,7,37,3,121,33,117,6,93,7,118,73,49,31,87,94,170,245,38,241,9,3,245,87,66,69,15,44,122,183,213,8,73,250,142,251,129,100,237,246,16,246,22,24,244,253,110,12,146,7,135,2,119,251,10,101,131,4,61,255,0,40,140,27,11,71,209,252,204,253,47,250,126,9,193,223,230,184,12,87,13,8,202,21,196,252,24,107,248,230,124,13,45,17,77,49,91,180,88,73,131,49,170,203,38,191,7,28,195,37,17,62,147,244,154,46,193,89,21,232,128,61,245,202,111,6,47,15,77,64,150,31,108,203,160,7,225,106,228,254,71,252,218,231,191,25,166,28,90,215,17,106,69,242,38,188,159,89,8,80,113,99,171,245,116,247,54,189,120,186,61,232,4,235,159,25,77,209,119,28,91,8,88,49,247,181,151,46,7,27,240,12,242,97,200,200,228,14,195,98,155,214,72,67,150,64,144,86,49,34,119,94,137,251,21,4,130,223,76,201,126,14,119,65,197,47,235,56,249,4,208,41,159,86,29,179,13,241,114,219,44,230,237,76,94,20,208,252,185,238,131,71,67,2,60,242,182,0,53,201,193,212,12,250,247,215,217,87,143,57,131,9,162,225,179,175,124,83,225,104,222,244,32,69,205,30,27,13,244,248,142,33,118,222,79,247,207,241,245,89,87,217,105,246,180,232,42,9,210,14,110,193,149,227,152,12,187,244,157,235,39,250,239,24,125,70,28,225,176,33,218,254,213,8,11,180,57,70,138,253,238,8,247,225,63,46,227,78,65,4,168,14,153,251,23,193,114,112,116,181,180,79,184,207,184,10,69,242,134,214,24,249,138,70,207,3,50,13,198,237,225,205,211,253,142,50,17,43,0,31,38,22,31,24,107,238,93,44,47,221,79,3,162,16,36,208,191,246,179,30,45,12,71,252,144,242,10,243,69,60,234,207,128,237,236,19,56,235,44,83,71,229,126,18,94,1,242,28,138,86,123,233,210,103,221,175,242,206,25,252,115,228,106,18,184,19,251,50,102,242,227,252,213,211,76,10,242,247,128,106,49,50,104,33,86,55,234,81,243,240,219,24,208,246,70,218,241,191,66,239,255,241,129,206,253,236,63,20,189,32,235,34,228,108,243,247,50,7,248,64,81,226,241,224,8,83,129,250,42,219,15,28,139,17,3,181,69,36,121,193,126,195,242,66,59,1,94,80,151,21,22,215,241,93,94,238,98,76,156,247,16,13,121,243,16,192,139,6,100,197,232,85,144,207,234,1,125,1,226,108,170,175,14,204,87,174,189,212,17,29,55,244,138,1,5,12,246,217,18,176,121,243,163,20,230,6,44,3,206,74,188,14,213,108,239,244,83,24,2,112,223,195,38,42,238,209,210,8,220,9,31,66,128,53,215,58,109,57,147,210,251,4,6,223,184,250,80,239,52,214,115,203,170,87,15,248,113,255,206,62,184,25,238,252,155,255,224,83,151,3,176,86,8,72,57,4,213,221,27,5,218,202,19,13,114,33,254,94,15,78,98,243,229,66,130,210,197,231,116,25,46,88,35,92,161,235,68,1,229,2,44,90,123,192,79,91,23,15,62,243,30,231,244,23,93,64,139,26,27,238,154,185,205,42,70,55,74,89,13,235,13,11,64,6,94,90,1,8,152,11,198,243,43,252,130,11,158,8,34,10,175,211,158,206,241,60,243,203,9,230,28,62,168,4,80,248,127,4,1,252,96,96,167,248,178,14,83,234,238,186,238,102,174,13,192,62,196,103,138,39,101,200,153,67,181,76,15,85,29,212,45,219,228,188,243,188,24,217,80,250,71,23,24,73,211,9,249,252,178,195,143,71,16,12,33,200,156,242,178,5,104,208,142,7,172,34,30,182,130,98,195,9,196,60,104,8,124,76,226,195,132,100,114,12,153,188,7,209,239,73,113,59,101,65,183,5,109,4,146,3,22,10,173,5,200,1,48,11,69,240,50,174,2,53,92,84,166,247,109,7,49,105,104,60,160,245,188,174,54,202,181,189,194,241,12,16,71,81,221,73,76,218,83,91,81,235,191,180,114,3,209,179,111,252,228,3,4,109,108,14,210,4,233,47,250,1,33,242,126,180,113,188,242,86,161,0,1,106,136,241,16,184,218,74,130,13,158,37,141,62,106,7,244,234,182,232,149,105,92,71,171,242,93,245,134,91,1,11,241,238,146,196,231,51,126,32,210,14,192,75,106,90,184,9,254,253,80,238,192,12,223,30,122,228,85,236,134,0,102,212,144,14,121,175,112,209,15,13,185,42,12,19,167,51,32,98,18,11,195,230,81,244,244,190,206,44,214,186,130,19,161,5,231,16,13,70,187,35,176,11,202,230,68,41,152,7,203,12,29,84,226,185,235,26,219,248,252,99,223,35,96,77,162,4,222,3,174,232,58,212,251,252,22,44,45,20,177,240,59,84,165,2,243,92,174,43,123,13,179,29,71,235,189,91,100,17,97,240,88,219,95,40,238,208,2,12,36,11,205,14,35,11,130,93,59,195,69,95,158,103,58,84,13,108,166,201,45,248,160,250,18,241,103,73,179,94,35,14,75,82,40,56,66,73,184,214,174,13,201,14,162,255,131,63,70,94,236,38,186,238,3,1},
  {245,203,179,248,213,224,146,186,4,9,174,203,237,238,90,9,79,59,49,8,162,6,27,93,31,80,92,185,7,242,107,9,34,249,167,204,95,245,96,10,17,5,75,227,19,91,240,13,126,190,146,15,47,105,209,245,239,35,132,248,90,246,236,210,104,201,181,252,196,3,188,75,134,182,189,192,68,46,8,226,13,216,33,13,88,246,180,7,186,225,224,250,92,183,130,21,84,64,185,199,45,3,25,244,6,176,102,181,155,236,225,53,111,203,60,252,65,56,137,9,168,236,167,52,20,19,179,31,18,12,211,78,63,178,164,244,130,254,0,43,161,9,104,241,99,175,107,241,238,252,32,34,129,200,72,48,242,91,210,12,58,10,246,175,163,25,58,254,26,214,105,18,117,87,193,80,223,197,185,220,28,52,254,235,222,31,130,191,177,48,205,250,213,79,101,38,94,202,10,230,30,181,66,179,94,105,221,1,7,12,61,23,61,232,108,8,194,88,117,42,137,93,153,42,67,217,204,53,216,222,161,28,90,232,158,4,211,0,79,17,225,215,36,103,245,9,206,251,165,77,151,95,63,15,250,72,63,251,216,240,171,4,27,12,237,103,47,65,45,12,168,250,247,5,194,175,92,181,144,49,65,101,171,213,7,61,191,237,101,62,231,9,187,5,249,34,21,223,99,88,240,233,229,210,136,83,207,242,82,205,168,188,204,247,77,90,253,6,228,243,98,189,105,84,186,47,32,64,233,197,255,240,184,188,203,209,11,56,131,14,229,10,104,109,32,252,252,74,52,7,48,49,251,71,123,241,15,193,228,193,100,56,118,217,212,17,20,252,145,175,205,241,192,94,74,234,119,62,36,235,41,11,247,252,117,81,37,3,230,221,52,12,137,43,61,12,59,83,76,55,183,109,124,5,69,63,240,183,110,78,79,195,66,83,86,255,251,76,37,252,75,79,9,91,166,2,197,0,69,248,101,59,160,19,80,241,13,4,193,206,2,111,222,0,227,251,61,225,21,247,13,8,195,59,146,13,249,196,178,39,145,97,179,41,128,74,191,33,221,193,150,254,255,246,181,196,43,0,94,237,69,252,244,249,128,77,145,110,219,62,43,31,253,77,89,85,152,5,142,211,229,254,175,37,95,219,76,16,104,216,232,79,137,225,140,182,176,4,206,247,82,13,12,238,126,95,255,231,106,221,118,77,22,226,62,183,140,228,175,4,242,58,159,39,2,103,172,29,208,104,227,45,238,79,56,189,135,244,217,55,108,14,233,36,181,102,159,226,120,37,6,254,227,66,134,202,202,236,225,9,155,51,195,13,76,53,114,243,23,252,156,193,61,14,86,7,14,8,70,72,188,185,25,246,78,253,192,249,17,248,98,83,144,35,226,176,145,249,181,90,6,222,23,254,126,27,200,84,122,39,240,80,96,45,37,246,242,242,149,23,227,13,79,249,50,244,244,85,225,197,190,69,199,24,62,245,144,50,125,194,148,176,65,63,240,208,161,4,0,25,134,182,115,250,9,243,191,33,245,245,222,253,66,12,69,8,36,234,234,0,183,87,213,62,150,101,131,25,46,6,121,188,212,16,207,248,120,18,207,94,9,9,121,240,98,4,86,195,158,253,229,231,115,252,128,221,176,43,243,242,109,241,246,31,76,76,72,10,22,58,111,246,15,206,236,254,100,250,116,26,111,105,57,21,185,247,140,67,236,238,247,57,226,44,250,254,22,252,71,36,86,39,188,178,106,186,7,14,138,64,252,18,249,191,165,4,208,12,254,88,192,9,22,71,135,239,162,207,2,10,175,41,5,0,233,251,213,234,113,52,94,234,187,55,24,245,134,202,212,9,12,243,248,95,2,8,54,79,162,3,30,12,134,103,206,255,229,25,40,181,57,191,77,71,238,96,130,65,19,37,168,212,207,253,131,218,90,216,152,213,242,70,141,69,37,237,246,242,138,185,134,179,26,241,161,69,152,93,64,92,195,184,91,251,34,36,255,244,89,204,78,255,80,255,141,46,33,219,192,246,142,233,48,1,35,193,66,247,148,104,113,252,43,35,127,101,60,38,232,51,47,73,111,45,96,174,116,5,252,80,29,82,64,39,248,226,251,247,195,76,246,184,56,222,44,65,57,14,75,26,33,51,239,220,152,253,107,220,122,97,52,92,83,197,110,246,158,84,55,99,142,254,35,229,95,249,164,253,193,111,37,208,215,0,235,18,210,17,70,50,180,94,36,65,216,242,132,79,24,1,156,4,166,255,130,244,41,30,113,205,23,49,246,3,111,19,187,24,43,245,148,181,37,65,46,74,25,215,204,246,32,175,6,220,87,105,143,92,85,91,207,4,57,102,94,81,158,193,16,73,33,255,163,14,243,8,165,21,132,69,132,96,244,1,42,22,162,219,16,240,255,6,224,24,27,71,27,176,159,248,40,204,68,237,166,175,8,216,255,55,217,58,195,65,208,99,77,255,94,200,174,242,210,244,196,87,172,57,143,217,246,17,120,253,71,72,255,20,179,207,68,231,161,91,188,229,199,194,249,43,65,28,11,234,189,45,188,81,111,244,89,112,116,67,80,59,69,34,131,68,25,233,172,6,112,58,226,182,182,195,12,180,64,26,163,236,31,28,232,249,139,48,65,225,230,248,35,176,31,54,30,0,218,246,172,66,33,95,25,84,115,249,189,5,117,10,146,85,162,110,205,247,181,56,34,252,147,3,155,239,202,19,101,9,201,13,242,252,112,72,12,61,53,211,41,214,155,12,95,88,240,248,171,210,29,220,185,97,41,188,45,55,169,192,103,2,184,35,105,5,168,15,193,33,123,13,178,10,160,14,102,254,242,204,214,68,2,74,107,254,150,246,24,1,116,34,98,188,75,208,202,107,186,234,228,1,134,64,184,29,139,224,10,18,60,7,170,5,105,9,112,11,54,27,155,81,253,9,134,103,156,15,106,46,82,6,180,247,190,56,245,218,168,90,168,250,191,6,31,0,121,108,53,93,209,73,38,251,37,244,191,16,44,4,79,100,231,247,155,245,243,244,66,6,10,39,237,78,24,29,11,3,140,14,48,4,40,18,240,216,56,7,1,229,35,46,97,235,59,77,178,205,217,11,133,94,17,15,133,188,0,186,173,1,113,246,90,12,169,28,182,255,139,185,78,80,207,3,212,49,112,3,57,90,197,248,108,98,109,221,54,5,96,10,201,78,110,208,213,243,235,7,104,192,52,86,104,240,45,180,106,190,159,244,164,13,13,103,83,248,148,21,152,58,252,13,2,47,71,229,164,21,212,22,221,245,116,35,194,19,107,59,88,222,216,191,208,184,15,222,102,14,219,248,180,254,171,242,101,39,169,243,20,72,253,185,161,184,170,84,97,255,224,249,55,248,221,98,12,234,228,34,71,7,147,252,34,203,252,240,107,100,13,92,174,111,192,240,120,186,165,197,72,252,92,79,194,205,196,246,215,11,119,14,120,64,64,251,221,3,17,252,75,48,226,244,216,250,59,2,5,100,25,54,243,185,60,19,244,103,132,3,253,34,154,97,247,242,26,254,57,221,82,247,224,69,111,33,94,245,113,52,173,224,195,20,18,246,66,88,45,250,105,78,113,254,83,13,185,5,131,248,169,14,201,211,34,5,214,254,150,86,191,245,61,212,159,7,212,26,203,42,246,53,38,0,113,84,168,6,143,253,198,49,43,102,246,100,61,9,59,19,64,10,229,250,232,215,246,174,29,99,207,246,142,4,136,10,222,181,132,195,216,246,53,247,26,72,213,1,54,3,225,44,202,13,101,43,118,96,215,240,226,230,94,5,48,190,75,242,183,240,88,247,192,230,225,0,205,238,78,102,64,245,212,83,163,12,66,190,154,1,90,35,144,49,25,43,33,94,243,214,98,9,99,39,213,2,178,108,186,8,99,243,189,107,196,23,126,27,101,110,138,21,170,43,39,13,141,195,24,243,136,102,168,247,164,200,114,247,6,14,110,61,188,247,203,255,218,229,226,179,3,42,72,57,36,11,223,92,41,10,62,225,123,175,41,1,146,188,209,105,172,245,107,13,15,191,22,211,144,3,172,37,130,98,113,64,147,242,150,189,198,205,250,95,174,229,95,43,243,48,112,255,221,245,161,226,81,191,204,0,172,79,90,5,160,4,157,13,14,218,135,9,240,61,12,109,141,18,76,64,232,245,170,183,3,105,228,249,121,3,242,84,133,49,146,2,231,71,47,246,48,99,204,40,37,79,140,6,129,251,204,188,150,234,97,243,102,2,205,237,33,190,162,192,252,234,143,32,183,33,15,217,38,24,208,6,87,202,248,237,122,246,74,4,137,2,26,12,149,218,111,25,1,10,71,17,177,242,150,238,168,188,204,249,49,237,41,106,29,232,56,80,162,52,179,3,206,108,214,61,40,233,55,21,219,100,22,250,74,13,227,71,246,105,46,196,129,36,57,6,158,8,50,179,1,231,8,204,140,8,234,2,26,86,131,2,117,234,152,94,228,14,44,242,160,225,93,10,138,14,61,44,254,247,193,209,85,15,231,196,163,245,114,212,171,27,67,79,140,223,51,1,43,227,141,0,188,243,143,251,158,64,136,97,244,67,234,48,240,243,238,55,33,64,16,68,148,104,200,181,251,182,65,246,56,241,11,100,48,199,44,56,126,250,232,74,118,74,131,66,216,53,219,185,69,8,151,199,186,26,198,253,76,213,224,11,252,2,172,250,207,217,119,53,79,189,42,93,112,253,49,12,60,86,87,81,103,199,13,17,149,18,110,4,208,92,237,13,134,235,20,3,83,11,77,2,26,51,83,201,159,212,34,1,43,233,100,106,209,65,21,253,7,6,154,220,248,214,77,249,190,111,161,186,199,241,125,64,254,197,42,210,86,101,251,9,32,46,219,27,187,238,141,227,1,246,153,8,167,222,65,255,217,25,70,7,63,218,150,212,22,206,70,255,180,226,252,247,221,90,102,52,34,35,236,241,236,32,36,86,213,37,141,226,81,1,121,247,193,10,4,232,135,64,101,106,200,69,137,2,110,31,220,88,77,220,73,206,178,231,211,36,207,207,11,250,194,71,209,253,64,255,77,84,10,110,131,222,112,48,104,8,232,5,160,184,146,238,193,245,0,26,7,255,202,24,83,24,102,22,223,14,175,79,198,86,70,87,217,254,4,60,125,8,57,242,8,46,85,244,150,241,164,251,21,53,145,57,171,74,138,68,106,11,121,14,223,234,135,22,164,93,160,3,165,34,251,17,72,206,226,97,124,220,155,3,135,2,245,33,34,254,87,100,50,72,208,34,19,0,42,217,146,189,84,233,45,97,154,66,86,243,12,64,173,58,203,247,43,11,232,40,217,42,116,182,93,252,224,92,22,5,58,34,147,197,166,194,129,187,85,191,188,246,6,234,142,8,186,13,255,242,1,61,123,244,243,2,61,248,150,59,175,242,65,58,152,247,232,100,67,96,255,33,24,243,132,36,145,99,62,95,76,13,29,14,75,6,217,85,167,36,152,77,76,3,126,202,27,72,210,83,2,202,54,217,168,3,203,233,128,248,175,40,128,206,216,90,59,6,236,239,252,50,114,208,35,1,238,84,6,14,65,63,54,56,137,241,109,42,134,62,28,1,111,16,168,180,7,67,89,87,195,230,251,25,200,233,240,247,59,11,29,109,25,6,187,236,81,188,57,177,93,71,88,207,243,242,208,3,208,78,165,196,12,246,102,62,70,3,243,252},
  {162,65,151,2,136,249,204,236,71,66,186,0,32,72,142,254,121,246,173,4,102,10,92,63,73,11,149,21,34,21,124,106,241,79,95,245,102,79,131,1,98,229,44,25,240,79,117,77,142,81,127,195,193,249,198,19,194,107,140,3,223,178,14,23,212,86,200,215,180,89,175,4,29,32,254,88,3,110,243,90,30,233,16,81,238,240,252,245,72,251,100,0,80,14,236,74,117,59,235,68,160,249,188,254,231,52,107,106,55,99,160,216,239,9,74,73,234,200,223,8,35,29,59,239,31,75,92,15,68,2,214,59,235,5,119,95,163,59,203,252,155,12,242,47,14,93,216,242,117,75,26,217,97,222,211,250,20,245,99,10,69,54,168,188,15,3,158,226,202,64,16,234,217,56,160,240,147,21,168,106,119,30,241,184,110,249,33,80,111,235,239,67,124,201,150,67,12,217,109,7,139,247,43,6,232,233,68,251,95,235,231,0,238,1,35,34,165,34,5,68,120,255,213,40,37,178,150,249,94,198,183,4,90,247,71,255,59,13,72,243,136,239,227,10,150,227,124,18,84,184,225,181,205,92,2,186,114,28,20,47,223,244,249,86,206,15,76,250,117,83,94,189,50,112,222,221,127,75,16,10,63,95,85,5,93,174,254,232,18,98,202,1,127,201,99,7,196,46,43,49,23,229,180,75,64,67,12,68,118,218,26,84,240,33,20,224,79,75,104,245,208,226,104,53,197,242,82,54,61,78,54,5,37,90,225,207,133,84,97,4,219,92,4,36,5,225,67,18,173,33,94,229,6,244,235,194,231,10,152,108,77,76,40,57,55,184,41,63,181,211,58,186,197,200,199,185,235,26,243,0,224,255,104,29,194,255,212,240,229,61,108,212,92,14,136,246,18,175,246,9,81,202,183,98,170,191,62,94,173,14,126,70,76,102,179,0,140,71,157,12,51,88,182,231,254,252,41,241,0,219,242,205,164,245,29,27,71,250,137,251,225,176,25,248,14,86,1,216,128,70,2,248,15,7,88,252,176,6,36,92,155,253,254,59,32,73,101,54,88,61,8,33,69,217,115,11,74,18,148,235,15,110,120,57,113,4,155,62,28,198,203,248,197,224,114,13,72,51,191,194,114,245,211,95,40,14,148,192,141,1,128,96,175,244,112,14,218,47,94,251,186,98,166,44,117,36,221,251,226,246,193,34,5,8,118,46,215,11,32,43,230,208,123,245,21,14,201,39,236,7,138,42,248,185,1,7,106,237,206,48,254,179,180,66,1,221,3,104,235,196,208,221,23,248,195,2,150,13,25,4,121,204,219,215,159,4,75,242,251,246,216,248,194,1,208,250,109,104,92,174,235,0,214,84,186,19,1,98,243,245,192,189,225,26,214,243,83,0,58,232,114,254,138,177,22,47,78,57,80,2,11,249,60,89,71,246,211,80,227,108,33,180,184,0,196,176,230,243,19,92,18,30,169,255,81,207,99,9,162,28,117,106,226,13,97,3,30,87,76,92,99,14,62,254,154,47,178,247,18,224,199,246,90,19,227,10,186,249,228,251,238,217,220,104,253,204,146,10,153,11,255,84,211,242,149,243,131,27,234,246,132,95,127,4,196,213,100,252,136,254,220,69,41,231,157,99,138,48,55,185,231,87,173,255,123,0,141,10,163,63,203,248,142,18,227,104,200,3,232,249,174,254,116,180,141,95,177,57,22,107,215,255,208,9,166,5,81,93,0,79,18,0,85,12,163,40,170,54,100,82,40,0,9,103,240,94,87,193,65,94,205,52,181,241,252,229,176,244,199,86,69,111,230,90,1,230,124,74,60,254,138,88,184,245,215,72,215,70,106,245,139,40,72,3,239,28,2,17,144,90,20,254,84,244,53,232,131,9,204,249,61,36,234,217,233,71,249,10,147,223,67,74,162,20,254,217,195,241,33,216,206,73,36,20,167,220,159,35,143,246,210,210,62,252,207,10,80,251,29,14,25,191,163,246,183,255,249,53,245,177,202,253,213,1,75,13,128,241,177,205,43,83,140,246,10,28,185,179,113,95,152,198,32,211,151,56,132,37,170,70,84,8,183,185,103,34,11,21,91,6,233,87,21,23,100,254,29,2,238,110,29,64,89,237,158,248,13,106,63,33,42,183,98,247,208,248,21,13,79,65,138,88,159,249,13,242,74,55,73,106,193,46,144,181,208,9,63,71,243,96,190,1,25,190,106,45,40,192,12,175,23,7,85,110,51,188,217,99,48,184,251,75,26,213,216,97,178,48,125,47,163,180,240,176,195,12,152,253,42,227,72,91,202,58,36,210,80,9,62,214,191,183,32,193,14,8,89,14,4,200,181,208,6,244,255,250,74,246,76,59,104,91,145,0,144,63,37,185,147,248,72,243,203,11,195,177,180,89,166,41,63,75,40,92,167,237,250,196,54,24,23,23,3,8,76,10,48,192,52,196,104,28,32,103,26,196,230,248,19,249,156,211,177,251,5,24,187,13,190,14,107,53,86,250,205,243,154,243,217,248,42,190,251,93,152,6,45,254,192,5,108,255,104,13,232,12,33,216,5,22,37,25,24,52,144,56,199,99,112,54,14,241,225,250,81,109,162,2,209,55,192,246,101,52,234,3,177,110,201,202,191,249,83,40,75,11,94,28,172,88,18,235,186,8,143,242,154,203,9,33,102,85,162,35,178,239,155,8,201,12,48,5,194,208,224,251,202,14,110,24,205,78,10,179,82,184,40,52,44,175,132,13,184,91,10,6,30,99,124,191,239,250,214,29,93,29,176,240,180,46,254,209,112,91,62,13,229,24,168,55,28,87,161,27,50,240,61,21,10,96,253,93,188,11,155,58,100,219,6,6,125,242,212,8,23,63,83,104,8,188,44,254,162,253,174,83,143,23,255,97,134,90,236,195,255,4,82,13,211,51,51,250,188,0,64,22,94,252,14,224,194,98,48,245,141,97,183,213,78,9,219,3,149,73,17,17,95,0,66,253,33,19,242,34,166,206,89,26,43,50,92,4,163,61,148,234,3,245,128,35,123,30,247,93,40,221,59,199,28,0,81,6,4,57,217,51,100,250,117,31,60,176,146,3,196,78,202,87,61,102,182,253,155,65,251,3,57,62,14,80,117,43,138,57,212,56,166,175,190,212,62,1,246,10,233,43,30,249,135,246,233,230,33,6,183,254,168,250,204,231,225,45,184,43,165,253,243,193,70,183,199,106,30,49,206,103,91,2,28,5,42,41,242,11,188,25,158,95,187,99,8,19,254,110,255,105,84,242,229,22,158,53,157,201,11,251,88,217,248,110,207,82,14,76,214,78,230,245,227,186,81,9,181,45,244,0,128,100,200,233,73,223,166,43,188,6,126,93,59,222,51,46,194,227,172,2,253,253,143,104,59,34,247,3,63,106,75,2,32,12,108,94,41,26,15,9,144,2,243,36,67,65,214,249,188,6,145,58,50,39,38,4,34,212,204,20,15,37,213,2,27,23,218,217,205,194,57,246,116,224,171,251,152,235,124,214,125,102,136,101,203,81,212,55,147,239,90,244,159,32,110,63,43,253,9,191,50,177,185,252,147,67,173,214,171,243,66,179,58,6,224,108,187,41,159,238,86,243,34,37,154,19,120,25,238,251,216,59,164,10,129,72,253,88,138,89,213,242,142,182,189,13,91,88,135,50,109,41,165,78,168,25,188,14,175,195,116,205,77,180,90,230,246,80,241,53,229,207,203,46,8,250,157,237,242,19,107,254,251,238,86,201,209,49,198,249,214,242,187,0,162,25,214,6,25,182,108,248,148,250,78,221,23,14,118,29,238,176,1,4,250,221,219,107,62,56,170,251,88,97,177,184,121,226,25,95,150,220,40,210,108,183,34,8,168,102,11,103,52,13,105,216,61,87,146,36,66,109,239,209,208,81,1,224,50,193,142,247,213,201,33,252,185,247,167,177,120,190,184,204,216,107,222,11,180,98,52,224,16,27,227,186,10,232,37,191,245,241,199,85,211,49,87,87,85,73,126,255,80,213,243,88,48,255,234,245,4,198,77,174,128,250,2,185,246,215,78,201,164,252,191,104,5,106,163,253,124,91,233,240,13,185,132,239,171,81,158,9,235,50,49,27,69,28,198,28,219,10,90,36,98,179,253,9,7,245,246,87,133,242,195,254,45,246,79,205,169,76,225,3,167,3,107,56,134,92,131,255,143,60,239,59,238,223,237,249,22,65,47,251,108,20,101,43,61,239,0,101,185,231,81,79,176,183,133,61,241,218,46,10,51,80,118,5,219,218,218,62,114,78,237,12,174,34,50,100,202,251,44,9,211,13,65,38,178,227,238,253,64,178,241,4,182,186,234,195,141,30,206,94,36,232,124,248,1,12,57,47,239,11,74,45,156,34,132,206,213,251,86,188,217,13,144,36,153,50,23,30,91,110,181,254,237,243,10,1,29,244,59,31,147,102,206,89,197,75,81,51,13,61,140,28,53,48,249,191,23,244,57,32,93,13,109,174,40,3,234,3,224,200,174,2,141,21,207,10,253,199,35,65,181,8,122,11,119,4,83,179,132,2,97,3,91,9,160,89,253,30,229,4,215,98,131,52,84,46,113,253,192,219,146,3,32,212,186,252,136,239,167,4,247,186,146,0,145,83,83,192,87,5,154,35,161,240,226,241,114,247,187,184,102,14,51,7,254,203,91,17,109,52,221,13,44,110,115,77,117,19,236,246,209,209,51,183,163,224,98,236,202,18,226,196,244,86,136,201,95,81,193,9,198,110,233,200,145,233,53,186,228,30,108,13,74,11,98,109,215,70,120,67,208,107,21,11,27,110,0,81,90,1,216,99,135,214,86,77,207,3,87,94,61,252,40,228,61,8,91,205,97,5,75,20,165,239,95,24,192,245,182,198,125,111,84,182,47,219,16,246,114,233,178,234,62,60,135,14,195,247,210,39,209,246,120,9,121,100,113,231,221,241,116,16,163,10,64,14,216,210,61,251,173,37,255,11,48,193,5,84,232,251,252,183,9,193,83,94,173,177,97,43,122,3,31,98,123,67,93,175,39,30,78,88,255,246,224,75,85,3,169,110,168,90,119,189,211,247,25,4,172,185,252,5,0,214,12,78,184,213,45,198,239,82,119,194,154,108,196,254,147,103,225,25,254,236,50,244,7,77,57,195,49,64,69,9,210,255,55,212,0,1,146,232,52,214,205,0,229,61,5,9,56,8,24,182,54,21,223,43,28,183,197,88,123,197,247,243,220,5,143,254,253,252,114,179,143,241,220,180,119,191,92,226,59,255,81,4,234,5,15,83,195,241,170,79,249,52,149,230,218,61,122,227,114,251,68,71,137,243,235,211,22,29,193,177,105,25,200,241,152,8,185,64,189,233,183,32,181,19,60,15,244,55,110,87,213,238,10,10,5,28,179,199,193,225,218,178,102,33,236,1,158,100,145,57,3,56,79,253,108,209,248,22,70,202,18,208,184,251,43,79,186,81,213,251,4,112,145,248,195,41,167,6,125,107,191,209,186,217,198,248,190,21,205,65,119,40,153,245,39,95,164,7,143,245,6,255,133,12,241,39,41,233,7,54,225,249,124,1,178,240,111,83,42,98,179,5,122,112,190,5,4,241,128,21,204,12,225,234,184,185,119,2,225,107,38,106,248,254,236,184,150,53,115,43,3,97,0,220,47,14,251,238,126,181,36,0,166,69,232,7,95,31,248,1,71,213,52,251,157,253,169,254,66,8},
} ;

static const unsigned char precomputed_core_scale3sntrup1277_n[precomputed_core_scale3sntrup1277_NUM][crypto_core_INPUTBYTES] = {
  {197,246,88,212,100,232,215,215,126,223,191,207,240,178,158,134,118,109,96,182,97,35,174,248,177,244,202,163,21,229,20,178,58,73,165,208,129,178,223,221,53,85,3,246,87,234,74,152,231,222,242,73,200,26,54,15,239,162,30,127,178,146,65,65,143,126,84,20,92,48,97,128,49,135,156,233,138,253,31,150,176,108,222,27,177,3,46,69,214,131,226,108,24,57,209,27,181,2,58,43,35,182,215,96,218,147,206,197,133,175,23,132,179,58,218,102,138,26,6,59,226,118,190,48,168,94,45,148,78,16,112,239,40,41,131,16,40,5,133,148,60,55,94,8,72,2,3,39,75,189,42,251,242,125,23,157,197,149,243,12,97,219,161,75,207,114,138,157,62,249,225,72,9,196,45,113,19,158,194,240,67,161,105,7,167,95,120,199,130,162,58,57,57,37,135,222,75,92,114,23,146,255,113,53,142,61,131,221,137,199,163,213,128,9,108,11,192,172,200,234,245,10,107,5,77,86,50,46,187,59,14,248,149,186,20,61,42,246,1,141,195,82,73,63,123,97,200,47,154,191,179,12,108,31,93,140,1,176,146,58,56,243,69,203,121,45,92,155,100,109,77,236,15,126,145,184,108,184,162,218,238,3,129,141,181,240,99,194,1,136,121,84,27,81,89,147,87,8,184,94,44,26,145,173,215,185,224,199,177,197,51,10,4,48,126,239,65,187,144,253,145,23,22,46,150,229,151,220,167,9,104,59,19,109,45,3,158,75,222,251,245,187,4,147,13,35,49,69,82,187,242,143,244,6,25,36,122,253,82,112,26,98,222,202,252,236,207,89,67,236,33,12,255,197,94,71,23,80,178,23,38,29,138,245,77,36,128,199,40,34,178,110,178,39,162,110,5,134,205,239,143,89,239,49,148,70,17,201,198,183,239,188,48,210,56,38,219,141,35,236,39,10,117,56,233,186,162,192,100,25,191,231,194,12,8,1,132,24,82,241,53,182,203,16,185,34,20,201,221,47,1,176,116,152,101,53,59,61,111,39,231,90,170,184,173,37,247,74,57,57,172,151,183,101,166,252,240,6,136,138,53,115,78,54,37,188,211,124,181,112,20,126,89,181,235,101,149,93,61,140,153,252,185,126,189,229,9,252,197,152,124,126,196,127,122,13,216,145,83,169,106,199,107,221,132,152,40,80,70,30,211,207,100,197,171,56,32,147,94,140,220,185,198,175,233,136,172,173,197,226,154,196,158,101,28,52,159,51,78,169,150,122,25,200,74,67,58,17,75,191,143,206,94,190,8,254,156,13,100,228,19,181,176,101,30,39,37,122,42,16,10,56,212,9,152,250,11,243,47,35,123,151,218,211,47,71,76,239,42,4,252,35,9,195,84,226,250,9,109,6,59,17,208,118,11,142,153,32,25,42,208,218,4,81,254,42,30,121,180,235,231,161,51,243,178,4,243,52,114,67,228,82,139,220,107,170,148,194,99,253,91,74,61,232,55,61,2,233,136,192,126,213,6,22,196,133,243,27,213,9,116,113,149,39,130,134,112,48,60,146,209,196,178,231,40,129,163,56,21,219,59,135,107,248,100,82,26,11,219,207,177,145,226,88,241,222,237,6,138,108,249,113,204,162,191,106,9,218,167,17,0,250,237,60,252,223,225,99,199,163,111,109,185,210,49,217,254,189,28,109,63,255,212,32,250,226,235,152,1,183,203,100,162,42,64,223,66,237,46,226,124,60,36,240,56,116,196,223,34,136,6,85,122,15,231,199,33,230,248,228,177,71,154,238,25,149,149,27,34,177,20,104,233,215,173,131,89,36,226,42,125,123,29,161,185,189,238,211,197,49,11,111,43,203,41,141,251,58,19,17,188,105,142,81,115,115,82,184,117,137,206,57,205,168,162,215,74,191,63,159,59,205,143,128,182,244,150,23,197,190,10,180,144,229,41,45,86,131,232,200,237,131,17,28,209,3,235,210,157,129,115,74,72,255,12,151,15,217,189,88,120,69,36,93,228,39,161,180,117,102,117,59,224,70,231,85,26,164,159,224,58,177,24,80,107,94,231,199,69,111,147,104,84,31,190,86,30,242,1,243,165,156,154,16,40,238,126,142,210,97,179,82,17,2,149,162,147,246,156,155,135,52,33,161,113,251,71,148,72,254,251,251,65,1,169,45,108,60,208,4,168,152,181,81,192,111,210,238,99,117,5,176,214,173,17,28,65,21,39,105,81,70,134,233,194,191,181,176,250,73,72,247,233,142,113,80,32,238,139,43,115,156,77,239,77,202,144,215,136,175,27,0,223,136,183,129,135,106,232,117,72,85,9,47,119,120,204,203,132,175,112,96,171,33,221,232,105,255,193,143,147,221,110,143,69,252,230,40,163,147,117,219,75,157,234,216,213,42,80,250,158,77,165,69,81,147,250,1,13,55,249,21,238,91,7,222,109,156,123,211,29,45,162,116,94,67,207,130,238,153,50,34,112,166,107,247,170,90,71,94,15,83,104,34,231,83,145,105,146,127,93,228,99,54,145,182,250,136,22,83,32,90,39,72,253,142,141,182,202,174,209,227,41,221,112,234,113,158,198,222,42,16,246,245,57,203,209,30,124,234,174,206,202,9,119,195,19,147,100,234,75,236,120,60,49,102,157,198,229,90,36,100,181,27,117,218,94,162,126,113,54,71,211,32,91,81,136,11,102,77,223,252,137,31,60,10,89,171,98,24,56,119,72,201,101,52,17,74,176,95,129,9,48,48,42,143,241,94,207,114,29,148,46,243,191,141,39,132,239,142,161,96,192,98,1,193,208,174,47,160,204,24,205,98,218,40,128,78,18,144,206,207,54,48,222,24,86,26,123,207,7,44,43,232,214,137,51,143,124,234,13,247,136,30,91,40,46,15,82,4,254,218,10,211,103,48,247,0,108,229,4,157,67,129,240,66,103,110,116,126,115,114,20,24,231,3,57,181,10,22,71,115,6,250,56,167,198,21,252,74,196,28,244,230,252,14,19,144,4,100,27,183,23,114,151,157,226,51,233,52,78,136,188,237,121,80,38,65,175,245,213,249,194,183,96,202,229,86,249,81,4,12,78,59,187,94,33,239,248,15,132,224,101,207,193,85,235,48,162,203,165,214,95,128,187,219,135,102,186,73,107,116,83,11,213,19,50,236,64,232,223,186,236,105,220,246,209,135,55,195,233,30,247,48,18,17,86,106,148,166,29,151,1,216,233,118,201,198,131,121,10,130,188,47,132,89,7,132,103,197,123,9,226,86,140,244,147,118,27,32,104,172,37,182,190,60,199,119,169,11,227,104,229,173,215,54,216,148,172,247,151,187,125,246,20,55,56,63,123,19,6,155,46,223,91,32,102,59,105,69,157,59,210,66,105,74,228,138,118,128,104,35,38,148,151,24,182,46,135,31,172,232,10,1,171,234,92,126,39,148,167,140,92,24,109,178,76,244,118,128,246,246,213,148,24,41,177,228,11,51,152,64,206,211,69,85,104,228,34,49,127,240,202,224,199,250,19,50,57,245,70,135,235,119,185,209,209,253,176,130,192,243,125,14,242,126,31,249,99,157,108,16,26,107,233,10,223,60,220,91,172,82,144,248,128,196,39,124,52,165,21,169,249,223,19,176,173,203,157,88,208,174,114,36,7,78,2,163,31,75,54,200,236,92,84,92,88,86,38,161,3,147,240,16,42,120,74,86,157,119,204,245,145,202,81,60,78,129,11,87,184,210,249,147,98,183,229,190,79,67,132,40,43,184,163,202,63,243,78,190,0,190,135,167,195,161,67,70,180,13,192,168,110,176,43,135,168,223,86,178,90,192,210,17,235,49,178,53,209,88,91,142,254,192,27,62,251,127,132,131,93,14,13,246,62,155,120,168,62,21,199,246,107,136,209,206,66,115,187,190,198,40,220,232,98,134,111,147,97,36,55,29,16,205,200,24,56,7,121,153,76,118,74,64,148,11,170,245,248,14,99,114,254,253,192,185,7,16,103,249,159,26,94,71,89,202,49,101,23,14,217,142,208,140,225,191,186,9,130,208,155,122,13,200,139,158,213,241,169,198,12,248,51,111,218,71,171,103,224,144,167,217,38,202,223,20,237,235,95,160,225,39,111,42,126,22,241,184,178,89,215,23,30,141,160,39,108,139,108,1,148,75,157,156,255,209,157,129,102,27,59,142,75,35,236,252,96,31,87,216,93,8,170,35,203,83,14,75,232,54,129,219,101,217,97,3,30,89,245,255,210,43,31,249,71,87,167,57,250,55,40,131,228,107,192,236,148,249,51,119,52,199,217,134,85,4,55,122,66,103,20,109,246,239,221,210,15,232,52,248,76,235,80,122,4,152,122,63,90,88,226,20,235,213,247,9,68,99,66,164,49,8,110,141,45,182,120,150,13,178,163,161,213,45,207,5,39,169,86,233,194,156,44,166,77,202,181,51,28,49,76,235,209,211,151,154,130,103,199,179,230,194,198,207,37,207,135,187,112,254,135,197,237,114,213,9,92,63,35,134,235,219,194,215,239,198,26,182,157,130,201,124,28,22,84,243,225,15,67,27,37,70,255,181,175,224,99,188,230,244,38,62,2,112,12,64,166,102,86,202,202,193,90,201,88,7,5,111,85,235,245,116,255,52,133,15,6,130,214,239,213,223,194,48,31,129,107,136,251,149,37,41,107,212,39,10,108,186,133,40,178,119,139,50,14,202,169,179,116,243,77,210,106,144,249,196,128,19,239,55,249,226,68,46,214,147,35,226,76,252,146,125,131,55,82,29,239,82,40,249,109,187,98,222,205,138,173,209,230,222,156,192,240,103,156,148,152,250,136,2,103,78,192,174,206,11,185,19,193,137,68,75,188,158,22,122,157,181,226,99,149,120,143,235,109,85,56,25,56,42,75,46,251,2,14,255,35,34,70,150,250,36,31,117,44,60,122,182,88,186,51,156,211,251,200,23,235,170,58,55,163,199,57,88,13,109,2,41,80,84,104,192,106,106,185,115,92,11,128,101,34,207,2,242,114,164,104,203,58,41,157,54,235,220,222,126,125,40,147,69,68,173,55,4,68,161,100,142,15,18,204,187,33,51,68,122,75,63,98,84,202,150,58,111,32,187,0,216,194,103,235,141,105,251,107,31,63,85,177,156,41,244,182,171,129,156,151,30,96,144,72,16,21,0,100,75,36,242,10,62,134,247,59,203,67,125,214,55,109,36,11,202,143,89,181,174,207,82,68,240,46,111,20,24,48,181,227,147,223,78,253,246,193,136,243,123,131,99,177,201,144,2,248,129,19,42,168,10,232,75,240,60,111,233,245,6,109,102,88,45,156,222,183,65,234,156,130,112,232,188,144,57,66,185,43,217,216,121,59,231,127,13,56,202,18,77,222,125,188,77,245,6,50,181,72,84,207,137,74,88,187,116,224,151,206,3,130,58,167,250,54,0,120,0,217,165,136,190,195,155,40,33,72,177,211,141,13,226,178,175,95,174,94,92,65,58,34,117,16,160,44,202,197,12,28,227,129,235,170,42,50,196,88,89,119,86,99,247,77,172,181,246,164,216,116,199,157,47,34,59,199,204,248,177,221,192,97,230,116,91,135,50,78,59,239,243,165,51,143,31,138,234,124,132,122,3,7,62,30,33,185,93,145,131,16,237,91,146,247,195,172,219,36,81,64,38,101,167,199,35,204,151,96,225,97,202,62,236,63,204,58,88,236,84,21,117,217,37,219,47,38,183,68,143},
  {157,58,87,181,150,152,135,132,247,64,100,172,62,213,107,61,58,161,80,225,14,102,27,235,51,33,195,191,213,48,167,254,195,225,42,221,19,224,208,155,166,5,134,32,63,237,228,42,9,47,185,94,26,212,166,230,228,17,4,5,212,193,141,204,12,92,136,42,122,2,206,171,147,145,103,248,147,244,41,53,37,67,80,108,72,223,84,224,162,225,28,86,24,27,183,49,54,35,188,71,60,225,130,211,65,30,49,246,109,99,237,223,207,180,151,51,47,94,140,142,14,219,100,122,54,113,101,64,253,141,213,75,123,116,31,124,157,143,113,143,203,118,214,55,9,16,245,65,231,26,187,233,51,245,163,26,150,229,116,204,17,153,45,47,77,230,16,72,150,21,187,254,137,35,218,9,60,148,0,210,63,214,22,85,138,86,88,161,173,241,251,22,216,141,101,20,42,50,191,134,14,52,205,197,140,147,172,191,55,72,165,106,20,226,90,159,100,116,108,183,84,219,157,68,89,249,87,215,96,30,29,119,202,171,201,6,141,214,207,53,109,136,25,3,37,239,30,202,238,118,249,59,102,230,62,164,234,106,86,52,174,244,1,231,185,8,122,255,9,72,67,186,120,122,201,100,53,61,140,6,59,250,202,33,74,230,153,106,156,164,254,165,170,224,66,40,189,242,161,238,84,10,178,80,225,133,170,247,197,74,76,166,174,89,42,125,146,178,249,84,143,167,64,44,229,3,94,64,92,15,86,138,173,29,176,52,2,70,105,150,221,83,203,237,217,254,98,196,68,99,52,164,211,129,137,243,217,217,84,75,54,125,14,249,143,89,34,150,78,113,185,45,107,70,87,108,136,134,227,156,164,8,36,96,65,116,54,87,84,77,161,92,69,139,112,179,167,74,135,39,117,83,98,249,43,240,238,251,133,46,35,65,203,42,202,242,3,195,120,56,76,251,204,76,79,185,15,244,194,101,233,57,20,201,205,229,213,99,164,225,233,99,167,170,37,23,87,100,219,54,211,69,164,95,177,239,176,199,191,211,57,231,255,76,166,23,75,234,254,64,180,189,79,88,66,80,113,248,6,149,87,102,142,149,38,254,218,168,24,229,247,51,235,4,89,150,249,104,224,21,83,76,185,156,214,81,40,146,126,174,35,215,247,36,218,43,22,200,57,229,85,225,123,161,154,187,113,6,35,103,203,33,175,92,169,90,213,194,234,214,89,54,133,25,2,116,34,235,149,123,178,0,229,82,246,8,213,109,221,7,12,136,209,145,147,164,160,111,74,158,50,202,118,150,96,166,153,137,132,29,27,105,228,100,122,114,167,175,175,32,245,35,233,254,213,164,250,225,101,126,97,254,122,111,130,70,145,45,155,29,115,145,126,12,15,161,85,22,132,210,234,194,183,194,166,204,165,135,123,206,30,154,40,138,141,127,63,2,177,73,147,209,25,93,69,65,57,160,42,182,168,132,10,187,74,67,184,104,87,213,219,186,28,162,250,31,60,153,161,244,170,118,222,144,12,190,231,239,165,59,210,169,71,9,90,204,97,231,226,149,185,20,163,213,78,60,131,222,232,116,56,4,201,171,213,184,246,55,134,218,201,82,47,73,102,182,124,200,63,24,201,235,189,125,95,152,28,14,37,53,100,9,15,93,102,205,167,174,76,24,82,78,105,202,158,244,110,32,21,116,25,6,85,134,53,136,34,138,231,175,146,28,189,79,190,166,117,46,96,176,81,5,41,232,28,229,210,196,78,254,112,113,30,165,106,89,56,204,55,185,123,208,185,82,7,211,85,64,157,54,254,115,174,69,28,56,206,144,253,211,168,203,62,78,31,68,220,19,104,148,29,222,150,88,216,117,118,69,148,244,178,203,236,143,9,118,42,136,105,197,91,86,112,89,62,135,27,164,73,221,114,230,125,218,176,44,229,36,33,77,230,57,224,250,250,88,5,12,229,181,191,80,13,113,193,77,150,170,164,136,68,98,59,132,150,140,206,77,96,53,253,92,225,62,35,110,196,91,129,64,8,20,179,32,129,2,124,210,82,221,167,244,209,240,124,8,58,138,166,12,206,224,167,226,63,31,47,24,245,215,56,80,182,198,42,115,157,100,154,66,121,59,121,94,44,217,20,123,162,230,151,20,111,210,31,198,19,225,250,19,109,77,224,191,22,142,11,107,40,146,34,65,4,142,221,42,195,137,236,220,161,50,154,244,27,172,200,67,62,45,246,34,95,51,5,117,133,38,12,26,4,208,175,136,142,237,243,234,42,108,141,138,128,208,64,50,247,133,45,99,151,222,215,5,233,218,97,66,241,55,207,164,143,38,133,154,174,51,57,38,74,72,96,199,106,64,228,85,109,211,172,216,119,9,34,123,150,119,156,254,99,61,82,75,219,10,8,121,180,119,130,201,180,75,54,223,1,141,51,45,83,122,239,2,223,162,158,127,160,79,52,189,182,13,146,60,76,249,237,8,59,63,46,77,176,107,117,128,196,159,155,201,89,202,67,109,55,162,204,42,49,20,122,202,79,93,232,170,178,50,240,244,18,106,186,146,42,131,162,179,55,67,34,116,151,101,191,16,166,106,198,89,203,153,18,144,73,70,220,173,245,124,14,199,146,75,118,102,197,18,77,185,95,225,92,52,131,105,63,19,32,241,91,21,34,125,70,157,21,19,162,109,29,148,159,212,167,230,245,224,221,216,202,117,2,30,141,212,242,200,29,190,238,189,135,127,54,195,57,231,5,109,187,86,16,85,55,27,121,115,72,126,9,231,114,51,27,254,247,58,5,149,189,203,250,158,119,199,232,80,95,63,5,61,67,113,196,135,25,235,88,191,241,132,28,156,235,202,28,105,38,129,65,78,163,136,109,44,127,22,132,26,145,55,92,191,125,4,153,143,99,163,75,10,4,161,187,232,0,43,36,243,253,209,93,205,196,70,134,29,156,146,43,79,51,49,214,220,15,255,121,121,234,1,188,60,233,220,169,23,179,110,20,120,72,15,155,76,168,5,34,144,172,194,75,14,149,44,81,181,74,48,226,113,248,189,34,44,151,80,151,225,208,190,175,178,214,16,0,254,72,209,126,200,141,107,174,22,55,29,3,189,46,248,164,96,192,106,58,77,12,98,191,34,168,20,10,127,142,252,98,80,3,1,148,39,3,204,242,24,145,221,52,13,214,243,199,8,24,129,60,7,195,71,159,103,15,245,122,89,115,183,26,11,125,254,155,214,129,1,210,74,237,108,113,19,70,119,136,94,87,74,101,83,42,3,254,234,181,136,241,209,175,2,219,102,255,73,245,45,187,66,231,164,252,15,92,197,220,49,181,34,110,197,161,57,117,53,154,19,46,108,72,116,49,252,203,25,216,210,26,67,109,201,186,142,18,183,120,165,92,202,31,106,55,228,243,162,56,131,95,245,90,94,177,237,130,189,207,19,49,232,72,216,23,166,117,52,34,40,69,122,104,43,76,242,124,82,37,138,59,137,210,237,191,238,34,104,130,59,106,190,201,2,181,26,16,221,202,25,154,104,99,79,147,213,171,56,76,90,46,43,156,146,5,118,31,117,29,39,168,21,106,212,150,73,7,172,233,234,215,56,61,165,106,117,132,111,230,199,102,247,221,194,34,39,114,49,156,90,57,148,119,66,60,121,183,187,240,254,166,154,110,119,212,75,1,91,165,160,122,227,254,145,23,73,16,147,224,124,114,29,110,13,73,150,164,133,193,208,56,45,93,71,77,33,220,105,246,99,252,82,199,106,229,63,178,92,50,176,148,125,48,62,54,157,79,67,14,3,89,165,141,139,154,65,136,89,252,241,242,238,13,254,146,18,108,204,199,64,125,21,177,74,90,163,108,220,0,119,46,255,13,78,16,65,2,111,142,36,88,182,56,90,51,169,112,139,19,133,143,135,41,122,251,58,213,13,42,241,149,146,27,158,27,119,50,182,121,79,85,154,94,58,241,169,199,197,72,195,237,105,79,188,162,103,140,154,12,25,120,63,216,246,35,101,31,59,130,92,126,20,252,184,128,244,67,241,155,176,4,201,97,144,147,239,145,187,123,153,81,123,128,151,23,187,183,10,147,190,27,39,60,238,51,130,178,133,185,58,198,73,228,65,187,101,213,16,150,112,15,91,180,244,90,60,177,13,185,157,109,216,168,197,101,21,95,199,59,208,62,5,54,189,221,177,213,147,14,139,41,240,85,251,62,229,18,154,2,17,44,21,230,21,57,217,81,253,121,77,149,202,46,65,14,150,69,123,24,179,33,148,242,104,198,186,20,50,4,193,230,224,61,140,147,32,105,0,183,207,202,102,197,146,232,126,221,239,99,206,52,253,157,14,192,176,195,53,217,172,223,140,229,38,67,144,78,171,127,0,227,131,161,133,109,228,48,133,82,231,72,105,189,166,46,171,87,89,101,62,25,219,211,251,206,187,143,12,81,11,135,120,129,100,52,217,165,81,94,18,67,218,8,55,79,24,13,145,51,13,244,173,162,117,109,113,138,200,188,114,68,145,150,182,21,64,232,168,131,69,207,231,228,142,123,39,24,243,142,245,135,116,213,18,13,74,118,95,141,123,202,96,125,124,69,34,0,97,90,234,246,11,177,142,158,14,19,192,151,212,242,206,137,241,228,117,233,59,170,237,105,189,167,39,78,126,158,153,127,75,10,76,81,40,60,139,178,40,93,90,87,91,29,152,233,188,12,117,198,189,28,69,241,136,220,109,175,28,91,125,194,238,175,3,173,97,183,125,190,77,117,99,47,6,204,73,233,78,157,248,182,88,248,230,157,58,232,115,100,228,22,237,161,201,56,172,93,178,213,86,190,73,13,213,122,178,211,185,132,238,13,52,231,129,39,100,45,31,217,44,27,194,138,56,32,118,212,35,242,123,114,60,34,148,95,223,100,223,27,62,93,8,90,103,245,119,4,249,83,84,249,54,114,119,195,249,30,227,71,241,230,1,139,144,237,162,209,21,29,221,195,213,84,78,217,115,120,173,193,35,9,55,25,129,57,79,70,223,192,144,146,205,104,115,100,117,61,87,188,11,134,86,178,88,162,247,152,0,253,13,42,155,121,218,67,113,97,38,245,242,207,87,168,130,101,30,224,81,167,218,37,57,250,52,169,155,241,100,90,37,140,205,215,147,94,211,46,68,168,220,19,182,174,49,56,159,95,76,153,46,55,165,89,247,144,111,17,161,11,166,61,135,142,52,147,124,139,85,152,45,197,90,195,221,139,120,233,164,119,193,28,31,187,12,15,68,165,152,116,45,97,119,57,166,12,92,111,211,152,184,14,240,153,140,58,198,23,21,51,15,45,206,187,125,213,98,170,84,131,154,45,185,226,105,145,236,218,153,130,85,53,231,48,90,230,218,227,144,5,175,128,24,241,101,122,27,77,128,25,164,84,237,8,177,15,224,135,110,5,52,195,16,120,97,58,101,156,33,214,192,125,99,1,152,89,109,117,183,172,164,76,38,9,137,230,189,73,168,65,214,226,192,13,36,73,247,55,182,77,67,209,145,188,244,159,195,252,16,59,80,86,38,74,161,62,41,39,110,60,250,126,105,128,153,44,126,185,186,222,69,219,62,98,194,13,230,86,89,249,13,239,4,78,99,195,126,124,225,4,42,119,215,171,123,156,131,245,56,34,243,224,168,243,175,186,34,126,212,116,250,6,123,165,199,3,120,251,231,58,175,67,90,54,85,110,31,175,41,145,108,81,69,1,171},
  {186,57,145,253,90,235,153,222,153,98,77,228,98,69,30,3,178,200,206,77,54,2,246,211,162,207,135,51,192,155,102,13,201,72,160,228,136,71,13,99,110,247,44,236,158,40,80,175,61,53,115,15,82,45,174,71,146,107,63,243,11,7,183,230,139,227,231,254,217,96,129,35,149,50,82,139,89,196,107,150,194,61,30,250,181,177,60,173,81,150,160,83,135,221,195,102,9,117,166,141,252,181,179,166,21,219,53,50,156,68,56,28,56,228,39,159,88,114,150,163,75,239,122,198,73,187,126,191,243,184,222,121,40,49,159,156,214,84,237,109,139,88,120,80,52,48,102,5,13,74,77,192,62,227,5,197,147,211,70,4,171,13,101,48,206,18,209,159,113,146,16,187,20,210,216,207,8,141,166,148,161,27,189,153,55,106,233,138,40,197,220,93,52,122,100,108,221,227,193,151,29,50,41,220,183,130,178,75,154,99,172,188,210,237,36,88,131,210,20,195,112,41,32,195,212,232,49,28,91,149,120,190,49,67,138,1,222,95,178,186,94,232,249,129,167,88,173,73,36,36,202,212,2,186,235,119,21,169,91,155,76,247,28,79,60,130,82,117,252,184,75,73,253,1,169,133,135,135,29,112,88,129,76,146,154,30,168,239,100,116,77,3,233,1,64,107,26,64,14,125,99,238,10,60,197,208,50,91,217,228,75,223,68,253,92,40,18,248,76,81,137,223,16,209,43,26,77,202,182,55,104,155,251,137,172,59,70,114,129,175,10,164,101,217,96,169,65,35,188,87,253,111,150,119,22,176,24,54,95,54,185,199,229,232,137,101,92,169,238,218,220,90,45,127,129,238,106,116,31,68,118,249,16,74,20,208,202,246,181,63,169,99,112,195,191,174,86,123,177,28,42,132,212,1,4,202,99,136,103,36,216,54,3,38,114,170,150,206,183,254,6,122,240,125,245,75,170,160,23,168,100,115,205,16,112,80,175,86,254,143,67,47,93,75,161,254,210,64,244,177,194,77,46,30,134,4,102,55,211,108,200,42,126,109,109,120,130,21,178,139,69,245,104,157,250,225,204,245,221,68,42,159,15,73,109,121,200,217,54,31,166,20,236,206,96,209,117,97,237,230,228,9,210,22,136,233,177,15,139,232,229,36,150,235,151,50,144,1,173,157,179,14,23,69,23,42,104,152,225,148,191,206,197,235,125,221,151,236,248,161,147,200,34,194,67,215,209,190,221,215,142,25,231,36,123,223,45,252,224,28,17,15,144,22,212,129,72,65,21,108,239,94,142,32,149,142,1,154,94,78,118,27,46,100,177,198,57,156,74,94,71,54,172,185,133,77,109,248,175,119,167,51,179,252,7,180,45,8,110,72,99,123,29,22,9,134,238,72,212,125,21,149,74,180,23,190,133,38,107,23,61,37,13,196,164,177,166,251,116,103,161,4,197,253,102,81,233,38,94,226,215,118,218,103,106,252,29,27,146,54,239,133,88,31,99,59,158,76,237,103,149,50,209,168,3,81,130,21,148,177,55,180,41,79,4,13,31,153,78,0,42,210,52,31,31,44,110,189,186,172,230,137,137,186,69,168,21,187,50,127,240,183,230,69,118,1,133,225,157,159,10,67,209,254,147,63,125,195,81,166,226,240,63,106,177,35,43,249,159,29,18,7,24,229,183,74,185,93,105,104,18,216,0,188,147,82,113,203,183,154,234,114,227,195,235,9,178,254,90,22,95,23,167,134,225,51,192,79,27,117,65,187,102,224,55,172,3,250,151,210,64,3,159,204,64,240,73,144,105,78,210,194,106,160,182,73,90,153,104,198,221,67,214,28,27,242,149,142,137,13,23,156,149,127,67,98,255,121,73,76,247,184,111,215,173,245,228,18,203,220,38,224,92,119,231,127,195,202,158,22,75,231,69,255,148,62,49,147,155,231,147,204,28,204,202,68,82,166,65,222,149,49,75,5,120,33,117,41,173,211,84,51,201,83,163,107,104,71,134,228,45,160,112,170,28,111,30,148,64,82,237,152,16,171,116,139,3,178,201,215,104,94,166,192,194,214,1,23,229,112,82,205,18,196,51,133,143,247,65,37,76,208,173,108,187,150,150,7,46,121,101,51,123,234,81,117,38,165,6,19,248,197,184,148,155,159,140,148,107,213,169,211,132,55,141,242,119,38,170,128,199,9,116,151,117,168,121,9,216,132,202,229,138,10,230,101,51,16,175,197,41,127,249,31,53,91,25,122,245,95,33,97,245,74,233,241,80,20,142,143,74,197,101,76,18,102,214,103,166,6,239,220,164,202,167,205,198,146,49,7,115,133,21,63,10,216,114,126,180,40,88,247,0,215,183,122,157,139,157,34,11,85,225,4,62,13,36,188,25,204,25,213,15,161,251,102,73,148,195,69,66,183,141,18,246,33,28,219,53,168,203,57,127,239,245,218,107,232,66,114,224,29,46,32,221,128,92,95,221,141,39,91,89,71,217,124,209,114,152,147,63,16,59,74,90,34,66,17,164,229,127,237,120,211,167,151,0,140,64,110,88,190,108,238,44,196,129,37,37,252,96,218,105,203,93,115,4,107,110,118,198,152,228,172,189,29,9,136,165,225,23,135,173,189,244,153,162,19,11,73,198,111,126,235,143,178,116,48,162,113,247,180,139,92,209,117,248,41,160,123,228,72,63,87,58,249,115,209,35,47,2,243,212,199,182,254,30,182,156,69,219,16,138,163,48,100,147,94,189,119,241,115,122,145,118,146,118,14,98,210,80,168,76,145,114,148,128,213,118,52,252,113,246,53,205,0,213,192,16,12,37,186,216,106,22,100,230,88,243,79,34,170,185,228,223,203,67,120,121,255,50,82,245,95,105,192,137,52,44,59,219,216,81,153,95,246,111,202,213,190,236,149,155,101,1,98,142,172,16,184,208,3,255,189,118,37,18,249,111,215,33,186,187,25,198,172,41,178,215,199,186,62,37,211,56,254,149,87,162,95,192,131,84,41,136,205,117,73,164,91,130,186,119,76,178,43,58,178,156,71,62,177,3,183,155,108,60,207,245,19,70,11,132,175,35,247,165,101,99,147,85,183,190,236,78,196,222,238,86,121,249,228,6,79,196,41,91,90,234,137,19,137,124,181,104,92,11,185,208,19,165,245,236,136,7,37,88,76,137,197,227,246,0,211,151,253,17,43,226,148,255,11,32,174,48,207,141,144,71,81,249,87,139,224,169,209,139,240,34,135,225,223,53,252,140,4,156,44,132,72,201,102,117,200,103,250,67,111,128,151,121,17,137,188,178,71,105,107,131,187,102,115,219,63,91,224,3,222,24,149,53,165,73,168,60,170,38,91,100,23,208,176,73,34,18,137,158,136,123,38,184,180,141,93,170,7,140,128,23,153,57,107,90,183,68,159,201,142,65,5,102,214,156,211,39,218,64,80,59,137,74,226,5,9,97,207,169,143,217,177,157,174,125,175,21,117,211,158,140,11,110,244,6,197,246,166,53,179,105,171,68,214,160,113,100,222,1,102,233,44,63,76,236,21,203,42,16,156,75,180,38,234,179,92,141,33,18,192,221,156,104,198,162,64,46,17,25,157,3,125,252,178,16,207,142,74,113,4,147,172,129,253,208,185,86,60,201,76,223,9,31,39,149,252,210,145,53,173,137,104,134,24,63,28,117,160,104,38,56,2,152,159,47,112,166,129,63,129,191,173,86,187,192,88,247,168,11,147,101,133,76,43,69,82,199,11,235,163,93,50,63,140,91,157,84,7,75,34,52,96,37,76,56,25,238,89,100,195,191,127,157,165,9,152,221,76,35,53,6,91,80,155,181,92,83,237,56,181,2,240,7,215,173,6,137,123,244,249,41,53,241,160,11,22,29,112,160,24,248,126,100,61,137,163,14,194,90,161,211,131,43,13,14,6,44,46,217,188,23,190,100,132,27,188,123,195,250,99,66,140,8,81,197,129,75,72,159,56,57,72,239,14,103,201,148,82,134,95,177,151,9,135,238,194,5,200,249,13,226,211,80,184,125,235,60,48,99,0,153,52,136,45,247,156,102,185,24,224,197,230,48,1,209,22,195,213,104,202,68,241,69,138,85,58,235,212,77,66,98,195,62,197,208,255,140,177,158,150,46,224,68,0,209,36,49,162,224,86,242,164,109,62,26,184,61,116,241,131,28,187,177,31,248,81,161,221,238,215,57,8,230,246,147,38,196,26,153,246,58,34,120,242,253,213,49,109,164,36,113,12,43,169,87,223,69,153,203,251,53,161,2,69,30,53,73,139,103,153,114,106,42,192,24,62,79,18,240,172,48,57,187,239,145,242,129,76,131,171,75,14,154,62,18,104,152,13,90,101,59,166,69,69,75,223,68,83,206,68,80,216,114,152,85,122,35,113,164,161,135,46,223,30,203,152,170,102,54,129,197,243,91,185,142,119,63,216,205,225,24,193,19,2,138,173,121,49,190,66,107,228,151,248,78,86,75,124,110,96,58,153,117,212,95,165,119,70,243,64,31,174,65,165,172,195,170,82,254,144,180,100,96,55,244,156,57,231,38,190,174,36,151,149,36,246,204,150,66,75,129,91,152,73,119,202,197,42,233,32,59,197,99,156,231,28,248,116,157,203,201,215,171,135,188,50,88,92,123,155,70,214,35,56,81,114,42,254,229,205,191,205,110,32,53,28,92,222,23,88,240,226,43,19,66,255,215,60,179,249,65,11,228,168,88,62,106,113,216,52,251,211,189,94,206,249,1,39,10,208,224,226,156,186,116,16,122,1,221,211,98,250,149,153,73,11,94,99,130,246,75,27,132,227,72,231,163,10,204,152,185,45,136,117,26,74,154,97,241,233,187,146,92,93,215,132,158,222,237,165,108,202,189,55,33,145,95,129,169,88,77,196,54,190,252,239,66,236,152,177,51,88,160,234,126,245,224,18,175,12,40,233,69,231,197,143,175,180,79,65,103,72,140,40,15,113,163,192,183,155,145,106,249,38,52,108,66,65,8,96,192,92,254,163,191,237,26,117,100,216,133,33,150,246,103,191,225,39,130,148,214,143,249,66,222,107,88,144,89,83,131,119,136,9,211,74,92,38,155,217,148,234,189,111,120,173,229,182,243,221,153,154,235,81,237,18,173,255,219,103,94,18,15,103,245,4,210,36,47,39,175,124,243,84,153,115,108,98,0,91,69,196,180,91,50,251,159,73,244,27,200,114,38,35,27,33,225,78,230,79,8,68,26,103,121,41,243,246,36,107,150,101,43,229,227,42,231,233,156,161,64,161,148,21,201,159,10,129,83,34,221,21,158,95,33,62,153,223,47,238,252,127,203,117,95,91,241,116,124,200,172,157,204,78,229,23,224,109,143,50,50,159,141,126,178,1,171,21,68,226,245,139,62,52,218,138,148,167,21,153,218,2,62,175,104,241,152,30,41,252,100,161,172,7,31,30,229,80,88,200,117,7,229,43,174,127,66,192,8,81,25,193,200,128,87,127,196,89,95,175,6,183,224,38,122,22,117,121,196,171,61,57,246,204,51,38,105,142,37,62,37,182,172,67,109,178,210,23,147,58,53,211,124,162,183,69,65,27,57,59,116,75,231,123,2,90,88,31,255,28,131,80,188,109,111,116,199,160,18,101,75,135,154,32,96,39,84,237,150,189,171,67,99,72,124,249,76,217,179,172,252,153,46,223,38,134,12,34,219,58,100,241,240,171,221,121,74,55,241,6,15,31,194,171,100,159},
  {35,32,202,181,197,178,87,239,90,32,81,75,77,34,237,159,192,177,143,1,15,99,97,31,214,78,116,17,163,102,193,45,232,36,136,71,15,122,129,0,137,151,81,189,61,122,20,36,199,122,232,54,254,72,47,102,131,131,132,86,8,220,71,103,137,124,171,61,41,40,229,86,76,106,151,210,238,46,62,211,29,238,157,122,250,250,65,92,5,94,223,245,93,100,145,120,20,30,230,203,243,72,167,74,58,113,102,216,170,128,243,61,184,163,91,205,97,227,8,78,78,105,124,69,162,120,97,15,127,246,223,200,230,182,106,127,206,200,153,169,156,164,147,111,71,41,53,91,20,206,113,147,222,63,241,168,73,177,52,249,4,199,75,223,242,181,157,150,219,31,195,67,224,199,224,250,30,188,37,131,106,20,14,222,141,243,248,36,56,68,146,203,231,56,31,118,23,62,226,162,217,167,185,172,11,153,108,254,136,153,77,0,250,85,78,192,36,107,68,118,59,160,52,109,202,219,31,8,221,55,61,172,49,72,109,170,105,4,5,6,235,154,161,3,69,236,193,101,47,51,94,50,220,211,105,222,19,105,73,111,245,166,64,39,135,15,215,243,20,38,221,52,83,218,93,234,194,120,157,13,2,42,180,182,50,133,189,152,243,42,219,10,232,56,52,248,217,25,166,26,112,151,41,206,173,32,241,32,229,147,75,38,61,192,111,64,178,120,139,71,3,236,101,113,170,70,179,113,172,121,18,87,164,125,94,144,196,123,222,161,54,41,153,107,106,235,174,101,124,21,221,236,2,252,12,140,77,174,117,46,92,206,165,114,208,221,80,31,250,230,209,51,170,56,0,137,230,189,81,0,141,95,101,105,169,245,137,90,228,30,55,231,97,100,216,252,25,48,82,3,46,57,42,43,161,53,87,212,143,175,23,119,177,129,145,85,113,119,223,174,254,124,165,237,151,94,118,155,19,148,185,143,140,252,76,19,128,158,112,179,94,219,179,82,71,124,190,61,109,204,105,72,5,173,219,73,144,87,249,40,137,84,151,115,77,205,100,28,181,30,69,21,42,62,190,184,91,16,239,238,242,46,21,200,142,76,118,116,199,55,134,178,170,64,19,100,5,198,168,54,19,92,222,212,203,79,239,53,28,96,109,42,248,241,208,4,139,111,221,158,43,43,207,195,20,193,140,179,246,252,216,21,106,248,191,25,138,99,77,195,181,144,41,167,7,90,48,194,145,183,27,195,187,51,190,162,225,68,135,26,189,49,41,203,190,148,238,44,12,226,3,149,112,72,84,161,50,175,179,86,230,57,92,232,53,172,44,241,169,167,91,243,150,0,221,93,188,215,135,218,249,170,223,123,43,102,152,213,81,167,83,138,56,19,242,251,94,10,209,237,19,95,65,134,159,196,7,200,93,96,108,243,1,40,109,167,222,207,142,46,30,135,251,245,255,133,162,166,158,211,243,190,246,74,46,144,33,3,35,105,20,131,246,89,222,246,247,209,177,211,33,90,106,255,203,196,230,167,25,235,0,72,11,102,142,184,81,158,57,94,13,233,225,215,18,58,134,3,70,164,66,209,4,156,116,91,110,19,97,157,25,42,232,161,255,60,185,179,197,9,225,118,118,237,204,128,27,197,208,136,58,210,162,245,41,0,47,174,206,116,153,253,199,101,142,130,133,11,248,253,39,95,143,220,28,42,40,200,159,216,176,245,3,249,226,1,8,212,237,121,6,0,199,174,206,23,123,28,185,37,184,170,240,129,61,127,48,54,88,212,220,27,212,90,103,66,125,6,218,209,4,218,143,40,190,151,193,205,20,170,27,125,213,6,138,34,138,204,187,6,198,23,24,1,146,190,67,101,29,211,73,180,9,177,122,152,148,163,49,8,172,107,97,62,144,119,83,174,68,64,174,205,35,17,189,147,46,176,30,147,135,205,249,16,160,148,34,22,133,167,89,145,87,94,88,249,93,179,76,100,198,138,225,252,42,10,64,28,186,219,1,245,52,96,25,175,128,80,78,58,166,208,151,242,155,19,166,49,104,127,155,226,115,145,202,199,25,108,123,204,9,13,80,222,186,21,70,17,201,172,144,39,244,17,185,9,95,171,231,217,76,202,134,239,157,72,156,45,2,192,33,136,99,7,3,158,26,250,178,202,27,125,53,83,156,5,91,199,176,45,216,25,67,50,3,249,2,34,62,213,215,10,198,223,187,110,203,53,23,48,112,77,180,217,36,223,224,128,35,51,150,35,113,231,53,128,211,111,108,111,244,49,99,219,46,185,136,84,33,236,5,126,219,29,31,145,112,88,125,146,168,221,115,139,71,98,96,100,191,141,250,229,21,71,85,254,110,167,177,200,101,211,219,170,29,202,202,136,49,168,43,156,134,99,84,134,41,40,207,194,2,206,165,211,160,239,17,226,255,188,74,103,238,12,215,163,35,139,207,225,101,190,77,215,113,140,143,178,158,178,71,60,40,94,68,18,252,164,215,185,102,113,114,83,220,176,203,176,243,82,33,53,150,41,136,87,34,245,83,162,17,10,101,185,229,99,30,147,68,188,164,18,245,112,29,29,218,128,189,113,90,80,56,179,8,132,73,161,136,199,64,82,100,198,78,1,40,47,86,57,130,93,94,194,25,89,183,19,209,39,25,68,81,163,114,176,241,142,240,191,15,124,35,22,249,154,137,173,86,79,35,162,169,144,179,73,238,4,103,18,220,121,193,134,217,221,165,27,119,133,44,175,213,40,193,247,247,213,231,138,146,8,223,190,12,20,144,165,41,111,189,59,189,40,106,4,228,103,37,114,161,124,120,19,121,240,172,102,155,127,236,126,148,174,118,200,223,62,2,2,127,251,137,98,74,31,94,130,107,52,100,255,54,255,39,38,114,103,66,128,111,40,183,225,66,97,198,89,222,112,36,73,129,10,173,17,221,73,109,64,131,128,253,91,28,128,80,146,45,78,73,1,116,205,72,101,136,160,3,180,248,101,147,192,245,143,96,104,166,197,116,1,206,30,239,67,1,167,109,107,22,191,234,126,203,148,124,141,180,170,27,2,153,114,224,112,223,243,20,106,39,219,115,11,217,121,219,124,172,129,146,84,118,117,150,11,0,31,71,122,20,110,27,200,137,114,245,218,253,145,125,75,82,174,144,195,10,83,45,82,182,66,248,182,61,170,56,254,87,152,56,196,213,24,55,255,100,54,213,50,218,45,247,111,135,215,182,181,199,76,251,23,185,249,129,189,119,127,214,128,69,187,151,132,66,216,47,241,228,17,119,113,242,56,108,73,219,232,149,132,50,123,71,206,223,121,162,252,180,222,27,3,212,110,15,246,109,214,171,67,214,234,207,24,148,87,23,212,124,234,254,110,169,65,247,75,255,169,114,130,86,192,253,171,2,131,25,86,115,164,17,127,80,104,5,3,29,11,62,193,174,202,242,253,148,87,200,29,83,23,98,1,201,145,49,17,242,107,52,11,246,17,177,147,2,140,0,7,143,64,38,94,155,153,231,231,108,44,197,214,134,37,137,199,68,240,49,71,34,21,103,31,166,94,22,224,121,219,147,169,30,118,162,146,57,81,41,220,190,172,141,46,214,194,72,69,114,166,163,22,203,16,21,104,231,8,53,30,159,78,24,205,236,39,27,40,90,241,237,135,44,100,182,39,26,27,188,194,36,207,37,104,148,175,248,54,143,143,130,220,49,237,63,37,232,198,10,59,134,196,69,8,242,68,147,187,102,180,188,154,133,227,136,197,85,158,242,80,252,245,35,104,5,248,198,135,55,243,239,243,45,234,112,250,191,190,13,134,190,161,17,149,54,46,87,114,142,254,181,42,78,51,230,235,160,212,69,63,203,59,55,136,201,77,37,215,70,215,169,14,54,147,172,124,115,22,3,132,184,59,221,122,190,149,121,139,237,242,90,142,248,8,166,157,160,219,59,53,251,57,53,46,93,164,41,43,207,149,157,104,180,222,193,237,202,138,186,155,218,38,222,26,10,210,180,34,42,85,131,231,62,125,35,160,97,242,191,55,130,218,109,8,105,51,101,232,45,142,121,94,130,130,68,216,244,244,193,40,144,90,194,136,63,240,38,208,138,88,230,197,168,104,4,105,47,105,92,249,11,193,137,49,236,98,173,81,63,210,234,155,46,95,34,157,216,228,208,35,94,76,141,86,102,114,111,126,129,170,114,30,146,115,13,235,79,83,159,202,101,254,17,17,100,195,210,154,237,43,166,237,8,122,163,221,196,30,14,148,186,88,254,36,191,182,92,233,139,116,19,207,60,185,39,107,83,214,238,83,119,163,222,14,88,108,249,150,250,169,211,219,251,86,165,222,97,140,28,191,135,212,31,67,231,157,171,174,0,26,165,174,91,25,33,107,63,229,90,244,133,52,224,14,29,193,32,27,74,20,182,217,250,159,60,6,193,160,114,156,86,191,30,215,135,125,132,35,8,198,156,30,113,190,84,26,102,224,74,6,0,21,12,100,226,47,165,96,97,76,179,56,39,11,28,188,69,174,18,227,78,117,250,77,145,249,125,1,132,49,25,11,222,246,220,248,205,210,236,105,228,11,138,128,110,198,9,111,123,84,83,148,134,86,115,60,62,84,235,154,160,76,16,52,115,10,200,208,132,224,29,87,203,192,139,165,9,241,57,72,252,221,53,165,17,173,189,57,182,186,188,27,178,79,81,132,190,206,20,102,145,92,174,59,36,136,244,149,137,68,219,101,9,226,233,209,235,56,98,37,235,173,47,47,182,56,238,152,122,222,57,191,17,100,91,99,99,217,138,204,21,118,221,216,26,164,246,46,237,207,49,246,53,214,64,61,95,121,88,76,10,127,191,254,203,65,191,2,220,228,222,76,6,17,74,240,98,18,45,92,165,226,108,47,47,221,120,233,195,71,57,238,249,67,87,30,45,90,46,178,51,194,155,167,40,3,192,43,142,237,178,155,105,186,206,13,173,185,91,145,172,8,124,193,66,14,35,54,68,38,11,159,103,136,22,54,94,212,162,219,184,24,145,161,162,213,22,118,50,48,250,190,7,125,66,7,141,35,218,246,208,217,37,211,144,223,241,167,179,86,247,136,103,162,19,61,241,206,251,60,34,141,146,208,144,54,203,131,236,84,30,130,56,104,189,68,83,6,154,206,38,140,168,31,42,78,51,10,208,145,237,95,153,152,207,231,220,95,228,30,87,88,123,248,27,221,255,187,226,24,199,50,132,210,60,226,253,251,7,77,152,74,236,179,57,220,133,80,7,50,144,53,135,150,124,245,46,247,78,87,242,37,65,251,123,207,64,113,154,66,139,201,145,65,19,94,89,119,150,241,12,231,159,190,254,48,16,104,152,80,155,248,128,202,82,238,42,21,212,16,20,5,233,28,103,39,90,69,155,13,68,190,164,141,254,64,177,134,15,192,145,181,119,214,200,114,238,28,197,169,55,230,149,188,213,227,25,59,251,158,166,36,43,208,71,169,153,47,219,82,46,24,141,87,108,131,168,59,81,62,47,93,215,102,220,202,106,194,51,167,250,41,121,183,152,71,239,9,196,99,232,108,118,67,154,113,56,8,193,10,249,69,18,38,251,42,145,172,107,218,253,76,191,240,109,17,87,79,94,153,251,136,144,246,56,46,79,216,187,74,183,136,31,28,190,24,238,127,19,63,82,100,188,154,61,50,31,75,207,118,11,163,98,191,168,0,128,231,169,8,204,94,246,159,22,88},
} ;

static const unsigned char precomputed_core_scale3sntrup1277_k[precomputed_core_scale3sntrup1277_NUM][crypto_core_KEYBYTES] = {
  {},
  {},
  {},
  {},
} ;

static const unsigned char precomputed_core_scale3sntrup1277_c[precomputed_core_scale3sntrup1277_NUM][crypto_core_CONSTBYTES] = {
  {},
  {},
  {},
  {},
} ;

static void test_core_scale3sntrup1277_impl(long long impl)
{
  unsigned char *h = test_core_scale3sntrup1277_h;
  unsigned char *n = test_core_scale3sntrup1277_n;
  unsigned char *k = test_core_scale3sntrup1277_k;
  unsigned char *c = test_core_scale3sntrup1277_c;
  unsigned char *h2 = test_core_scale3sntrup1277_h2;
  unsigned char *n2 = test_core_scale3sntrup1277_n2;
  unsigned char *k2 = test_core_scale3sntrup1277_k2;
  unsigned char *c2 = test_core_scale3sntrup1277_c2;
  long long hlen = crypto_core_OUTPUTBYTES;
  long long nlen = crypto_core_INPUTBYTES;
  long long klen = crypto_core_KEYBYTES;
  long long clen = crypto_core_CONSTBYTES;

  if (targeti && strcmp(targeti,".") && strcmp(targeti,ntruprime_dispatch_core_scale3sntrup1277_implementation(impl))) return;
  if (targetn && atol(targetn) != impl) return;
  if (impl >= 0) {
    crypto_core = ntruprime_dispatch_core_scale3sntrup1277(impl);
    printf("core_scale3sntrup1277 %lld implementation %s compiler %s\n",impl,ntruprime_dispatch_core_scale3sntrup1277_implementation(impl),ntruprime_dispatch_core_scale3sntrup1277_compiler(impl));
  } else {
    crypto_core = ntruprime_core_scale3sntrup1277;
    printf("core_scale3sntrup1277 selected implementation %s compiler %s\n",ntruprime_core_scale3sntrup1277_implementation(),ntruprime_core_scale3sntrup1277_compiler());
  }
  for (long long checksumbig = 0;checksumbig < 2;++checksumbig) {
    long long loops = checksumbig ? 4096 : 512;

    checksum_clear();

    for (long long loop = 0;loop < loops;++loop) {

      output_prepare(h2,h,hlen);
      input_prepare(n2,n,nlen);
      input_prepare(k2,k,klen);
      input_prepare(c2,c,clen);
      secret(n,nlen);
      secret(k,klen);
      secret(c,clen);
      crypto_core(h,n,k,c);
      public(n,nlen);
      public(k,klen);
      public(c,clen);
      public(h,hlen);
      checksum(h,hlen);
      output_compare(h2,h,hlen,"crypto_core");
      input_compare(n2,n,nlen,"crypto_core");
      input_compare(k2,k,klen,"crypto_core");
      input_compare(c2,c,clen,"crypto_core");

      double_canary(h2,h,hlen);
      double_canary(n2,n,nlen);
      double_canary(k2,k,klen);
      double_canary(c2,c,clen);
      secret(n2,nlen);
      secret(k2,klen);
      secret(c2,clen);
      crypto_core(h2,n2,k2,c2);
      public(n2,nlen);
      public(k2,klen);
      public(c2,clen);
      public(h2,hlen);
      if (memcmp(h2,h,hlen) != 0) fail("failure: crypto_core is nondeterministic\n");

      double_canary(h2,h,hlen);
      double_canary(n2,n,nlen);
      double_canary(k2,k,klen);
      double_canary(c2,c,clen);
      secret(n2,nlen);
      secret(k,klen);
      secret(c,clen);
      crypto_core(n2,n2,k,c);
      public(n2,hlen);
      public(k,klen);
      public(c,clen);
      if (memcmp(n2,h,hlen) != 0) fail("failure: crypto_core does not handle n=h overlap\n");
      memcpy(n2,n,nlen);
      secret(n,nlen);
      secret(k2,klen);
      secret(c,clen);
      crypto_core(k2,n,k2,c);
      public(k2,hlen);
      public(n,nlen);
      public(c,clen);
      if (memcmp(k2,h,hlen) != 0) fail("failure: crypto_core does not handle k=h overlap\n");
      memcpy(k2,k,klen);
      secret(n,nlen);
      secret(k,klen);
      secret(c2,clen);
      crypto_core(c2,n,k,c2);
      public(c2,hlen);
      public(n,nlen);
      public(k,klen);
      if (memcmp(c2,h,hlen) != 0) fail("failure: crypto_core does not handle c=h overlap\n");
      memcpy(c2,c,clen);
    }
    checksum_expected(core_scale3sntrup1277_checksums[checksumbig]);
  }
  for (long long precomp = 0;precomp < precomputed_core_scale3sntrup1277_NUM;++precomp) {
    output_prepare(h2,h,crypto_core_OUTPUTBYTES);
    input_prepare(n2,n,crypto_core_INPUTBYTES);
    memcpy(n,precomputed_core_scale3sntrup1277_n[precomp],crypto_core_INPUTBYTES);
    memcpy(n2,precomputed_core_scale3sntrup1277_n[precomp],crypto_core_INPUTBYTES);
    input_prepare(k2,k,crypto_core_KEYBYTES);
    memcpy(k,precomputed_core_scale3sntrup1277_k[precomp],crypto_core_KEYBYTES);
    memcpy(k2,precomputed_core_scale3sntrup1277_k[precomp],crypto_core_KEYBYTES);
    input_prepare(c2,c,crypto_core_CONSTBYTES);
    memcpy(c,precomputed_core_scale3sntrup1277_c[precomp],crypto_core_CONSTBYTES);
    memcpy(c2,precomputed_core_scale3sntrup1277_c[precomp],crypto_core_CONSTBYTES);
    crypto_core(h,n,k,c);
    if (memcmp(h,precomputed_core_scale3sntrup1277_h[precomp],crypto_core_OUTPUTBYTES)) {
      fail("failure: crypto_core fails precomputed test vectors\n");
      printf("expected h: ");
      for (long long pos = 0;pos < crypto_core_OUTPUTBYTES;++pos) printf("%02x",((unsigned char *) precomputed_core_scale3sntrup1277_h[precomp])[pos]);
      printf("\n");
      printf("received h: ");
      for (long long pos = 0;pos < crypto_core_OUTPUTBYTES;++pos) printf("%02x",h[pos]);
      printf("\n");
    }
    output_compare(h2,h,crypto_core_OUTPUTBYTES,"crypto_core");
    input_compare(n2,n,crypto_core_INPUTBYTES,"crypto_core");
    input_compare(k2,k,crypto_core_KEYBYTES,"crypto_core");
    input_compare(c2,c,crypto_core_CONSTBYTES,"crypto_core");
  }
}

void test_core_scale3sntrup1277(void)
{
  long long maxalloc = 0;
  if (targeto && strcmp(targeto,"core")) return;
  if (targetp && strcmp(targetp,"scale3sntrup1277")) return;
  storage_core_scale3sntrup1277_h = callocplus(crypto_core_OUTPUTBYTES);
  test_core_scale3sntrup1277_h = aligned(storage_core_scale3sntrup1277_h,crypto_core_OUTPUTBYTES);
  if (crypto_core_OUTPUTBYTES > maxalloc) maxalloc = crypto_core_OUTPUTBYTES;
  storage_core_scale3sntrup1277_n = callocplus(crypto_core_INPUTBYTES);
  test_core_scale3sntrup1277_n = aligned(storage_core_scale3sntrup1277_n,crypto_core_INPUTBYTES);
  if (crypto_core_INPUTBYTES > maxalloc) maxalloc = crypto_core_INPUTBYTES;
  storage_core_scale3sntrup1277_k = callocplus(crypto_core_KEYBYTES);
  test_core_scale3sntrup1277_k = aligned(storage_core_scale3sntrup1277_k,crypto_core_KEYBYTES);
  if (crypto_core_KEYBYTES > maxalloc) maxalloc = crypto_core_KEYBYTES;
  storage_core_scale3sntrup1277_c = callocplus(crypto_core_CONSTBYTES);
  test_core_scale3sntrup1277_c = aligned(storage_core_scale3sntrup1277_c,crypto_core_CONSTBYTES);
  if (crypto_core_CONSTBYTES > maxalloc) maxalloc = crypto_core_CONSTBYTES;
  storage_core_scale3sntrup1277_h2 = callocplus(maxalloc);
  test_core_scale3sntrup1277_h2 = aligned(storage_core_scale3sntrup1277_h2,crypto_core_OUTPUTBYTES);
  storage_core_scale3sntrup1277_n2 = callocplus(maxalloc);
  test_core_scale3sntrup1277_n2 = aligned(storage_core_scale3sntrup1277_n2,crypto_core_INPUTBYTES);
  storage_core_scale3sntrup1277_k2 = callocplus(maxalloc);
  test_core_scale3sntrup1277_k2 = aligned(storage_core_scale3sntrup1277_k2,crypto_core_KEYBYTES);
  storage_core_scale3sntrup1277_c2 = callocplus(maxalloc);
  test_core_scale3sntrup1277_c2 = aligned(storage_core_scale3sntrup1277_c2,crypto_core_CONSTBYTES);

  for (long long offset = 0;offset < 2;++offset) {
    if (targetoffset && atol(targetoffset) != offset) continue;
    if (offset && valgrind) break;
    printf("core_scale3sntrup1277 offset %lld\n",offset);
    for (long long impl = -1;impl < ntruprime_numimpl_core_scale3sntrup1277();++impl)
      forked(test_core_scale3sntrup1277_impl,impl);
    ++test_core_scale3sntrup1277_h;
    ++test_core_scale3sntrup1277_n;
    ++test_core_scale3sntrup1277_k;
    ++test_core_scale3sntrup1277_c;
    ++test_core_scale3sntrup1277_h2;
    ++test_core_scale3sntrup1277_n2;
    ++test_core_scale3sntrup1277_k2;
    ++test_core_scale3sntrup1277_c2;
  }
  free(storage_core_scale3sntrup1277_c2);
  free(storage_core_scale3sntrup1277_k2);
  free(storage_core_scale3sntrup1277_n2);
  free(storage_core_scale3sntrup1277_h2);
  free(storage_core_scale3sntrup1277_c);
  free(storage_core_scale3sntrup1277_k);
  free(storage_core_scale3sntrup1277_n);
  free(storage_core_scale3sntrup1277_h);
}
#undef crypto_core_OUTPUTBYTES
#undef crypto_core_INPUTBYTES
#undef crypto_core_KEYBYTES
#undef crypto_core_CONSTBYTES

