/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.nashorn.internal.runtime;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Arrays;
import org.openjdk.nashorn.internal.runtime.Context;

abstract class NashornLoader
extends ClassLoader {
    protected static final String RUNTIME_PKG = "org.openjdk.nashorn.internal.runtime";
    protected static final String SCRIPTS_PKG = "org.openjdk.nashorn.internal.scripts";
    static final Module NASHORN_MODULE = Context.class.getModule();
    private static final String MODULE_MANIPULATOR_NAME = "org.openjdk.nashorn.internal.scripts.ModuleGraphManipulator";
    private static final byte[] MODULE_MANIPULATOR_BYTES = NashornLoader.readModuleManipulatorBytes();
    private Method addModuleExport;

    NashornLoader(ClassLoader parent) {
        super(parent);
    }

    void loadModuleManipulator() {
        try {
            Class<?> clazz = this.defineClass(MODULE_MANIPULATOR_NAME, MODULE_MANIPULATOR_BYTES, 0, MODULE_MANIPULATOR_BYTES.length);
            Class.forName(MODULE_MANIPULATOR_NAME, true, this);
            this.addModuleExport = clazz.getDeclaredMethod("addExport", Module.class);
            this.addModuleExport.setAccessible(true);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    final void addModuleExport(Module to) {
        try {
            this.addModuleExport.invoke(null, to);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException ex) {
            throw new RuntimeException(ex);
        }
    }

    static boolean isInNamedModule() {
        return NASHORN_MODULE.isNamed();
    }

    static ClassLoader createClassLoader(String classPath, ClassLoader parent) {
        URL[] urls = NashornLoader.pathToURLs(classPath);
        return URLClassLoader.newInstance(urls, parent);
    }

    private static URL[] pathToURLs(String path) {
        String[] components = path.split(File.pathSeparator);
        return (URL[])Arrays.stream(components).map(File::new).map(NashornLoader::fileToURL).toArray(URL[]::new);
    }

    private static URL fileToURL(File file) {
        Object name;
        try {
            name = file.getCanonicalPath();
        }
        catch (IOException e) {
            name = file.getAbsolutePath();
        }
        name = ((String)name).replace(File.separatorChar, '/');
        if (!((String)name).startsWith("/")) {
            name = "/" + (String)name;
        }
        if (!file.isFile()) {
            name = (String)name + "/";
        }
        try {
            return new URL("file", "", (String)name);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("file");
        }
    }

    private static byte[] readModuleManipulatorBytes() {
        byte[] byArray;
        block8: {
            String res = "/" + MODULE_MANIPULATOR_NAME.replace('.', '/') + ".class";
            InputStream in = NashornLoader.class.getResourceAsStream(res);
            try {
                byArray = in.readAllBytes();
                if (in == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException exp) {
                    throw new UncheckedIOException(exp);
                }
            }
            in.close();
        }
        return byArray;
    }
}

